<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_add = new t_trip_info_add();

// Run the page
$t_trip_info_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var ft_trip_infoadd = currentForm = new ew.Form("ft_trip_infoadd", "add");

// Validate form
ft_trip_infoadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_trip_info_add->vehicle_type->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_type->caption(), $t_trip_info->vehicle_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->vehicle->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle->caption(), $t_trip_info->vehicle->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle->errorMessage()) ?>");
		<?php if ($t_trip_info_add->_route->Required) { ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->_route->caption(), $t_trip_info->_route->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->_route->errorMessage()) ?>");
		<?php if ($t_trip_info_add->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->reports_to->caption(), $t_trip_info->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->buyer->caption(), $t_trip_info->buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->buyer->errorMessage()) ?>");
		<?php if ($t_trip_info_add->b_consignor->Required) { ?>
			elm = this.getElements("x" + infix + "_b_consignor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->b_consignor->caption(), $t_trip_info->b_consignor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->b_consignee->Required) { ?>
			elm = this.getElements("x" + infix + "_b_consignee");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->b_consignee->caption(), $t_trip_info->b_consignee->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->load_date->Required) { ?>
			elm = this.getElements("x" + infix + "_load_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->load_date->caption(), $t_trip_info->load_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_date->errorMessage()) ?>");
		<?php if ($t_trip_info_add->load_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->load_weight->caption(), $t_trip_info->load_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_weight->errorMessage()) ?>");
		<?php if ($t_trip_info_add->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->driver->caption(), $t_trip_info->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->driver_name->Required) { ?>
			elm = this.getElements("x" + infix + "_driver_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->driver_name->caption(), $t_trip_info->driver_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->agent->caption(), $t_trip_info->agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->comm->Required) { ?>
			elm = this.getElements("x" + infix + "_comm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->comm->caption(), $t_trip_info->comm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_comm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->comm->errorMessage()) ?>");
		<?php if ($t_trip_info_add->material->Required) { ?>
			elm = this.getElements("x" + infix + "_material");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->material->caption(), $t_trip_info->material->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->packing_type->caption(), $t_trip_info->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->m_hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_m_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->m_hsn->caption(), $t_trip_info->m_hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->_40->caption(), $t_trip_info->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->_40->errorMessage()) ?>");
		<?php if ($t_trip_info_add->freight_type->Required) { ?>
			elm = this.getElements("x" + infix + "_freight_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->freight_type->caption(), $t_trip_info->freight_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->freight->Required) { ?>
			elm = this.getElements("x" + infix + "_freight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->freight->caption(), $t_trip_info->freight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_freight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->freight->errorMessage()) ?>");
		<?php if ($t_trip_info_add->gst_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_gst_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->gst_percent->caption(), $t_trip_info->gst_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_gst_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->gst_percent->errorMessage()) ?>");
		<?php if ($t_trip_info_add->load_km->Required) { ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->load_km->caption(), $t_trip_info->load_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_km->errorMessage()) ?>");
		<?php if ($t_trip_info_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->remarks->caption(), $t_trip_info->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->consignor->Required) { ?>
			elm = this.getElements("x" + infix + "_consignor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->consignor->caption(), $t_trip_info->consignor->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_consignor");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->consignor->errorMessage()) ?>");
		<?php if ($t_trip_info_add->vehicle_freight_comm->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_comm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_comm->caption(), $t_trip_info->vehicle_freight_comm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_comm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_comm->errorMessage()) ?>");
		<?php if ($t_trip_info_add->vehicle_freight_type->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_type->caption(), $t_trip_info->vehicle_freight_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->vehicle_freight_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_amount->caption(), $t_trip_info->vehicle_freight_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_amount->errorMessage()) ?>");
		<?php if ($t_trip_info_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->operator->caption(), $t_trip_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->datetime->caption(), $t_trip_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_trip_infoadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_infoadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_infoadd.multiPage = new ew.MultiPage("ft_trip_infoadd");

// Dynamic selection lists
ft_trip_infoadd.lists["x_vehicle_type"] = <?php echo $t_trip_info_add->vehicle_type->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_info_add->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_infoadd.lists["x_vehicle"] = <?php echo $t_trip_info_add->vehicle->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_info_add->vehicle->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x__route"] = <?php echo $t_trip_info_add->_route->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x__route"].options = <?php echo JsonEncode($t_trip_info_add->_route->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x_reports_to"] = <?php echo $t_trip_info_add->reports_to->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_info_add->reports_to->lookupOptions()) ?>;
ft_trip_infoadd.lists["x_buyer"] = <?php echo $t_trip_info_add->buyer->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_info_add->buyer->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x_b_consignor"] = <?php echo $t_trip_info_add->b_consignor->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_info_add->b_consignor->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x_b_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x_b_consignee"] = <?php echo $t_trip_info_add->b_consignee->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_info_add->b_consignee->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x_b_consignee"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x_driver"] = <?php echo $t_trip_info_add->driver->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_add->driver->lookupOptions()) ?>;
ft_trip_infoadd.lists["x_agent"] = <?php echo $t_trip_info_add->agent->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_agent"].options = <?php echo JsonEncode($t_trip_info_add->agent->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x_freight_type"] = <?php echo $t_trip_info_add->freight_type->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_info_add->freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infoadd.lists["x_consignor"] = <?php echo $t_trip_info_add->consignor->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_consignor"].options = <?php echo JsonEncode($t_trip_info_add->consignor->lookupOptions()) ?>;
ft_trip_infoadd.autoSuggests["x_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoadd.lists["x_vehicle_freight_type"] = <?php echo $t_trip_info_add->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_info_add->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infoadd.lists["x_operator"] = <?php echo $t_trip_info_add->operator->Lookup->toClientList() ?>;
ft_trip_infoadd.lists["x_operator"].options = <?php echo JsonEncode($t_trip_info_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_info_add->showPageHeader(); ?>
<?php
$t_trip_info_add->showMessage();
?>
<form name="ft_trip_infoadd" id="ft_trip_infoadd" class="<?php echo $t_trip_info_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_info_add->IsModal ?>">
<?php if ($t_trip_info_add->MultiPages->Items[0]->Visible) { ?>
<div class="ew-add-div"><!-- page0 -->
<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
	<div id="r_vehicle_type" class="form-group row">
		<label id="elh_t_trip_info_vehicle_type" for="x_vehicle_type" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_type->caption() ?><?php echo ($t_trip_info->vehicle_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_type">
<?php $t_trip_info->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_info->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_type" data-page="0" data-value-separator="<?php echo $t_trip_info->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_info->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_info->vehicle_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label id="elh_t_trip_info_vehicle" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle->caption() ?><?php echo ($t_trip_info->vehicle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$t_trip_info->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_info->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_info->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->vehicle->ReadOnly || $t_trip_info->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "vehicle_info") && !$t_trip_info->vehicle->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_vehicle" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->vehicle->caption() ?>" data-title="<?php echo $t_trip_info->vehicle->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_vehicle',url:'vehicle_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_vehicle" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_info->vehicle->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_info->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
<?php echo $t_trip_info->vehicle->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label id="elh_t_trip_info__route" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->_route->caption() ?><?php echo ($t_trip_info->_route->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->_route->cellAttributes() ?>>
<span id="el_t_trip_info__route">
<?php
$wrkonchange = "" . trim(@$t_trip_info->_route->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->_route->EditAttrs["onchange"] = "";
?>
<span id="as_x__route" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__route" id="sv_x__route" value="<?php echo RemoveHtml($t_trip_info->_route->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->_route->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->_route->getPlaceHolder()) ?>"<?php echo $t_trip_info->_route->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->_route->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__route',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->_route->ReadOnly || $t_trip_info->_route->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "t_route_info") && !$t_trip_info->_route->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x__route" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->_route->caption() ?>" data-title="<?php echo $t_trip_info->_route->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x__route',url:'t_route_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x__route" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->_route->displayValueSeparatorAttribute() ?>" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_info->_route->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x__route","forceSelect":true});
</script>
<?php echo $t_trip_info->_route->Lookup->getParamTag("p_x__route") ?>
</span>
<?php echo $t_trip_info->_route->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label id="elh_t_trip_info_driver" for="x_driver" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->driver->caption() ?><?php echo ($t_trip_info->driver->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->driver->cellAttributes() ?>>
<span id="el_t_trip_info_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_driver" data-page="0" data-value-separator="<?php echo $t_trip_info->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $t_trip_info->driver->editAttributes() ?>>
		<?php echo $t_trip_info->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $t_trip_info->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
<?php echo $t_trip_info->driver->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->driver_name->Visible) { // driver_name ?>
	<div id="r_driver_name" class="form-group row">
		<label id="elh_t_trip_info_driver_name" for="x_driver_name" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->driver_name->caption() ?><?php echo ($t_trip_info->driver_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->driver_name->cellAttributes() ?>>
<span id="el_t_trip_info_driver_name">
<input type="text" data-table="t_trip_info" data-field="x_driver_name" data-page="0" name="x_driver_name" id="x_driver_name" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->driver_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->driver_name->EditValue ?>"<?php echo $t_trip_info->driver_name->editAttributes() ?>>
</span>
<?php echo $t_trip_info->driver_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->consignor->Visible) { // consignor ?>
	<div id="r_consignor" class="form-group row">
		<label id="elh_t_trip_info_consignor" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->consignor->caption() ?><?php echo ($t_trip_info->consignor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->consignor->cellAttributes() ?>>
<span id="el_t_trip_info_consignor">
<?php
$wrkonchange = "" . trim(@$t_trip_info->consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->consignor->EditAttrs["onchange"] = "";
?>
<span id="as_x_consignor" class="text-nowrap" style="z-index: 8410">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x_consignor" id="sv_x_consignor" value="<?php echo RemoveHtml($t_trip_info->consignor->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->consignor->editAttributes() ?>>
<?php if (AllowAdd(CurrentProjectID() . "production_partner") && !$t_trip_info->consignor->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_consignor" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->consignor->caption() ?>" data-title="<?php echo $t_trip_info->consignor->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_consignor',url:'production_partneraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_consignor" data-page="0" data-value-separator="<?php echo $t_trip_info->consignor->displayValueSeparatorAttribute() ?>" name="x_consignor" id="x_consignor" value="<?php echo HtmlEncode($t_trip_info->consignor->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x_consignor","forceSelect":false});
</script>
<?php echo $t_trip_info->consignor->Lookup->getParamTag("p_x_consignor") ?>
</span>
<?php echo $t_trip_info->consignor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<div id="r_vehicle_freight_comm" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_comm" for="x_vehicle_freight_comm" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_comm->caption() ?><?php echo ($t_trip_info->vehicle_freight_comm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_comm->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_comm">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_comm" data-page="0" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_comm->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_comm->editAttributes() ?>>
</span>
<?php echo $t_trip_info->vehicle_freight_comm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<div id="r_vehicle_freight_type" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_type" for="x_vehicle_freight_type" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_type->caption() ?><?php echo ($t_trip_info->vehicle_freight_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_freight_type" data-page="0" data-value-separator="<?php echo $t_trip_info->vehicle_freight_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_freight_type" name="x_vehicle_freight_type"<?php echo $t_trip_info->vehicle_freight_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_info->vehicle_freight_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<div id="r_vehicle_freight_amount" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_amount" for="x_vehicle_freight_amount" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_amount->caption() ?><?php echo ($t_trip_info->vehicle_freight_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_amount->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_amount">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_amount" data-page="0" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_amount->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_amount->editAttributes() ?>>
</span>
<?php echo $t_trip_info->vehicle_freight_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="t_trip_info_add"><!-- multi-page accordion -->
<div class="card ew-accordion-card<?php echo $t_trip_info_add->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_add->MultiPages->isActive("1")) ?>" href="#tab_t_trip_info1"><?php echo $t_trip_info->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_add->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_info_add->MultiPages->Parent ?>" id="tab_t_trip_info1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($t_trip_info->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_t_trip_info_reports_to" for="x_reports_to" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->reports_to->caption() ?><?php echo ($t_trip_info->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->reports_to->cellAttributes() ?>>
<span id="el_t_trip_info_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_reports_to" data-page="1" data-value-separator="<?php echo $t_trip_info->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $t_trip_info->reports_to->editAttributes() ?>>
		<?php echo $t_trip_info->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $t_trip_info->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $t_trip_info->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label id="elh_t_trip_info_buyer" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->buyer->caption() ?><?php echo ($t_trip_info->buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->buyer->cellAttributes() ?>>
<span id="el_t_trip_info_buyer">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$t_trip_info->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_info->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_info->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->buyer->ReadOnly || $t_trip_info->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$t_trip_info->buyer->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->buyer->caption() ?>" data-title="<?php echo $t_trip_info->buyer->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_buyer" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_info->buyer->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_info->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
<?php echo $t_trip_info->buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->b_consignor->Visible) { // b_consignor ?>
	<div id="r_b_consignor" class="form-group row">
		<label id="elh_t_trip_info_b_consignor" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->b_consignor->caption() ?><?php echo ($t_trip_info->b_consignor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->b_consignor->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignor">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignor->EditAttrs["onchange"] = "";
?>
<span id="as_x_b_consignor" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_b_consignor" id="sv_x_b_consignor" value="<?php echo RemoveHtml($t_trip_info->b_consignor->EditValue) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignor->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignor->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignor',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignor->ReadOnly || $t_trip_info->b_consignor->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignor" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignor->displayValueSeparatorAttribute() ?>" name="x_b_consignor" id="x_b_consignor" value="<?php echo HtmlEncode($t_trip_info->b_consignor->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x_b_consignor","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignor->Lookup->getParamTag("p_x_b_consignor") ?>
</span>
<?php echo $t_trip_info->b_consignor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->b_consignee->Visible) { // b_consignee ?>
	<div id="r_b_consignee" class="form-group row">
		<label id="elh_t_trip_info_b_consignee" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->b_consignee->caption() ?><?php echo ($t_trip_info->b_consignee->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->b_consignee->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignee">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignee->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignee->EditAttrs["onchange"] = "";
?>
<span id="as_x_b_consignee" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_b_consignee" id="sv_x_b_consignee" value="<?php echo RemoveHtml($t_trip_info->b_consignee->EditValue) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignee->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignee->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignee',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignee->ReadOnly || $t_trip_info->b_consignee->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignee" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignee->displayValueSeparatorAttribute() ?>" name="x_b_consignee" id="x_b_consignee" value="<?php echo HtmlEncode($t_trip_info->b_consignee->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x_b_consignee","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignee->Lookup->getParamTag("p_x_b_consignee") ?>
</span>
<?php echo $t_trip_info->b_consignee->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label id="elh_t_trip_info_agent" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->agent->caption() ?><?php echo ($t_trip_info->agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->agent->cellAttributes() ?>>
<span id="el_t_trip_info_agent">
<?php
$wrkonchange = "" . trim(@$t_trip_info->agent->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->agent->EditAttrs["onchange"] = "";
?>
<span id="as_x_agent" class="text-nowrap" style="z-index: 8780">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_agent" id="sv_x_agent" value="<?php echo RemoveHtml($t_trip_info->agent->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->agent->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->agent->getPlaceHolder()) ?>"<?php echo $t_trip_info->agent->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->agent->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_agent',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->agent->ReadOnly || $t_trip_info->agent->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_agent" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->agent->displayValueSeparatorAttribute() ?>" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($t_trip_info->agent->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoadd.createAutoSuggest({"id":"x_agent","forceSelect":true});
</script>
<?php echo $t_trip_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php echo $t_trip_info->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->comm->Visible) { // comm ?>
	<div id="r_comm" class="form-group row">
		<label id="elh_t_trip_info_comm" for="x_comm" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->comm->caption() ?><?php echo ($t_trip_info->comm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->comm->cellAttributes() ?>>
<span id="el_t_trip_info_comm">
<input type="text" data-table="t_trip_info" data-field="x_comm" data-page="1" name="x_comm" id="x_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->comm->EditValue ?>"<?php echo $t_trip_info->comm->editAttributes() ?>>
</span>
<?php echo $t_trip_info->comm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label id="elh_t_trip_info_material" for="x_material" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->material->caption() ?><?php echo ($t_trip_info->material->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->material->cellAttributes() ?>>
<span id="el_t_trip_info_material">
<input type="text" data-table="t_trip_info" data-field="x_material" data-page="1" name="x_material" id="x_material" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->material->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->material->EditValue ?>"<?php echo $t_trip_info->material->editAttributes() ?>>
</span>
<?php echo $t_trip_info->material->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_t_trip_info_packing_type" for="x_packing_type" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->packing_type->caption() ?><?php echo ($t_trip_info->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->packing_type->cellAttributes() ?>>
<span id="el_t_trip_info_packing_type">
<input type="text" data-table="t_trip_info" data-field="x_packing_type" data-page="1" name="x_packing_type" id="x_packing_type" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_trip_info->packing_type->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->packing_type->EditValue ?>"<?php echo $t_trip_info->packing_type->editAttributes() ?>>
</span>
<?php echo $t_trip_info->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->m_hsn->Visible) { // m_hsn ?>
	<div id="r_m_hsn" class="form-group row">
		<label id="elh_t_trip_info_m_hsn" for="x_m_hsn" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->m_hsn->caption() ?><?php echo ($t_trip_info->m_hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->m_hsn->cellAttributes() ?>>
<span id="el_t_trip_info_m_hsn">
<input type="text" data-table="t_trip_info" data-field="x_m_hsn" data-page="1" name="x_m_hsn" id="x_m_hsn" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($t_trip_info->m_hsn->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->m_hsn->EditValue ?>"<?php echo $t_trip_info->m_hsn->editAttributes() ?>>
</span>
<?php echo $t_trip_info->m_hsn->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_t_trip_info__40" for="x__40" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->_40->caption() ?><?php echo ($t_trip_info->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->_40->cellAttributes() ?>>
<span id="el_t_trip_info__40">
<input type="text" data-table="t_trip_info" data-field="x__40" data-page="1" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->_40->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->_40->EditValue ?>"<?php echo $t_trip_info->_40->editAttributes() ?>>
</span>
<?php echo $t_trip_info->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_trip_info_remarks" for="x_remarks" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->remarks->caption() ?><?php echo ($t_trip_info->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->remarks->cellAttributes() ?>>
<span id="el_t_trip_info_remarks">
<textarea data-table="t_trip_info" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($t_trip_info->remarks->getPlaceHolder()) ?>"<?php echo $t_trip_info->remarks->editAttributes() ?>><?php echo $t_trip_info->remarks->EditValue ?></textarea>
</span>
<?php echo $t_trip_info->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $t_trip_info_add->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_add->MultiPages->isActive("2")) ?>" href="#tab_t_trip_info2"><?php echo $t_trip_info->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_add->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $t_trip_info_add->MultiPages->Parent ?>" id="tab_t_trip_info2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($t_trip_info->freight_type->Visible) { // freight_type ?>
	<div id="r_freight_type" class="form-group row">
		<label id="elh_t_trip_info_freight_type" for="x_freight_type" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->freight_type->caption() ?><?php echo ($t_trip_info->freight_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_freight_type" data-page="2" data-value-separator="<?php echo $t_trip_info->freight_type->displayValueSeparatorAttribute() ?>" id="x_freight_type" name="x_freight_type"<?php echo $t_trip_info->freight_type->editAttributes() ?>>
		<?php echo $t_trip_info->freight_type->selectOptionListHtml("x_freight_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_info->freight_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->freight->Visible) { // freight ?>
	<div id="r_freight" class="form-group row">
		<label id="elh_t_trip_info_freight" for="x_freight" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->freight->caption() ?><?php echo ($t_trip_info->freight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->freight->cellAttributes() ?>>
<span id="el_t_trip_info_freight">
<input type="text" data-table="t_trip_info" data-field="x_freight" data-page="2" name="x_freight" id="x_freight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->freight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->freight->EditValue ?>"<?php echo $t_trip_info->freight->editAttributes() ?>>
</span>
<?php echo $t_trip_info->freight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->gst_percent->Visible) { // gst_percent ?>
	<div id="r_gst_percent" class="form-group row">
		<label id="elh_t_trip_info_gst_percent" for="x_gst_percent" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->gst_percent->caption() ?><?php echo ($t_trip_info->gst_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->gst_percent->cellAttributes() ?>>
<span id="el_t_trip_info_gst_percent">
<input type="text" data-table="t_trip_info" data-field="x_gst_percent" data-page="2" name="x_gst_percent" id="x_gst_percent" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->gst_percent->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->gst_percent->EditValue ?>"<?php echo $t_trip_info->gst_percent->editAttributes() ?>>
</span>
<?php echo $t_trip_info->gst_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
<div class="card ew-accordion-card<?php echo $t_trip_info_add->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_add->MultiPages->isActive("3")) ?>" href="#tab_t_trip_info3"><?php echo $t_trip_info->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_add->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $t_trip_info_add->MultiPages->Parent ?>" id="tab_t_trip_info3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-add-div"><!-- page* -->
<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
	<div id="r_load_date" class="form-group row">
		<label id="elh_t_trip_info_load_date" for="x_load_date" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->load_date->caption() ?><?php echo ($t_trip_info->load_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->load_date->cellAttributes() ?>>
<span id="el_t_trip_info_load_date">
<input type="text" data-table="t_trip_info" data-field="x_load_date" data-page="3" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_info->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_date->EditValue ?>"<?php echo $t_trip_info->load_date->editAttributes() ?>>
<?php if (!$t_trip_info->load_date->ReadOnly && !$t_trip_info->load_date->Disabled && !isset($t_trip_info->load_date->EditAttrs["readonly"]) && !isset($t_trip_info->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infoadd", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
<?php echo $t_trip_info->load_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label id="elh_t_trip_info_load_weight" for="x_load_weight" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->load_weight->caption() ?><?php echo ($t_trip_info->load_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->load_weight->cellAttributes() ?>>
<span id="el_t_trip_info_load_weight">
<input type="text" data-table="t_trip_info" data-field="x_load_weight" data-page="3" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_weight->EditValue ?>"<?php echo $t_trip_info->load_weight->editAttributes() ?>>
</span>
<?php echo $t_trip_info->load_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label id="elh_t_trip_info_load_km" for="x_load_km" class="<?php echo $t_trip_info_add->LeftColumnClass ?>"><?php echo $t_trip_info->load_km->caption() ?><?php echo ($t_trip_info->load_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_add->RightColumnClass ?>"><div<?php echo $t_trip_info->load_km->cellAttributes() ?>>
<span id="el_t_trip_info_load_km">
<input type="text" data-table="t_trip_info" data-field="x_load_km" data-page="3" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_km->EditValue ?>"<?php echo $t_trip_info->load_km->editAttributes() ?>>
</span>
<?php echo $t_trip_info->load_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
	if (in_array("t_expenses_o", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_expenses_o->DetailAdd) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_expenses_o", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_expenses_ogrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_receipt_d", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_receipt_d->DetailAdd) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_receipt_d", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_receipt_dgrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_diesal_expenses", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_diesal_expenses->DetailAdd) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_diesal_expenses", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_diesal_expensesgrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_route_info", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_route_info->DetailAdd) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_route_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_route_infogrid.php" ?>
<?php } ?>
<?php if (!$t_trip_info_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_info_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_trip_info_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_info_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var type = $("#x_vehicle_type").val();
		if (type == 1)
		{
		$("#r_consignor").hide();
		$("#r_vehicle_freight").hide();
		$("#r_vehicle_freight_type").hide();
		$("#r_vehicle_freight_amount").hide();
		$("#r_vehicle_freight_comm").hide();
		$("#r_vehicle_freight_final").hide();
		$("#r_driver").show();
		} else {
		$("#r_consignor").show();
		$("#r_vehicle_freight").show();
		$("#r_vehicle_freight_type").show();
		$("#r_vehicle_freight_amount").show();
		$("#r_vehicle_freight_comm").show();
		$("#r_vehicle_freight_final").show();
		$("#r_driver").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_add->terminate();
?>