<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_edit = new t_trip_info_edit();

// Run the page
$t_trip_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_trip_infoedit = currentForm = new ew.Form("ft_trip_infoedit", "edit");

// Validate form
ft_trip_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_trip_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->id->caption(), $t_trip_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->vehicle_type->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_type->caption(), $t_trip_info->vehicle_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->vehicle->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle->caption(), $t_trip_info->vehicle->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->_route->Required) { ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->_route->caption(), $t_trip_info->_route->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->_route->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->route_name->Required) { ?>
			elm = this.getElements("x" + infix + "_route_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->route_name->caption(), $t_trip_info->route_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->reports_to->caption(), $t_trip_info->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->buyer->caption(), $t_trip_info->buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->buyer->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->b_consignor->Required) { ?>
			elm = this.getElements("x" + infix + "_b_consignor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->b_consignor->caption(), $t_trip_info->b_consignor->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->b_consignee->Required) { ?>
			elm = this.getElements("x" + infix + "_b_consignee");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->b_consignee->caption(), $t_trip_info->b_consignee->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->load_date->Required) { ?>
			elm = this.getElements("x" + infix + "_load_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->load_date->caption(), $t_trip_info->load_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_date->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->load_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->load_weight->caption(), $t_trip_info->load_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_weight->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->unload_date->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->unload_date->caption(), $t_trip_info->unload_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_date->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->unload_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->unload_weight->caption(), $t_trip_info->unload_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_weight");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_weight->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->invoice_no->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->invoice_no->caption(), $t_trip_info->invoice_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->invoice_date->Required) { ?>
			elm = this.getElements("x" + infix + "_invoice_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->invoice_date->caption(), $t_trip_info->invoice_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->amount->Required) { ?>
			elm = this.getElements("x" + infix + "_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->amount->caption(), $t_trip_info->amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->delivery_pod->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_pod");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->delivery_pod->caption(), $t_trip_info->delivery_pod->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->status->caption(), $t_trip_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->days->Required) { ?>
			elm = this.getElements("x" + infix + "_days");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->days->caption(), $t_trip_info->days->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->driver->caption(), $t_trip_info->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->driver_name->Required) { ?>
			elm = this.getElements("x" + infix + "_driver_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->driver_name->caption(), $t_trip_info->driver_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->agent->caption(), $t_trip_info->agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->comm->Required) { ?>
			elm = this.getElements("x" + infix + "_comm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->comm->caption(), $t_trip_info->comm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_comm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->comm->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->material->Required) { ?>
			elm = this.getElements("x" + infix + "_material");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->material->caption(), $t_trip_info->material->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->packing_type->Required) { ?>
			elm = this.getElements("x" + infix + "_packing_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->packing_type->caption(), $t_trip_info->packing_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->m_hsn->Required) { ?>
			elm = this.getElements("x" + infix + "_m_hsn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->m_hsn->caption(), $t_trip_info->m_hsn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->_40->caption(), $t_trip_info->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->_40->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->lr_no->Required) { ?>
			elm = this.getElements("x" + infix + "_lr_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->lr_no->caption(), $t_trip_info->lr_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->km->Required) { ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->km->caption(), $t_trip_info->km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->km->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->freight_type->Required) { ?>
			elm = this.getElements("x" + infix + "_freight_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->freight_type->caption(), $t_trip_info->freight_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->freight->Required) { ?>
			elm = this.getElements("x" + infix + "_freight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->freight->caption(), $t_trip_info->freight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_freight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->freight->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->ded_det->Required) { ?>
			elm = this.getElements("x" + infix + "_ded_det");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->ded_det->caption(), $t_trip_info->ded_det->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ded_det");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->ded_det->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->ded_det_remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_ded_det_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->ded_det_remarks->caption(), $t_trip_info->ded_det_remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->gst_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_gst_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->gst_percent->caption(), $t_trip_info->gst_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_gst_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->gst_percent->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->gst_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_gst_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->gst_amount->caption(), $t_trip_info->gst_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->final_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_final_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->final_amount->caption(), $t_trip_info->final_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->load_km->Required) { ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->load_km->caption(), $t_trip_info->load_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_km->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->unload_km->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->unload_km->caption(), $t_trip_info->unload_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_km->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->delivery_receipt->Required) { ?>
			felm = this.getElements("x" + infix + "_delivery_receipt");
			elm = this.getElements("fn_x" + infix + "_delivery_receipt");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->delivery_receipt->caption(), $t_trip_info->delivery_receipt->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->delivery_docket->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_docket");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->delivery_docket->caption(), $t_trip_info->delivery_docket->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->diesal_op_b->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_op_b");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->diesal_op_b->caption(), $t_trip_info->diesal_op_b->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->diesal_required->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_required");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->diesal_required->caption(), $t_trip_info->diesal_required->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->diesal_fill->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_fill");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->diesal_fill->caption(), $t_trip_info->diesal_fill->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->diesal_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->diesal_amount->caption(), $t_trip_info->diesal_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->diesal_cl_balance->Required) { ?>
			elm = this.getElements("x" + infix + "_diesal_cl_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->diesal_cl_balance->caption(), $t_trip_info->diesal_cl_balance->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->vehicle_average->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_average");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_average->caption(), $t_trip_info->vehicle_average->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->cash_required->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_required");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->cash_required->caption(), $t_trip_info->cash_required->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->cash_op_b->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_op_b");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->cash_op_b->caption(), $t_trip_info->cash_op_b->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->cash_paid->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_paid");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->cash_paid->caption(), $t_trip_info->cash_paid->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->cash_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->cash_expenses->caption(), $t_trip_info->cash_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->cash_cl_balance->Required) { ?>
			elm = this.getElements("x" + infix + "_cash_cl_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->cash_cl_balance->caption(), $t_trip_info->cash_cl_balance->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->fasttag_op_b->Required) { ?>
			elm = this.getElements("x" + infix + "_fasttag_op_b");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->fasttag_op_b->caption(), $t_trip_info->fasttag_op_b->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->fasttag_recharge->Required) { ?>
			elm = this.getElements("x" + infix + "_fasttag_recharge");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->fasttag_recharge->caption(), $t_trip_info->fasttag_recharge->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->fasttag_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_fasttag_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->fasttag_expenses->caption(), $t_trip_info->fasttag_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->toll_expenses_cash->Required) { ?>
			elm = this.getElements("x" + infix + "_toll_expenses_cash");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->toll_expenses_cash->caption(), $t_trip_info->toll_expenses_cash->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->fasttag_cl_balance->Required) { ?>
			elm = this.getElements("x" + infix + "_fasttag_cl_balance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->fasttag_cl_balance->caption(), $t_trip_info->fasttag_cl_balance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_fasttag_cl_balance");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->fasttag_cl_balance->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->remarks->caption(), $t_trip_info->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->uploads->Required) { ?>
			felm = this.getElements("x" + infix + "_uploads");
			elm = this.getElements("fn_x" + infix + "_uploads");
			if (felm && elm && !ew.hasValue(elm))
				return this.onError(felm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->uploads->caption(), $t_trip_info->uploads->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->consignor->Required) { ?>
			elm = this.getElements("x" + infix + "_consignor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->consignor->caption(), $t_trip_info->consignor->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_consignor");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->consignor->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->vehicle_freight_comm->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_comm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_comm->caption(), $t_trip_info->vehicle_freight_comm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_comm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_comm->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->vehicle_freight_type->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_type->caption(), $t_trip_info->vehicle_freight_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->vehicle_freight_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_amount->caption(), $t_trip_info->vehicle_freight_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_amount->errorMessage()) ?>");
		<?php if ($t_trip_info_edit->vehicle_freight_final->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_final");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->vehicle_freight_final->caption(), $t_trip_info->vehicle_freight_final->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->operator->caption(), $t_trip_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_info_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_info->datetime->caption(), $t_trip_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_trip_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_infoedit.multiPage = new ew.MultiPage("ft_trip_infoedit");

// Dynamic selection lists
ft_trip_infoedit.lists["x_vehicle_type"] = <?php echo $t_trip_info_edit->vehicle_type->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_info_edit->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_infoedit.lists["x_vehicle"] = <?php echo $t_trip_info_edit->vehicle->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_info_edit->vehicle->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x__route"] = <?php echo $t_trip_info_edit->_route->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x__route"].options = <?php echo JsonEncode($t_trip_info_edit->_route->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x_reports_to"] = <?php echo $t_trip_info_edit->reports_to->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_info_edit->reports_to->lookupOptions()) ?>;
ft_trip_infoedit.lists["x_buyer"] = <?php echo $t_trip_info_edit->buyer->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_info_edit->buyer->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x_b_consignor"] = <?php echo $t_trip_info_edit->b_consignor->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_info_edit->b_consignor->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x_b_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x_b_consignee"] = <?php echo $t_trip_info_edit->b_consignee->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_info_edit->b_consignee->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x_b_consignee"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x_delivery_pod"] = <?php echo $t_trip_info_edit->delivery_pod->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_delivery_pod"].options = <?php echo JsonEncode($t_trip_info_edit->delivery_pod->options(FALSE, TRUE)) ?>;
ft_trip_infoedit.lists["x_status"] = <?php echo $t_trip_info_edit->status->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_status"].options = <?php echo JsonEncode($t_trip_info_edit->status->options(FALSE, TRUE)) ?>;
ft_trip_infoedit.lists["x_driver"] = <?php echo $t_trip_info_edit->driver->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_edit->driver->lookupOptions()) ?>;
ft_trip_infoedit.lists["x_agent"] = <?php echo $t_trip_info_edit->agent->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_agent"].options = <?php echo JsonEncode($t_trip_info_edit->agent->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x_freight_type"] = <?php echo $t_trip_info_edit->freight_type->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_info_edit->freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infoedit.lists["x_consignor"] = <?php echo $t_trip_info_edit->consignor->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_consignor"].options = <?php echo JsonEncode($t_trip_info_edit->consignor->lookupOptions()) ?>;
ft_trip_infoedit.autoSuggests["x_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoedit.lists["x_vehicle_freight_type"] = <?php echo $t_trip_info_edit->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_info_edit->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infoedit.lists["x_operator"] = <?php echo $t_trip_info_edit->operator->Lookup->toClientList() ?>;
ft_trip_infoedit.lists["x_operator"].options = <?php echo JsonEncode($t_trip_info_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_info_edit->showPageHeader(); ?>
<?php
$t_trip_info_edit->showMessage();
?>
<form name="ft_trip_infoedit" id="ft_trip_infoedit" class="<?php echo $t_trip_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_info_edit->IsModal ?>">
<?php if ($t_trip_info_edit->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($t_trip_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_trip_info_id" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->id->caption() ?><?php echo ($t_trip_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->id->cellAttributes() ?>>
<span id="el_t_trip_info_id">
<span<?php echo $t_trip_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_id" data-page="0" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_trip_info->id->CurrentValue) ?>">
<?php echo $t_trip_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
	<div id="r_vehicle_type" class="form-group row">
		<label id="elh_t_trip_info_vehicle_type" for="x_vehicle_type" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_type->caption() ?><?php echo ($t_trip_info->vehicle_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_type" data-page="0" data-value-separator="<?php echo $t_trip_info->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_info->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_info->vehicle_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label id="elh_t_trip_info_vehicle" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle->caption() ?><?php echo ($t_trip_info->vehicle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle">
<span<?php echo $t_trip_info->vehicle->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->vehicle->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_vehicle" data-page="0" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_info->vehicle->CurrentValue) ?>">
<?php echo $t_trip_info->vehicle->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label id="elh_t_trip_info__route" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->_route->caption() ?><?php echo ($t_trip_info->_route->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->_route->cellAttributes() ?>>
<span id="el_t_trip_info__route">
<?php
$wrkonchange = "" . trim(@$t_trip_info->_route->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->_route->EditAttrs["onchange"] = "";
?>
<span id="as_x__route" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__route" id="sv_x__route" value="<?php echo RemoveHtml($t_trip_info->_route->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->_route->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->_route->getPlaceHolder()) ?>"<?php echo $t_trip_info->_route->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->_route->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__route',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->_route->ReadOnly || $t_trip_info->_route->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "t_route_info") && !$t_trip_info->_route->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x__route" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->_route->caption() ?>" data-title="<?php echo $t_trip_info->_route->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x__route',url:'t_route_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x__route" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->_route->displayValueSeparatorAttribute() ?>" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_info->_route->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoedit.createAutoSuggest({"id":"x__route","forceSelect":true});
</script>
<?php echo $t_trip_info->_route->Lookup->getParamTag("p_x__route") ?>
</span>
<?php echo $t_trip_info->_route->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->route_name->Visible) { // route_name ?>
	<div id="r_route_name" class="form-group row">
		<label id="elh_t_trip_info_route_name" for="x_route_name" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->route_name->caption() ?><?php echo ($t_trip_info->route_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->route_name->cellAttributes() ?>>
<span id="el_t_trip_info_route_name">
<span<?php echo $t_trip_info->route_name->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->route_name->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_route_name" data-page="0" name="x_route_name" id="x_route_name" value="<?php echo HtmlEncode($t_trip_info->route_name->CurrentValue) ?>">
<?php echo $t_trip_info->route_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_t_trip_info_status" for="x_status" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->status->caption() ?><?php echo ($t_trip_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->status->cellAttributes() ?>>
<span id="el_t_trip_info_status">
<span<?php echo $t_trip_info->status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->status->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_status" data-page="0" name="x_status" id="x_status" value="<?php echo HtmlEncode($t_trip_info->status->CurrentValue) ?>">
<?php echo $t_trip_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->days->Visible) { // days ?>
	<div id="r_days" class="form-group row">
		<label id="elh_t_trip_info_days" for="x_days" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->days->caption() ?><?php echo ($t_trip_info->days->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->days->cellAttributes() ?>>
<span id="el_t_trip_info_days">
<span<?php echo $t_trip_info->days->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->days->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_days" data-page="0" name="x_days" id="x_days" value="<?php echo HtmlEncode($t_trip_info->days->CurrentValue) ?>">
<?php echo $t_trip_info->days->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label id="elh_t_trip_info_driver" for="x_driver" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->driver->caption() ?><?php echo ($t_trip_info->driver->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->driver->cellAttributes() ?>>
<span id="el_t_trip_info_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_driver" data-page="0" data-value-separator="<?php echo $t_trip_info->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $t_trip_info->driver->editAttributes() ?>>
		<?php echo $t_trip_info->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $t_trip_info->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
<?php echo $t_trip_info->driver->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->driver_name->Visible) { // driver_name ?>
	<div id="r_driver_name" class="form-group row">
		<label id="elh_t_trip_info_driver_name" for="x_driver_name" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->driver_name->caption() ?><?php echo ($t_trip_info->driver_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->driver_name->cellAttributes() ?>>
<span id="el_t_trip_info_driver_name">
<input type="text" data-table="t_trip_info" data-field="x_driver_name" data-page="0" name="x_driver_name" id="x_driver_name" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->driver_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->driver_name->EditValue ?>"<?php echo $t_trip_info->driver_name->editAttributes() ?>>
</span>
<?php echo $t_trip_info->driver_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->consignor->Visible) { // consignor ?>
	<div id="r_consignor" class="form-group row">
		<label id="elh_t_trip_info_consignor" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->consignor->caption() ?><?php echo ($t_trip_info->consignor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->consignor->cellAttributes() ?>>
<span id="el_t_trip_info_consignor">
<?php
$wrkonchange = "" . trim(@$t_trip_info->consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->consignor->EditAttrs["onchange"] = "";
?>
<span id="as_x_consignor" class="text-nowrap" style="z-index: 8410">
	<div class="input-group">
		<input type="text" class="form-control" name="sv_x_consignor" id="sv_x_consignor" value="<?php echo RemoveHtml($t_trip_info->consignor->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->consignor->editAttributes() ?>>
<?php if (AllowAdd(CurrentProjectID() . "production_partner") && !$t_trip_info->consignor->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_consignor" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->consignor->caption() ?>" data-title="<?php echo $t_trip_info->consignor->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_consignor',url:'production_partneraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_consignor" data-page="0" data-value-separator="<?php echo $t_trip_info->consignor->displayValueSeparatorAttribute() ?>" name="x_consignor" id="x_consignor" value="<?php echo HtmlEncode($t_trip_info->consignor->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoedit.createAutoSuggest({"id":"x_consignor","forceSelect":false});
</script>
<?php echo $t_trip_info->consignor->Lookup->getParamTag("p_x_consignor") ?>
</span>
<?php echo $t_trip_info->consignor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<div id="r_vehicle_freight_comm" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_comm" for="x_vehicle_freight_comm" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_comm->caption() ?><?php echo ($t_trip_info->vehicle_freight_comm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_comm->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_comm">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_comm" data-page="0" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_comm->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_comm->editAttributes() ?>>
</span>
<?php echo $t_trip_info->vehicle_freight_comm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<div id="r_vehicle_freight_type" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_type" for="x_vehicle_freight_type" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_type->caption() ?><?php echo ($t_trip_info->vehicle_freight_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_freight_type" data-page="0" data-value-separator="<?php echo $t_trip_info->vehicle_freight_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_freight_type" name="x_vehicle_freight_type"<?php echo $t_trip_info->vehicle_freight_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_info->vehicle_freight_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<div id="r_vehicle_freight_amount" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_amount" for="x_vehicle_freight_amount" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_amount->caption() ?><?php echo ($t_trip_info->vehicle_freight_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_amount->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_amount">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_amount" data-page="0" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_amount->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_amount->editAttributes() ?>>
</span>
<?php echo $t_trip_info->vehicle_freight_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
	<div id="r_vehicle_freight_final" class="form-group row">
		<label id="elh_t_trip_info_vehicle_freight_final" for="x_vehicle_freight_final" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_freight_final->caption() ?><?php echo ($t_trip_info->vehicle_freight_final->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_final->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_final">
<span<?php echo $t_trip_info->vehicle_freight_final->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->vehicle_freight_final->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_vehicle_freight_final" data-page="0" name="x_vehicle_freight_final" id="x_vehicle_freight_final" value="<?php echo HtmlEncode($t_trip_info->vehicle_freight_final->CurrentValue) ?>">
<?php echo $t_trip_info->vehicle_freight_final->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="t_trip_info_edit"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("1")) ?>" href="#tab_t_trip_info1"><?php echo $t_trip_info->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_t_trip_info_reports_to" for="x_reports_to" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->reports_to->caption() ?><?php echo ($t_trip_info->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->reports_to->cellAttributes() ?>>
<span id="el_t_trip_info_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_reports_to" data-page="1" data-value-separator="<?php echo $t_trip_info->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $t_trip_info->reports_to->editAttributes() ?>>
		<?php echo $t_trip_info->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $t_trip_info->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $t_trip_info->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label id="elh_t_trip_info_buyer" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->buyer->caption() ?><?php echo ($t_trip_info->buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->buyer->cellAttributes() ?>>
<span id="el_t_trip_info_buyer">
<?php
$wrkonchange = "ew.autoFill(this);" . trim(@$t_trip_info->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_info->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_info->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->buyer->ReadOnly || $t_trip_info->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$t_trip_info->buyer->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_info->buyer->caption() ?>" data-title="<?php echo $t_trip_info->buyer->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_buyer" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_info->buyer->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoedit.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_info->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
<?php echo $t_trip_info->buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->b_consignor->Visible) { // b_consignor ?>
	<div id="r_b_consignor" class="form-group row">
		<label id="elh_t_trip_info_b_consignor" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->b_consignor->caption() ?><?php echo ($t_trip_info->b_consignor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->b_consignor->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignor">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignor->EditAttrs["onchange"] = "";
?>
<span id="as_x_b_consignor" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_b_consignor" id="sv_x_b_consignor" value="<?php echo RemoveHtml($t_trip_info->b_consignor->EditValue) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignor->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignor->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignor',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignor->ReadOnly || $t_trip_info->b_consignor->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignor" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignor->displayValueSeparatorAttribute() ?>" name="x_b_consignor" id="x_b_consignor" value="<?php echo HtmlEncode($t_trip_info->b_consignor->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoedit.createAutoSuggest({"id":"x_b_consignor","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignor->Lookup->getParamTag("p_x_b_consignor") ?>
</span>
<?php echo $t_trip_info->b_consignor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->b_consignee->Visible) { // b_consignee ?>
	<div id="r_b_consignee" class="form-group row">
		<label id="elh_t_trip_info_b_consignee" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->b_consignee->caption() ?><?php echo ($t_trip_info->b_consignee->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->b_consignee->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignee">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignee->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignee->EditAttrs["onchange"] = "";
?>
<span id="as_x_b_consignee" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_b_consignee" id="sv_x_b_consignee" value="<?php echo RemoveHtml($t_trip_info->b_consignee->EditValue) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignee->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignee->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignee',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignee->ReadOnly || $t_trip_info->b_consignee->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignee" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignee->displayValueSeparatorAttribute() ?>" name="x_b_consignee" id="x_b_consignee" value="<?php echo HtmlEncode($t_trip_info->b_consignee->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoedit.createAutoSuggest({"id":"x_b_consignee","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignee->Lookup->getParamTag("p_x_b_consignee") ?>
</span>
<?php echo $t_trip_info->b_consignee->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label id="elh_t_trip_info_agent" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->agent->caption() ?><?php echo ($t_trip_info->agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->agent->cellAttributes() ?>>
<span id="el_t_trip_info_agent">
<?php
$wrkonchange = "" . trim(@$t_trip_info->agent->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->agent->EditAttrs["onchange"] = "";
?>
<span id="as_x_agent" class="text-nowrap" style="z-index: 8780">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_agent" id="sv_x_agent" value="<?php echo RemoveHtml($t_trip_info->agent->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->agent->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->agent->getPlaceHolder()) ?>"<?php echo $t_trip_info->agent->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->agent->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_agent',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->agent->ReadOnly || $t_trip_info->agent->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_agent" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->agent->displayValueSeparatorAttribute() ?>" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($t_trip_info->agent->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infoedit.createAutoSuggest({"id":"x_agent","forceSelect":true});
</script>
<?php echo $t_trip_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php echo $t_trip_info->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->comm->Visible) { // comm ?>
	<div id="r_comm" class="form-group row">
		<label id="elh_t_trip_info_comm" for="x_comm" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->comm->caption() ?><?php echo ($t_trip_info->comm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->comm->cellAttributes() ?>>
<span id="el_t_trip_info_comm">
<input type="text" data-table="t_trip_info" data-field="x_comm" data-page="1" name="x_comm" id="x_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->comm->EditValue ?>"<?php echo $t_trip_info->comm->editAttributes() ?>>
</span>
<?php echo $t_trip_info->comm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label id="elh_t_trip_info_material" for="x_material" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->material->caption() ?><?php echo ($t_trip_info->material->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->material->cellAttributes() ?>>
<span id="el_t_trip_info_material">
<input type="text" data-table="t_trip_info" data-field="x_material" data-page="1" name="x_material" id="x_material" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->material->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->material->EditValue ?>"<?php echo $t_trip_info->material->editAttributes() ?>>
</span>
<?php echo $t_trip_info->material->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label id="elh_t_trip_info_packing_type" for="x_packing_type" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->packing_type->caption() ?><?php echo ($t_trip_info->packing_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->packing_type->cellAttributes() ?>>
<span id="el_t_trip_info_packing_type">
<input type="text" data-table="t_trip_info" data-field="x_packing_type" data-page="1" name="x_packing_type" id="x_packing_type" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_trip_info->packing_type->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->packing_type->EditValue ?>"<?php echo $t_trip_info->packing_type->editAttributes() ?>>
</span>
<?php echo $t_trip_info->packing_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->m_hsn->Visible) { // m_hsn ?>
	<div id="r_m_hsn" class="form-group row">
		<label id="elh_t_trip_info_m_hsn" for="x_m_hsn" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->m_hsn->caption() ?><?php echo ($t_trip_info->m_hsn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->m_hsn->cellAttributes() ?>>
<span id="el_t_trip_info_m_hsn">
<input type="text" data-table="t_trip_info" data-field="x_m_hsn" data-page="1" name="x_m_hsn" id="x_m_hsn" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($t_trip_info->m_hsn->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->m_hsn->EditValue ?>"<?php echo $t_trip_info->m_hsn->editAttributes() ?>>
</span>
<?php echo $t_trip_info->m_hsn->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_t_trip_info__40" for="x__40" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->_40->caption() ?><?php echo ($t_trip_info->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->_40->cellAttributes() ?>>
<span id="el_t_trip_info__40">
<input type="text" data-table="t_trip_info" data-field="x__40" data-page="1" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->_40->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->_40->EditValue ?>"<?php echo $t_trip_info->_40->editAttributes() ?>>
</span>
<?php echo $t_trip_info->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->lr_no->Visible) { // lr_no ?>
	<div id="r_lr_no" class="form-group row">
		<label id="elh_t_trip_info_lr_no" for="x_lr_no" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->lr_no->caption() ?><?php echo ($t_trip_info->lr_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->lr_no->cellAttributes() ?>>
<span id="el_t_trip_info_lr_no">
<input type="text" data-table="t_trip_info" data-field="x_lr_no" data-page="1" name="x_lr_no" id="x_lr_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($t_trip_info->lr_no->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->lr_no->EditValue ?>"<?php echo $t_trip_info->lr_no->editAttributes() ?>>
</span>
<?php echo $t_trip_info->lr_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_trip_info_remarks" for="x_remarks" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->remarks->caption() ?><?php echo ($t_trip_info->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->remarks->cellAttributes() ?>>
<span id="el_t_trip_info_remarks">
<textarea data-table="t_trip_info" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($t_trip_info->remarks->getPlaceHolder()) ?>"<?php echo $t_trip_info->remarks->editAttributes() ?>><?php echo $t_trip_info->remarks->EditValue ?></textarea>
</span>
<?php echo $t_trip_info->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("2")) ?>" href="#tab_t_trip_info2"><?php echo $t_trip_info->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label id="elh_t_trip_info_invoice_no" for="x_invoice_no" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->invoice_no->caption() ?><?php echo ($t_trip_info->invoice_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->invoice_no->cellAttributes() ?>>
<span id="el_t_trip_info_invoice_no">
<span<?php echo $t_trip_info->invoice_no->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->invoice_no->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_invoice_no" data-page="2" name="x_invoice_no" id="x_invoice_no" value="<?php echo HtmlEncode($t_trip_info->invoice_no->CurrentValue) ?>">
<?php echo $t_trip_info->invoice_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label id="elh_t_trip_info_invoice_date" for="x_invoice_date" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->invoice_date->caption() ?><?php echo ($t_trip_info->invoice_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->invoice_date->cellAttributes() ?>>
<span id="el_t_trip_info_invoice_date">
<span<?php echo $t_trip_info->invoice_date->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->invoice_date->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_invoice_date" data-page="2" name="x_invoice_date" id="x_invoice_date" value="<?php echo HtmlEncode($t_trip_info->invoice_date->CurrentValue) ?>">
<?php echo $t_trip_info->invoice_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label id="elh_t_trip_info_amount" for="x_amount" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->amount->caption() ?><?php echo ($t_trip_info->amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->amount->cellAttributes() ?>>
<span id="el_t_trip_info_amount">
<span<?php echo $t_trip_info->amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_amount" data-page="2" name="x_amount" id="x_amount" value="<?php echo HtmlEncode($t_trip_info->amount->CurrentValue) ?>">
<?php echo $t_trip_info->amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label id="elh_t_trip_info_km" for="x_km" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->km->caption() ?><?php echo ($t_trip_info->km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->km->cellAttributes() ?>>
<span id="el_t_trip_info_km">
<input type="text" data-table="t_trip_info" data-field="x_km" data-page="2" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->km->EditValue ?>"<?php echo $t_trip_info->km->editAttributes() ?>>
</span>
<?php echo $t_trip_info->km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->freight_type->Visible) { // freight_type ?>
	<div id="r_freight_type" class="form-group row">
		<label id="elh_t_trip_info_freight_type" for="x_freight_type" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->freight_type->caption() ?><?php echo ($t_trip_info->freight_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_freight_type" data-page="2" data-value-separator="<?php echo $t_trip_info->freight_type->displayValueSeparatorAttribute() ?>" id="x_freight_type" name="x_freight_type"<?php echo $t_trip_info->freight_type->editAttributes() ?>>
		<?php echo $t_trip_info->freight_type->selectOptionListHtml("x_freight_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_info->freight_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->freight->Visible) { // freight ?>
	<div id="r_freight" class="form-group row">
		<label id="elh_t_trip_info_freight" for="x_freight" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->freight->caption() ?><?php echo ($t_trip_info->freight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->freight->cellAttributes() ?>>
<span id="el_t_trip_info_freight">
<input type="text" data-table="t_trip_info" data-field="x_freight" data-page="2" name="x_freight" id="x_freight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->freight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->freight->EditValue ?>"<?php echo $t_trip_info->freight->editAttributes() ?>>
</span>
<?php echo $t_trip_info->freight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->ded_det->Visible) { // ded_det ?>
	<div id="r_ded_det" class="form-group row">
		<label id="elh_t_trip_info_ded_det" for="x_ded_det" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->ded_det->caption() ?><?php echo ($t_trip_info->ded_det->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->ded_det->cellAttributes() ?>>
<span id="el_t_trip_info_ded_det">
<input type="text" data-table="t_trip_info" data-field="x_ded_det" data-page="2" name="x_ded_det" id="x_ded_det" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->ded_det->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->ded_det->EditValue ?>"<?php echo $t_trip_info->ded_det->editAttributes() ?>>
</span>
<?php echo $t_trip_info->ded_det->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->ded_det_remarks->Visible) { // ded_det_remarks ?>
	<div id="r_ded_det_remarks" class="form-group row">
		<label id="elh_t_trip_info_ded_det_remarks" for="x_ded_det_remarks" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->ded_det_remarks->caption() ?><?php echo ($t_trip_info->ded_det_remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->ded_det_remarks->cellAttributes() ?>>
<span id="el_t_trip_info_ded_det_remarks">
<input type="text" data-table="t_trip_info" data-field="x_ded_det_remarks" data-page="2" name="x_ded_det_remarks" id="x_ded_det_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_trip_info->ded_det_remarks->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->ded_det_remarks->EditValue ?>"<?php echo $t_trip_info->ded_det_remarks->editAttributes() ?>>
</span>
<?php echo $t_trip_info->ded_det_remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->gst_percent->Visible) { // gst_percent ?>
	<div id="r_gst_percent" class="form-group row">
		<label id="elh_t_trip_info_gst_percent" for="x_gst_percent" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->gst_percent->caption() ?><?php echo ($t_trip_info->gst_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->gst_percent->cellAttributes() ?>>
<span id="el_t_trip_info_gst_percent">
<input type="text" data-table="t_trip_info" data-field="x_gst_percent" data-page="2" name="x_gst_percent" id="x_gst_percent" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->gst_percent->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->gst_percent->EditValue ?>"<?php echo $t_trip_info->gst_percent->editAttributes() ?>>
</span>
<?php echo $t_trip_info->gst_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->gst_amount->Visible) { // gst_amount ?>
	<div id="r_gst_amount" class="form-group row">
		<label id="elh_t_trip_info_gst_amount" for="x_gst_amount" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->gst_amount->caption() ?><?php echo ($t_trip_info->gst_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->gst_amount->cellAttributes() ?>>
<span id="el_t_trip_info_gst_amount">
<span<?php echo $t_trip_info->gst_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->gst_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_gst_amount" data-page="2" name="x_gst_amount" id="x_gst_amount" value="<?php echo HtmlEncode($t_trip_info->gst_amount->CurrentValue) ?>">
<?php echo $t_trip_info->gst_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label id="elh_t_trip_info_final_amount" for="x_final_amount" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->final_amount->caption() ?><?php echo ($t_trip_info->final_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->final_amount->cellAttributes() ?>>
<span id="el_t_trip_info_final_amount">
<span<?php echo $t_trip_info->final_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->final_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_final_amount" data-page="2" name="x_final_amount" id="x_final_amount" value="<?php echo HtmlEncode($t_trip_info->final_amount->CurrentValue) ?>">
<?php echo $t_trip_info->final_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("3")) ?>" href="#tab_t_trip_info3"><?php echo $t_trip_info->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
	<div id="r_load_date" class="form-group row">
		<label id="elh_t_trip_info_load_date" for="x_load_date" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->load_date->caption() ?><?php echo ($t_trip_info->load_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->load_date->cellAttributes() ?>>
<span id="el_t_trip_info_load_date">
<input type="text" data-table="t_trip_info" data-field="x_load_date" data-page="3" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_info->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_date->EditValue ?>"<?php echo $t_trip_info->load_date->editAttributes() ?>>
<?php if (!$t_trip_info->load_date->ReadOnly && !$t_trip_info->load_date->Disabled && !isset($t_trip_info->load_date->EditAttrs["readonly"]) && !isset($t_trip_info->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infoedit", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
<?php echo $t_trip_info->load_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label id="elh_t_trip_info_load_weight" for="x_load_weight" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->load_weight->caption() ?><?php echo ($t_trip_info->load_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->load_weight->cellAttributes() ?>>
<span id="el_t_trip_info_load_weight">
<input type="text" data-table="t_trip_info" data-field="x_load_weight" data-page="3" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_weight->EditValue ?>"<?php echo $t_trip_info->load_weight->editAttributes() ?>>
</span>
<?php echo $t_trip_info->load_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_date->Visible) { // unload_date ?>
	<div id="r_unload_date" class="form-group row">
		<label id="elh_t_trip_info_unload_date" for="x_unload_date" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->unload_date->caption() ?><?php echo ($t_trip_info->unload_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->unload_date->cellAttributes() ?>>
<span id="el_t_trip_info_unload_date">
<input type="text" data-table="t_trip_info" data-field="x_unload_date" data-page="3" name="x_unload_date" id="x_unload_date" placeholder="<?php echo HtmlEncode($t_trip_info->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_date->EditValue ?>"<?php echo $t_trip_info->unload_date->editAttributes() ?>>
<?php if (!$t_trip_info->unload_date->ReadOnly && !$t_trip_info->unload_date->Disabled && !isset($t_trip_info->unload_date->EditAttrs["readonly"]) && !isset($t_trip_info->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infoedit", "x_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $t_trip_info->unload_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_weight->Visible) { // unload_weight ?>
	<div id="r_unload_weight" class="form-group row">
		<label id="elh_t_trip_info_unload_weight" for="x_unload_weight" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->unload_weight->caption() ?><?php echo ($t_trip_info->unload_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->unload_weight->cellAttributes() ?>>
<span id="el_t_trip_info_unload_weight">
<input type="text" data-table="t_trip_info" data-field="x_unload_weight" data-page="3" name="x_unload_weight" id="x_unload_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->unload_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_weight->EditValue ?>"<?php echo $t_trip_info->unload_weight->editAttributes() ?>>
</span>
<?php echo $t_trip_info->unload_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->delivery_pod->Visible) { // delivery_pod ?>
	<div id="r_delivery_pod" class="form-group row">
		<label id="elh_t_trip_info_delivery_pod" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->delivery_pod->caption() ?><?php echo ($t_trip_info->delivery_pod->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->delivery_pod->cellAttributes() ?>>
<span id="el_t_trip_info_delivery_pod">
<div id="tp_x_delivery_pod" class="ew-template"><input type="radio" class="form-check-input" data-table="t_trip_info" data-field="x_delivery_pod" data-page="3" data-value-separator="<?php echo $t_trip_info->delivery_pod->displayValueSeparatorAttribute() ?>" name="x_delivery_pod" id="x_delivery_pod" value="{value}"<?php echo $t_trip_info->delivery_pod->editAttributes() ?>></div>
<div id="dsl_x_delivery_pod" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $t_trip_info->delivery_pod->radioButtonListHtml(FALSE, "x_delivery_pod", 3) ?>
</div></div>
</span>
<?php echo $t_trip_info->delivery_pod->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label id="elh_t_trip_info_load_km" for="x_load_km" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->load_km->caption() ?><?php echo ($t_trip_info->load_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->load_km->cellAttributes() ?>>
<span id="el_t_trip_info_load_km">
<input type="text" data-table="t_trip_info" data-field="x_load_km" data-page="3" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_km->EditValue ?>"<?php echo $t_trip_info->load_km->editAttributes() ?>>
</span>
<?php echo $t_trip_info->load_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_km->Visible) { // unload_km ?>
	<div id="r_unload_km" class="form-group row">
		<label id="elh_t_trip_info_unload_km" for="x_unload_km" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->unload_km->caption() ?><?php echo ($t_trip_info->unload_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->unload_km->cellAttributes() ?>>
<span id="el_t_trip_info_unload_km">
<input type="text" data-table="t_trip_info" data-field="x_unload_km" data-page="3" name="x_unload_km" id="x_unload_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->unload_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_km->EditValue ?>"<?php echo $t_trip_info->unload_km->editAttributes() ?>>
</span>
<?php echo $t_trip_info->unload_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->delivery_receipt->Visible) { // delivery_receipt ?>
	<div id="r_delivery_receipt" class="form-group row">
		<label id="elh_t_trip_info_delivery_receipt" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->delivery_receipt->caption() ?><?php echo ($t_trip_info->delivery_receipt->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->delivery_receipt->cellAttributes() ?>>
<span id="el_t_trip_info_delivery_receipt">
<div id="fd_x_delivery_receipt">
<span title="<?php echo $t_trip_info->delivery_receipt->title() ? $t_trip_info->delivery_receipt->title() : $Language->phrase("ChooseFiles") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_trip_info->delivery_receipt->ReadOnly || $t_trip_info->delivery_receipt->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_trip_info" data-field="x_delivery_receipt" data-page="3" name="x_delivery_receipt" id="x_delivery_receipt" multiple="multiple"<?php echo $t_trip_info->delivery_receipt->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_delivery_receipt" id= "fn_x_delivery_receipt" value="<?php echo $t_trip_info->delivery_receipt->Upload->FileName ?>">
<?php if (Post("fa_x_delivery_receipt") == "0") { ?>
<input type="hidden" name="fa_x_delivery_receipt" id= "fa_x_delivery_receipt" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_delivery_receipt" id= "fa_x_delivery_receipt" value="1">
<?php } ?>
<input type="hidden" name="fs_x_delivery_receipt" id= "fs_x_delivery_receipt" value="250">
<input type="hidden" name="fx_x_delivery_receipt" id= "fx_x_delivery_receipt" value="<?php echo $t_trip_info->delivery_receipt->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_delivery_receipt" id= "fm_x_delivery_receipt" value="<?php echo $t_trip_info->delivery_receipt->UploadMaxFileSize ?>">
<input type="hidden" name="fc_x_delivery_receipt" id= "fc_x_delivery_receipt" value="<?php echo $t_trip_info->delivery_receipt->UploadMaxFileCount ?>">
</div>
<table id="ft_x_delivery_receipt" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_trip_info->delivery_receipt->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->delivery_docket->Visible) { // delivery_docket ?>
	<div id="r_delivery_docket" class="form-group row">
		<label id="elh_t_trip_info_delivery_docket" for="x_delivery_docket" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->delivery_docket->caption() ?><?php echo ($t_trip_info->delivery_docket->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->delivery_docket->cellAttributes() ?>>
<span id="el_t_trip_info_delivery_docket">
<input type="text" data-table="t_trip_info" data-field="x_delivery_docket" data-page="3" name="x_delivery_docket" id="x_delivery_docket" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_trip_info->delivery_docket->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->delivery_docket->EditValue ?>"<?php echo $t_trip_info->delivery_docket->editAttributes() ?>>
</span>
<?php echo $t_trip_info->delivery_docket->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("4") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("4")) ?>" href="#tab_t_trip_info4"><?php echo $t_trip_info->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->diesal_op_b->Visible) { // diesal_op_b ?>
	<div id="r_diesal_op_b" class="form-group row">
		<label id="elh_t_trip_info_diesal_op_b" for="x_diesal_op_b" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->diesal_op_b->caption() ?><?php echo ($t_trip_info->diesal_op_b->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_op_b->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_op_b">
<span<?php echo $t_trip_info->diesal_op_b->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->diesal_op_b->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_diesal_op_b" data-page="4" name="x_diesal_op_b" id="x_diesal_op_b" value="<?php echo HtmlEncode($t_trip_info->diesal_op_b->CurrentValue) ?>">
<?php echo $t_trip_info->diesal_op_b->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_required->Visible) { // diesal_required ?>
	<div id="r_diesal_required" class="form-group row">
		<label id="elh_t_trip_info_diesal_required" for="x_diesal_required" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->diesal_required->caption() ?><?php echo ($t_trip_info->diesal_required->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_required->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_required">
<span<?php echo $t_trip_info->diesal_required->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->diesal_required->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_diesal_required" data-page="4" name="x_diesal_required" id="x_diesal_required" value="<?php echo HtmlEncode($t_trip_info->diesal_required->CurrentValue) ?>">
<?php echo $t_trip_info->diesal_required->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_fill->Visible) { // diesal_fill ?>
	<div id="r_diesal_fill" class="form-group row">
		<label id="elh_t_trip_info_diesal_fill" for="x_diesal_fill" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->diesal_fill->caption() ?><?php echo ($t_trip_info->diesal_fill->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_fill->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_fill">
<span<?php echo $t_trip_info->diesal_fill->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->diesal_fill->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_diesal_fill" data-page="4" name="x_diesal_fill" id="x_diesal_fill" value="<?php echo HtmlEncode($t_trip_info->diesal_fill->CurrentValue) ?>">
<?php echo $t_trip_info->diesal_fill->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_amount->Visible) { // diesal_amount ?>
	<div id="r_diesal_amount" class="form-group row">
		<label id="elh_t_trip_info_diesal_amount" for="x_diesal_amount" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->diesal_amount->caption() ?><?php echo ($t_trip_info->diesal_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_amount->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_amount">
<span<?php echo $t_trip_info->diesal_amount->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->diesal_amount->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_diesal_amount" data-page="4" name="x_diesal_amount" id="x_diesal_amount" value="<?php echo HtmlEncode($t_trip_info->diesal_amount->CurrentValue) ?>">
<?php echo $t_trip_info->diesal_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
	<div id="r_diesal_cl_balance" class="form-group row">
		<label id="elh_t_trip_info_diesal_cl_balance" for="x_diesal_cl_balance" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->diesal_cl_balance->caption() ?><?php echo ($t_trip_info->diesal_cl_balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_cl_balance->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_cl_balance">
<span<?php echo $t_trip_info->diesal_cl_balance->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->diesal_cl_balance->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_diesal_cl_balance" data-page="4" name="x_diesal_cl_balance" id="x_diesal_cl_balance" value="<?php echo HtmlEncode($t_trip_info->diesal_cl_balance->CurrentValue) ?>">
<?php echo $t_trip_info->diesal_cl_balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_average->Visible) { // vehicle_average ?>
	<div id="r_vehicle_average" class="form-group row">
		<label id="elh_t_trip_info_vehicle_average" for="x_vehicle_average" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->vehicle_average->caption() ?><?php echo ($t_trip_info->vehicle_average->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_average->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_average">
<span<?php echo $t_trip_info->vehicle_average->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->vehicle_average->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_vehicle_average" data-page="4" name="x_vehicle_average" id="x_vehicle_average" value="<?php echo HtmlEncode($t_trip_info->vehicle_average->CurrentValue) ?>">
<?php echo $t_trip_info->vehicle_average->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("5") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("5")) ?>" href="#tab_t_trip_info5"><?php echo $t_trip_info->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->cash_required->Visible) { // cash_required ?>
	<div id="r_cash_required" class="form-group row">
		<label id="elh_t_trip_info_cash_required" for="x_cash_required" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->cash_required->caption() ?><?php echo ($t_trip_info->cash_required->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_required->cellAttributes() ?>>
<span id="el_t_trip_info_cash_required">
<span<?php echo $t_trip_info->cash_required->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->cash_required->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_cash_required" data-page="5" name="x_cash_required" id="x_cash_required" value="<?php echo HtmlEncode($t_trip_info->cash_required->CurrentValue) ?>">
<?php echo $t_trip_info->cash_required->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_op_b->Visible) { // cash_op_b ?>
	<div id="r_cash_op_b" class="form-group row">
		<label id="elh_t_trip_info_cash_op_b" for="x_cash_op_b" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->cash_op_b->caption() ?><?php echo ($t_trip_info->cash_op_b->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_op_b->cellAttributes() ?>>
<span id="el_t_trip_info_cash_op_b">
<span<?php echo $t_trip_info->cash_op_b->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->cash_op_b->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_cash_op_b" data-page="5" name="x_cash_op_b" id="x_cash_op_b" value="<?php echo HtmlEncode($t_trip_info->cash_op_b->CurrentValue) ?>">
<?php echo $t_trip_info->cash_op_b->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_paid->Visible) { // cash_paid ?>
	<div id="r_cash_paid" class="form-group row">
		<label id="elh_t_trip_info_cash_paid" for="x_cash_paid" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->cash_paid->caption() ?><?php echo ($t_trip_info->cash_paid->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_paid->cellAttributes() ?>>
<span id="el_t_trip_info_cash_paid">
<span<?php echo $t_trip_info->cash_paid->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->cash_paid->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_cash_paid" data-page="5" name="x_cash_paid" id="x_cash_paid" value="<?php echo HtmlEncode($t_trip_info->cash_paid->CurrentValue) ?>">
<?php echo $t_trip_info->cash_paid->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_expenses->Visible) { // cash_expenses ?>
	<div id="r_cash_expenses" class="form-group row">
		<label id="elh_t_trip_info_cash_expenses" for="x_cash_expenses" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->cash_expenses->caption() ?><?php echo ($t_trip_info->cash_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_expenses->cellAttributes() ?>>
<span id="el_t_trip_info_cash_expenses">
<span<?php echo $t_trip_info->cash_expenses->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->cash_expenses->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_cash_expenses" data-page="5" name="x_cash_expenses" id="x_cash_expenses" value="<?php echo HtmlEncode($t_trip_info->cash_expenses->CurrentValue) ?>">
<?php echo $t_trip_info->cash_expenses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_cl_balance->Visible) { // cash_cl_balance ?>
	<div id="r_cash_cl_balance" class="form-group row">
		<label id="elh_t_trip_info_cash_cl_balance" for="x_cash_cl_balance" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->cash_cl_balance->caption() ?><?php echo ($t_trip_info->cash_cl_balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_cl_balance->cellAttributes() ?>>
<span id="el_t_trip_info_cash_cl_balance">
<span<?php echo $t_trip_info->cash_cl_balance->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->cash_cl_balance->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_cash_cl_balance" data-page="5" name="x_cash_cl_balance" id="x_cash_cl_balance" value="<?php echo HtmlEncode($t_trip_info->cash_cl_balance->CurrentValue) ?>">
<?php echo $t_trip_info->cash_cl_balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("6") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("6")) ?>" href="#tab_t_trip_info6"><?php echo $t_trip_info->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->fasttag_op_b->Visible) { // fasttag_op_b ?>
	<div id="r_fasttag_op_b" class="form-group row">
		<label id="elh_t_trip_info_fasttag_op_b" for="x_fasttag_op_b" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->fasttag_op_b->caption() ?><?php echo ($t_trip_info->fasttag_op_b->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_op_b->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_op_b">
<span<?php echo $t_trip_info->fasttag_op_b->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->fasttag_op_b->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_fasttag_op_b" data-page="6" name="x_fasttag_op_b" id="x_fasttag_op_b" value="<?php echo HtmlEncode($t_trip_info->fasttag_op_b->CurrentValue) ?>">
<?php echo $t_trip_info->fasttag_op_b->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->fasttag_recharge->Visible) { // fasttag_recharge ?>
	<div id="r_fasttag_recharge" class="form-group row">
		<label id="elh_t_trip_info_fasttag_recharge" for="x_fasttag_recharge" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->fasttag_recharge->caption() ?><?php echo ($t_trip_info->fasttag_recharge->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_recharge->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_recharge">
<span<?php echo $t_trip_info->fasttag_recharge->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->fasttag_recharge->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_fasttag_recharge" data-page="6" name="x_fasttag_recharge" id="x_fasttag_recharge" value="<?php echo HtmlEncode($t_trip_info->fasttag_recharge->CurrentValue) ?>">
<?php echo $t_trip_info->fasttag_recharge->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->fasttag_expenses->Visible) { // fasttag_expenses ?>
	<div id="r_fasttag_expenses" class="form-group row">
		<label id="elh_t_trip_info_fasttag_expenses" for="x_fasttag_expenses" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->fasttag_expenses->caption() ?><?php echo ($t_trip_info->fasttag_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_expenses->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_expenses">
<span<?php echo $t_trip_info->fasttag_expenses->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->fasttag_expenses->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_fasttag_expenses" data-page="6" name="x_fasttag_expenses" id="x_fasttag_expenses" value="<?php echo HtmlEncode($t_trip_info->fasttag_expenses->CurrentValue) ?>">
<?php echo $t_trip_info->fasttag_expenses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
	<div id="r_toll_expenses_cash" class="form-group row">
		<label id="elh_t_trip_info_toll_expenses_cash" for="x_toll_expenses_cash" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->toll_expenses_cash->caption() ?><?php echo ($t_trip_info->toll_expenses_cash->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->toll_expenses_cash->cellAttributes() ?>>
<span id="el_t_trip_info_toll_expenses_cash">
<span<?php echo $t_trip_info->toll_expenses_cash->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_info->toll_expenses_cash->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_toll_expenses_cash" data-page="6" name="x_toll_expenses_cash" id="x_toll_expenses_cash" value="<?php echo HtmlEncode($t_trip_info->toll_expenses_cash->CurrentValue) ?>">
<?php echo $t_trip_info->toll_expenses_cash->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
	<div id="r_fasttag_cl_balance" class="form-group row">
		<label id="elh_t_trip_info_fasttag_cl_balance" for="x_fasttag_cl_balance" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->fasttag_cl_balance->caption() ?><?php echo ($t_trip_info->fasttag_cl_balance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_cl_balance->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_cl_balance">
<input type="text" data-table="t_trip_info" data-field="x_fasttag_cl_balance" data-page="6" name="x_fasttag_cl_balance" id="x_fasttag_cl_balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->fasttag_cl_balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->fasttag_cl_balance->EditValue ?>"<?php echo $t_trip_info->fasttag_cl_balance->editAttributes() ?>>
</span>
<?php echo $t_trip_info->fasttag_cl_balance->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_edit->MultiPages->pageStyle("7") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_edit->MultiPages->isActive("7")) ?>" href="#tab_t_trip_info7"><?php echo $t_trip_info->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_edit->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $t_trip_info_edit->MultiPages->Parent ?>" id="tab_t_trip_info7"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_info->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label id="elh_t_trip_info_uploads" class="<?php echo $t_trip_info_edit->LeftColumnClass ?>"><?php echo $t_trip_info->uploads->caption() ?><?php echo ($t_trip_info->uploads->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_info_edit->RightColumnClass ?>"><div<?php echo $t_trip_info->uploads->cellAttributes() ?>>
<span id="el_t_trip_info_uploads">
<div id="fd_x_uploads">
<span title="<?php echo $t_trip_info->uploads->title() ? $t_trip_info->uploads->title() : $Language->phrase("ChooseFile") ?>" class="btn btn-default btn-sm fileinput-button ew-tooltip<?php if ($t_trip_info->uploads->ReadOnly || $t_trip_info->uploads->Disabled) echo " d-none"; ?>">
	<span><?php echo $Language->phrase("ChooseFileBtn") ?></span>
	<input type="file" title=" " data-table="t_trip_info" data-field="x_uploads" data-page="7" name="x_uploads" id="x_uploads"<?php echo $t_trip_info->uploads->editAttributes() ?>>
</span>
<input type="hidden" name="fn_x_uploads" id= "fn_x_uploads" value="<?php echo $t_trip_info->uploads->Upload->FileName ?>">
<?php if (Post("fa_x_uploads") == "0") { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_uploads" id= "fa_x_uploads" value="1">
<?php } ?>
<input type="hidden" name="fs_x_uploads" id= "fs_x_uploads" value="500">
<input type="hidden" name="fx_x_uploads" id= "fx_x_uploads" value="<?php echo $t_trip_info->uploads->UploadAllowedFileExt ?>">
<input type="hidden" name="fm_x_uploads" id= "fm_x_uploads" value="<?php echo $t_trip_info->uploads->UploadMaxFileSize ?>">
</div>
<table id="ft_x_uploads" class="table table-sm float-left ew-upload-table"><tbody class="files"></tbody></table>
</span>
<?php echo $t_trip_info->uploads->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php
	if (in_array("t_expenses_o", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_expenses_o->DetailEdit) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_expenses_o", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_expenses_ogrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_receipt_d", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_receipt_d->DetailEdit) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_receipt_d", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_receipt_dgrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_diesal_expenses", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_diesal_expenses->DetailEdit) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_diesal_expenses", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_diesal_expensesgrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_route_info", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_route_info->DetailEdit) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_route_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_route_infogrid.php" ?>
<?php } ?>
<?php if (!$t_trip_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_trip_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var type = $("#x_vehicle_type").val();
		if (type == 1)
		{
		$("#r_consignor").hide();
		$("#r_vehicle_freight").hide();
		$("#r_vehicle_freight_type").hide();
		$("#r_vehicle_freight_amount").hide();
		$("#r_vehicle_freight_comm").hide();
		$("#r_vehicle_freight_final").hide();
		$("#r_driver").show();
		} else {
		$("#r_consignor").show();
		$("#r_vehicle_freight").show();
		$("#r_vehicle_freight_type").show();
		$("#r_vehicle_freight_amount").show();
		$("#r_vehicle_freight_comm").show();
		$("#r_vehicle_freight_final").show();
		$("#r_driver").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_edit->terminate();
?>