<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_list = new t_trip_info_list();

// Run the page
$t_trip_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_infolist = currentForm = new ew.Form("ft_trip_infolist", "list");
ft_trip_infolist.formKeyCountName = '<?php echo $t_trip_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_infolist.lists["x_vehicle_type"] = <?php echo $t_trip_info_list->vehicle_type->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_info_list->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_infolist.lists["x_vehicle"] = <?php echo $t_trip_info_list->vehicle->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_info_list->vehicle->lookupOptions()) ?>;
ft_trip_infolist.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolist.lists["x_reports_to"] = <?php echo $t_trip_info_list->reports_to->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_info_list->reports_to->lookupOptions()) ?>;
ft_trip_infolist.lists["x_buyer"] = <?php echo $t_trip_info_list->buyer->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_info_list->buyer->lookupOptions()) ?>;
ft_trip_infolist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolist.lists["x_b_consignor"] = <?php echo $t_trip_info_list->b_consignor->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_info_list->b_consignor->lookupOptions()) ?>;
ft_trip_infolist.autoSuggests["x_b_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolist.lists["x_b_consignee"] = <?php echo $t_trip_info_list->b_consignee->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_info_list->b_consignee->lookupOptions()) ?>;
ft_trip_infolist.autoSuggests["x_b_consignee"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolist.lists["x_delivery_pod"] = <?php echo $t_trip_info_list->delivery_pod->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_delivery_pod"].options = <?php echo JsonEncode($t_trip_info_list->delivery_pod->options(FALSE, TRUE)) ?>;
ft_trip_infolist.lists["x_status"] = <?php echo $t_trip_info_list->status->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_status"].options = <?php echo JsonEncode($t_trip_info_list->status->options(FALSE, TRUE)) ?>;
ft_trip_infolist.lists["x_driver"] = <?php echo $t_trip_info_list->driver->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_list->driver->lookupOptions()) ?>;
ft_trip_infolist.lists["x_agent"] = <?php echo $t_trip_info_list->agent->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_agent"].options = <?php echo JsonEncode($t_trip_info_list->agent->lookupOptions()) ?>;
ft_trip_infolist.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolist.lists["x_freight_type"] = <?php echo $t_trip_info_list->freight_type->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_info_list->freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infolist.lists["x_consignor"] = <?php echo $t_trip_info_list->consignor->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_consignor"].options = <?php echo JsonEncode($t_trip_info_list->consignor->lookupOptions()) ?>;
ft_trip_infolist.autoSuggests["x_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolist.lists["x_vehicle_freight_type"] = <?php echo $t_trip_info_list->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_infolist.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_info_list->vehicle_freight_type->options(FALSE, TRUE)) ?>;

// Form object for search
var ft_trip_infolistsrch = currentSearchForm = new ew.Form("ft_trip_infolistsrch");

// Validate function for search
ft_trip_infolistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_vehicle");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->invoice_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_infolistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_infolistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_infolistsrch.lists["x_vehicle_type"] = <?php echo $t_trip_info_list->vehicle_type->Lookup->toClientList() ?>;
ft_trip_infolistsrch.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_info_list->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_infolistsrch.lists["x_vehicle"] = <?php echo $t_trip_info_list->vehicle->Lookup->toClientList() ?>;
ft_trip_infolistsrch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_info_list->vehicle->lookupOptions()) ?>;
ft_trip_infolistsrch.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infolistsrch.lists["x_buyer"] = <?php echo $t_trip_info_list->buyer->Lookup->toClientList() ?>;
ft_trip_infolistsrch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_info_list->buyer->lookupOptions()) ?>;
ft_trip_infolistsrch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
ft_trip_infolistsrch.filterList = <?php echo $t_trip_info_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_info_list->TotalRecs > 0 && $t_trip_info_list->ExportOptions->visible()) { ?>
<?php $t_trip_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_info_list->ImportOptions->visible()) { ?>
<?php $t_trip_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_info_list->SearchOptions->visible()) { ?>
<?php $t_trip_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_info_list->FilterOptions->visible()) { ?>
<?php $t_trip_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_info->isExport() && !$t_trip_info->CurrentAction) { ?>
<form name="ft_trip_infolistsrch" id="ft_trip_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_info">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_info_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_info->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_info->resetAttributes();
$t_trip_info_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
	<div id="xsc_vehicle_type" class="ew-cell form-group">
		<label for="x_vehicle_type" class="ew-search-caption ew-label"><?php echo $t_trip_info->vehicle_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="="></span>
		<span class="ew-search-field">
<?php $t_trip_info->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_info->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_type" data-value-separator="<?php echo $t_trip_info->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_info->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
	<div id="xsc_vehicle" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_info->vehicle->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_info->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_info->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_info->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->vehicle->ReadOnly || $t_trip_info->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_vehicle" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_info->vehicle->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infolistsrch.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_info->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
	<div id="xsc_buyer" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_info->buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_info->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_info->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_info->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->buyer->ReadOnly || $t_trip_info->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_info->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infolistsrch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_info->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
	<div id="xsc_load_date" class="ew-cell form-group">
		<label for="x_load_date" class="ew-search-caption ew-label"><?php echo $t_trip_info->load_date->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_date" id="z_load_date" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_info" data-field="x_load_date" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_info->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_date->EditValue ?>"<?php echo $t_trip_info->load_date->editAttributes() ?>>
<?php if (!$t_trip_info->load_date->ReadOnly && !$t_trip_info->load_date->Disabled && !isset($t_trip_info->load_date->EditAttrs["readonly"]) && !isset($t_trip_info->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infolistsrch", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_date->Visible) { // unload_date ?>
	<div id="xsc_unload_date" class="ew-cell form-group">
		<label for="x_unload_date" class="ew-search-caption ew-label"><?php echo $t_trip_info->unload_date->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_date" id="z_unload_date" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_info" data-field="x_unload_date" name="x_unload_date" id="x_unload_date" placeholder="<?php echo HtmlEncode($t_trip_info->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_date->EditValue ?>"<?php echo $t_trip_info->unload_date->editAttributes() ?>>
<?php if (!$t_trip_info->unload_date->ReadOnly && !$t_trip_info->unload_date->Disabled && !isset($t_trip_info->unload_date->EditAttrs["readonly"]) && !isset($t_trip_info->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infolistsrch", "x_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_info->invoice_date->Visible) { // invoice_date ?>
	<div id="xsc_invoice_date" class="ew-cell form-group">
		<label for="x_invoice_date" class="ew-search-caption ew-label"><?php echo $t_trip_info->invoice_date->caption() ?></label>
		<span class="ew-search-operator"><select name="z_invoice_date" id="z_invoice_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_info" data-field="x_invoice_date" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_info->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->invoice_date->EditValue ?>"<?php echo $t_trip_info->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_info->invoice_date->ReadOnly && !$t_trip_info->invoice_date->Disabled && !isset($t_trip_info->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_info->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infolistsrch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_invoice_date style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_invoice_date style="d-none"">
<input type="text" data-table="t_trip_info" data-field="x_invoice_date" name="y_invoice_date" id="y_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_info->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->invoice_date->EditValue2 ?>"<?php echo $t_trip_info->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_info->invoice_date->ReadOnly && !$t_trip_info->invoice_date->Disabled && !isset($t_trip_info->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_info->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infolistsrch", "y_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_info_list->showPageHeader(); ?>
<?php
$t_trip_info_list->showMessage();
?>
<?php if ($t_trip_info_list->TotalRecs > 0 || $t_trip_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_info">
<?php if (!$t_trip_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_info_list->Pager)) $t_trip_info_list->Pager = new PrevNextPager($t_trip_info_list->StartRec, $t_trip_info_list->DisplayRecs, $t_trip_info_list->TotalRecs, $t_trip_info_list->AutoHidePager) ?>
<?php if ($t_trip_info_list->Pager->RecordCount > 0 && $t_trip_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_info_list->TotalRecs > 0 && (!$t_trip_info_list->AutoHidePageSizeSelector || $t_trip_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_infolist" id="ft_trip_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<div id="gmp_t_trip_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_info_list->TotalRecs > 0 || $t_trip_info->isGridEdit()) { ?>
<table id="tbl_t_trip_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_info_list->renderListOptions();

// Render list options (header, left)
$t_trip_info_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_info->id->Visible) { // id ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_trip_info->id->headerCellClass() ?>"><div id="elh_t_trip_info_id" class="t_trip_info_id"><div class="ew-table-header-caption"><?php echo $t_trip_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_trip_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->id) ?>',2);"><div id="elh_t_trip_info_id" class="t_trip_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle_type) == "") { ?>
		<th data-name="vehicle_type" class="<?php echo $t_trip_info->vehicle_type->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_type" class="t_trip_info_vehicle_type"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_type" class="<?php echo $t_trip_info->vehicle_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle_type) ?>',2);"><div id="elh_t_trip_info_vehicle_type" class="t_trip_info_vehicle_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle) == "") { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_info->vehicle->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle" class="t_trip_info_vehicle"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_info->vehicle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle) ?>',2);"><div id="elh_t_trip_info_vehicle" class="t_trip_info_vehicle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->route_name->Visible) { // route_name ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->route_name) == "") { ?>
		<th data-name="route_name" class="<?php echo $t_trip_info->route_name->headerCellClass() ?>"><div id="elh_t_trip_info_route_name" class="t_trip_info_route_name"><div class="ew-table-header-caption"><?php echo $t_trip_info->route_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="route_name" class="<?php echo $t_trip_info->route_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->route_name) ?>',2);"><div id="elh_t_trip_info_route_name" class="t_trip_info_route_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->route_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->route_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->route_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->reports_to->Visible) { // reports_to ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $t_trip_info->reports_to->headerCellClass() ?>"><div id="elh_t_trip_info_reports_to" class="t_trip_info_reports_to"><div class="ew-table-header-caption"><?php echo $t_trip_info->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $t_trip_info->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->reports_to) ?>',2);"><div id="elh_t_trip_info_reports_to" class="t_trip_info_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $t_trip_info->buyer->headerCellClass() ?>"><div id="elh_t_trip_info_buyer" class="t_trip_info_buyer"><div class="ew-table-header-caption"><?php echo $t_trip_info->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $t_trip_info->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->buyer) ?>',2);"><div id="elh_t_trip_info_buyer" class="t_trip_info_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->b_consignor->Visible) { // b_consignor ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->b_consignor) == "") { ?>
		<th data-name="b_consignor" class="<?php echo $t_trip_info->b_consignor->headerCellClass() ?>"><div id="elh_t_trip_info_b_consignor" class="t_trip_info_b_consignor"><div class="ew-table-header-caption"><?php echo $t_trip_info->b_consignor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_consignor" class="<?php echo $t_trip_info->b_consignor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->b_consignor) ?>',2);"><div id="elh_t_trip_info_b_consignor" class="t_trip_info_b_consignor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->b_consignor->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->b_consignor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->b_consignor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->b_consignee->Visible) { // b_consignee ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->b_consignee) == "") { ?>
		<th data-name="b_consignee" class="<?php echo $t_trip_info->b_consignee->headerCellClass() ?>"><div id="elh_t_trip_info_b_consignee" class="t_trip_info_b_consignee"><div class="ew-table-header-caption"><?php echo $t_trip_info->b_consignee->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_consignee" class="<?php echo $t_trip_info->b_consignee->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->b_consignee) ?>',2);"><div id="elh_t_trip_info_b_consignee" class="t_trip_info_b_consignee">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->b_consignee->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->b_consignee->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->b_consignee->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->load_date) == "") { ?>
		<th data-name="load_date" class="<?php echo $t_trip_info->load_date->headerCellClass() ?>"><div id="elh_t_trip_info_load_date" class="t_trip_info_load_date"><div class="ew-table-header-caption"><?php echo $t_trip_info->load_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_date" class="<?php echo $t_trip_info->load_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->load_date) ?>',2);"><div id="elh_t_trip_info_load_date" class="t_trip_info_load_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->load_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->load_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->load_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->load_weight->Visible) { // load_weight ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->load_weight) == "") { ?>
		<th data-name="load_weight" class="<?php echo $t_trip_info->load_weight->headerCellClass() ?>"><div id="elh_t_trip_info_load_weight" class="t_trip_info_load_weight"><div class="ew-table-header-caption"><?php echo $t_trip_info->load_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_weight" class="<?php echo $t_trip_info->load_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->load_weight) ?>',2);"><div id="elh_t_trip_info_load_weight" class="t_trip_info_load_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->load_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->load_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->load_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->unload_date->Visible) { // unload_date ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->unload_date) == "") { ?>
		<th data-name="unload_date" class="<?php echo $t_trip_info->unload_date->headerCellClass() ?>"><div id="elh_t_trip_info_unload_date" class="t_trip_info_unload_date"><div class="ew-table-header-caption"><?php echo $t_trip_info->unload_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_date" class="<?php echo $t_trip_info->unload_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->unload_date) ?>',2);"><div id="elh_t_trip_info_unload_date" class="t_trip_info_unload_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->unload_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->unload_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->unload_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->unload_weight->Visible) { // unload_weight ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->unload_weight) == "") { ?>
		<th data-name="unload_weight" class="<?php echo $t_trip_info->unload_weight->headerCellClass() ?>"><div id="elh_t_trip_info_unload_weight" class="t_trip_info_unload_weight"><div class="ew-table-header-caption"><?php echo $t_trip_info->unload_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_weight" class="<?php echo $t_trip_info->unload_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->unload_weight) ?>',2);"><div id="elh_t_trip_info_unload_weight" class="t_trip_info_unload_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->unload_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->unload_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->unload_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->invoice_no->Visible) { // invoice_no ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->invoice_no) == "") { ?>
		<th data-name="invoice_no" class="<?php echo $t_trip_info->invoice_no->headerCellClass() ?>"><div id="elh_t_trip_info_invoice_no" class="t_trip_info_invoice_no"><div class="ew-table-header-caption"><?php echo $t_trip_info->invoice_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_no" class="<?php echo $t_trip_info->invoice_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->invoice_no) ?>',2);"><div id="elh_t_trip_info_invoice_no" class="t_trip_info_invoice_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->invoice_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->invoice_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->invoice_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->invoice_date->Visible) { // invoice_date ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->invoice_date) == "") { ?>
		<th data-name="invoice_date" class="<?php echo $t_trip_info->invoice_date->headerCellClass() ?>"><div id="elh_t_trip_info_invoice_date" class="t_trip_info_invoice_date"><div class="ew-table-header-caption"><?php echo $t_trip_info->invoice_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="invoice_date" class="<?php echo $t_trip_info->invoice_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->invoice_date) ?>',2);"><div id="elh_t_trip_info_invoice_date" class="t_trip_info_invoice_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->invoice_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->invoice_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->invoice_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->amount->Visible) { // amount ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->amount) == "") { ?>
		<th data-name="amount" class="<?php echo $t_trip_info->amount->headerCellClass() ?>"><div id="elh_t_trip_info_amount" class="t_trip_info_amount"><div class="ew-table-header-caption"><?php echo $t_trip_info->amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="amount" class="<?php echo $t_trip_info->amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->amount) ?>',2);"><div id="elh_t_trip_info_amount" class="t_trip_info_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->delivery_pod->Visible) { // delivery_pod ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->delivery_pod) == "") { ?>
		<th data-name="delivery_pod" class="<?php echo $t_trip_info->delivery_pod->headerCellClass() ?>"><div id="elh_t_trip_info_delivery_pod" class="t_trip_info_delivery_pod"><div class="ew-table-header-caption"><?php echo $t_trip_info->delivery_pod->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_pod" class="<?php echo $t_trip_info->delivery_pod->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->delivery_pod) ?>',2);"><div id="elh_t_trip_info_delivery_pod" class="t_trip_info_delivery_pod">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->delivery_pod->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->delivery_pod->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->delivery_pod->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->status->Visible) { // status ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $t_trip_info->status->headerCellClass() ?>"><div id="elh_t_trip_info_status" class="t_trip_info_status"><div class="ew-table-header-caption"><?php echo $t_trip_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $t_trip_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->status) ?>',2);"><div id="elh_t_trip_info_status" class="t_trip_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->days->Visible) { // days ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->days) == "") { ?>
		<th data-name="days" class="<?php echo $t_trip_info->days->headerCellClass() ?>"><div id="elh_t_trip_info_days" class="t_trip_info_days"><div class="ew-table-header-caption"><?php echo $t_trip_info->days->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="days" class="<?php echo $t_trip_info->days->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->days) ?>',2);"><div id="elh_t_trip_info_days" class="t_trip_info_days">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->days->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->days->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->days->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->driver->Visible) { // driver ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_trip_info->driver->headerCellClass() ?>"><div id="elh_t_trip_info_driver" class="t_trip_info_driver"><div class="ew-table-header-caption"><?php echo $t_trip_info->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_trip_info->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->driver) ?>',2);"><div id="elh_t_trip_info_driver" class="t_trip_info_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->driver->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->driver_name->Visible) { // driver_name ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->driver_name) == "") { ?>
		<th data-name="driver_name" class="<?php echo $t_trip_info->driver_name->headerCellClass() ?>"><div id="elh_t_trip_info_driver_name" class="t_trip_info_driver_name"><div class="ew-table-header-caption"><?php echo $t_trip_info->driver_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver_name" class="<?php echo $t_trip_info->driver_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->driver_name) ?>',2);"><div id="elh_t_trip_info_driver_name" class="t_trip_info_driver_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->driver_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->driver_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->driver_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->agent->Visible) { // agent ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->agent) == "") { ?>
		<th data-name="agent" class="<?php echo $t_trip_info->agent->headerCellClass() ?>"><div id="elh_t_trip_info_agent" class="t_trip_info_agent"><div class="ew-table-header-caption"><?php echo $t_trip_info->agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="agent" class="<?php echo $t_trip_info->agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->agent) ?>',2);"><div id="elh_t_trip_info_agent" class="t_trip_info_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->agent->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->comm->Visible) { // comm ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->comm) == "") { ?>
		<th data-name="comm" class="<?php echo $t_trip_info->comm->headerCellClass() ?>"><div id="elh_t_trip_info_comm" class="t_trip_info_comm"><div class="ew-table-header-caption"><?php echo $t_trip_info->comm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="comm" class="<?php echo $t_trip_info->comm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->comm) ?>',2);"><div id="elh_t_trip_info_comm" class="t_trip_info_comm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->comm->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->comm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->comm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->material->Visible) { // material ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->material) == "") { ?>
		<th data-name="material" class="<?php echo $t_trip_info->material->headerCellClass() ?>"><div id="elh_t_trip_info_material" class="t_trip_info_material"><div class="ew-table-header-caption"><?php echo $t_trip_info->material->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material" class="<?php echo $t_trip_info->material->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->material) ?>',2);"><div id="elh_t_trip_info_material" class="t_trip_info_material">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->material->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->material->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->material->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->packing_type->Visible) { // packing_type ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->packing_type) == "") { ?>
		<th data-name="packing_type" class="<?php echo $t_trip_info->packing_type->headerCellClass() ?>"><div id="elh_t_trip_info_packing_type" class="t_trip_info_packing_type"><div class="ew-table-header-caption"><?php echo $t_trip_info->packing_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="packing_type" class="<?php echo $t_trip_info->packing_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->packing_type) ?>',2);"><div id="elh_t_trip_info_packing_type" class="t_trip_info_packing_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->packing_type->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->packing_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->packing_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->m_hsn->Visible) { // m_hsn ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->m_hsn) == "") { ?>
		<th data-name="m_hsn" class="<?php echo $t_trip_info->m_hsn->headerCellClass() ?>"><div id="elh_t_trip_info_m_hsn" class="t_trip_info_m_hsn"><div class="ew-table-header-caption"><?php echo $t_trip_info->m_hsn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_hsn" class="<?php echo $t_trip_info->m_hsn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->m_hsn) ?>',2);"><div id="elh_t_trip_info_m_hsn" class="t_trip_info_m_hsn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->m_hsn->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->m_hsn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->m_hsn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->_40->Visible) { // @ ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $t_trip_info->_40->headerCellClass() ?>"><div id="elh_t_trip_info__40" class="t_trip_info__40"><div class="ew-table-header-caption"><?php echo $t_trip_info->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $t_trip_info->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->_40) ?>',2);"><div id="elh_t_trip_info__40" class="t_trip_info__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->lr_no->Visible) { // lr_no ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->lr_no) == "") { ?>
		<th data-name="lr_no" class="<?php echo $t_trip_info->lr_no->headerCellClass() ?>"><div id="elh_t_trip_info_lr_no" class="t_trip_info_lr_no"><div class="ew-table-header-caption"><?php echo $t_trip_info->lr_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lr_no" class="<?php echo $t_trip_info->lr_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->lr_no) ?>',2);"><div id="elh_t_trip_info_lr_no" class="t_trip_info_lr_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->lr_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->lr_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->lr_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->km->Visible) { // km ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->km) == "") { ?>
		<th data-name="km" class="<?php echo $t_trip_info->km->headerCellClass() ?>"><div id="elh_t_trip_info_km" class="t_trip_info_km"><div class="ew-table-header-caption"><?php echo $t_trip_info->km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="km" class="<?php echo $t_trip_info->km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->km) ?>',2);"><div id="elh_t_trip_info_km" class="t_trip_info_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->freight_type->Visible) { // freight_type ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->freight_type) == "") { ?>
		<th data-name="freight_type" class="<?php echo $t_trip_info->freight_type->headerCellClass() ?>"><div id="elh_t_trip_info_freight_type" class="t_trip_info_freight_type"><div class="ew-table-header-caption"><?php echo $t_trip_info->freight_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="freight_type" class="<?php echo $t_trip_info->freight_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->freight_type) ?>',2);"><div id="elh_t_trip_info_freight_type" class="t_trip_info_freight_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->freight_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->freight_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->freight_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->freight->Visible) { // freight ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->freight) == "") { ?>
		<th data-name="freight" class="<?php echo $t_trip_info->freight->headerCellClass() ?>"><div id="elh_t_trip_info_freight" class="t_trip_info_freight"><div class="ew-table-header-caption"><?php echo $t_trip_info->freight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="freight" class="<?php echo $t_trip_info->freight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->freight) ?>',2);"><div id="elh_t_trip_info_freight" class="t_trip_info_freight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->freight->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->freight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->freight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->ded_det->Visible) { // ded_det ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->ded_det) == "") { ?>
		<th data-name="ded_det" class="<?php echo $t_trip_info->ded_det->headerCellClass() ?>"><div id="elh_t_trip_info_ded_det" class="t_trip_info_ded_det"><div class="ew-table-header-caption"><?php echo $t_trip_info->ded_det->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_det" class="<?php echo $t_trip_info->ded_det->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->ded_det) ?>',2);"><div id="elh_t_trip_info_ded_det" class="t_trip_info_ded_det">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->ded_det->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->ded_det->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->ded_det->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->ded_det_remarks->Visible) { // ded_det_remarks ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->ded_det_remarks) == "") { ?>
		<th data-name="ded_det_remarks" class="<?php echo $t_trip_info->ded_det_remarks->headerCellClass() ?>"><div id="elh_t_trip_info_ded_det_remarks" class="t_trip_info_ded_det_remarks"><div class="ew-table-header-caption"><?php echo $t_trip_info->ded_det_remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ded_det_remarks" class="<?php echo $t_trip_info->ded_det_remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->ded_det_remarks) ?>',2);"><div id="elh_t_trip_info_ded_det_remarks" class="t_trip_info_ded_det_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->ded_det_remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->ded_det_remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->ded_det_remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->gst_percent->Visible) { // gst_percent ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->gst_percent) == "") { ?>
		<th data-name="gst_percent" class="<?php echo $t_trip_info->gst_percent->headerCellClass() ?>"><div id="elh_t_trip_info_gst_percent" class="t_trip_info_gst_percent"><div class="ew-table-header-caption"><?php echo $t_trip_info->gst_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst_percent" class="<?php echo $t_trip_info->gst_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->gst_percent) ?>',2);"><div id="elh_t_trip_info_gst_percent" class="t_trip_info_gst_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->gst_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->gst_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->gst_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->gst_amount->Visible) { // gst_amount ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->gst_amount) == "") { ?>
		<th data-name="gst_amount" class="<?php echo $t_trip_info->gst_amount->headerCellClass() ?>"><div id="elh_t_trip_info_gst_amount" class="t_trip_info_gst_amount"><div class="ew-table-header-caption"><?php echo $t_trip_info->gst_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst_amount" class="<?php echo $t_trip_info->gst_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->gst_amount) ?>',2);"><div id="elh_t_trip_info_gst_amount" class="t_trip_info_gst_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->gst_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->gst_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->gst_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->final_amount->Visible) { // final_amount ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->final_amount) == "") { ?>
		<th data-name="final_amount" class="<?php echo $t_trip_info->final_amount->headerCellClass() ?>"><div id="elh_t_trip_info_final_amount" class="t_trip_info_final_amount"><div class="ew-table-header-caption"><?php echo $t_trip_info->final_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="final_amount" class="<?php echo $t_trip_info->final_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->final_amount) ?>',2);"><div id="elh_t_trip_info_final_amount" class="t_trip_info_final_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->final_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->final_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->final_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->load_km->Visible) { // load_km ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->load_km) == "") { ?>
		<th data-name="load_km" class="<?php echo $t_trip_info->load_km->headerCellClass() ?>"><div id="elh_t_trip_info_load_km" class="t_trip_info_load_km"><div class="ew-table-header-caption"><?php echo $t_trip_info->load_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_km" class="<?php echo $t_trip_info->load_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->load_km) ?>',2);"><div id="elh_t_trip_info_load_km" class="t_trip_info_load_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->load_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->load_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->load_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->unload_km->Visible) { // unload_km ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->unload_km) == "") { ?>
		<th data-name="unload_km" class="<?php echo $t_trip_info->unload_km->headerCellClass() ?>"><div id="elh_t_trip_info_unload_km" class="t_trip_info_unload_km"><div class="ew-table-header-caption"><?php echo $t_trip_info->unload_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_km" class="<?php echo $t_trip_info->unload_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->unload_km) ?>',2);"><div id="elh_t_trip_info_unload_km" class="t_trip_info_unload_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->unload_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->unload_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->unload_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->delivery_receipt->Visible) { // delivery_receipt ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->delivery_receipt) == "") { ?>
		<th data-name="delivery_receipt" class="<?php echo $t_trip_info->delivery_receipt->headerCellClass() ?>"><div id="elh_t_trip_info_delivery_receipt" class="t_trip_info_delivery_receipt"><div class="ew-table-header-caption"><?php echo $t_trip_info->delivery_receipt->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_receipt" class="<?php echo $t_trip_info->delivery_receipt->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->delivery_receipt) ?>',2);"><div id="elh_t_trip_info_delivery_receipt" class="t_trip_info_delivery_receipt">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->delivery_receipt->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->delivery_receipt->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->delivery_receipt->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->delivery_docket->Visible) { // delivery_docket ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->delivery_docket) == "") { ?>
		<th data-name="delivery_docket" class="<?php echo $t_trip_info->delivery_docket->headerCellClass() ?>"><div id="elh_t_trip_info_delivery_docket" class="t_trip_info_delivery_docket"><div class="ew-table-header-caption"><?php echo $t_trip_info->delivery_docket->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_docket" class="<?php echo $t_trip_info->delivery_docket->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->delivery_docket) ?>',2);"><div id="elh_t_trip_info_delivery_docket" class="t_trip_info_delivery_docket">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->delivery_docket->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->delivery_docket->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->delivery_docket->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->diesal_op_b->Visible) { // diesal_op_b ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->diesal_op_b) == "") { ?>
		<th data-name="diesal_op_b" class="<?php echo $t_trip_info->diesal_op_b->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_op_b" class="t_trip_info_diesal_op_b"><div class="ew-table-header-caption"><?php echo $t_trip_info->diesal_op_b->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal_op_b" class="<?php echo $t_trip_info->diesal_op_b->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->diesal_op_b) ?>',2);"><div id="elh_t_trip_info_diesal_op_b" class="t_trip_info_diesal_op_b">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->diesal_op_b->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->diesal_op_b->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->diesal_op_b->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->diesal_required->Visible) { // diesal_required ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->diesal_required) == "") { ?>
		<th data-name="diesal_required" class="<?php echo $t_trip_info->diesal_required->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_required" class="t_trip_info_diesal_required"><div class="ew-table-header-caption"><?php echo $t_trip_info->diesal_required->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal_required" class="<?php echo $t_trip_info->diesal_required->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->diesal_required) ?>',2);"><div id="elh_t_trip_info_diesal_required" class="t_trip_info_diesal_required">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->diesal_required->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->diesal_required->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->diesal_required->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->diesal_fill->Visible) { // diesal_fill ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->diesal_fill) == "") { ?>
		<th data-name="diesal_fill" class="<?php echo $t_trip_info->diesal_fill->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_fill" class="t_trip_info_diesal_fill"><div class="ew-table-header-caption"><?php echo $t_trip_info->diesal_fill->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal_fill" class="<?php echo $t_trip_info->diesal_fill->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->diesal_fill) ?>',2);"><div id="elh_t_trip_info_diesal_fill" class="t_trip_info_diesal_fill">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->diesal_fill->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->diesal_fill->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->diesal_fill->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->diesal_amount->Visible) { // diesal_amount ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->diesal_amount) == "") { ?>
		<th data-name="diesal_amount" class="<?php echo $t_trip_info->diesal_amount->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_amount" class="t_trip_info_diesal_amount"><div class="ew-table-header-caption"><?php echo $t_trip_info->diesal_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal_amount" class="<?php echo $t_trip_info->diesal_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->diesal_amount) ?>',2);"><div id="elh_t_trip_info_diesal_amount" class="t_trip_info_diesal_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->diesal_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->diesal_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->diesal_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->diesal_cl_balance) == "") { ?>
		<th data-name="diesal_cl_balance" class="<?php echo $t_trip_info->diesal_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_diesal_cl_balance" class="t_trip_info_diesal_cl_balance"><div class="ew-table-header-caption"><?php echo $t_trip_info->diesal_cl_balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diesal_cl_balance" class="<?php echo $t_trip_info->diesal_cl_balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->diesal_cl_balance) ?>',2);"><div id="elh_t_trip_info_diesal_cl_balance" class="t_trip_info_diesal_cl_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->diesal_cl_balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->diesal_cl_balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->diesal_cl_balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle_average->Visible) { // vehicle_average ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle_average) == "") { ?>
		<th data-name="vehicle_average" class="<?php echo $t_trip_info->vehicle_average->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_average" class="t_trip_info_vehicle_average"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_average->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_average" class="<?php echo $t_trip_info->vehicle_average->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle_average) ?>',2);"><div id="elh_t_trip_info_vehicle_average" class="t_trip_info_vehicle_average">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_average->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle_average->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle_average->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->cash_required->Visible) { // cash_required ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->cash_required) == "") { ?>
		<th data-name="cash_required" class="<?php echo $t_trip_info->cash_required->headerCellClass() ?>"><div id="elh_t_trip_info_cash_required" class="t_trip_info_cash_required"><div class="ew-table-header-caption"><?php echo $t_trip_info->cash_required->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cash_required" class="<?php echo $t_trip_info->cash_required->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->cash_required) ?>',2);"><div id="elh_t_trip_info_cash_required" class="t_trip_info_cash_required">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->cash_required->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->cash_required->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->cash_required->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->cash_op_b->Visible) { // cash_op_b ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->cash_op_b) == "") { ?>
		<th data-name="cash_op_b" class="<?php echo $t_trip_info->cash_op_b->headerCellClass() ?>"><div id="elh_t_trip_info_cash_op_b" class="t_trip_info_cash_op_b"><div class="ew-table-header-caption"><?php echo $t_trip_info->cash_op_b->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cash_op_b" class="<?php echo $t_trip_info->cash_op_b->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->cash_op_b) ?>',2);"><div id="elh_t_trip_info_cash_op_b" class="t_trip_info_cash_op_b">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->cash_op_b->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->cash_op_b->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->cash_op_b->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->cash_paid->Visible) { // cash_paid ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->cash_paid) == "") { ?>
		<th data-name="cash_paid" class="<?php echo $t_trip_info->cash_paid->headerCellClass() ?>"><div id="elh_t_trip_info_cash_paid" class="t_trip_info_cash_paid"><div class="ew-table-header-caption"><?php echo $t_trip_info->cash_paid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cash_paid" class="<?php echo $t_trip_info->cash_paid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->cash_paid) ?>',2);"><div id="elh_t_trip_info_cash_paid" class="t_trip_info_cash_paid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->cash_paid->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->cash_paid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->cash_paid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->cash_expenses->Visible) { // cash_expenses ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->cash_expenses) == "") { ?>
		<th data-name="cash_expenses" class="<?php echo $t_trip_info->cash_expenses->headerCellClass() ?>"><div id="elh_t_trip_info_cash_expenses" class="t_trip_info_cash_expenses"><div class="ew-table-header-caption"><?php echo $t_trip_info->cash_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cash_expenses" class="<?php echo $t_trip_info->cash_expenses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->cash_expenses) ?>',2);"><div id="elh_t_trip_info_cash_expenses" class="t_trip_info_cash_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->cash_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->cash_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->cash_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->cash_cl_balance->Visible) { // cash_cl_balance ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->cash_cl_balance) == "") { ?>
		<th data-name="cash_cl_balance" class="<?php echo $t_trip_info->cash_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_cash_cl_balance" class="t_trip_info_cash_cl_balance"><div class="ew-table-header-caption"><?php echo $t_trip_info->cash_cl_balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="cash_cl_balance" class="<?php echo $t_trip_info->cash_cl_balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->cash_cl_balance) ?>',2);"><div id="elh_t_trip_info_cash_cl_balance" class="t_trip_info_cash_cl_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->cash_cl_balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->cash_cl_balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->cash_cl_balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->fasttag_op_b->Visible) { // fasttag_op_b ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->fasttag_op_b) == "") { ?>
		<th data-name="fasttag_op_b" class="<?php echo $t_trip_info->fasttag_op_b->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_op_b" class="t_trip_info_fasttag_op_b"><div class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_op_b->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fasttag_op_b" class="<?php echo $t_trip_info->fasttag_op_b->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->fasttag_op_b) ?>',2);"><div id="elh_t_trip_info_fasttag_op_b" class="t_trip_info_fasttag_op_b">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_op_b->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->fasttag_op_b->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->fasttag_op_b->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->fasttag_recharge->Visible) { // fasttag_recharge ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->fasttag_recharge) == "") { ?>
		<th data-name="fasttag_recharge" class="<?php echo $t_trip_info->fasttag_recharge->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_recharge" class="t_trip_info_fasttag_recharge"><div class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_recharge->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fasttag_recharge" class="<?php echo $t_trip_info->fasttag_recharge->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->fasttag_recharge) ?>',2);"><div id="elh_t_trip_info_fasttag_recharge" class="t_trip_info_fasttag_recharge">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_recharge->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->fasttag_recharge->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->fasttag_recharge->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->fasttag_expenses->Visible) { // fasttag_expenses ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->fasttag_expenses) == "") { ?>
		<th data-name="fasttag_expenses" class="<?php echo $t_trip_info->fasttag_expenses->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_expenses" class="t_trip_info_fasttag_expenses"><div class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fasttag_expenses" class="<?php echo $t_trip_info->fasttag_expenses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->fasttag_expenses) ?>',2);"><div id="elh_t_trip_info_fasttag_expenses" class="t_trip_info_fasttag_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->fasttag_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->fasttag_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->toll_expenses_cash) == "") { ?>
		<th data-name="toll_expenses_cash" class="<?php echo $t_trip_info->toll_expenses_cash->headerCellClass() ?>"><div id="elh_t_trip_info_toll_expenses_cash" class="t_trip_info_toll_expenses_cash"><div class="ew-table-header-caption"><?php echo $t_trip_info->toll_expenses_cash->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="toll_expenses_cash" class="<?php echo $t_trip_info->toll_expenses_cash->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->toll_expenses_cash) ?>',2);"><div id="elh_t_trip_info_toll_expenses_cash" class="t_trip_info_toll_expenses_cash">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->toll_expenses_cash->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->toll_expenses_cash->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->toll_expenses_cash->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->fasttag_cl_balance) == "") { ?>
		<th data-name="fasttag_cl_balance" class="<?php echo $t_trip_info->fasttag_cl_balance->headerCellClass() ?>"><div id="elh_t_trip_info_fasttag_cl_balance" class="t_trip_info_fasttag_cl_balance"><div class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_cl_balance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fasttag_cl_balance" class="<?php echo $t_trip_info->fasttag_cl_balance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->fasttag_cl_balance) ?>',2);"><div id="elh_t_trip_info_fasttag_cl_balance" class="t_trip_info_fasttag_cl_balance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->fasttag_cl_balance->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->fasttag_cl_balance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->fasttag_cl_balance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->consignor->Visible) { // consignor ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->consignor) == "") { ?>
		<th data-name="consignor" class="<?php echo $t_trip_info->consignor->headerCellClass() ?>"><div id="elh_t_trip_info_consignor" class="t_trip_info_consignor"><div class="ew-table-header-caption"><?php echo $t_trip_info->consignor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="consignor" class="<?php echo $t_trip_info->consignor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->consignor) ?>',2);"><div id="elh_t_trip_info_consignor" class="t_trip_info_consignor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->consignor->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->consignor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->consignor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle_freight_comm) == "") { ?>
		<th data-name="vehicle_freight_comm" class="<?php echo $t_trip_info->vehicle_freight_comm->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_comm" class="t_trip_info_vehicle_freight_comm"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_comm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_comm" class="<?php echo $t_trip_info->vehicle_freight_comm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle_freight_comm) ?>',2);"><div id="elh_t_trip_info_vehicle_freight_comm" class="t_trip_info_vehicle_freight_comm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_comm->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle_freight_comm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle_freight_comm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle_freight_type) == "") { ?>
		<th data-name="vehicle_freight_type" class="<?php echo $t_trip_info->vehicle_freight_type->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_type" class="t_trip_info_vehicle_freight_type"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_type" class="<?php echo $t_trip_info->vehicle_freight_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle_freight_type) ?>',2);"><div id="elh_t_trip_info_vehicle_freight_type" class="t_trip_info_vehicle_freight_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle_freight_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle_freight_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle_freight_amount) == "") { ?>
		<th data-name="vehicle_freight_amount" class="<?php echo $t_trip_info->vehicle_freight_amount->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_amount" class="t_trip_info_vehicle_freight_amount"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_amount" class="<?php echo $t_trip_info->vehicle_freight_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle_freight_amount) ?>',2);"><div id="elh_t_trip_info_vehicle_freight_amount" class="t_trip_info_vehicle_freight_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle_freight_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle_freight_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->vehicle_freight_final) == "") { ?>
		<th data-name="vehicle_freight_final" class="<?php echo $t_trip_info->vehicle_freight_final->headerCellClass() ?>"><div id="elh_t_trip_info_vehicle_freight_final" class="t_trip_info_vehicle_freight_final"><div class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_final->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_final" class="<?php echo $t_trip_info->vehicle_freight_final->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->vehicle_freight_final) ?>',2);"><div id="elh_t_trip_info_vehicle_freight_final" class="t_trip_info_vehicle_freight_final">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->vehicle_freight_final->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->vehicle_freight_final->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->vehicle_freight_final->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_info->datetime->Visible) { // datetime ?>
	<?php if ($t_trip_info->sortUrl($t_trip_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_trip_info->datetime->headerCellClass() ?>"><div id="elh_t_trip_info_datetime" class="t_trip_info_datetime"><div class="ew-table-header-caption"><?php echo $t_trip_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_trip_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_info->SortUrl($t_trip_info->datetime) ?>',2);"><div id="elh_t_trip_info_datetime" class="t_trip_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_info->ExportAll && $t_trip_info->isExport()) {
	$t_trip_info_list->StopRec = $t_trip_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_info_list->TotalRecs > $t_trip_info_list->StartRec + $t_trip_info_list->DisplayRecs - 1)
		$t_trip_info_list->StopRec = $t_trip_info_list->StartRec + $t_trip_info_list->DisplayRecs - 1;
	else
		$t_trip_info_list->StopRec = $t_trip_info_list->TotalRecs;
}
$t_trip_info_list->RecCnt = $t_trip_info_list->StartRec - 1;
if ($t_trip_info_list->Recordset && !$t_trip_info_list->Recordset->EOF) {
	$t_trip_info_list->Recordset->moveFirst();
	$selectLimit = $t_trip_info_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_info_list->StartRec > 1)
		$t_trip_info_list->Recordset->move($t_trip_info_list->StartRec - 1);
} elseif (!$t_trip_info->AllowAddDeleteRow && $t_trip_info_list->StopRec == 0) {
	$t_trip_info_list->StopRec = $t_trip_info->GridAddRowCount;
}

// Initialize aggregate
$t_trip_info->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_info->resetAttributes();
$t_trip_info_list->renderRow();
while ($t_trip_info_list->RecCnt < $t_trip_info_list->StopRec) {
	$t_trip_info_list->RecCnt++;
	if ($t_trip_info_list->RecCnt >= $t_trip_info_list->StartRec) {
		$t_trip_info_list->RowCnt++;

		// Set up key count
		$t_trip_info_list->KeyCount = $t_trip_info_list->RowIndex;

		// Init row class and style
		$t_trip_info->resetAttributes();
		$t_trip_info->CssClass = "";
		if ($t_trip_info->isGridAdd()) {
		} else {
			$t_trip_info_list->loadRowValues($t_trip_info_list->Recordset); // Load row values
		}
		$t_trip_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_info->RowAttrs = array_merge($t_trip_info->RowAttrs, array('data-rowindex'=>$t_trip_info_list->RowCnt, 'id'=>'r' . $t_trip_info_list->RowCnt . '_t_trip_info', 'data-rowtype'=>$t_trip_info->RowType));

		// Render row
		$t_trip_info_list->renderRow();

		// Render list options
		$t_trip_info_list->renderListOptions();
?>
	<tr<?php echo $t_trip_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_info_list->ListOptions->render("body", "left", $t_trip_info_list->RowCnt);
?>
	<?php if ($t_trip_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_trip_info->id->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_id" class="t_trip_info_id">
<span<?php echo $t_trip_info->id->viewAttributes() ?>>
<?php echo $t_trip_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
		<td data-name="vehicle_type"<?php echo $t_trip_info->vehicle_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle_type" class="t_trip_info_vehicle_type">
<span<?php echo $t_trip_info->vehicle_type->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
		<td data-name="vehicle"<?php echo $t_trip_info->vehicle->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle" class="t_trip_info_vehicle">
<span<?php echo $t_trip_info->vehicle->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->route_name->Visible) { // route_name ?>
		<td data-name="route_name"<?php echo $t_trip_info->route_name->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_route_name" class="t_trip_info_route_name">
<span<?php echo $t_trip_info->route_name->viewAttributes() ?>>
<?php echo $t_trip_info->route_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $t_trip_info->reports_to->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_reports_to" class="t_trip_info_reports_to">
<span<?php echo $t_trip_info->reports_to->viewAttributes() ?>>
<?php echo $t_trip_info->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $t_trip_info->buyer->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_buyer" class="t_trip_info_buyer">
<span<?php echo $t_trip_info->buyer->viewAttributes() ?>>
<?php echo $t_trip_info->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->b_consignor->Visible) { // b_consignor ?>
		<td data-name="b_consignor"<?php echo $t_trip_info->b_consignor->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_b_consignor" class="t_trip_info_b_consignor">
<span<?php echo $t_trip_info->b_consignor->viewAttributes() ?>>
<?php echo $t_trip_info->b_consignor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->b_consignee->Visible) { // b_consignee ?>
		<td data-name="b_consignee"<?php echo $t_trip_info->b_consignee->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_b_consignee" class="t_trip_info_b_consignee">
<span<?php echo $t_trip_info->b_consignee->viewAttributes() ?>>
<?php echo $t_trip_info->b_consignee->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
		<td data-name="load_date"<?php echo $t_trip_info->load_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_load_date" class="t_trip_info_load_date">
<span<?php echo $t_trip_info->load_date->viewAttributes() ?>>
<?php echo $t_trip_info->load_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->load_weight->Visible) { // load_weight ?>
		<td data-name="load_weight"<?php echo $t_trip_info->load_weight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_load_weight" class="t_trip_info_load_weight">
<span<?php echo $t_trip_info->load_weight->viewAttributes() ?>>
<?php echo $t_trip_info->load_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->unload_date->Visible) { // unload_date ?>
		<td data-name="unload_date"<?php echo $t_trip_info->unload_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_unload_date" class="t_trip_info_unload_date">
<span<?php echo $t_trip_info->unload_date->viewAttributes() ?>>
<?php echo $t_trip_info->unload_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->unload_weight->Visible) { // unload_weight ?>
		<td data-name="unload_weight"<?php echo $t_trip_info->unload_weight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_unload_weight" class="t_trip_info_unload_weight">
<span<?php echo $t_trip_info->unload_weight->viewAttributes() ?>>
<?php echo $t_trip_info->unload_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->invoice_no->Visible) { // invoice_no ?>
		<td data-name="invoice_no"<?php echo $t_trip_info->invoice_no->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_invoice_no" class="t_trip_info_invoice_no">
<span<?php echo $t_trip_info->invoice_no->viewAttributes() ?>>
<?php echo $t_trip_info->invoice_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->invoice_date->Visible) { // invoice_date ?>
		<td data-name="invoice_date"<?php echo $t_trip_info->invoice_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_invoice_date" class="t_trip_info_invoice_date">
<span<?php echo $t_trip_info->invoice_date->viewAttributes() ?>>
<?php echo $t_trip_info->invoice_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->amount->Visible) { // amount ?>
		<td data-name="amount"<?php echo $t_trip_info->amount->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_amount" class="t_trip_info_amount">
<span<?php echo $t_trip_info->amount->viewAttributes() ?>>
<?php echo $t_trip_info->amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->delivery_pod->Visible) { // delivery_pod ?>
		<td data-name="delivery_pod"<?php echo $t_trip_info->delivery_pod->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_delivery_pod" class="t_trip_info_delivery_pod">
<span<?php echo $t_trip_info->delivery_pod->viewAttributes() ?>>
<?php echo $t_trip_info->delivery_pod->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $t_trip_info->status->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_status" class="t_trip_info_status">
<span<?php echo $t_trip_info->status->viewAttributes() ?>>
<?php echo $t_trip_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->days->Visible) { // days ?>
		<td data-name="days"<?php echo $t_trip_info->days->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_days" class="t_trip_info_days">
<span<?php echo $t_trip_info->days->viewAttributes() ?>>
<?php echo $t_trip_info->days->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_trip_info->driver->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_driver" class="t_trip_info_driver">
<span<?php echo $t_trip_info->driver->viewAttributes() ?>>
<?php echo $t_trip_info->driver->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->driver_name->Visible) { // driver_name ?>
		<td data-name="driver_name"<?php echo $t_trip_info->driver_name->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_driver_name" class="t_trip_info_driver_name">
<span<?php echo $t_trip_info->driver_name->viewAttributes() ?>>
<?php echo $t_trip_info->driver_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->agent->Visible) { // agent ?>
		<td data-name="agent"<?php echo $t_trip_info->agent->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_agent" class="t_trip_info_agent">
<span<?php echo $t_trip_info->agent->viewAttributes() ?>>
<?php echo $t_trip_info->agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->comm->Visible) { // comm ?>
		<td data-name="comm"<?php echo $t_trip_info->comm->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_comm" class="t_trip_info_comm">
<span<?php echo $t_trip_info->comm->viewAttributes() ?>>
<?php echo $t_trip_info->comm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->material->Visible) { // material ?>
		<td data-name="material"<?php echo $t_trip_info->material->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_material" class="t_trip_info_material">
<span<?php echo $t_trip_info->material->viewAttributes() ?>>
<?php echo $t_trip_info->material->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->packing_type->Visible) { // packing_type ?>
		<td data-name="packing_type"<?php echo $t_trip_info->packing_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_packing_type" class="t_trip_info_packing_type">
<span<?php echo $t_trip_info->packing_type->viewAttributes() ?>>
<?php echo $t_trip_info->packing_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->m_hsn->Visible) { // m_hsn ?>
		<td data-name="m_hsn"<?php echo $t_trip_info->m_hsn->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_m_hsn" class="t_trip_info_m_hsn">
<span<?php echo $t_trip_info->m_hsn->viewAttributes() ?>>
<?php echo $t_trip_info->m_hsn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $t_trip_info->_40->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info__40" class="t_trip_info__40">
<span<?php echo $t_trip_info->_40->viewAttributes() ?>>
<?php echo $t_trip_info->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->lr_no->Visible) { // lr_no ?>
		<td data-name="lr_no"<?php echo $t_trip_info->lr_no->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_lr_no" class="t_trip_info_lr_no">
<span<?php echo $t_trip_info->lr_no->viewAttributes() ?>>
<?php echo $t_trip_info->lr_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->km->Visible) { // km ?>
		<td data-name="km"<?php echo $t_trip_info->km->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_km" class="t_trip_info_km">
<span<?php echo $t_trip_info->km->viewAttributes() ?>>
<?php echo $t_trip_info->km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->freight_type->Visible) { // freight_type ?>
		<td data-name="freight_type"<?php echo $t_trip_info->freight_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_freight_type" class="t_trip_info_freight_type">
<span<?php echo $t_trip_info->freight_type->viewAttributes() ?>>
<?php echo $t_trip_info->freight_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->freight->Visible) { // freight ?>
		<td data-name="freight"<?php echo $t_trip_info->freight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_freight" class="t_trip_info_freight">
<span<?php echo $t_trip_info->freight->viewAttributes() ?>>
<?php echo $t_trip_info->freight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->ded_det->Visible) { // ded_det ?>
		<td data-name="ded_det"<?php echo $t_trip_info->ded_det->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_ded_det" class="t_trip_info_ded_det">
<span<?php echo $t_trip_info->ded_det->viewAttributes() ?>>
<?php echo $t_trip_info->ded_det->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->ded_det_remarks->Visible) { // ded_det_remarks ?>
		<td data-name="ded_det_remarks"<?php echo $t_trip_info->ded_det_remarks->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_ded_det_remarks" class="t_trip_info_ded_det_remarks">
<span<?php echo $t_trip_info->ded_det_remarks->viewAttributes() ?>>
<?php echo $t_trip_info->ded_det_remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->gst_percent->Visible) { // gst_percent ?>
		<td data-name="gst_percent"<?php echo $t_trip_info->gst_percent->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_gst_percent" class="t_trip_info_gst_percent">
<span<?php echo $t_trip_info->gst_percent->viewAttributes() ?>>
<?php echo $t_trip_info->gst_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->gst_amount->Visible) { // gst_amount ?>
		<td data-name="gst_amount"<?php echo $t_trip_info->gst_amount->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_gst_amount" class="t_trip_info_gst_amount">
<span<?php echo $t_trip_info->gst_amount->viewAttributes() ?>>
<?php echo $t_trip_info->gst_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->final_amount->Visible) { // final_amount ?>
		<td data-name="final_amount"<?php echo $t_trip_info->final_amount->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_final_amount" class="t_trip_info_final_amount">
<span<?php echo $t_trip_info->final_amount->viewAttributes() ?>>
<?php echo $t_trip_info->final_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->load_km->Visible) { // load_km ?>
		<td data-name="load_km"<?php echo $t_trip_info->load_km->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_load_km" class="t_trip_info_load_km">
<span<?php echo $t_trip_info->load_km->viewAttributes() ?>>
<?php echo $t_trip_info->load_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->unload_km->Visible) { // unload_km ?>
		<td data-name="unload_km"<?php echo $t_trip_info->unload_km->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_unload_km" class="t_trip_info_unload_km">
<span<?php echo $t_trip_info->unload_km->viewAttributes() ?>>
<?php echo $t_trip_info->unload_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->delivery_receipt->Visible) { // delivery_receipt ?>
		<td data-name="delivery_receipt"<?php echo $t_trip_info->delivery_receipt->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_delivery_receipt" class="t_trip_info_delivery_receipt">
<span>
<?php echo GetFileViewTag($t_trip_info->delivery_receipt, $t_trip_info->delivery_receipt->getViewValue()) ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->delivery_docket->Visible) { // delivery_docket ?>
		<td data-name="delivery_docket"<?php echo $t_trip_info->delivery_docket->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_delivery_docket" class="t_trip_info_delivery_docket">
<span<?php echo $t_trip_info->delivery_docket->viewAttributes() ?>>
<?php echo $t_trip_info->delivery_docket->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->diesal_op_b->Visible) { // diesal_op_b ?>
		<td data-name="diesal_op_b"<?php echo $t_trip_info->diesal_op_b->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_diesal_op_b" class="t_trip_info_diesal_op_b">
<span<?php echo $t_trip_info->diesal_op_b->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_op_b->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->diesal_required->Visible) { // diesal_required ?>
		<td data-name="diesal_required"<?php echo $t_trip_info->diesal_required->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_diesal_required" class="t_trip_info_diesal_required">
<span<?php echo $t_trip_info->diesal_required->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_required->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->diesal_fill->Visible) { // diesal_fill ?>
		<td data-name="diesal_fill"<?php echo $t_trip_info->diesal_fill->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_diesal_fill" class="t_trip_info_diesal_fill">
<span<?php echo $t_trip_info->diesal_fill->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_fill->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->diesal_amount->Visible) { // diesal_amount ?>
		<td data-name="diesal_amount"<?php echo $t_trip_info->diesal_amount->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_diesal_amount" class="t_trip_info_diesal_amount">
<span<?php echo $t_trip_info->diesal_amount->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
		<td data-name="diesal_cl_balance"<?php echo $t_trip_info->diesal_cl_balance->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_diesal_cl_balance" class="t_trip_info_diesal_cl_balance">
<span<?php echo $t_trip_info->diesal_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_cl_balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle_average->Visible) { // vehicle_average ?>
		<td data-name="vehicle_average"<?php echo $t_trip_info->vehicle_average->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle_average" class="t_trip_info_vehicle_average">
<span<?php echo $t_trip_info->vehicle_average->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_average->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->cash_required->Visible) { // cash_required ?>
		<td data-name="cash_required"<?php echo $t_trip_info->cash_required->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_cash_required" class="t_trip_info_cash_required">
<span<?php echo $t_trip_info->cash_required->viewAttributes() ?>>
<?php echo $t_trip_info->cash_required->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->cash_op_b->Visible) { // cash_op_b ?>
		<td data-name="cash_op_b"<?php echo $t_trip_info->cash_op_b->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_cash_op_b" class="t_trip_info_cash_op_b">
<span<?php echo $t_trip_info->cash_op_b->viewAttributes() ?>>
<?php echo $t_trip_info->cash_op_b->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->cash_paid->Visible) { // cash_paid ?>
		<td data-name="cash_paid"<?php echo $t_trip_info->cash_paid->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_cash_paid" class="t_trip_info_cash_paid">
<span<?php echo $t_trip_info->cash_paid->viewAttributes() ?>>
<?php echo $t_trip_info->cash_paid->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->cash_expenses->Visible) { // cash_expenses ?>
		<td data-name="cash_expenses"<?php echo $t_trip_info->cash_expenses->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_cash_expenses" class="t_trip_info_cash_expenses">
<span<?php echo $t_trip_info->cash_expenses->viewAttributes() ?>>
<?php echo $t_trip_info->cash_expenses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->cash_cl_balance->Visible) { // cash_cl_balance ?>
		<td data-name="cash_cl_balance"<?php echo $t_trip_info->cash_cl_balance->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_cash_cl_balance" class="t_trip_info_cash_cl_balance">
<span<?php echo $t_trip_info->cash_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info->cash_cl_balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->fasttag_op_b->Visible) { // fasttag_op_b ?>
		<td data-name="fasttag_op_b"<?php echo $t_trip_info->fasttag_op_b->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_fasttag_op_b" class="t_trip_info_fasttag_op_b">
<span<?php echo $t_trip_info->fasttag_op_b->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_op_b->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->fasttag_recharge->Visible) { // fasttag_recharge ?>
		<td data-name="fasttag_recharge"<?php echo $t_trip_info->fasttag_recharge->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_fasttag_recharge" class="t_trip_info_fasttag_recharge">
<span<?php echo $t_trip_info->fasttag_recharge->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_recharge->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->fasttag_expenses->Visible) { // fasttag_expenses ?>
		<td data-name="fasttag_expenses"<?php echo $t_trip_info->fasttag_expenses->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_fasttag_expenses" class="t_trip_info_fasttag_expenses">
<span<?php echo $t_trip_info->fasttag_expenses->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_expenses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
		<td data-name="toll_expenses_cash"<?php echo $t_trip_info->toll_expenses_cash->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_toll_expenses_cash" class="t_trip_info_toll_expenses_cash">
<span<?php echo $t_trip_info->toll_expenses_cash->viewAttributes() ?>>
<?php echo $t_trip_info->toll_expenses_cash->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
		<td data-name="fasttag_cl_balance"<?php echo $t_trip_info->fasttag_cl_balance->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_fasttag_cl_balance" class="t_trip_info_fasttag_cl_balance">
<span<?php echo $t_trip_info->fasttag_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_cl_balance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->consignor->Visible) { // consignor ?>
		<td data-name="consignor"<?php echo $t_trip_info->consignor->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_consignor" class="t_trip_info_consignor">
<span<?php echo $t_trip_info->consignor->viewAttributes() ?>>
<?php echo $t_trip_info->consignor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
		<td data-name="vehicle_freight_comm"<?php echo $t_trip_info->vehicle_freight_comm->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle_freight_comm" class="t_trip_info_vehicle_freight_comm">
<span<?php echo $t_trip_info->vehicle_freight_comm->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_comm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
		<td data-name="vehicle_freight_type"<?php echo $t_trip_info->vehicle_freight_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle_freight_type" class="t_trip_info_vehicle_freight_type">
<span<?php echo $t_trip_info->vehicle_freight_type->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
		<td data-name="vehicle_freight_amount"<?php echo $t_trip_info->vehicle_freight_amount->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle_freight_amount" class="t_trip_info_vehicle_freight_amount">
<span<?php echo $t_trip_info->vehicle_freight_amount->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
		<td data-name="vehicle_freight_final"<?php echo $t_trip_info->vehicle_freight_final->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_vehicle_freight_final" class="t_trip_info_vehicle_freight_final">
<span<?php echo $t_trip_info->vehicle_freight_final->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_final->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_trip_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_trip_info_list->RowCnt ?>_t_trip_info_datetime" class="t_trip_info_datetime">
<span<?php echo $t_trip_info->datetime->viewAttributes() ?>>
<?php echo $t_trip_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_info_list->ListOptions->render("body", "right", $t_trip_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_info->isGridAdd())
		$t_trip_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_info_list->Recordset)
	$t_trip_info_list->Recordset->Close();
?>
<?php if (!$t_trip_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_info_list->Pager)) $t_trip_info_list->Pager = new PrevNextPager($t_trip_info_list->StartRec, $t_trip_info_list->DisplayRecs, $t_trip_info_list->TotalRecs, $t_trip_info_list->AutoHidePager) ?>
<?php if ($t_trip_info_list->Pager->RecordCount > 0 && $t_trip_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_info_list->pageUrl() ?>start=<?php echo $t_trip_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_info_list->TotalRecs > 0 && (!$t_trip_info_list->AutoHidePageSizeSelector || $t_trip_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_info_list->TotalRecs == 0 && !$t_trip_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_list->terminate();
?>