<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_search = new t_trip_info_search();

// Run the page
$t_trip_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_info_search->IsModal) { ?>
var ft_trip_infosearch = currentAdvancedSearchForm = new ew.Form("ft_trip_infosearch", "search");
<?php } else { ?>
var ft_trip_infosearch = currentForm = new ew.Form("ft_trip_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_infosearch.multiPage = new ew.MultiPage("ft_trip_infosearch");

// Dynamic selection lists
ft_trip_infosearch.lists["x_vehicle_type"] = <?php echo $t_trip_info_search->vehicle_type->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_info_search->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_infosearch.lists["x_vehicle"] = <?php echo $t_trip_info_search->vehicle->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_info_search->vehicle->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x__route"] = <?php echo $t_trip_info_search->_route->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x__route"].options = <?php echo JsonEncode($t_trip_info_search->_route->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x_reports_to"] = <?php echo $t_trip_info_search->reports_to->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_info_search->reports_to->lookupOptions()) ?>;
ft_trip_infosearch.lists["x_buyer"] = <?php echo $t_trip_info_search->buyer->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_info_search->buyer->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x_b_consignor"] = <?php echo $t_trip_info_search->b_consignor->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_info_search->b_consignor->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x_b_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x_b_consignee"] = <?php echo $t_trip_info_search->b_consignee->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_info_search->b_consignee->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x_b_consignee"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x_delivery_pod"] = <?php echo $t_trip_info_search->delivery_pod->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_delivery_pod"].options = <?php echo JsonEncode($t_trip_info_search->delivery_pod->options(FALSE, TRUE)) ?>;
ft_trip_infosearch.lists["x_status"] = <?php echo $t_trip_info_search->status->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_status"].options = <?php echo JsonEncode($t_trip_info_search->status->options(FALSE, TRUE)) ?>;
ft_trip_infosearch.lists["x_driver"] = <?php echo $t_trip_info_search->driver->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_search->driver->lookupOptions()) ?>;
ft_trip_infosearch.lists["x_agent"] = <?php echo $t_trip_info_search->agent->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_agent"].options = <?php echo JsonEncode($t_trip_info_search->agent->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x_freight_type"] = <?php echo $t_trip_info_search->freight_type->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_info_search->freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infosearch.lists["x_consignor"] = <?php echo $t_trip_info_search->consignor->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_consignor"].options = <?php echo JsonEncode($t_trip_info_search->consignor->lookupOptions()) ?>;
ft_trip_infosearch.autoSuggests["x_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infosearch.lists["x_vehicle_freight_type"] = <?php echo $t_trip_info_search->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_info_search->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infosearch.lists["x_operator"] = <?php echo $t_trip_info_search->operator->Lookup->toClientList() ?>;
ft_trip_infosearch.lists["x_operator"].options = <?php echo JsonEncode($t_trip_info_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_trip_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__route");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->_route->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_weight");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_weight");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->invoice_no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_invoice_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->invoice_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_days");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->days->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_comm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->comm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_km");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_freight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->freight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ded_det");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->ded_det->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gst_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->gst_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gst_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->gst_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_final_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->final_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->load_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->unload_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diesal_op_b");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->diesal_op_b->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diesal_required");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->diesal_required->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diesal_fill");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->diesal_fill->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diesal_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->diesal_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diesal_cl_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->diesal_cl_balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_average");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_average->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cash_required");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->cash_required->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cash_op_b");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->cash_op_b->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cash_paid");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->cash_paid->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cash_expenses");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->cash_expenses->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cash_cl_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->cash_cl_balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_fasttag_op_b");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->fasttag_op_b->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_fasttag_recharge");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->fasttag_recharge->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_fasttag_expenses");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->fasttag_expenses->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_toll_expenses_cash");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->toll_expenses_cash->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_fasttag_cl_balance");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->fasttag_cl_balance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_consignor");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->consignor->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_freight_comm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_comm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_freight_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_freight_final");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->vehicle_freight_final->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_info_search->showPageHeader(); ?>
<?php
$t_trip_info_search->showMessage();
?>
<form name="ft_trip_infosearch" id="ft_trip_infosearch" class="<?php echo $t_trip_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_info_search->IsModal ?>">
<?php if ($t_trip_info_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($t_trip_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_id"><?php echo $t_trip_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->id->cellAttributes() ?>>
			<span id="el_t_trip_info_id">
<input type="text" data-table="t_trip_info" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_trip_info->id->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->id->EditValue ?>"<?php echo $t_trip_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
	<div id="r_vehicle_type" class="form-group row">
		<label for="x_vehicle_type" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_type"><?php echo $t_trip_info->vehicle_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_type->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle_type">
<?php $t_trip_info->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_info->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_type" data-page="0" data-value-separator="<?php echo $t_trip_info->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_info->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle"><?php echo $t_trip_info->vehicle->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle">
<?php
$wrkonchange = "" . trim(@$t_trip_info->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_info->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_info->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->vehicle->ReadOnly || $t_trip_info->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_vehicle" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_info->vehicle->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_info->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info__route"><?php echo $t_trip_info->_route->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__route" id="z__route" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->_route->cellAttributes() ?>>
			<span id="el_t_trip_info__route">
<?php
$wrkonchange = "" . trim(@$t_trip_info->_route->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->_route->EditAttrs["onchange"] = "";
?>
<span id="as_x__route" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__route" id="sv_x__route" value="<?php echo RemoveHtml($t_trip_info->_route->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->_route->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->_route->getPlaceHolder()) ?>"<?php echo $t_trip_info->_route->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->_route->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__route',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->_route->ReadOnly || $t_trip_info->_route->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x__route" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->_route->displayValueSeparatorAttribute() ?>" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_info->_route->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x__route","forceSelect":true});
</script>
<?php echo $t_trip_info->_route->Lookup->getParamTag("p_x__route") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->route_name->Visible) { // route_name ?>
	<div id="r_route_name" class="form-group row">
		<label for="x_route_name" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_route_name"><?php echo $t_trip_info->route_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_route_name" id="z_route_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->route_name->cellAttributes() ?>>
			<span id="el_t_trip_info_route_name">
<input type="text" data-table="t_trip_info" data-field="x_route_name" data-page="0" name="x_route_name" id="x_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_trip_info->route_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->route_name->EditValue ?>"<?php echo $t_trip_info->route_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_status"><?php echo $t_trip_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->status->cellAttributes() ?>>
			<span id="el_t_trip_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_status" data-page="0" data-value-separator="<?php echo $t_trip_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_trip_info->status->editAttributes() ?>>
		<?php echo $t_trip_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->days->Visible) { // days ?>
	<div id="r_days" class="form-group row">
		<label for="x_days" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_days"><?php echo $t_trip_info->days->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_days" id="z_days" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->days->cellAttributes() ?>>
			<span id="el_t_trip_info_days">
<input type="text" data-table="t_trip_info" data-field="x_days" data-page="0" name="x_days" id="x_days" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->days->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->days->EditValue ?>"<?php echo $t_trip_info->days->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label for="x_driver" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_driver"><?php echo $t_trip_info->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->driver->cellAttributes() ?>>
			<span id="el_t_trip_info_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_driver" data-page="0" data-value-separator="<?php echo $t_trip_info->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $t_trip_info->driver->editAttributes() ?>>
		<?php echo $t_trip_info->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $t_trip_info->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->driver_name->Visible) { // driver_name ?>
	<div id="r_driver_name" class="form-group row">
		<label for="x_driver_name" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_driver_name"><?php echo $t_trip_info->driver_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver_name" id="z_driver_name" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->driver_name->cellAttributes() ?>>
			<span id="el_t_trip_info_driver_name">
<input type="text" data-table="t_trip_info" data-field="x_driver_name" data-page="0" name="x_driver_name" id="x_driver_name" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->driver_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->driver_name->EditValue ?>"<?php echo $t_trip_info->driver_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->consignor->Visible) { // consignor ?>
	<div id="r_consignor" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_consignor"><?php echo $t_trip_info->consignor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_consignor" id="z_consignor" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->consignor->cellAttributes() ?>>
			<span id="el_t_trip_info_consignor">
<?php
$wrkonchange = "" . trim(@$t_trip_info->consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->consignor->EditAttrs["onchange"] = "";
?>
<span id="as_x_consignor" class="text-nowrap" style="z-index: 8410">
	<input type="text" class="form-control" name="sv_x_consignor" id="sv_x_consignor" value="<?php echo RemoveHtml($t_trip_info->consignor->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->consignor->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_consignor" data-page="0" data-value-separator="<?php echo $t_trip_info->consignor->displayValueSeparatorAttribute() ?>" name="x_consignor" id="x_consignor" value="<?php echo HtmlEncode($t_trip_info->consignor->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x_consignor","forceSelect":false});
</script>
<?php echo $t_trip_info->consignor->Lookup->getParamTag("p_x_consignor") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<div id="r_vehicle_freight_comm" class="form-group row">
		<label for="x_vehicle_freight_comm" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_comm"><?php echo $t_trip_info->vehicle_freight_comm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_comm" id="z_vehicle_freight_comm" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_comm->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle_freight_comm">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_comm" data-page="0" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_comm->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_comm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<div id="r_vehicle_freight_type" class="form-group row">
		<label for="x_vehicle_freight_type" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_type"><?php echo $t_trip_info->vehicle_freight_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_type" id="z_vehicle_freight_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_type->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_vehicle_freight_type" data-page="0" data-value-separator="<?php echo $t_trip_info->vehicle_freight_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_freight_type" name="x_vehicle_freight_type"<?php echo $t_trip_info->vehicle_freight_type->editAttributes() ?>>
		<?php echo $t_trip_info->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<div id="r_vehicle_freight_amount" class="form-group row">
		<label for="x_vehicle_freight_amount" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_amount"><?php echo $t_trip_info->vehicle_freight_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_amount" id="z_vehicle_freight_amount" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_amount->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle_freight_amount">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_amount" data-page="0" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_amount->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
	<div id="r_vehicle_freight_final" class="form-group row">
		<label for="x_vehicle_freight_final" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_final"><?php echo $t_trip_info->vehicle_freight_final->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_final" id="z_vehicle_freight_final" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_freight_final->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle_freight_final">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_freight_final" data-page="0" name="x_vehicle_freight_final" id="x_vehicle_freight_final" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_freight_final->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_freight_final->EditValue ?>"<?php echo $t_trip_info->vehicle_freight_final->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="t_trip_info_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("1")) ?>" href="#tab_t_trip_info1"><?php echo $t_trip_info->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_reports_to"><?php echo $t_trip_info->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->reports_to->cellAttributes() ?>>
			<span id="el_t_trip_info_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_reports_to" data-page="1" data-value-separator="<?php echo $t_trip_info->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $t_trip_info->reports_to->editAttributes() ?>>
		<?php echo $t_trip_info->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $t_trip_info->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_buyer"><?php echo $t_trip_info->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->buyer->cellAttributes() ?>>
			<span id="el_t_trip_info_buyer">
<?php
$wrkonchange = "" . trim(@$t_trip_info->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8930">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_info->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_info->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->buyer->ReadOnly || $t_trip_info->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_buyer" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_info->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_info->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->b_consignor->Visible) { // b_consignor ?>
	<div id="r_b_consignor" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_b_consignor"><?php echo $t_trip_info->b_consignor->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->b_consignor->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_b_consignor" id="z_b_consignor" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_info->b_consignor->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_info_b_consignor">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignor->EditAttrs["onchange"] = "";
?>
<span id="as_x_b_consignor" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_b_consignor" id="sv_x_b_consignor" value="<?php echo RemoveHtml($t_trip_info->b_consignor->EditValue) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignor->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignor->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignor',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignor->ReadOnly || $t_trip_info->b_consignor->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignor" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignor->displayValueSeparatorAttribute() ?>" name="x_b_consignor" id="x_b_consignor" value="<?php echo HtmlEncode($t_trip_info->b_consignor->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x_b_consignor","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignor->Lookup->getParamTag("p_x_b_consignor") ?>
</span>
			<span class="ew-search-cond btw1_b_consignor d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_info_b_consignor" class="btw1_b_consignor d-none">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignor->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignor->EditAttrs["onchange"] = "";
?>
<span id="as_y_b_consignor" class="text-nowrap" style="z-index: 8920">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_y_b_consignor" id="sv_y_b_consignor" value="<?php echo RemoveHtml($t_trip_info->b_consignor->EditValue2) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignor->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignor->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignor->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'y_b_consignor',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignor->ReadOnly || $t_trip_info->b_consignor->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignor" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignor->displayValueSeparatorAttribute() ?>" name="y_b_consignor" id="y_b_consignor" value="<?php echo HtmlEncode($t_trip_info->b_consignor->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"y_b_consignor","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignor->Lookup->getParamTag("p_y_b_consignor") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->b_consignee->Visible) { // b_consignee ?>
	<div id="r_b_consignee" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_b_consignee"><?php echo $t_trip_info->b_consignee->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->b_consignee->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_b_consignee" id="z_b_consignee" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_info->b_consignee->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_info_b_consignee">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignee->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignee->EditAttrs["onchange"] = "";
?>
<span id="as_x_b_consignee" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_b_consignee" id="sv_x_b_consignee" value="<?php echo RemoveHtml($t_trip_info->b_consignee->EditValue) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignee->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignee->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignee',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignee->ReadOnly || $t_trip_info->b_consignee->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignee" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignee->displayValueSeparatorAttribute() ?>" name="x_b_consignee" id="x_b_consignee" value="<?php echo HtmlEncode($t_trip_info->b_consignee->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x_b_consignee","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignee->Lookup->getParamTag("p_x_b_consignee") ?>
</span>
			<span class="ew-search-cond btw1_b_consignee d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_info_b_consignee" class="btw1_b_consignee d-none">
<?php
$wrkonchange = "" . trim(@$t_trip_info->b_consignee->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->b_consignee->EditAttrs["onchange"] = "";
?>
<span id="as_y_b_consignee" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_y_b_consignee" id="sv_y_b_consignee" value="<?php echo RemoveHtml($t_trip_info->b_consignee->EditValue2) ?>" size="30" maxlength="250" placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->b_consignee->getPlaceHolder()) ?>"<?php echo $t_trip_info->b_consignee->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->b_consignee->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'y_b_consignee',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->b_consignee->ReadOnly || $t_trip_info->b_consignee->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_b_consignee" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->b_consignee->displayValueSeparatorAttribute() ?>" name="y_b_consignee" id="y_b_consignee" value="<?php echo HtmlEncode($t_trip_info->b_consignee->AdvancedSearch->SearchValue2) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"y_b_consignee","forceSelect":true});
</script>
<?php echo $t_trip_info->b_consignee->Lookup->getParamTag("p_y_b_consignee") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_agent"><?php echo $t_trip_info->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_agent" id="z_agent" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->agent->cellAttributes() ?>>
			<span id="el_t_trip_info_agent">
<?php
$wrkonchange = "" . trim(@$t_trip_info->agent->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_info->agent->EditAttrs["onchange"] = "";
?>
<span id="as_x_agent" class="text-nowrap" style="z-index: 8780">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_agent" id="sv_x_agent" value="<?php echo RemoveHtml($t_trip_info->agent->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->agent->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_info->agent->getPlaceHolder()) ?>"<?php echo $t_trip_info->agent->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_info->agent->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_agent',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_info->agent->ReadOnly || $t_trip_info->agent->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_info" data-field="x_agent" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_info->agent->displayValueSeparatorAttribute() ?>" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($t_trip_info->agent->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_infosearch.createAutoSuggest({"id":"x_agent","forceSelect":false});
</script>
<?php echo $t_trip_info->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->comm->Visible) { // comm ?>
	<div id="r_comm" class="form-group row">
		<label for="x_comm" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_comm"><?php echo $t_trip_info->comm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_comm" id="z_comm" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->comm->cellAttributes() ?>>
			<span id="el_t_trip_info_comm">
<input type="text" data-table="t_trip_info" data-field="x_comm" data-page="1" name="x_comm" id="x_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->comm->EditValue ?>"<?php echo $t_trip_info->comm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label for="x_material" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_material"><?php echo $t_trip_info->material->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material" id="z_material" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->material->cellAttributes() ?>>
			<span id="el_t_trip_info_material">
<input type="text" data-table="t_trip_info" data-field="x_material" data-page="1" name="x_material" id="x_material" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->material->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->material->EditValue ?>"<?php echo $t_trip_info->material->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->packing_type->Visible) { // packing_type ?>
	<div id="r_packing_type" class="form-group row">
		<label for="x_packing_type" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_packing_type"><?php echo $t_trip_info->packing_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_packing_type" id="z_packing_type" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->packing_type->cellAttributes() ?>>
			<span id="el_t_trip_info_packing_type">
<input type="text" data-table="t_trip_info" data-field="x_packing_type" data-page="1" name="x_packing_type" id="x_packing_type" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($t_trip_info->packing_type->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->packing_type->EditValue ?>"<?php echo $t_trip_info->packing_type->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->m_hsn->Visible) { // m_hsn ?>
	<div id="r_m_hsn" class="form-group row">
		<label for="x_m_hsn" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_m_hsn"><?php echo $t_trip_info->m_hsn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_m_hsn" id="z_m_hsn" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->m_hsn->cellAttributes() ?>>
			<span id="el_t_trip_info_m_hsn">
<input type="text" data-table="t_trip_info" data-field="x_m_hsn" data-page="1" name="x_m_hsn" id="x_m_hsn" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($t_trip_info->m_hsn->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->m_hsn->EditValue ?>"<?php echo $t_trip_info->m_hsn->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info__40"><?php echo $t_trip_info->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->_40->cellAttributes() ?>>
			<span id="el_t_trip_info__40">
<input type="text" data-table="t_trip_info" data-field="x__40" data-page="1" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->_40->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->_40->EditValue ?>"<?php echo $t_trip_info->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->lr_no->Visible) { // lr_no ?>
	<div id="r_lr_no" class="form-group row">
		<label for="x_lr_no" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_lr_no"><?php echo $t_trip_info->lr_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_lr_no" id="z_lr_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->lr_no->cellAttributes() ?>>
			<span id="el_t_trip_info_lr_no">
<input type="text" data-table="t_trip_info" data-field="x_lr_no" data-page="1" name="x_lr_no" id="x_lr_no" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($t_trip_info->lr_no->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->lr_no->EditValue ?>"<?php echo $t_trip_info->lr_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_remarks"><?php echo $t_trip_info->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->remarks->cellAttributes() ?>>
			<span id="el_t_trip_info_remarks">
<input type="text" data-table="t_trip_info" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($t_trip_info->remarks->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->remarks->EditValue ?>"<?php echo $t_trip_info->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("2")) ?>" href="#tab_t_trip_info2"><?php echo $t_trip_info->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->invoice_no->Visible) { // invoice_no ?>
	<div id="r_invoice_no" class="form-group row">
		<label for="x_invoice_no" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_invoice_no"><?php echo $t_trip_info->invoice_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_invoice_no" id="z_invoice_no" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->invoice_no->cellAttributes() ?>>
			<span id="el_t_trip_info_invoice_no">
<input type="text" data-table="t_trip_info" data-field="x_invoice_no" data-page="2" name="x_invoice_no" id="x_invoice_no" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->invoice_no->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->invoice_no->EditValue ?>"<?php echo $t_trip_info->invoice_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->invoice_date->Visible) { // invoice_date ?>
	<div id="r_invoice_date" class="form-group row">
		<label for="x_invoice_date" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_invoice_date"><?php echo $t_trip_info->invoice_date->caption() ?></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->invoice_date->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_invoice_date" id="z_invoice_date" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($t_trip_info->invoice_date->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_t_trip_info_invoice_date">
<input type="text" data-table="t_trip_info" data-field="x_invoice_date" data-page="2" name="x_invoice_date" id="x_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_info->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->invoice_date->EditValue ?>"<?php echo $t_trip_info->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_info->invoice_date->ReadOnly && !$t_trip_info->invoice_date->Disabled && !isset($t_trip_info->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_info->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infosearch", "x_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
			<span class="ew-search-cond btw1_invoice_date d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_t_trip_info_invoice_date" class="btw1_invoice_date d-none">
<input type="text" data-table="t_trip_info" data-field="x_invoice_date" data-page="2" name="y_invoice_date" id="y_invoice_date" placeholder="<?php echo HtmlEncode($t_trip_info->invoice_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->invoice_date->EditValue2 ?>"<?php echo $t_trip_info->invoice_date->editAttributes() ?>>
<?php if (!$t_trip_info->invoice_date->ReadOnly && !$t_trip_info->invoice_date->Disabled && !isset($t_trip_info->invoice_date->EditAttrs["readonly"]) && !isset($t_trip_info->invoice_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infosearch", "y_invoice_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->amount->Visible) { // amount ?>
	<div id="r_amount" class="form-group row">
		<label for="x_amount" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_amount"><?php echo $t_trip_info->amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_amount" id="z_amount" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->amount->cellAttributes() ?>>
			<span id="el_t_trip_info_amount">
<input type="text" data-table="t_trip_info" data-field="x_amount" data-page="2" name="x_amount" id="x_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->amount->EditValue ?>"<?php echo $t_trip_info->amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label for="x_km" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_km"><?php echo $t_trip_info->km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_km" id="z_km" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->km->cellAttributes() ?>>
			<span id="el_t_trip_info_km">
<input type="text" data-table="t_trip_info" data-field="x_km" data-page="2" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->km->EditValue ?>"<?php echo $t_trip_info->km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->freight_type->Visible) { // freight_type ?>
	<div id="r_freight_type" class="form-group row">
		<label for="x_freight_type" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_freight_type"><?php echo $t_trip_info->freight_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_freight_type" id="z_freight_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->freight_type->cellAttributes() ?>>
			<span id="el_t_trip_info_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_freight_type" data-page="2" data-value-separator="<?php echo $t_trip_info->freight_type->displayValueSeparatorAttribute() ?>" id="x_freight_type" name="x_freight_type"<?php echo $t_trip_info->freight_type->editAttributes() ?>>
		<?php echo $t_trip_info->freight_type->selectOptionListHtml("x_freight_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->freight->Visible) { // freight ?>
	<div id="r_freight" class="form-group row">
		<label for="x_freight" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_freight"><?php echo $t_trip_info->freight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_freight" id="z_freight" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->freight->cellAttributes() ?>>
			<span id="el_t_trip_info_freight">
<input type="text" data-table="t_trip_info" data-field="x_freight" data-page="2" name="x_freight" id="x_freight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->freight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->freight->EditValue ?>"<?php echo $t_trip_info->freight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->ded_det->Visible) { // ded_det ?>
	<div id="r_ded_det" class="form-group row">
		<label for="x_ded_det" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_ded_det"><?php echo $t_trip_info->ded_det->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ded_det" id="z_ded_det" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->ded_det->cellAttributes() ?>>
			<span id="el_t_trip_info_ded_det">
<input type="text" data-table="t_trip_info" data-field="x_ded_det" data-page="2" name="x_ded_det" id="x_ded_det" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->ded_det->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->ded_det->EditValue ?>"<?php echo $t_trip_info->ded_det->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->ded_det_remarks->Visible) { // ded_det_remarks ?>
	<div id="r_ded_det_remarks" class="form-group row">
		<label for="x_ded_det_remarks" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_ded_det_remarks"><?php echo $t_trip_info->ded_det_remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_ded_det_remarks" id="z_ded_det_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->ded_det_remarks->cellAttributes() ?>>
			<span id="el_t_trip_info_ded_det_remarks">
<input type="text" data-table="t_trip_info" data-field="x_ded_det_remarks" data-page="2" name="x_ded_det_remarks" id="x_ded_det_remarks" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_trip_info->ded_det_remarks->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->ded_det_remarks->EditValue ?>"<?php echo $t_trip_info->ded_det_remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->gst_percent->Visible) { // gst_percent ?>
	<div id="r_gst_percent" class="form-group row">
		<label for="x_gst_percent" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_gst_percent"><?php echo $t_trip_info->gst_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst_percent" id="z_gst_percent" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->gst_percent->cellAttributes() ?>>
			<span id="el_t_trip_info_gst_percent">
<input type="text" data-table="t_trip_info" data-field="x_gst_percent" data-page="2" name="x_gst_percent" id="x_gst_percent" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->gst_percent->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->gst_percent->EditValue ?>"<?php echo $t_trip_info->gst_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->gst_amount->Visible) { // gst_amount ?>
	<div id="r_gst_amount" class="form-group row">
		<label for="x_gst_amount" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_gst_amount"><?php echo $t_trip_info->gst_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst_amount" id="z_gst_amount" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->gst_amount->cellAttributes() ?>>
			<span id="el_t_trip_info_gst_amount">
<input type="text" data-table="t_trip_info" data-field="x_gst_amount" data-page="2" name="x_gst_amount" id="x_gst_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->gst_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->gst_amount->EditValue ?>"<?php echo $t_trip_info->gst_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->final_amount->Visible) { // final_amount ?>
	<div id="r_final_amount" class="form-group row">
		<label for="x_final_amount" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_final_amount"><?php echo $t_trip_info->final_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_final_amount" id="z_final_amount" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->final_amount->cellAttributes() ?>>
			<span id="el_t_trip_info_final_amount">
<input type="text" data-table="t_trip_info" data-field="x_final_amount" data-page="2" name="x_final_amount" id="x_final_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->final_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->final_amount->EditValue ?>"<?php echo $t_trip_info->final_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("3")) ?>" href="#tab_t_trip_info3"><?php echo $t_trip_info->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
	<div id="r_load_date" class="form-group row">
		<label for="x_load_date" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_load_date"><?php echo $t_trip_info->load_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_date" id="z_load_date" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->load_date->cellAttributes() ?>>
			<span id="el_t_trip_info_load_date">
<input type="text" data-table="t_trip_info" data-field="x_load_date" data-page="3" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_info->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_date->EditValue ?>"<?php echo $t_trip_info->load_date->editAttributes() ?>>
<?php if (!$t_trip_info->load_date->ReadOnly && !$t_trip_info->load_date->Disabled && !isset($t_trip_info->load_date->EditAttrs["readonly"]) && !isset($t_trip_info->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infosearch", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label for="x_load_weight" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_load_weight"><?php echo $t_trip_info->load_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_weight" id="z_load_weight" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->load_weight->cellAttributes() ?>>
			<span id="el_t_trip_info_load_weight">
<input type="text" data-table="t_trip_info" data-field="x_load_weight" data-page="3" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_weight->EditValue ?>"<?php echo $t_trip_info->load_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_date->Visible) { // unload_date ?>
	<div id="r_unload_date" class="form-group row">
		<label for="x_unload_date" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_unload_date"><?php echo $t_trip_info->unload_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_date" id="z_unload_date" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->unload_date->cellAttributes() ?>>
			<span id="el_t_trip_info_unload_date">
<input type="text" data-table="t_trip_info" data-field="x_unload_date" data-page="3" name="x_unload_date" id="x_unload_date" placeholder="<?php echo HtmlEncode($t_trip_info->unload_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_date->EditValue ?>"<?php echo $t_trip_info->unload_date->editAttributes() ?>>
<?php if (!$t_trip_info->unload_date->ReadOnly && !$t_trip_info->unload_date->Disabled && !isset($t_trip_info->unload_date->EditAttrs["readonly"]) && !isset($t_trip_info->unload_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infosearch", "x_unload_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_weight->Visible) { // unload_weight ?>
	<div id="r_unload_weight" class="form-group row">
		<label for="x_unload_weight" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_unload_weight"><?php echo $t_trip_info->unload_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_weight" id="z_unload_weight" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->unload_weight->cellAttributes() ?>>
			<span id="el_t_trip_info_unload_weight">
<input type="text" data-table="t_trip_info" data-field="x_unload_weight" data-page="3" name="x_unload_weight" id="x_unload_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->unload_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_weight->EditValue ?>"<?php echo $t_trip_info->unload_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->delivery_pod->Visible) { // delivery_pod ?>
	<div id="r_delivery_pod" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_delivery_pod"><?php echo $t_trip_info->delivery_pod->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delivery_pod" id="z_delivery_pod" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->delivery_pod->cellAttributes() ?>>
			<span id="el_t_trip_info_delivery_pod">
<div id="tp_x_delivery_pod" class="ew-template"><input type="radio" class="form-check-input" data-table="t_trip_info" data-field="x_delivery_pod" data-page="3" data-value-separator="<?php echo $t_trip_info->delivery_pod->displayValueSeparatorAttribute() ?>" name="x_delivery_pod" id="x_delivery_pod" value="{value}"<?php echo $t_trip_info->delivery_pod->editAttributes() ?>></div>
<div id="dsl_x_delivery_pod" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $t_trip_info->delivery_pod->radioButtonListHtml(FALSE, "x_delivery_pod", 3) ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label for="x_load_km" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_load_km"><?php echo $t_trip_info->load_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_km" id="z_load_km" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->load_km->cellAttributes() ?>>
			<span id="el_t_trip_info_load_km">
<input type="text" data-table="t_trip_info" data-field="x_load_km" data-page="3" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->load_km->EditValue ?>"<?php echo $t_trip_info->load_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->unload_km->Visible) { // unload_km ?>
	<div id="r_unload_km" class="form-group row">
		<label for="x_unload_km" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_unload_km"><?php echo $t_trip_info->unload_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_km" id="z_unload_km" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->unload_km->cellAttributes() ?>>
			<span id="el_t_trip_info_unload_km">
<input type="text" data-table="t_trip_info" data-field="x_unload_km" data-page="3" name="x_unload_km" id="x_unload_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->unload_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->unload_km->EditValue ?>"<?php echo $t_trip_info->unload_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->delivery_receipt->Visible) { // delivery_receipt ?>
	<div id="r_delivery_receipt" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_delivery_receipt"><?php echo $t_trip_info->delivery_receipt->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_delivery_receipt" id="z_delivery_receipt" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->delivery_receipt->cellAttributes() ?>>
			<span id="el_t_trip_info_delivery_receipt">
<input type="text" data-table="t_trip_info" data-field="x_delivery_receipt" data-page="3" name="x_delivery_receipt" id="x_delivery_receipt" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_trip_info->delivery_receipt->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->delivery_receipt->EditValue ?>"<?php echo $t_trip_info->delivery_receipt->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->delivery_docket->Visible) { // delivery_docket ?>
	<div id="r_delivery_docket" class="form-group row">
		<label for="x_delivery_docket" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_delivery_docket"><?php echo $t_trip_info->delivery_docket->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_delivery_docket" id="z_delivery_docket" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->delivery_docket->cellAttributes() ?>>
			<span id="el_t_trip_info_delivery_docket">
<input type="text" data-table="t_trip_info" data-field="x_delivery_docket" data-page="3" name="x_delivery_docket" id="x_delivery_docket" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_trip_info->delivery_docket->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->delivery_docket->EditValue ?>"<?php echo $t_trip_info->delivery_docket->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("4")) ?>" href="#tab_t_trip_info4"><?php echo $t_trip_info->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info4"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->diesal_op_b->Visible) { // diesal_op_b ?>
	<div id="r_diesal_op_b" class="form-group row">
		<label for="x_diesal_op_b" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_op_b"><?php echo $t_trip_info->diesal_op_b->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diesal_op_b" id="z_diesal_op_b" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_op_b->cellAttributes() ?>>
			<span id="el_t_trip_info_diesal_op_b">
<input type="text" data-table="t_trip_info" data-field="x_diesal_op_b" data-page="4" name="x_diesal_op_b" id="x_diesal_op_b" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->diesal_op_b->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->diesal_op_b->EditValue ?>"<?php echo $t_trip_info->diesal_op_b->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_required->Visible) { // diesal_required ?>
	<div id="r_diesal_required" class="form-group row">
		<label for="x_diesal_required" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_required"><?php echo $t_trip_info->diesal_required->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diesal_required" id="z_diesal_required" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_required->cellAttributes() ?>>
			<span id="el_t_trip_info_diesal_required">
<input type="text" data-table="t_trip_info" data-field="x_diesal_required" data-page="4" name="x_diesal_required" id="x_diesal_required" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->diesal_required->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->diesal_required->EditValue ?>"<?php echo $t_trip_info->diesal_required->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_fill->Visible) { // diesal_fill ?>
	<div id="r_diesal_fill" class="form-group row">
		<label for="x_diesal_fill" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_fill"><?php echo $t_trip_info->diesal_fill->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diesal_fill" id="z_diesal_fill" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_fill->cellAttributes() ?>>
			<span id="el_t_trip_info_diesal_fill">
<input type="text" data-table="t_trip_info" data-field="x_diesal_fill" data-page="4" name="x_diesal_fill" id="x_diesal_fill" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->diesal_fill->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->diesal_fill->EditValue ?>"<?php echo $t_trip_info->diesal_fill->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_amount->Visible) { // diesal_amount ?>
	<div id="r_diesal_amount" class="form-group row">
		<label for="x_diesal_amount" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_amount"><?php echo $t_trip_info->diesal_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diesal_amount" id="z_diesal_amount" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_amount->cellAttributes() ?>>
			<span id="el_t_trip_info_diesal_amount">
<input type="text" data-table="t_trip_info" data-field="x_diesal_amount" data-page="4" name="x_diesal_amount" id="x_diesal_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->diesal_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->diesal_amount->EditValue ?>"<?php echo $t_trip_info->diesal_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
	<div id="r_diesal_cl_balance" class="form-group row">
		<label for="x_diesal_cl_balance" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_diesal_cl_balance"><?php echo $t_trip_info->diesal_cl_balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_diesal_cl_balance" id="z_diesal_cl_balance" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->diesal_cl_balance->cellAttributes() ?>>
			<span id="el_t_trip_info_diesal_cl_balance">
<input type="text" data-table="t_trip_info" data-field="x_diesal_cl_balance" data-page="4" name="x_diesal_cl_balance" id="x_diesal_cl_balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->diesal_cl_balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->diesal_cl_balance->EditValue ?>"<?php echo $t_trip_info->diesal_cl_balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->vehicle_average->Visible) { // vehicle_average ?>
	<div id="r_vehicle_average" class="form-group row">
		<label for="x_vehicle_average" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_average"><?php echo $t_trip_info->vehicle_average->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_average" id="z_vehicle_average" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->vehicle_average->cellAttributes() ?>>
			<span id="el_t_trip_info_vehicle_average">
<input type="text" data-table="t_trip_info" data-field="x_vehicle_average" data-page="4" name="x_vehicle_average" id="x_vehicle_average" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->vehicle_average->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->vehicle_average->EditValue ?>"<?php echo $t_trip_info->vehicle_average->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("5")) ?>" href="#tab_t_trip_info5"><?php echo $t_trip_info->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info5"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->cash_required->Visible) { // cash_required ?>
	<div id="r_cash_required" class="form-group row">
		<label for="x_cash_required" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_required"><?php echo $t_trip_info->cash_required->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cash_required" id="z_cash_required" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_required->cellAttributes() ?>>
			<span id="el_t_trip_info_cash_required">
<input type="text" data-table="t_trip_info" data-field="x_cash_required" data-page="5" name="x_cash_required" id="x_cash_required" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->cash_required->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->cash_required->EditValue ?>"<?php echo $t_trip_info->cash_required->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_op_b->Visible) { // cash_op_b ?>
	<div id="r_cash_op_b" class="form-group row">
		<label for="x_cash_op_b" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_op_b"><?php echo $t_trip_info->cash_op_b->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cash_op_b" id="z_cash_op_b" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_op_b->cellAttributes() ?>>
			<span id="el_t_trip_info_cash_op_b">
<input type="text" data-table="t_trip_info" data-field="x_cash_op_b" data-page="5" name="x_cash_op_b" id="x_cash_op_b" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->cash_op_b->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->cash_op_b->EditValue ?>"<?php echo $t_trip_info->cash_op_b->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_paid->Visible) { // cash_paid ?>
	<div id="r_cash_paid" class="form-group row">
		<label for="x_cash_paid" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_paid"><?php echo $t_trip_info->cash_paid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cash_paid" id="z_cash_paid" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_paid->cellAttributes() ?>>
			<span id="el_t_trip_info_cash_paid">
<input type="text" data-table="t_trip_info" data-field="x_cash_paid" data-page="5" name="x_cash_paid" id="x_cash_paid" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->cash_paid->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->cash_paid->EditValue ?>"<?php echo $t_trip_info->cash_paid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_expenses->Visible) { // cash_expenses ?>
	<div id="r_cash_expenses" class="form-group row">
		<label for="x_cash_expenses" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_expenses"><?php echo $t_trip_info->cash_expenses->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cash_expenses" id="z_cash_expenses" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_expenses->cellAttributes() ?>>
			<span id="el_t_trip_info_cash_expenses">
<input type="text" data-table="t_trip_info" data-field="x_cash_expenses" data-page="5" name="x_cash_expenses" id="x_cash_expenses" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->cash_expenses->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->cash_expenses->EditValue ?>"<?php echo $t_trip_info->cash_expenses->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->cash_cl_balance->Visible) { // cash_cl_balance ?>
	<div id="r_cash_cl_balance" class="form-group row">
		<label for="x_cash_cl_balance" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_cash_cl_balance"><?php echo $t_trip_info->cash_cl_balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cash_cl_balance" id="z_cash_cl_balance" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->cash_cl_balance->cellAttributes() ?>>
			<span id="el_t_trip_info_cash_cl_balance">
<input type="text" data-table="t_trip_info" data-field="x_cash_cl_balance" data-page="5" name="x_cash_cl_balance" id="x_cash_cl_balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->cash_cl_balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->cash_cl_balance->EditValue ?>"<?php echo $t_trip_info->cash_cl_balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("6")) ?>" href="#tab_t_trip_info6"><?php echo $t_trip_info->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info6"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->fasttag_op_b->Visible) { // fasttag_op_b ?>
	<div id="r_fasttag_op_b" class="form-group row">
		<label for="x_fasttag_op_b" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_op_b"><?php echo $t_trip_info->fasttag_op_b->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fasttag_op_b" id="z_fasttag_op_b" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_op_b->cellAttributes() ?>>
			<span id="el_t_trip_info_fasttag_op_b">
<input type="text" data-table="t_trip_info" data-field="x_fasttag_op_b" data-page="6" name="x_fasttag_op_b" id="x_fasttag_op_b" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->fasttag_op_b->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->fasttag_op_b->EditValue ?>"<?php echo $t_trip_info->fasttag_op_b->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->fasttag_recharge->Visible) { // fasttag_recharge ?>
	<div id="r_fasttag_recharge" class="form-group row">
		<label for="x_fasttag_recharge" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_recharge"><?php echo $t_trip_info->fasttag_recharge->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fasttag_recharge" id="z_fasttag_recharge" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_recharge->cellAttributes() ?>>
			<span id="el_t_trip_info_fasttag_recharge">
<input type="text" data-table="t_trip_info" data-field="x_fasttag_recharge" data-page="6" name="x_fasttag_recharge" id="x_fasttag_recharge" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->fasttag_recharge->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->fasttag_recharge->EditValue ?>"<?php echo $t_trip_info->fasttag_recharge->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->fasttag_expenses->Visible) { // fasttag_expenses ?>
	<div id="r_fasttag_expenses" class="form-group row">
		<label for="x_fasttag_expenses" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_expenses"><?php echo $t_trip_info->fasttag_expenses->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fasttag_expenses" id="z_fasttag_expenses" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_expenses->cellAttributes() ?>>
			<span id="el_t_trip_info_fasttag_expenses">
<input type="text" data-table="t_trip_info" data-field="x_fasttag_expenses" data-page="6" name="x_fasttag_expenses" id="x_fasttag_expenses" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->fasttag_expenses->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->fasttag_expenses->EditValue ?>"<?php echo $t_trip_info->fasttag_expenses->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
	<div id="r_toll_expenses_cash" class="form-group row">
		<label for="x_toll_expenses_cash" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_toll_expenses_cash"><?php echo $t_trip_info->toll_expenses_cash->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_toll_expenses_cash" id="z_toll_expenses_cash" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->toll_expenses_cash->cellAttributes() ?>>
			<span id="el_t_trip_info_toll_expenses_cash">
<input type="text" data-table="t_trip_info" data-field="x_toll_expenses_cash" data-page="6" name="x_toll_expenses_cash" id="x_toll_expenses_cash" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->toll_expenses_cash->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->toll_expenses_cash->EditValue ?>"<?php echo $t_trip_info->toll_expenses_cash->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
	<div id="r_fasttag_cl_balance" class="form-group row">
		<label for="x_fasttag_cl_balance" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_cl_balance"><?php echo $t_trip_info->fasttag_cl_balance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fasttag_cl_balance" id="z_fasttag_cl_balance" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->fasttag_cl_balance->cellAttributes() ?>>
			<span id="el_t_trip_info_fasttag_cl_balance">
<input type="text" data-table="t_trip_info" data-field="x_fasttag_cl_balance" data-page="6" name="x_fasttag_cl_balance" id="x_fasttag_cl_balance" size="30" placeholder="<?php echo HtmlEncode($t_trip_info->fasttag_cl_balance->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->fasttag_cl_balance->EditValue ?>"<?php echo $t_trip_info->fasttag_cl_balance->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_info_search->MultiPages->pageStyle("7") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_search->MultiPages->isActive("7")) ?>" href="#tab_t_trip_info7"><?php echo $t_trip_info->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_search->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $t_trip_info_search->MultiPages->Parent ?>" id="tab_t_trip_info7"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_info->uploads->Visible) { // uploads ?>
	<div id="r_uploads" class="form-group row">
		<label class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_uploads"><?php echo $t_trip_info->uploads->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_uploads" id="z_uploads" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->uploads->cellAttributes() ?>>
			<span id="el_t_trip_info_uploads">
<input type="text" data-table="t_trip_info" data-field="x_uploads" data-page="7" name="x_uploads" id="x_uploads" placeholder="<?php echo HtmlEncode($t_trip_info->uploads->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->uploads->EditValue ?>"<?php echo $t_trip_info->uploads->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_operator"><?php echo $t_trip_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->operator->cellAttributes() ?>>
			<span id="el_t_trip_info_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_info" data-field="x_operator" data-page="7" data-value-separator="<?php echo $t_trip_info->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $t_trip_info->operator->editAttributes() ?>>
		<?php echo $t_trip_info->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $t_trip_info->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_trip_info_search->LeftColumnClass ?>"><span id="elh_t_trip_info_datetime"><?php echo $t_trip_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_trip_info_search->RightColumnClass ?>"><div<?php echo $t_trip_info->datetime->cellAttributes() ?>>
			<span id="el_t_trip_info_datetime">
<input type="text" data-table="t_trip_info" data-field="x_datetime" data-page="7" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_trip_info->datetime->getPlaceHolder()) ?>" value="<?php echo $t_trip_info->datetime->EditValue ?>"<?php echo $t_trip_info->datetime->editAttributes() ?>>
<?php if (!$t_trip_info->datetime->ReadOnly && !$t_trip_info->datetime->Disabled && !isset($t_trip_info->datetime->EditAttrs["readonly"]) && !isset($t_trip_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$t_trip_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_search->terminate();
?>