<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_info_view = new t_trip_info_view();

// Run the page
$t_trip_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_trip_infoview = currentForm = new ew.Form("ft_trip_infoview", "view");

// Form_CustomValidate event
ft_trip_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_infoview.multiPage = new ew.MultiPage("ft_trip_infoview");

// Dynamic selection lists
ft_trip_infoview.lists["x_vehicle_type"] = <?php echo $t_trip_info_view->vehicle_type->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_info_view->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_infoview.lists["x_vehicle"] = <?php echo $t_trip_info_view->vehicle->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_info_view->vehicle->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x__route"] = <?php echo $t_trip_info_view->_route->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x__route"].options = <?php echo JsonEncode($t_trip_info_view->_route->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x_reports_to"] = <?php echo $t_trip_info_view->reports_to->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_info_view->reports_to->lookupOptions()) ?>;
ft_trip_infoview.lists["x_buyer"] = <?php echo $t_trip_info_view->buyer->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_info_view->buyer->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x_b_consignor"] = <?php echo $t_trip_info_view->b_consignor->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_info_view->b_consignor->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x_b_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x_b_consignee"] = <?php echo $t_trip_info_view->b_consignee->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_info_view->b_consignee->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x_b_consignee"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x_delivery_pod"] = <?php echo $t_trip_info_view->delivery_pod->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_delivery_pod"].options = <?php echo JsonEncode($t_trip_info_view->delivery_pod->options(FALSE, TRUE)) ?>;
ft_trip_infoview.lists["x_status"] = <?php echo $t_trip_info_view->status->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_status"].options = <?php echo JsonEncode($t_trip_info_view->status->options(FALSE, TRUE)) ?>;
ft_trip_infoview.lists["x_driver"] = <?php echo $t_trip_info_view->driver->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_driver"].options = <?php echo JsonEncode($t_trip_info_view->driver->lookupOptions()) ?>;
ft_trip_infoview.lists["x_agent"] = <?php echo $t_trip_info_view->agent->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_agent"].options = <?php echo JsonEncode($t_trip_info_view->agent->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x_freight_type"] = <?php echo $t_trip_info_view->freight_type->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_info_view->freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infoview.lists["x_consignor"] = <?php echo $t_trip_info_view->consignor->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_consignor"].options = <?php echo JsonEncode($t_trip_info_view->consignor->lookupOptions()) ?>;
ft_trip_infoview.autoSuggests["x_consignor"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_infoview.lists["x_vehicle_freight_type"] = <?php echo $t_trip_info_view->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_info_view->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_infoview.lists["x_operator"] = <?php echo $t_trip_info_view->operator->Lookup->toClientList() ?>;
ft_trip_infoview.lists["x_operator"].options = <?php echo JsonEncode($t_trip_info_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_trip_info_view->ExportOptions->render("body") ?>
<?php $t_trip_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_trip_info_view->showPageHeader(); ?>
<?php
$t_trip_info_view->showMessage();
?>
<form name="ft_trip_infoview" id="ft_trip_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_info">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_info_view->IsModal ?>">
<?php if ($t_trip_info_view->MultiPages->Items[0]->Visible) { ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_id"><?php echo $t_trip_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_trip_info->id->cellAttributes() ?>>
<span id="el_t_trip_info_id" data-page="0">
<span<?php echo $t_trip_info->id->viewAttributes() ?>>
<?php echo $t_trip_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle_type->Visible) { // vehicle_type ?>
	<tr id="r_vehicle_type">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_type"><?php echo $t_trip_info->vehicle_type->caption() ?></span></td>
		<td data-name="vehicle_type"<?php echo $t_trip_info->vehicle_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_type" data-page="0">
<span<?php echo $t_trip_info->vehicle_type->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle->Visible) { // vehicle ?>
	<tr id="r_vehicle">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle"><?php echo $t_trip_info->vehicle->caption() ?></span></td>
		<td data-name="vehicle"<?php echo $t_trip_info->vehicle->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle" data-page="0">
<span<?php echo $t_trip_info->vehicle->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->_route->Visible) { // route ?>
	<tr id="r__route">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info__route"><?php echo $t_trip_info->_route->caption() ?></span></td>
		<td data-name="_route"<?php echo $t_trip_info->_route->cellAttributes() ?>>
<span id="el_t_trip_info__route" data-page="0">
<span<?php echo $t_trip_info->_route->viewAttributes() ?>>
<?php echo $t_trip_info->_route->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->route_name->Visible) { // route_name ?>
	<tr id="r_route_name">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_route_name"><?php echo $t_trip_info->route_name->caption() ?></span></td>
		<td data-name="route_name"<?php echo $t_trip_info->route_name->cellAttributes() ?>>
<span id="el_t_trip_info_route_name" data-page="0">
<span<?php echo $t_trip_info->route_name->viewAttributes() ?>>
<?php echo $t_trip_info->route_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_status"><?php echo $t_trip_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $t_trip_info->status->cellAttributes() ?>>
<span id="el_t_trip_info_status" data-page="0">
<span<?php echo $t_trip_info->status->viewAttributes() ?>>
<?php echo $t_trip_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->days->Visible) { // days ?>
	<tr id="r_days">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_days"><?php echo $t_trip_info->days->caption() ?></span></td>
		<td data-name="days"<?php echo $t_trip_info->days->cellAttributes() ?>>
<span id="el_t_trip_info_days" data-page="0">
<span<?php echo $t_trip_info->days->viewAttributes() ?>>
<?php echo $t_trip_info->days->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->driver->Visible) { // driver ?>
	<tr id="r_driver">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_driver"><?php echo $t_trip_info->driver->caption() ?></span></td>
		<td data-name="driver"<?php echo $t_trip_info->driver->cellAttributes() ?>>
<span id="el_t_trip_info_driver" data-page="0">
<span<?php echo $t_trip_info->driver->viewAttributes() ?>>
<?php echo $t_trip_info->driver->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->driver_name->Visible) { // driver_name ?>
	<tr id="r_driver_name">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_driver_name"><?php echo $t_trip_info->driver_name->caption() ?></span></td>
		<td data-name="driver_name"<?php echo $t_trip_info->driver_name->cellAttributes() ?>>
<span id="el_t_trip_info_driver_name" data-page="0">
<span<?php echo $t_trip_info->driver_name->viewAttributes() ?>>
<?php echo $t_trip_info->driver_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->consignor->Visible) { // consignor ?>
	<tr id="r_consignor">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_consignor"><?php echo $t_trip_info->consignor->caption() ?></span></td>
		<td data-name="consignor"<?php echo $t_trip_info->consignor->cellAttributes() ?>>
<span id="el_t_trip_info_consignor" data-page="0">
<span<?php echo $t_trip_info->consignor->viewAttributes() ?>>
<?php echo $t_trip_info->consignor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<tr id="r_vehicle_freight_comm">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_comm"><?php echo $t_trip_info->vehicle_freight_comm->caption() ?></span></td>
		<td data-name="vehicle_freight_comm"<?php echo $t_trip_info->vehicle_freight_comm->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_comm" data-page="0">
<span<?php echo $t_trip_info->vehicle_freight_comm->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_comm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<tr id="r_vehicle_freight_type">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_type"><?php echo $t_trip_info->vehicle_freight_type->caption() ?></span></td>
		<td data-name="vehicle_freight_type"<?php echo $t_trip_info->vehicle_freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_type" data-page="0">
<span<?php echo $t_trip_info->vehicle_freight_type->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<tr id="r_vehicle_freight_amount">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_amount"><?php echo $t_trip_info->vehicle_freight_amount->caption() ?></span></td>
		<td data-name="vehicle_freight_amount"<?php echo $t_trip_info->vehicle_freight_amount->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_amount" data-page="0">
<span<?php echo $t_trip_info->vehicle_freight_amount->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle_freight_final->Visible) { // vehicle_freight_final ?>
	<tr id="r_vehicle_freight_final">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_freight_final"><?php echo $t_trip_info->vehicle_freight_final->caption() ?></span></td>
		<td data-name="vehicle_freight_final"<?php echo $t_trip_info->vehicle_freight_final->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_freight_final" data-page="0">
<span<?php echo $t_trip_info->vehicle_freight_final->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_freight_final->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
<div class="ew-multi-page">
<div class="accordion ew-accordion" id="t_trip_info_view"><!-- multi-page accordion -->
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("1")) ?>" href="#tab_t_trip_info1"><?php echo $t_trip_info->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info1">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->reports_to->Visible) { // reports_to ?>
	<tr id="r_reports_to">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_reports_to"><?php echo $t_trip_info->reports_to->caption() ?></span></td>
		<td data-name="reports_to"<?php echo $t_trip_info->reports_to->cellAttributes() ?>>
<span id="el_t_trip_info_reports_to" data-page="1">
<span<?php echo $t_trip_info->reports_to->viewAttributes() ?>>
<?php echo $t_trip_info->reports_to->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->buyer->Visible) { // buyer ?>
	<tr id="r_buyer">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_buyer"><?php echo $t_trip_info->buyer->caption() ?></span></td>
		<td data-name="buyer"<?php echo $t_trip_info->buyer->cellAttributes() ?>>
<span id="el_t_trip_info_buyer" data-page="1">
<span<?php echo $t_trip_info->buyer->viewAttributes() ?>>
<?php echo $t_trip_info->buyer->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->b_consignor->Visible) { // b_consignor ?>
	<tr id="r_b_consignor">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_b_consignor"><?php echo $t_trip_info->b_consignor->caption() ?></span></td>
		<td data-name="b_consignor"<?php echo $t_trip_info->b_consignor->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignor" data-page="1">
<span<?php echo $t_trip_info->b_consignor->viewAttributes() ?>>
<?php echo $t_trip_info->b_consignor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->b_consignee->Visible) { // b_consignee ?>
	<tr id="r_b_consignee">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_b_consignee"><?php echo $t_trip_info->b_consignee->caption() ?></span></td>
		<td data-name="b_consignee"<?php echo $t_trip_info->b_consignee->cellAttributes() ?>>
<span id="el_t_trip_info_b_consignee" data-page="1">
<span<?php echo $t_trip_info->b_consignee->viewAttributes() ?>>
<?php echo $t_trip_info->b_consignee->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->agent->Visible) { // agent ?>
	<tr id="r_agent">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_agent"><?php echo $t_trip_info->agent->caption() ?></span></td>
		<td data-name="agent"<?php echo $t_trip_info->agent->cellAttributes() ?>>
<span id="el_t_trip_info_agent" data-page="1">
<span<?php echo $t_trip_info->agent->viewAttributes() ?>>
<?php echo $t_trip_info->agent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->comm->Visible) { // comm ?>
	<tr id="r_comm">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_comm"><?php echo $t_trip_info->comm->caption() ?></span></td>
		<td data-name="comm"<?php echo $t_trip_info->comm->cellAttributes() ?>>
<span id="el_t_trip_info_comm" data-page="1">
<span<?php echo $t_trip_info->comm->viewAttributes() ?>>
<?php echo $t_trip_info->comm->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->material->Visible) { // material ?>
	<tr id="r_material">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_material"><?php echo $t_trip_info->material->caption() ?></span></td>
		<td data-name="material"<?php echo $t_trip_info->material->cellAttributes() ?>>
<span id="el_t_trip_info_material" data-page="1">
<span<?php echo $t_trip_info->material->viewAttributes() ?>>
<?php echo $t_trip_info->material->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->packing_type->Visible) { // packing_type ?>
	<tr id="r_packing_type">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_packing_type"><?php echo $t_trip_info->packing_type->caption() ?></span></td>
		<td data-name="packing_type"<?php echo $t_trip_info->packing_type->cellAttributes() ?>>
<span id="el_t_trip_info_packing_type" data-page="1">
<span<?php echo $t_trip_info->packing_type->viewAttributes() ?>>
<?php echo $t_trip_info->packing_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->m_hsn->Visible) { // m_hsn ?>
	<tr id="r_m_hsn">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_m_hsn"><?php echo $t_trip_info->m_hsn->caption() ?></span></td>
		<td data-name="m_hsn"<?php echo $t_trip_info->m_hsn->cellAttributes() ?>>
<span id="el_t_trip_info_m_hsn" data-page="1">
<span<?php echo $t_trip_info->m_hsn->viewAttributes() ?>>
<?php echo $t_trip_info->m_hsn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->_40->Visible) { // @ ?>
	<tr id="r__40">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info__40"><?php echo $t_trip_info->_40->caption() ?></span></td>
		<td data-name="_40"<?php echo $t_trip_info->_40->cellAttributes() ?>>
<span id="el_t_trip_info__40" data-page="1">
<span<?php echo $t_trip_info->_40->viewAttributes() ?>>
<?php echo $t_trip_info->_40->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->lr_no->Visible) { // lr_no ?>
	<tr id="r_lr_no">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_lr_no"><?php echo $t_trip_info->lr_no->caption() ?></span></td>
		<td data-name="lr_no"<?php echo $t_trip_info->lr_no->cellAttributes() ?>>
<span id="el_t_trip_info_lr_no" data-page="1">
<span<?php echo $t_trip_info->lr_no->viewAttributes() ?>>
<?php echo $t_trip_info->lr_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_remarks"><?php echo $t_trip_info->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_trip_info->remarks->cellAttributes() ?>>
<span id="el_t_trip_info_remarks" data-page="1">
<span<?php echo $t_trip_info->remarks->viewAttributes() ?>>
<?php echo $t_trip_info->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("2")) ?>" href="#tab_t_trip_info2"><?php echo $t_trip_info->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info2">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->invoice_no->Visible) { // invoice_no ?>
	<tr id="r_invoice_no">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_invoice_no"><?php echo $t_trip_info->invoice_no->caption() ?></span></td>
		<td data-name="invoice_no"<?php echo $t_trip_info->invoice_no->cellAttributes() ?>>
<span id="el_t_trip_info_invoice_no" data-page="2">
<span<?php echo $t_trip_info->invoice_no->viewAttributes() ?>>
<?php echo $t_trip_info->invoice_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->invoice_date->Visible) { // invoice_date ?>
	<tr id="r_invoice_date">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_invoice_date"><?php echo $t_trip_info->invoice_date->caption() ?></span></td>
		<td data-name="invoice_date"<?php echo $t_trip_info->invoice_date->cellAttributes() ?>>
<span id="el_t_trip_info_invoice_date" data-page="2">
<span<?php echo $t_trip_info->invoice_date->viewAttributes() ?>>
<?php echo $t_trip_info->invoice_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->amount->Visible) { // amount ?>
	<tr id="r_amount">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_amount"><?php echo $t_trip_info->amount->caption() ?></span></td>
		<td data-name="amount"<?php echo $t_trip_info->amount->cellAttributes() ?>>
<span id="el_t_trip_info_amount" data-page="2">
<span<?php echo $t_trip_info->amount->viewAttributes() ?>>
<?php echo $t_trip_info->amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->km->Visible) { // km ?>
	<tr id="r_km">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_km"><?php echo $t_trip_info->km->caption() ?></span></td>
		<td data-name="km"<?php echo $t_trip_info->km->cellAttributes() ?>>
<span id="el_t_trip_info_km" data-page="2">
<span<?php echo $t_trip_info->km->viewAttributes() ?>>
<?php echo $t_trip_info->km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->freight_type->Visible) { // freight_type ?>
	<tr id="r_freight_type">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_freight_type"><?php echo $t_trip_info->freight_type->caption() ?></span></td>
		<td data-name="freight_type"<?php echo $t_trip_info->freight_type->cellAttributes() ?>>
<span id="el_t_trip_info_freight_type" data-page="2">
<span<?php echo $t_trip_info->freight_type->viewAttributes() ?>>
<?php echo $t_trip_info->freight_type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->freight->Visible) { // freight ?>
	<tr id="r_freight">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_freight"><?php echo $t_trip_info->freight->caption() ?></span></td>
		<td data-name="freight"<?php echo $t_trip_info->freight->cellAttributes() ?>>
<span id="el_t_trip_info_freight" data-page="2">
<span<?php echo $t_trip_info->freight->viewAttributes() ?>>
<?php echo $t_trip_info->freight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->ded_det->Visible) { // ded_det ?>
	<tr id="r_ded_det">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_ded_det"><?php echo $t_trip_info->ded_det->caption() ?></span></td>
		<td data-name="ded_det"<?php echo $t_trip_info->ded_det->cellAttributes() ?>>
<span id="el_t_trip_info_ded_det" data-page="2">
<span<?php echo $t_trip_info->ded_det->viewAttributes() ?>>
<?php echo $t_trip_info->ded_det->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->ded_det_remarks->Visible) { // ded_det_remarks ?>
	<tr id="r_ded_det_remarks">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_ded_det_remarks"><?php echo $t_trip_info->ded_det_remarks->caption() ?></span></td>
		<td data-name="ded_det_remarks"<?php echo $t_trip_info->ded_det_remarks->cellAttributes() ?>>
<span id="el_t_trip_info_ded_det_remarks" data-page="2">
<span<?php echo $t_trip_info->ded_det_remarks->viewAttributes() ?>>
<?php echo $t_trip_info->ded_det_remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->gst_percent->Visible) { // gst_percent ?>
	<tr id="r_gst_percent">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_gst_percent"><?php echo $t_trip_info->gst_percent->caption() ?></span></td>
		<td data-name="gst_percent"<?php echo $t_trip_info->gst_percent->cellAttributes() ?>>
<span id="el_t_trip_info_gst_percent" data-page="2">
<span<?php echo $t_trip_info->gst_percent->viewAttributes() ?>>
<?php echo $t_trip_info->gst_percent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->gst_amount->Visible) { // gst_amount ?>
	<tr id="r_gst_amount">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_gst_amount"><?php echo $t_trip_info->gst_amount->caption() ?></span></td>
		<td data-name="gst_amount"<?php echo $t_trip_info->gst_amount->cellAttributes() ?>>
<span id="el_t_trip_info_gst_amount" data-page="2">
<span<?php echo $t_trip_info->gst_amount->viewAttributes() ?>>
<?php echo $t_trip_info->gst_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->final_amount->Visible) { // final_amount ?>
	<tr id="r_final_amount">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_final_amount"><?php echo $t_trip_info->final_amount->caption() ?></span></td>
		<td data-name="final_amount"<?php echo $t_trip_info->final_amount->cellAttributes() ?>>
<span id="el_t_trip_info_final_amount" data-page="2">
<span<?php echo $t_trip_info->final_amount->viewAttributes() ?>>
<?php echo $t_trip_info->final_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("3")) ?>" href="#tab_t_trip_info3"><?php echo $t_trip_info->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info3">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->load_date->Visible) { // load_date ?>
	<tr id="r_load_date">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_load_date"><?php echo $t_trip_info->load_date->caption() ?></span></td>
		<td data-name="load_date"<?php echo $t_trip_info->load_date->cellAttributes() ?>>
<span id="el_t_trip_info_load_date" data-page="3">
<span<?php echo $t_trip_info->load_date->viewAttributes() ?>>
<?php echo $t_trip_info->load_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->load_weight->Visible) { // load_weight ?>
	<tr id="r_load_weight">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_load_weight"><?php echo $t_trip_info->load_weight->caption() ?></span></td>
		<td data-name="load_weight"<?php echo $t_trip_info->load_weight->cellAttributes() ?>>
<span id="el_t_trip_info_load_weight" data-page="3">
<span<?php echo $t_trip_info->load_weight->viewAttributes() ?>>
<?php echo $t_trip_info->load_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->unload_date->Visible) { // unload_date ?>
	<tr id="r_unload_date">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_unload_date"><?php echo $t_trip_info->unload_date->caption() ?></span></td>
		<td data-name="unload_date"<?php echo $t_trip_info->unload_date->cellAttributes() ?>>
<span id="el_t_trip_info_unload_date" data-page="3">
<span<?php echo $t_trip_info->unload_date->viewAttributes() ?>>
<?php echo $t_trip_info->unload_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->unload_weight->Visible) { // unload_weight ?>
	<tr id="r_unload_weight">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_unload_weight"><?php echo $t_trip_info->unload_weight->caption() ?></span></td>
		<td data-name="unload_weight"<?php echo $t_trip_info->unload_weight->cellAttributes() ?>>
<span id="el_t_trip_info_unload_weight" data-page="3">
<span<?php echo $t_trip_info->unload_weight->viewAttributes() ?>>
<?php echo $t_trip_info->unload_weight->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->delivery_pod->Visible) { // delivery_pod ?>
	<tr id="r_delivery_pod">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_delivery_pod"><?php echo $t_trip_info->delivery_pod->caption() ?></span></td>
		<td data-name="delivery_pod"<?php echo $t_trip_info->delivery_pod->cellAttributes() ?>>
<span id="el_t_trip_info_delivery_pod" data-page="3">
<span<?php echo $t_trip_info->delivery_pod->viewAttributes() ?>>
<?php echo $t_trip_info->delivery_pod->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->load_km->Visible) { // load_km ?>
	<tr id="r_load_km">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_load_km"><?php echo $t_trip_info->load_km->caption() ?></span></td>
		<td data-name="load_km"<?php echo $t_trip_info->load_km->cellAttributes() ?>>
<span id="el_t_trip_info_load_km" data-page="3">
<span<?php echo $t_trip_info->load_km->viewAttributes() ?>>
<?php echo $t_trip_info->load_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->unload_km->Visible) { // unload_km ?>
	<tr id="r_unload_km">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_unload_km"><?php echo $t_trip_info->unload_km->caption() ?></span></td>
		<td data-name="unload_km"<?php echo $t_trip_info->unload_km->cellAttributes() ?>>
<span id="el_t_trip_info_unload_km" data-page="3">
<span<?php echo $t_trip_info->unload_km->viewAttributes() ?>>
<?php echo $t_trip_info->unload_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->delivery_receipt->Visible) { // delivery_receipt ?>
	<tr id="r_delivery_receipt">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_delivery_receipt"><?php echo $t_trip_info->delivery_receipt->caption() ?></span></td>
		<td data-name="delivery_receipt"<?php echo $t_trip_info->delivery_receipt->cellAttributes() ?>>
<span id="el_t_trip_info_delivery_receipt" data-page="3">
<span>
<?php echo GetFileViewTag($t_trip_info->delivery_receipt, $t_trip_info->delivery_receipt->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->delivery_docket->Visible) { // delivery_docket ?>
	<tr id="r_delivery_docket">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_delivery_docket"><?php echo $t_trip_info->delivery_docket->caption() ?></span></td>
		<td data-name="delivery_docket"<?php echo $t_trip_info->delivery_docket->cellAttributes() ?>>
<span id="el_t_trip_info_delivery_docket" data-page="3">
<span<?php echo $t_trip_info->delivery_docket->viewAttributes() ?>>
<?php echo $t_trip_info->delivery_docket->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("4") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("4")) ?>" href="#tab_t_trip_info4"><?php echo $t_trip_info->pageCaption(4) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("4") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info4">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->diesal_op_b->Visible) { // diesal_op_b ?>
	<tr id="r_diesal_op_b">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_diesal_op_b"><?php echo $t_trip_info->diesal_op_b->caption() ?></span></td>
		<td data-name="diesal_op_b"<?php echo $t_trip_info->diesal_op_b->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_op_b" data-page="4">
<span<?php echo $t_trip_info->diesal_op_b->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_op_b->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->diesal_required->Visible) { // diesal_required ?>
	<tr id="r_diesal_required">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_diesal_required"><?php echo $t_trip_info->diesal_required->caption() ?></span></td>
		<td data-name="diesal_required"<?php echo $t_trip_info->diesal_required->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_required" data-page="4">
<span<?php echo $t_trip_info->diesal_required->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_required->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->diesal_fill->Visible) { // diesal_fill ?>
	<tr id="r_diesal_fill">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_diesal_fill"><?php echo $t_trip_info->diesal_fill->caption() ?></span></td>
		<td data-name="diesal_fill"<?php echo $t_trip_info->diesal_fill->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_fill" data-page="4">
<span<?php echo $t_trip_info->diesal_fill->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_fill->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->diesal_amount->Visible) { // diesal_amount ?>
	<tr id="r_diesal_amount">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_diesal_amount"><?php echo $t_trip_info->diesal_amount->caption() ?></span></td>
		<td data-name="diesal_amount"<?php echo $t_trip_info->diesal_amount->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_amount" data-page="4">
<span<?php echo $t_trip_info->diesal_amount->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_amount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->diesal_cl_balance->Visible) { // diesal_cl_balance ?>
	<tr id="r_diesal_cl_balance">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_diesal_cl_balance"><?php echo $t_trip_info->diesal_cl_balance->caption() ?></span></td>
		<td data-name="diesal_cl_balance"<?php echo $t_trip_info->diesal_cl_balance->cellAttributes() ?>>
<span id="el_t_trip_info_diesal_cl_balance" data-page="4">
<span<?php echo $t_trip_info->diesal_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info->diesal_cl_balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->vehicle_average->Visible) { // vehicle_average ?>
	<tr id="r_vehicle_average">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_vehicle_average"><?php echo $t_trip_info->vehicle_average->caption() ?></span></td>
		<td data-name="vehicle_average"<?php echo $t_trip_info->vehicle_average->cellAttributes() ?>>
<span id="el_t_trip_info_vehicle_average" data-page="4">
<span<?php echo $t_trip_info->vehicle_average->viewAttributes() ?>>
<?php echo $t_trip_info->vehicle_average->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("5") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("5")) ?>" href="#tab_t_trip_info5"><?php echo $t_trip_info->pageCaption(5) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("5") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info5">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->cash_required->Visible) { // cash_required ?>
	<tr id="r_cash_required">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_cash_required"><?php echo $t_trip_info->cash_required->caption() ?></span></td>
		<td data-name="cash_required"<?php echo $t_trip_info->cash_required->cellAttributes() ?>>
<span id="el_t_trip_info_cash_required" data-page="5">
<span<?php echo $t_trip_info->cash_required->viewAttributes() ?>>
<?php echo $t_trip_info->cash_required->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->cash_op_b->Visible) { // cash_op_b ?>
	<tr id="r_cash_op_b">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_cash_op_b"><?php echo $t_trip_info->cash_op_b->caption() ?></span></td>
		<td data-name="cash_op_b"<?php echo $t_trip_info->cash_op_b->cellAttributes() ?>>
<span id="el_t_trip_info_cash_op_b" data-page="5">
<span<?php echo $t_trip_info->cash_op_b->viewAttributes() ?>>
<?php echo $t_trip_info->cash_op_b->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->cash_paid->Visible) { // cash_paid ?>
	<tr id="r_cash_paid">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_cash_paid"><?php echo $t_trip_info->cash_paid->caption() ?></span></td>
		<td data-name="cash_paid"<?php echo $t_trip_info->cash_paid->cellAttributes() ?>>
<span id="el_t_trip_info_cash_paid" data-page="5">
<span<?php echo $t_trip_info->cash_paid->viewAttributes() ?>>
<?php echo $t_trip_info->cash_paid->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->cash_expenses->Visible) { // cash_expenses ?>
	<tr id="r_cash_expenses">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_cash_expenses"><?php echo $t_trip_info->cash_expenses->caption() ?></span></td>
		<td data-name="cash_expenses"<?php echo $t_trip_info->cash_expenses->cellAttributes() ?>>
<span id="el_t_trip_info_cash_expenses" data-page="5">
<span<?php echo $t_trip_info->cash_expenses->viewAttributes() ?>>
<?php echo $t_trip_info->cash_expenses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->cash_cl_balance->Visible) { // cash_cl_balance ?>
	<tr id="r_cash_cl_balance">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_cash_cl_balance"><?php echo $t_trip_info->cash_cl_balance->caption() ?></span></td>
		<td data-name="cash_cl_balance"<?php echo $t_trip_info->cash_cl_balance->cellAttributes() ?>>
<span id="el_t_trip_info_cash_cl_balance" data-page="5">
<span<?php echo $t_trip_info->cash_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info->cash_cl_balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("6") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("6")) ?>" href="#tab_t_trip_info6"><?php echo $t_trip_info->pageCaption(6) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("6") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info6">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->fasttag_op_b->Visible) { // fasttag_op_b ?>
	<tr id="r_fasttag_op_b">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_op_b"><?php echo $t_trip_info->fasttag_op_b->caption() ?></span></td>
		<td data-name="fasttag_op_b"<?php echo $t_trip_info->fasttag_op_b->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_op_b" data-page="6">
<span<?php echo $t_trip_info->fasttag_op_b->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_op_b->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->fasttag_recharge->Visible) { // fasttag_recharge ?>
	<tr id="r_fasttag_recharge">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_recharge"><?php echo $t_trip_info->fasttag_recharge->caption() ?></span></td>
		<td data-name="fasttag_recharge"<?php echo $t_trip_info->fasttag_recharge->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_recharge" data-page="6">
<span<?php echo $t_trip_info->fasttag_recharge->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_recharge->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->fasttag_expenses->Visible) { // fasttag_expenses ?>
	<tr id="r_fasttag_expenses">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_expenses"><?php echo $t_trip_info->fasttag_expenses->caption() ?></span></td>
		<td data-name="fasttag_expenses"<?php echo $t_trip_info->fasttag_expenses->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_expenses" data-page="6">
<span<?php echo $t_trip_info->fasttag_expenses->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_expenses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->toll_expenses_cash->Visible) { // toll_expenses_cash ?>
	<tr id="r_toll_expenses_cash">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_toll_expenses_cash"><?php echo $t_trip_info->toll_expenses_cash->caption() ?></span></td>
		<td data-name="toll_expenses_cash"<?php echo $t_trip_info->toll_expenses_cash->cellAttributes() ?>>
<span id="el_t_trip_info_toll_expenses_cash" data-page="6">
<span<?php echo $t_trip_info->toll_expenses_cash->viewAttributes() ?>>
<?php echo $t_trip_info->toll_expenses_cash->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->fasttag_cl_balance->Visible) { // fasttag_cl_balance ?>
	<tr id="r_fasttag_cl_balance">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_fasttag_cl_balance"><?php echo $t_trip_info->fasttag_cl_balance->caption() ?></span></td>
		<td data-name="fasttag_cl_balance"<?php echo $t_trip_info->fasttag_cl_balance->cellAttributes() ?>>
<span id="el_t_trip_info_fasttag_cl_balance" data-page="6">
<span<?php echo $t_trip_info->fasttag_cl_balance->viewAttributes() ?>>
<?php echo $t_trip_info->fasttag_cl_balance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
	<div class="card ew-accordion-card<?php echo $t_trip_info_view->MultiPages->pageStyle("7") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_info_view->MultiPages->isActive("7")) ?>" href="#tab_t_trip_info7"><?php echo $t_trip_info->pageCaption(7) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_info_view->MultiPages->pageStyle("7") ?>" data-parent="<?php echo $t_trip_info_view->MultiPages->Parent ?>" id="tab_t_trip_info7">
			<div class="card-body"><!-- multi-page accordion .card-body -->
<?php } ?>
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_trip_info->uploads->Visible) { // uploads ?>
	<tr id="r_uploads">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_uploads"><?php echo $t_trip_info->uploads->caption() ?></span></td>
		<td data-name="uploads"<?php echo $t_trip_info->uploads->cellAttributes() ?>>
<span id="el_t_trip_info_uploads" data-page="7">
<span>
<?php echo GetFileViewTag($t_trip_info->uploads, $t_trip_info->uploads->getViewValue()) ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_operator"><?php echo $t_trip_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_trip_info->operator->cellAttributes() ?>>
<span id="el_t_trip_info_operator" data-page="7">
<span<?php echo $t_trip_info->operator->viewAttributes() ?>>
<?php echo $t_trip_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_trip_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_trip_info_view->TableLeftColumnClass ?>"><span id="elh_t_trip_info_datetime"><?php echo $t_trip_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_trip_info->datetime->cellAttributes() ?>>
<span id="el_t_trip_info_datetime" data-page="7">
<span<?php echo $t_trip_info->datetime->viewAttributes() ?>>
<?php echo $t_trip_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
<?php if (!$t_trip_info->isExport()) { ?>
			</div>
		</div>
	</div>
<?php } ?>
<?php if (!$t_trip_info->isExport()) { ?>
</div>
</div>
<?php } ?>
<?php
	if (in_array("t_expenses_o", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_expenses_o->DetailView) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_expenses_o", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_expenses_ogrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_receipt_d", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_receipt_d->DetailView) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_receipt_d", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_receipt_dgrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_diesal_expenses", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_diesal_expenses->DetailView) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_diesal_expenses", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_diesal_expensesgrid.php" ?>
<?php } ?>
<?php
	if (in_array("t_route_info", explode(",", $t_trip_info->getCurrentDetailTable())) && $t_route_info->DetailView) {
?>
<?php if ($t_trip_info->getCurrentDetailTable() <> "") { ?>
<h4 class="ew-detail-caption"><?php echo $Language->TablePhrase("t_route_info", "TblCaption") ?></h4>
<?php } ?>
<?php include_once "t_route_infogrid.php" ?>
<?php } ?>
</form>
<?php
$t_trip_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_info_view->terminate();
?>