<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_loadslip_list = new t_trip_loadslip_list();

// Run the page
$t_trip_loadslip_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_loadslip_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_loadslip->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_loadsliplist = currentForm = new ew.Form("ft_trip_loadsliplist", "list");
ft_trip_loadsliplist.formKeyCountName = '<?php echo $t_trip_loadslip_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_loadsliplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_loadsliplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_loadsliplist.lists["x_vehicle_type"] = <?php echo $t_trip_loadslip_list->vehicle_type->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_loadslip_list->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_loadsliplist.lists["x_vehicle"] = <?php echo $t_trip_loadslip_list->vehicle->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_loadslip_list->vehicle->lookupOptions()) ?>;
ft_trip_loadsliplist.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadsliplist.lists["x_driver"] = <?php echo $t_trip_loadslip_list->driver->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_driver"].options = <?php echo JsonEncode($t_trip_loadslip_list->driver->lookupOptions()) ?>;
ft_trip_loadsliplist.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadsliplist.lists["x_reports_to"] = <?php echo $t_trip_loadslip_list->reports_to->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_loadslip_list->reports_to->lookupOptions()) ?>;
ft_trip_loadsliplist.lists["x_buyer"] = <?php echo $t_trip_loadslip_list->buyer->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_loadslip_list->buyer->lookupOptions()) ?>;
ft_trip_loadsliplist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadsliplist.lists["x_b_consignor"] = <?php echo $t_trip_loadslip_list->b_consignor->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_loadslip_list->b_consignor->lookupOptions()) ?>;
ft_trip_loadsliplist.lists["x_b_consignee"] = <?php echo $t_trip_loadslip_list->b_consignee->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_loadslip_list->b_consignee->lookupOptions()) ?>;
ft_trip_loadsliplist.lists["x_agent"] = <?php echo $t_trip_loadslip_list->agent->Lookup->toClientList() ?>;
ft_trip_loadsliplist.lists["x_agent"].options = <?php echo JsonEncode($t_trip_loadslip_list->agent->lookupOptions()) ?>;
ft_trip_loadsliplist.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var ft_trip_loadsliplistsrch = currentSearchForm = new ew.Form("ft_trip_loadsliplistsrch");

// Validate function for search
ft_trip_loadsliplistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_vehicle");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->vehicle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->buyer->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_loadsliplistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_loadsliplistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_loadsliplistsrch.lists["x_vehicle_type"] = <?php echo $t_trip_loadslip_list->vehicle_type->Lookup->toClientList() ?>;
ft_trip_loadsliplistsrch.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_loadslip_list->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_loadsliplistsrch.lists["x_vehicle"] = <?php echo $t_trip_loadslip_list->vehicle->Lookup->toClientList() ?>;
ft_trip_loadsliplistsrch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_loadslip_list->vehicle->lookupOptions()) ?>;
ft_trip_loadsliplistsrch.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadsliplistsrch.lists["x_buyer"] = <?php echo $t_trip_loadslip_list->buyer->Lookup->toClientList() ?>;
ft_trip_loadsliplistsrch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_loadslip_list->buyer->lookupOptions()) ?>;
ft_trip_loadsliplistsrch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
ft_trip_loadsliplistsrch.filterList = <?php echo $t_trip_loadslip_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_loadsliplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_loadslip->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_loadslip_list->TotalRecs > 0 && $t_trip_loadslip_list->ExportOptions->visible()) { ?>
<?php $t_trip_loadslip_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_loadslip_list->ImportOptions->visible()) { ?>
<?php $t_trip_loadslip_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_loadslip_list->SearchOptions->visible()) { ?>
<?php $t_trip_loadslip_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_loadslip_list->FilterOptions->visible()) { ?>
<?php $t_trip_loadslip_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_loadslip_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_loadslip->isExport() && !$t_trip_loadslip->CurrentAction) { ?>
<form name="ft_trip_loadsliplistsrch" id="ft_trip_loadsliplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_loadslip_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_loadsliplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_loadslip">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_loadslip_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_loadslip->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_loadslip->resetAttributes();
$t_trip_loadslip_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_loadslip->vehicle_type->Visible) { // vehicle_type ?>
	<div id="xsc_vehicle_type" class="ew-cell form-group">
		<label for="x_vehicle_type" class="ew-search-caption ew-label"><?php echo $t_trip_loadslip->vehicle_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="="></span>
		<span class="ew-search-field">
<?php $t_trip_loadslip->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_loadslip->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_loadslip" data-field="x_vehicle_type" data-value-separator="<?php echo $t_trip_loadslip->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_loadslip->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_loadslip->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->vehicle->Visible) { // vehicle ?>
	<div id="xsc_vehicle" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_loadslip->vehicle->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_loadslip->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->vehicle->ReadOnly || $t_trip_loadslip->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_vehicle" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_loadslip->vehicle->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadsliplistsrch.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_loadslip->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->buyer->Visible) { // buyer ?>
	<div id="xsc_buyer" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_loadslip->buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_loadslip->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->buyer->ReadOnly || $t_trip_loadslip->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_loadslip->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadsliplistsrch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_loadslip->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_loadslip_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_loadslip_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_loadslip_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_loadslip_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_loadslip_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_loadslip_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_loadslip_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_loadslip_list->showPageHeader(); ?>
<?php
$t_trip_loadslip_list->showMessage();
?>
<?php if ($t_trip_loadslip_list->TotalRecs > 0 || $t_trip_loadslip->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_loadslip_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_loadslip">
<?php if (!$t_trip_loadslip->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_loadslip->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_loadslip_list->Pager)) $t_trip_loadslip_list->Pager = new PrevNextPager($t_trip_loadslip_list->StartRec, $t_trip_loadslip_list->DisplayRecs, $t_trip_loadslip_list->TotalRecs, $t_trip_loadslip_list->AutoHidePager) ?>
<?php if ($t_trip_loadslip_list->Pager->RecordCount > 0 && $t_trip_loadslip_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_loadslip_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_loadslip_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_loadslip_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_loadslip_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_loadslip_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_loadslip_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_loadslip_list->TotalRecs > 0 && (!$t_trip_loadslip_list->AutoHidePageSizeSelector || $t_trip_loadslip_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_loadslip">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_loadslip_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_loadslip_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_loadslip_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_loadslip_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_loadslip_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_loadslip->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_loadslip_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_loadsliplist" id="ft_trip_loadsliplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_loadslip_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_loadslip_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_loadslip">
<div id="gmp_t_trip_loadslip" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_loadslip_list->TotalRecs > 0 || $t_trip_loadslip->isGridEdit()) { ?>
<table id="tbl_t_trip_loadsliplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_loadslip_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_loadslip_list->renderListOptions();

// Render list options (header, left)
$t_trip_loadslip_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_loadslip->id->Visible) { // id ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_trip_loadslip->id->headerCellClass() ?>"><div id="elh_t_trip_loadslip_id" class="t_trip_loadslip_id"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_trip_loadslip->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->id) ?>',2);"><div id="elh_t_trip_loadslip_id" class="t_trip_loadslip_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->vehicle_type->Visible) { // vehicle_type ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->vehicle_type) == "") { ?>
		<th data-name="vehicle_type" class="<?php echo $t_trip_loadslip->vehicle_type->headerCellClass() ?>"><div id="elh_t_trip_loadslip_vehicle_type" class="t_trip_loadslip_vehicle_type"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->vehicle_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_type" class="<?php echo $t_trip_loadslip->vehicle_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->vehicle_type) ?>',2);"><div id="elh_t_trip_loadslip_vehicle_type" class="t_trip_loadslip_vehicle_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->vehicle_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->vehicle_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->vehicle_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->vehicle->Visible) { // vehicle ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->vehicle) == "") { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_loadslip->vehicle->headerCellClass() ?>"><div id="elh_t_trip_loadslip_vehicle" class="t_trip_loadslip_vehicle"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->vehicle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_loadslip->vehicle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->vehicle) ?>',2);"><div id="elh_t_trip_loadslip_vehicle" class="t_trip_loadslip_vehicle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->vehicle->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->vehicle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->vehicle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->route_name->Visible) { // route_name ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->route_name) == "") { ?>
		<th data-name="route_name" class="<?php echo $t_trip_loadslip->route_name->headerCellClass() ?>"><div id="elh_t_trip_loadslip_route_name" class="t_trip_loadslip_route_name"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->route_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="route_name" class="<?php echo $t_trip_loadslip->route_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->route_name) ?>',2);"><div id="elh_t_trip_loadslip_route_name" class="t_trip_loadslip_route_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->route_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->route_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->route_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->driver->Visible) { // driver ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_trip_loadslip->driver->headerCellClass() ?>"><div id="elh_t_trip_loadslip_driver" class="t_trip_loadslip_driver"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_trip_loadslip->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->driver) ?>',2);"><div id="elh_t_trip_loadslip_driver" class="t_trip_loadslip_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->driver->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->driver_name->Visible) { // driver_name ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->driver_name) == "") { ?>
		<th data-name="driver_name" class="<?php echo $t_trip_loadslip->driver_name->headerCellClass() ?>"><div id="elh_t_trip_loadslip_driver_name" class="t_trip_loadslip_driver_name"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->driver_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver_name" class="<?php echo $t_trip_loadslip->driver_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->driver_name) ?>',2);"><div id="elh_t_trip_loadslip_driver_name" class="t_trip_loadslip_driver_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->driver_name->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->driver_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->driver_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->reports_to->Visible) { // reports_to ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $t_trip_loadslip->reports_to->headerCellClass() ?>"><div id="elh_t_trip_loadslip_reports_to" class="t_trip_loadslip_reports_to"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $t_trip_loadslip->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->reports_to) ?>',2);"><div id="elh_t_trip_loadslip_reports_to" class="t_trip_loadslip_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->buyer->Visible) { // buyer ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $t_trip_loadslip->buyer->headerCellClass() ?>"><div id="elh_t_trip_loadslip_buyer" class="t_trip_loadslip_buyer"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $t_trip_loadslip->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->buyer) ?>',2);"><div id="elh_t_trip_loadslip_buyer" class="t_trip_loadslip_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->b_consignor->Visible) { // b_consignor ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->b_consignor) == "") { ?>
		<th data-name="b_consignor" class="<?php echo $t_trip_loadslip->b_consignor->headerCellClass() ?>"><div id="elh_t_trip_loadslip_b_consignor" class="t_trip_loadslip_b_consignor"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->b_consignor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_consignor" class="<?php echo $t_trip_loadslip->b_consignor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->b_consignor) ?>',2);"><div id="elh_t_trip_loadslip_b_consignor" class="t_trip_loadslip_b_consignor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->b_consignor->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->b_consignor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->b_consignor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->b_consignee->Visible) { // b_consignee ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->b_consignee) == "") { ?>
		<th data-name="b_consignee" class="<?php echo $t_trip_loadslip->b_consignee->headerCellClass() ?>"><div id="elh_t_trip_loadslip_b_consignee" class="t_trip_loadslip_b_consignee"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->b_consignee->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="b_consignee" class="<?php echo $t_trip_loadslip->b_consignee->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->b_consignee) ?>',2);"><div id="elh_t_trip_loadslip_b_consignee" class="t_trip_loadslip_b_consignee">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->b_consignee->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->b_consignee->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->b_consignee->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->agent->Visible) { // agent ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->agent) == "") { ?>
		<th data-name="agent" class="<?php echo $t_trip_loadslip->agent->headerCellClass() ?>"><div id="elh_t_trip_loadslip_agent" class="t_trip_loadslip_agent"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="agent" class="<?php echo $t_trip_loadslip->agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->agent) ?>',2);"><div id="elh_t_trip_loadslip_agent" class="t_trip_loadslip_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->agent->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->operator->Visible) { // operator ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_trip_loadslip->operator->headerCellClass() ?>"><div id="elh_t_trip_loadslip_operator" class="t_trip_loadslip_operator"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_trip_loadslip->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->operator) ?>',2);"><div id="elh_t_trip_loadslip_operator" class="t_trip_loadslip_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_loadslip->datetime->Visible) { // datetime ?>
	<?php if ($t_trip_loadslip->sortUrl($t_trip_loadslip->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_trip_loadslip->datetime->headerCellClass() ?>"><div id="elh_t_trip_loadslip_datetime" class="t_trip_loadslip_datetime"><div class="ew-table-header-caption"><?php echo $t_trip_loadslip->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_trip_loadslip->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_loadslip->SortUrl($t_trip_loadslip->datetime) ?>',2);"><div id="elh_t_trip_loadslip_datetime" class="t_trip_loadslip_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_loadslip->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_loadslip->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_loadslip->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_loadslip_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_loadslip->ExportAll && $t_trip_loadslip->isExport()) {
	$t_trip_loadslip_list->StopRec = $t_trip_loadslip_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_loadslip_list->TotalRecs > $t_trip_loadslip_list->StartRec + $t_trip_loadslip_list->DisplayRecs - 1)
		$t_trip_loadslip_list->StopRec = $t_trip_loadslip_list->StartRec + $t_trip_loadslip_list->DisplayRecs - 1;
	else
		$t_trip_loadslip_list->StopRec = $t_trip_loadslip_list->TotalRecs;
}
$t_trip_loadslip_list->RecCnt = $t_trip_loadslip_list->StartRec - 1;
if ($t_trip_loadslip_list->Recordset && !$t_trip_loadslip_list->Recordset->EOF) {
	$t_trip_loadslip_list->Recordset->moveFirst();
	$selectLimit = $t_trip_loadslip_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_loadslip_list->StartRec > 1)
		$t_trip_loadslip_list->Recordset->move($t_trip_loadslip_list->StartRec - 1);
} elseif (!$t_trip_loadslip->AllowAddDeleteRow && $t_trip_loadslip_list->StopRec == 0) {
	$t_trip_loadslip_list->StopRec = $t_trip_loadslip->GridAddRowCount;
}

// Initialize aggregate
$t_trip_loadslip->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_loadslip->resetAttributes();
$t_trip_loadslip_list->renderRow();
while ($t_trip_loadslip_list->RecCnt < $t_trip_loadslip_list->StopRec) {
	$t_trip_loadslip_list->RecCnt++;
	if ($t_trip_loadslip_list->RecCnt >= $t_trip_loadslip_list->StartRec) {
		$t_trip_loadslip_list->RowCnt++;

		// Set up key count
		$t_trip_loadslip_list->KeyCount = $t_trip_loadslip_list->RowIndex;

		// Init row class and style
		$t_trip_loadslip->resetAttributes();
		$t_trip_loadslip->CssClass = "";
		if ($t_trip_loadslip->isGridAdd()) {
		} else {
			$t_trip_loadslip_list->loadRowValues($t_trip_loadslip_list->Recordset); // Load row values
		}
		$t_trip_loadslip->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_loadslip->RowAttrs = array_merge($t_trip_loadslip->RowAttrs, array('data-rowindex'=>$t_trip_loadslip_list->RowCnt, 'id'=>'r' . $t_trip_loadslip_list->RowCnt . '_t_trip_loadslip', 'data-rowtype'=>$t_trip_loadslip->RowType));

		// Render row
		$t_trip_loadslip_list->renderRow();

		// Render list options
		$t_trip_loadslip_list->renderListOptions();
?>
	<tr<?php echo $t_trip_loadslip->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_loadslip_list->ListOptions->render("body", "left", $t_trip_loadslip_list->RowCnt);
?>
	<?php if ($t_trip_loadslip->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_trip_loadslip->id->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_id" class="t_trip_loadslip_id">
<span<?php echo $t_trip_loadslip->id->viewAttributes() ?>>
<?php echo $t_trip_loadslip->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->vehicle_type->Visible) { // vehicle_type ?>
		<td data-name="vehicle_type"<?php echo $t_trip_loadslip->vehicle_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_vehicle_type" class="t_trip_loadslip_vehicle_type">
<span<?php echo $t_trip_loadslip->vehicle_type->viewAttributes() ?>>
<?php echo $t_trip_loadslip->vehicle_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->vehicle->Visible) { // vehicle ?>
		<td data-name="vehicle"<?php echo $t_trip_loadslip->vehicle->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_vehicle" class="t_trip_loadslip_vehicle">
<span<?php echo $t_trip_loadslip->vehicle->viewAttributes() ?>>
<?php echo $t_trip_loadslip->vehicle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->route_name->Visible) { // route_name ?>
		<td data-name="route_name"<?php echo $t_trip_loadslip->route_name->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_route_name" class="t_trip_loadslip_route_name">
<span<?php echo $t_trip_loadslip->route_name->viewAttributes() ?>>
<?php echo $t_trip_loadslip->route_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_trip_loadslip->driver->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_driver" class="t_trip_loadslip_driver">
<span<?php echo $t_trip_loadslip->driver->viewAttributes() ?>>
<?php echo $t_trip_loadslip->driver->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->driver_name->Visible) { // driver_name ?>
		<td data-name="driver_name"<?php echo $t_trip_loadslip->driver_name->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_driver_name" class="t_trip_loadslip_driver_name">
<span<?php echo $t_trip_loadslip->driver_name->viewAttributes() ?>>
<?php echo $t_trip_loadslip->driver_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $t_trip_loadslip->reports_to->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_reports_to" class="t_trip_loadslip_reports_to">
<span<?php echo $t_trip_loadslip->reports_to->viewAttributes() ?>>
<?php echo $t_trip_loadslip->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $t_trip_loadslip->buyer->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_buyer" class="t_trip_loadslip_buyer">
<span<?php echo $t_trip_loadslip->buyer->viewAttributes() ?>>
<?php echo $t_trip_loadslip->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->b_consignor->Visible) { // b_consignor ?>
		<td data-name="b_consignor"<?php echo $t_trip_loadslip->b_consignor->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_b_consignor" class="t_trip_loadslip_b_consignor">
<span<?php echo $t_trip_loadslip->b_consignor->viewAttributes() ?>>
<?php echo $t_trip_loadslip->b_consignor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->b_consignee->Visible) { // b_consignee ?>
		<td data-name="b_consignee"<?php echo $t_trip_loadslip->b_consignee->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_b_consignee" class="t_trip_loadslip_b_consignee">
<span<?php echo $t_trip_loadslip->b_consignee->viewAttributes() ?>>
<?php echo $t_trip_loadslip->b_consignee->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->agent->Visible) { // agent ?>
		<td data-name="agent"<?php echo $t_trip_loadslip->agent->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_agent" class="t_trip_loadslip_agent">
<span<?php echo $t_trip_loadslip->agent->viewAttributes() ?>>
<?php echo $t_trip_loadslip->agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_trip_loadslip->operator->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_operator" class="t_trip_loadslip_operator">
<span<?php echo $t_trip_loadslip->operator->viewAttributes() ?>>
<?php echo $t_trip_loadslip->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_loadslip->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_trip_loadslip->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_trip_loadslip_list->RowCnt ?>_t_trip_loadslip_datetime" class="t_trip_loadslip_datetime">
<span<?php echo $t_trip_loadslip->datetime->viewAttributes() ?>>
<?php echo $t_trip_loadslip->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_loadslip_list->ListOptions->render("body", "right", $t_trip_loadslip_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_loadslip->isGridAdd())
		$t_trip_loadslip_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_loadslip->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_loadslip_list->Recordset)
	$t_trip_loadslip_list->Recordset->Close();
?>
<?php if (!$t_trip_loadslip->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_loadslip->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_loadslip_list->Pager)) $t_trip_loadslip_list->Pager = new PrevNextPager($t_trip_loadslip_list->StartRec, $t_trip_loadslip_list->DisplayRecs, $t_trip_loadslip_list->TotalRecs, $t_trip_loadslip_list->AutoHidePager) ?>
<?php if ($t_trip_loadslip_list->Pager->RecordCount > 0 && $t_trip_loadslip_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_loadslip_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_loadslip_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_loadslip_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_loadslip_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_loadslip_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_loadslip_list->pageUrl() ?>start=<?php echo $t_trip_loadslip_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_loadslip_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_loadslip_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_loadslip_list->TotalRecs > 0 && (!$t_trip_loadslip_list->AutoHidePageSizeSelector || $t_trip_loadslip_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_loadslip">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_loadslip_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_loadslip_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_loadslip_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_loadslip_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_loadslip_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_loadslip->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_loadslip_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_loadslip_list->TotalRecs == 0 && !$t_trip_loadslip->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_loadslip_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_loadslip_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_loadslip->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_loadslip->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_loadslip", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_loadslip_list->terminate();
?>