<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_loadslip_search = new t_trip_loadslip_search();

// Run the page
$t_trip_loadslip_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_loadslip_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_loadslip_search->IsModal) { ?>
var ft_trip_loadslipsearch = currentAdvancedSearchForm = new ew.Form("ft_trip_loadslipsearch", "search");
<?php } else { ?>
var ft_trip_loadslipsearch = currentForm = new ew.Form("ft_trip_loadslipsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_loadslipsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_loadslipsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_loadslipsearch.multiPage = new ew.MultiPage("ft_trip_loadslipsearch");

// Dynamic selection lists
ft_trip_loadslipsearch.lists["x_vehicle_type"] = <?php echo $t_trip_loadslip_search->vehicle_type->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_loadslip_search->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_loadslipsearch.lists["x_vehicle"] = <?php echo $t_trip_loadslip_search->vehicle->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_loadslip_search->vehicle->lookupOptions()) ?>;
ft_trip_loadslipsearch.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadslipsearch.lists["x__route"] = <?php echo $t_trip_loadslip_search->_route->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x__route"].options = <?php echo JsonEncode($t_trip_loadslip_search->_route->lookupOptions()) ?>;
ft_trip_loadslipsearch.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadslipsearch.lists["x_driver"] = <?php echo $t_trip_loadslip_search->driver->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_driver"].options = <?php echo JsonEncode($t_trip_loadslip_search->driver->lookupOptions()) ?>;
ft_trip_loadslipsearch.autoSuggests["x_driver"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadslipsearch.lists["x_reports_to"] = <?php echo $t_trip_loadslip_search->reports_to->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_loadslip_search->reports_to->lookupOptions()) ?>;
ft_trip_loadslipsearch.lists["x_buyer"] = <?php echo $t_trip_loadslip_search->buyer->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_loadslip_search->buyer->lookupOptions()) ?>;
ft_trip_loadslipsearch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_loadslipsearch.lists["x_b_consignor"] = <?php echo $t_trip_loadslip_search->b_consignor->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_b_consignor"].options = <?php echo JsonEncode($t_trip_loadslip_search->b_consignor->lookupOptions()) ?>;
ft_trip_loadslipsearch.lists["x_b_consignee"] = <?php echo $t_trip_loadslip_search->b_consignee->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_b_consignee"].options = <?php echo JsonEncode($t_trip_loadslip_search->b_consignee->lookupOptions()) ?>;
ft_trip_loadslipsearch.lists["x_agent"] = <?php echo $t_trip_loadslip_search->agent->Lookup->toClientList() ?>;
ft_trip_loadslipsearch.lists["x_agent"].options = <?php echo JsonEncode($t_trip_loadslip_search->agent->lookupOptions()) ?>;
ft_trip_loadslipsearch.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

ft_trip_loadslipsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->vehicle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__route");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->_route->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_driver_name");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->driver_name->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_loadslip->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_loadslip_search->showPageHeader(); ?>
<?php
$t_trip_loadslip_search->showMessage();
?>
<form name="ft_trip_loadslipsearch" id="ft_trip_loadslipsearch" class="<?php echo $t_trip_loadslip_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_loadslip_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_loadslip_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_loadslip">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_loadslip_search->IsModal ?>">
<?php if ($t_trip_loadslip_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($t_trip_loadslip->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_id"><?php echo $t_trip_loadslip->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->id->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_id">
<input type="text" data-table="t_trip_loadslip" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_trip_loadslip->id->getPlaceHolder()) ?>" value="<?php echo $t_trip_loadslip->id->EditValue ?>"<?php echo $t_trip_loadslip->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->vehicle_type->Visible) { // vehicle_type ?>
	<div id="r_vehicle_type" class="form-group row">
		<label for="x_vehicle_type" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_vehicle_type"><?php echo $t_trip_loadslip->vehicle_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->vehicle_type->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_vehicle_type">
<?php $t_trip_loadslip->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_loadslip->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_loadslip" data-field="x_vehicle_type" data-page="0" data-value-separator="<?php echo $t_trip_loadslip->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_loadslip->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_loadslip->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_vehicle"><?php echo $t_trip_loadslip->vehicle->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->vehicle->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_vehicle">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_loadslip->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->vehicle->ReadOnly || $t_trip_loadslip->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_vehicle" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_loadslip->vehicle->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadslipsearch.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_loadslip->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip__route"><?php echo $t_trip_loadslip->_route->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__route" id="z__route" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->_route->cellAttributes() ?>>
			<span id="el_t_trip_loadslip__route">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->_route->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->_route->EditAttrs["onchange"] = "";
?>
<span id="as_x__route" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__route" id="sv_x__route" value="<?php echo RemoveHtml($t_trip_loadslip->_route->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->_route->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->_route->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->_route->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->_route->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__route',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->_route->ReadOnly || $t_trip_loadslip->_route->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x__route" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->_route->displayValueSeparatorAttribute() ?>" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_loadslip->_route->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadslipsearch.createAutoSuggest({"id":"x__route","forceSelect":true});
</script>
<?php echo $t_trip_loadslip->_route->Lookup->getParamTag("p_x__route") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->route_name->Visible) { // route_name ?>
	<div id="r_route_name" class="form-group row">
		<label for="x_route_name" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_route_name"><?php echo $t_trip_loadslip->route_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_route_name" id="z_route_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->route_name->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_route_name">
<input type="text" data-table="t_trip_loadslip" data-field="x_route_name" data-page="0" name="x_route_name" id="x_route_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($t_trip_loadslip->route_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_loadslip->route_name->EditValue ?>"<?php echo $t_trip_loadslip->route_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_driver"><?php echo $t_trip_loadslip->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->driver->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_driver">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->driver->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->driver->EditAttrs["onchange"] = "";
?>
<span id="as_x_driver" class="text-nowrap" style="z-index: 8940">
	<input type="text" class="form-control" name="sv_x_driver" id="sv_x_driver" value="<?php echo RemoveHtml($t_trip_loadslip->driver->EditValue) ?>" size="50" placeholder="<?php echo HtmlEncode($t_trip_loadslip->driver->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->driver->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->driver->editAttributes() ?>>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_driver" data-page="0" data-value-separator="<?php echo $t_trip_loadslip->driver->displayValueSeparatorAttribute() ?>" name="x_driver" id="x_driver" value="<?php echo HtmlEncode($t_trip_loadslip->driver->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadslipsearch.createAutoSuggest({"id":"x_driver","forceSelect":false});
</script>
<?php echo $t_trip_loadslip->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->driver_name->Visible) { // driver_name ?>
	<div id="r_driver_name" class="form-group row">
		<label for="x_driver_name" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_driver_name"><?php echo $t_trip_loadslip->driver_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver_name" id="z_driver_name" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->driver_name->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_driver_name">
<input type="text" data-table="t_trip_loadslip" data-field="x_driver_name" data-page="0" name="x_driver_name" id="x_driver_name" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->driver_name->getPlaceHolder()) ?>" value="<?php echo $t_trip_loadslip->driver_name->EditValue ?>"<?php echo $t_trip_loadslip->driver_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="t_trip_loadslip_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $t_trip_loadslip_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_loadslip_search->MultiPages->isActive("1")) ?>" href="#tab_t_trip_loadslip1"><?php echo $t_trip_loadslip->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_loadslip_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_loadslip_search->MultiPages->Parent ?>" id="tab_t_trip_loadslip1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_loadslip->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_reports_to"><?php echo $t_trip_loadslip->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->reports_to->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_loadslip" data-field="x_reports_to" data-page="1" data-value-separator="<?php echo $t_trip_loadslip->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $t_trip_loadslip->reports_to->editAttributes() ?>>
		<?php echo $t_trip_loadslip->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $t_trip_loadslip->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_buyer"><?php echo $t_trip_loadslip->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->buyer->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_buyer">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8910">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_loadslip->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->buyer->ReadOnly || $t_trip_loadslip->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_buyer" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_loadslip->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadslipsearch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_loadslip->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->b_consignor->Visible) { // b_consignor ?>
	<div id="r_b_consignor" class="form-group row">
		<label for="x_b_consignor" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_b_consignor"><?php echo $t_trip_loadslip->b_consignor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_consignor" id="z_b_consignor" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->b_consignor->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_b_consignor">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_b_consignor"><?php echo strval($t_trip_loadslip->b_consignor->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($t_trip_loadslip->b_consignor->AdvancedSearch->ViewValue) : $t_trip_loadslip->b_consignor->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->b_consignor->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->b_consignor->ReadOnly || $t_trip_loadslip->b_consignor->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignor',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $t_trip_loadslip->b_consignor->Lookup->getParamTag("p_x_b_consignor") ?>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_b_consignor" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->b_consignor->displayValueSeparatorAttribute() ?>" name="x_b_consignor" id="x_b_consignor" value="<?php echo $t_trip_loadslip->b_consignor->AdvancedSearch->SearchValue ?>"<?php echo $t_trip_loadslip->b_consignor->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->b_consignee->Visible) { // b_consignee ?>
	<div id="r_b_consignee" class="form-group row">
		<label for="x_b_consignee" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_b_consignee"><?php echo $t_trip_loadslip->b_consignee->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_b_consignee" id="z_b_consignee" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->b_consignee->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_b_consignee">
<div class="input-group ew-lookup-list">
	<div class="form-control ew-lookup-text" tabindex="-1" id="lu_x_b_consignee"><?php echo strval($t_trip_loadslip->b_consignee->AdvancedSearch->ViewValue) == "" ? $Language->phrase("PleaseSelect") : (REMOVE_XSS ? HtmlDecode($t_trip_loadslip->b_consignee->AdvancedSearch->ViewValue) : $t_trip_loadslip->b_consignee->AdvancedSearch->ViewValue) ?></div>
	<div class="input-group-append">
		<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->b_consignee->caption()), $Language->phrase("LookupLink", TRUE))) ?>" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->b_consignee->ReadOnly || $t_trip_loadslip->b_consignee->Disabled) ? " disabled" : "")?> onclick="ew.modalLookupShow({lnk:this,el:'x_b_consignee',m:0,n:10});"><i class="fa fa-search ew-icon"></i></button>
	</div>
</div>
<?php echo $t_trip_loadslip->b_consignee->Lookup->getParamTag("p_x_b_consignee") ?>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_b_consignee" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->b_consignee->displayValueSeparatorAttribute() ?>" name="x_b_consignee" id="x_b_consignee" value="<?php echo $t_trip_loadslip->b_consignee->AdvancedSearch->SearchValue ?>"<?php echo $t_trip_loadslip->b_consignee->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_agent"><?php echo $t_trip_loadslip->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_agent" id="z_agent" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->agent->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_agent">
<?php
$wrkonchange = "" . trim(@$t_trip_loadslip->agent->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_loadslip->agent->EditAttrs["onchange"] = "";
?>
<span id="as_x_agent" class="text-nowrap" style="z-index: 8880">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_agent" id="sv_x_agent" value="<?php echo RemoveHtml($t_trip_loadslip->agent->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->agent->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_loadslip->agent->getPlaceHolder()) ?>"<?php echo $t_trip_loadslip->agent->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_loadslip->agent->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_agent',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_loadslip->agent->ReadOnly || $t_trip_loadslip->agent->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_loadslip" data-field="x_agent" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_loadslip->agent->displayValueSeparatorAttribute() ?>" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($t_trip_loadslip->agent->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_loadslipsearch.createAutoSuggest({"id":"x_agent","forceSelect":false});
</script>
<?php echo $t_trip_loadslip->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_operator"><?php echo $t_trip_loadslip->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->operator->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_operator">
<input type="text" data-table="t_trip_loadslip" data-field="x_operator" data-page="1" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($t_trip_loadslip->operator->getPlaceHolder()) ?>" value="<?php echo $t_trip_loadslip->operator->EditValue ?>"<?php echo $t_trip_loadslip->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_loadslip->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_trip_loadslip_search->LeftColumnClass ?>"><span id="elh_t_trip_loadslip_datetime"><?php echo $t_trip_loadslip->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_trip_loadslip_search->RightColumnClass ?>"><div<?php echo $t_trip_loadslip->datetime->cellAttributes() ?>>
			<span id="el_t_trip_loadslip_datetime">
<input type="text" data-table="t_trip_loadslip" data-field="x_datetime" data-page="1" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_trip_loadslip->datetime->getPlaceHolder()) ?>" value="<?php echo $t_trip_loadslip->datetime->EditValue ?>"<?php echo $t_trip_loadslip->datetime->editAttributes() ?>>
<?php if (!$t_trip_loadslip->datetime->ReadOnly && !$t_trip_loadslip->datetime->Disabled && !isset($t_trip_loadslip->datetime->EditAttrs["readonly"]) && !isset($t_trip_loadslip->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_loadslipsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$t_trip_loadslip_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_loadslip_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_loadslip_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_loadslip_search->terminate();
?>