<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_start_edit = new t_trip_start_edit();

// Run the page
$t_trip_start_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_start_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var ft_trip_startedit = currentForm = new ew.Form("ft_trip_startedit", "edit");

// Validate form
ft_trip_startedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($t_trip_start_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->id->caption(), $t_trip_start->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->vehicle_type->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->vehicle_type->caption(), $t_trip_start->vehicle_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->vehicle->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->vehicle->caption(), $t_trip_start->vehicle->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->_route->Required) { ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->_route->caption(), $t_trip_start->_route->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__route");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->_route->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->reports_to->Required) { ?>
			elm = this.getElements("x" + infix + "_reports_to");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->reports_to->caption(), $t_trip_start->reports_to->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->vehicle_freight_type->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->vehicle_freight_type->caption(), $t_trip_start->vehicle_freight_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->vehicle_freight_amount->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_amount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->vehicle_freight_amount->caption(), $t_trip_start->vehicle_freight_amount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_amount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->vehicle_freight_amount->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->material->Required) { ?>
			elm = this.getElements("x" + infix + "_material");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->material->caption(), $t_trip_start->material->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->_40->Required) { ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->_40->caption(), $t_trip_start->_40->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "__40");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->_40->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->buyer->caption(), $t_trip_start->buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->buyer->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->agent->Required) { ?>
			elm = this.getElements("x" + infix + "_agent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->agent->caption(), $t_trip_start->agent->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->comm->Required) { ?>
			elm = this.getElements("x" + infix + "_comm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->comm->caption(), $t_trip_start->comm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_comm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->comm->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->load_date->Required) { ?>
			elm = this.getElements("x" + infix + "_load_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->load_date->caption(), $t_trip_start->load_date->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_date");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_date->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->load_weight->Required) { ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->load_weight->caption(), $t_trip_start->load_weight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_weight");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_weight->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->load_km->Required) { ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->load_km->caption(), $t_trip_start->load_km->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_km");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_km->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->gst_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_gst_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->gst_percent->caption(), $t_trip_start->gst_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_gst_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->gst_percent->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->driver->caption(), $t_trip_start->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->remarks->caption(), $t_trip_start->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->vehicle_freight_comm->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_comm");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->vehicle_freight_comm->caption(), $t_trip_start->vehicle_freight_comm->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_vehicle_freight_comm");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->vehicle_freight_comm->errorMessage()) ?>");
		<?php if ($t_trip_start_edit->freight_type->Required) { ?>
			elm = this.getElements("x" + infix + "_freight_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->freight_type->caption(), $t_trip_start->freight_type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($t_trip_start_edit->freight->Required) { ?>
			elm = this.getElements("x" + infix + "_freight");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $t_trip_start->freight->caption(), $t_trip_start->freight->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_freight");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($t_trip_start->freight->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ft_trip_startedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_startedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_startedit.multiPage = new ew.MultiPage("ft_trip_startedit");

// Dynamic selection lists
ft_trip_startedit.lists["x_vehicle_type"] = <?php echo $t_trip_start_edit->vehicle_type->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_start_edit->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_startedit.lists["x_vehicle"] = <?php echo $t_trip_start_edit->vehicle->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_start_edit->vehicle->lookupOptions()) ?>;
ft_trip_startedit.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startedit.lists["x__route"] = <?php echo $t_trip_start_edit->_route->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x__route"].options = <?php echo JsonEncode($t_trip_start_edit->_route->lookupOptions()) ?>;
ft_trip_startedit.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startedit.lists["x_reports_to"] = <?php echo $t_trip_start_edit->reports_to->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_start_edit->reports_to->lookupOptions()) ?>;
ft_trip_startedit.lists["x_vehicle_freight_type"] = <?php echo $t_trip_start_edit->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_start_edit->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_startedit.lists["x_buyer"] = <?php echo $t_trip_start_edit->buyer->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_start_edit->buyer->lookupOptions()) ?>;
ft_trip_startedit.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startedit.lists["x_agent"] = <?php echo $t_trip_start_edit->agent->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_agent"].options = <?php echo JsonEncode($t_trip_start_edit->agent->lookupOptions()) ?>;
ft_trip_startedit.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startedit.lists["x_freight_type"] = <?php echo $t_trip_start_edit->freight_type->Lookup->toClientList() ?>;
ft_trip_startedit.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_start_edit->freight_type->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_start_edit->showPageHeader(); ?>
<?php
$t_trip_start_edit->showMessage();
?>
<form name="ft_trip_startedit" id="ft_trip_startedit" class="<?php echo $t_trip_start_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_start_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_start_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_start">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_start_edit->IsModal ?>">
<?php if ($t_trip_start_edit->MultiPages->Items[0]->Visible) { ?>
<div class="ew-edit-div"><!-- page0 -->
<?php if ($t_trip_start->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_t_trip_start_id" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->id->caption() ?><?php echo ($t_trip_start->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->id->cellAttributes() ?>>
<span id="el_t_trip_start_id">
<span<?php echo $t_trip_start->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_start->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_id" data-page="0" name="x_id" id="x_id" value="<?php echo HtmlEncode($t_trip_start->id->CurrentValue) ?>">
<?php echo $t_trip_start->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_type->Visible) { // vehicle_type ?>
	<div id="r_vehicle_type" class="form-group row">
		<label id="elh_t_trip_start_vehicle_type" for="x_vehicle_type" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->vehicle_type->caption() ?><?php echo ($t_trip_start->vehicle_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_type->cellAttributes() ?>>
<span id="el_t_trip_start_vehicle_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_vehicle_type" data-page="0" data-value-separator="<?php echo $t_trip_start->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_start->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_start->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_start->vehicle_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label id="elh_t_trip_start_vehicle" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->vehicle->caption() ?><?php echo ($t_trip_start->vehicle->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle->cellAttributes() ?>>
<span id="el_t_trip_start_vehicle">
<span<?php echo $t_trip_start->vehicle->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($t_trip_start->vehicle->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_vehicle" data-page="0" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_start->vehicle->CurrentValue) ?>">
<?php echo $t_trip_start->vehicle->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label id="elh_t_trip_start__route" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->_route->caption() ?><?php echo ($t_trip_start->_route->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->_route->cellAttributes() ?>>
<span id="el_t_trip_start__route">
<?php
$wrkonchange = "" . trim(@$t_trip_start->_route->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->_route->EditAttrs["onchange"] = "";
?>
<span id="as_x__route" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__route" id="sv_x__route" value="<?php echo RemoveHtml($t_trip_start->_route->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->_route->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->_route->getPlaceHolder()) ?>"<?php echo $t_trip_start->_route->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->_route->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__route',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->_route->ReadOnly || $t_trip_start->_route->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "t_route_info") && !$t_trip_start->_route->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x__route" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_start->_route->caption() ?>" data-title="<?php echo $t_trip_start->_route->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x__route',url:'t_route_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x__route" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->_route->displayValueSeparatorAttribute() ?>" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_start->_route->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startedit.createAutoSuggest({"id":"x__route","forceSelect":true});
</script>
<?php echo $t_trip_start->_route->Lookup->getParamTag("p_x__route") ?>
</span>
<?php echo $t_trip_start->_route->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<div id="r_vehicle_freight_type" class="form-group row">
		<label id="elh_t_trip_start_vehicle_freight_type" for="x_vehicle_freight_type" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->vehicle_freight_type->caption() ?><?php echo ($t_trip_start->vehicle_freight_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_freight_type->cellAttributes() ?>>
<span id="el_t_trip_start_vehicle_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_vehicle_freight_type" data-page="0" data-value-separator="<?php echo $t_trip_start->vehicle_freight_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_freight_type" name="x_vehicle_freight_type"<?php echo $t_trip_start->vehicle_freight_type->editAttributes() ?>>
		<?php echo $t_trip_start->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_start->vehicle_freight_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<div id="r_vehicle_freight_amount" class="form-group row">
		<label id="elh_t_trip_start_vehicle_freight_amount" for="x_vehicle_freight_amount" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->vehicle_freight_amount->caption() ?><?php echo ($t_trip_start->vehicle_freight_amount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_freight_amount->cellAttributes() ?>>
<span id="el_t_trip_start_vehicle_freight_amount">
<input type="text" data-table="t_trip_start" data-field="x_vehicle_freight_amount" data-page="0" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->vehicle_freight_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->vehicle_freight_amount->EditValue ?>"<?php echo $t_trip_start->vehicle_freight_amount->editAttributes() ?>>
</span>
<?php echo $t_trip_start->vehicle_freight_amount->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label id="elh_t_trip_start_driver" for="x_driver" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->driver->caption() ?><?php echo ($t_trip_start->driver->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->driver->cellAttributes() ?>>
<span id="el_t_trip_start_driver">
<input type="text" data-table="t_trip_start" data-field="x_driver" data-page="0" name="x_driver" id="x_driver" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->driver->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->driver->EditValue ?>"<?php echo $t_trip_start->driver->editAttributes() ?>>
</span>
<?php echo $t_trip_start->driver->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<div id="r_vehicle_freight_comm" class="form-group row">
		<label id="elh_t_trip_start_vehicle_freight_comm" for="x_vehicle_freight_comm" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->vehicle_freight_comm->caption() ?><?php echo ($t_trip_start->vehicle_freight_comm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_freight_comm->cellAttributes() ?>>
<span id="el_t_trip_start_vehicle_freight_comm">
<input type="text" data-table="t_trip_start" data-field="x_vehicle_freight_comm" data-page="0" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->vehicle_freight_comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->vehicle_freight_comm->EditValue ?>"<?php echo $t_trip_start->vehicle_freight_comm->editAttributes() ?>>
</span>
<?php echo $t_trip_start->vehicle_freight_comm->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="t_trip_start_edit"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $t_trip_start_edit->MultiPages->pageStyle("1") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_start_edit->MultiPages->isActive("1")) ?>" href="#tab_t_trip_start1"><?php echo $t_trip_start->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_start_edit->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_start_edit->MultiPages->Parent ?>" id="tab_t_trip_start1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_start->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label id="elh_t_trip_start_reports_to" for="x_reports_to" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->reports_to->caption() ?><?php echo ($t_trip_start->reports_to->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->reports_to->cellAttributes() ?>>
<span id="el_t_trip_start_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_reports_to" data-page="1" data-value-separator="<?php echo $t_trip_start->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $t_trip_start->reports_to->editAttributes() ?>>
		<?php echo $t_trip_start->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $t_trip_start->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
<?php echo $t_trip_start->reports_to->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label id="elh_t_trip_start_material" for="x_material" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->material->caption() ?><?php echo ($t_trip_start->material->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->material->cellAttributes() ?>>
<span id="el_t_trip_start_material">
<input type="text" data-table="t_trip_start" data-field="x_material" data-page="1" name="x_material" id="x_material" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->material->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->material->EditValue ?>"<?php echo $t_trip_start->material->editAttributes() ?>>
</span>
<?php echo $t_trip_start->material->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label id="elh_t_trip_start__40" for="x__40" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->_40->caption() ?><?php echo ($t_trip_start->_40->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->_40->cellAttributes() ?>>
<span id="el_t_trip_start__40">
<input type="text" data-table="t_trip_start" data-field="x__40" data-page="1" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->_40->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->_40->EditValue ?>"<?php echo $t_trip_start->_40->editAttributes() ?>>
</span>
<?php echo $t_trip_start->_40->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label id="elh_t_trip_start_buyer" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->buyer->caption() ?><?php echo ($t_trip_start->buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->buyer->cellAttributes() ?>>
<span id="el_t_trip_start_buyer">
<?php
$wrkonchange = "" . trim(@$t_trip_start->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_start->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_start->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->buyer->ReadOnly || $t_trip_start->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
<?php if (AllowAdd(CurrentProjectID() . "buyer") && !$t_trip_start->buyer->ReadOnly) { ?>
<button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_buyer" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $t_trip_start->buyer->caption() ?>" data-title="<?php echo $t_trip_start->buyer->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_buyer',url:'buyeraddopt.php'});"><i class="fa fa-plus ew-icon"></i></button>
<?php } ?>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_buyer" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_start->buyer->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startedit.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_start->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
<?php echo $t_trip_start->buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label id="elh_t_trip_start_agent" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->agent->caption() ?><?php echo ($t_trip_start->agent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->agent->cellAttributes() ?>>
<span id="el_t_trip_start_agent">
<?php
$wrkonchange = "" . trim(@$t_trip_start->agent->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->agent->EditAttrs["onchange"] = "";
?>
<span id="as_x_agent" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_agent" id="sv_x_agent" value="<?php echo RemoveHtml($t_trip_start->agent->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->agent->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->agent->getPlaceHolder()) ?>"<?php echo $t_trip_start->agent->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->agent->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_agent',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->agent->ReadOnly || $t_trip_start->agent->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_agent" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->agent->displayValueSeparatorAttribute() ?>" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($t_trip_start->agent->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startedit.createAutoSuggest({"id":"x_agent","forceSelect":true});
</script>
<?php echo $t_trip_start->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
<?php echo $t_trip_start->agent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->comm->Visible) { // comm ?>
	<div id="r_comm" class="form-group row">
		<label id="elh_t_trip_start_comm" for="x_comm" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->comm->caption() ?><?php echo ($t_trip_start->comm->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->comm->cellAttributes() ?>>
<span id="el_t_trip_start_comm">
<input type="text" data-table="t_trip_start" data-field="x_comm" data-page="1" name="x_comm" id="x_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->comm->EditValue ?>"<?php echo $t_trip_start->comm->editAttributes() ?>>
</span>
<?php echo $t_trip_start->comm->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_t_trip_start_remarks" for="x_remarks" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->remarks->caption() ?><?php echo ($t_trip_start->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->remarks->cellAttributes() ?>>
<span id="el_t_trip_start_remarks">
<textarea data-table="t_trip_start" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($t_trip_start->remarks->getPlaceHolder()) ?>"<?php echo $t_trip_start->remarks->editAttributes() ?>><?php echo $t_trip_start->remarks->EditValue ?></textarea>
</span>
<?php echo $t_trip_start->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_start_edit->MultiPages->pageStyle("2") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_start_edit->MultiPages->isActive("2")) ?>" href="#tab_t_trip_start2"><?php echo $t_trip_start->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_start_edit->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $t_trip_start_edit->MultiPages->Parent ?>" id="tab_t_trip_start2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_start->gst_percent->Visible) { // gst_percent ?>
	<div id="r_gst_percent" class="form-group row">
		<label id="elh_t_trip_start_gst_percent" for="x_gst_percent" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->gst_percent->caption() ?><?php echo ($t_trip_start->gst_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->gst_percent->cellAttributes() ?>>
<span id="el_t_trip_start_gst_percent">
<input type="text" data-table="t_trip_start" data-field="x_gst_percent" data-page="2" name="x_gst_percent" id="x_gst_percent" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->gst_percent->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->gst_percent->EditValue ?>"<?php echo $t_trip_start->gst_percent->editAttributes() ?>>
</span>
<?php echo $t_trip_start->gst_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->freight_type->Visible) { // freight_type ?>
	<div id="r_freight_type" class="form-group row">
		<label id="elh_t_trip_start_freight_type" for="x_freight_type" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->freight_type->caption() ?><?php echo ($t_trip_start->freight_type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->freight_type->cellAttributes() ?>>
<span id="el_t_trip_start_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_freight_type" data-page="2" data-value-separator="<?php echo $t_trip_start->freight_type->displayValueSeparatorAttribute() ?>" id="x_freight_type" name="x_freight_type"<?php echo $t_trip_start->freight_type->editAttributes() ?>>
		<?php echo $t_trip_start->freight_type->selectOptionListHtml("x_freight_type") ?>
	</select>
</div>
</span>
<?php echo $t_trip_start->freight_type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->freight->Visible) { // freight ?>
	<div id="r_freight" class="form-group row">
		<label id="elh_t_trip_start_freight" for="x_freight" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->freight->caption() ?><?php echo ($t_trip_start->freight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->freight->cellAttributes() ?>>
<span id="el_t_trip_start_freight">
<input type="text" data-table="t_trip_start" data-field="x_freight" data-page="2" name="x_freight" id="x_freight" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->freight->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->freight->EditValue ?>"<?php echo $t_trip_start->freight->editAttributes() ?>>
</span>
<?php echo $t_trip_start->freight->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
	<div class="card ew-accordion-card<?php echo $t_trip_start_edit->MultiPages->pageStyle("3") ?>"><!-- multi-page accordion .card -->
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_start_edit->MultiPages->isActive("3")) ?>" href="#tab_t_trip_start3"><?php echo $t_trip_start->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_start_edit->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $t_trip_start_edit->MultiPages->Parent ?>" id="tab_t_trip_start3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-edit-div"><!-- page* -->
<?php if ($t_trip_start->load_date->Visible) { // load_date ?>
	<div id="r_load_date" class="form-group row">
		<label id="elh_t_trip_start_load_date" for="x_load_date" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->load_date->caption() ?><?php echo ($t_trip_start->load_date->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->load_date->cellAttributes() ?>>
<span id="el_t_trip_start_load_date">
<input type="text" data-table="t_trip_start" data-field="x_load_date" data-page="3" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_start->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_date->EditValue ?>"<?php echo $t_trip_start->load_date->editAttributes() ?>>
<?php if (!$t_trip_start->load_date->ReadOnly && !$t_trip_start->load_date->Disabled && !isset($t_trip_start->load_date->EditAttrs["readonly"]) && !isset($t_trip_start->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_startedit", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
<?php echo $t_trip_start->load_date->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label id="elh_t_trip_start_load_weight" for="x_load_weight" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->load_weight->caption() ?><?php echo ($t_trip_start->load_weight->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->load_weight->cellAttributes() ?>>
<span id="el_t_trip_start_load_weight">
<input type="text" data-table="t_trip_start" data-field="x_load_weight" data-page="3" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_weight->EditValue ?>"<?php echo $t_trip_start->load_weight->editAttributes() ?>>
</span>
<?php echo $t_trip_start->load_weight->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label id="elh_t_trip_start_load_km" for="x_load_km" class="<?php echo $t_trip_start_edit->LeftColumnClass ?>"><?php echo $t_trip_start->load_km->caption() ?><?php echo ($t_trip_start->load_km->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $t_trip_start_edit->RightColumnClass ?>"><div<?php echo $t_trip_start->load_km->cellAttributes() ?>>
<span id="el_t_trip_start_load_km">
<input type="text" data-table="t_trip_start" data-field="x_load_km" data-page="3" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_km->EditValue ?>"<?php echo $t_trip_start->load_km->editAttributes() ?>>
</span>
<?php echo $t_trip_start->load_km->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div><!-- /multi-page accordion .card -->
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$t_trip_start_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_start_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $t_trip_start_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_start_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var type = $("#x_vehicle_type").val();
		if (type == 1)
		{
		$("#r_consignor").hide();
		$("#r_vehicle_freight").hide();
		$("#r_vehicle_freight_type").hide();
		$("#r_vehicle_freight_amount").hide();
		$("#r_vehicle_freight_comm").hide();
		$("#r_vehicle_freight_final").hide();
		$("#r_driver").show();
		} else {
		$("#r_consignor").show();
		$("#r_vehicle_freight").show();
		$("#r_vehicle_freight_type").show();
		$("#r_vehicle_freight_amount").show();
		$("#r_vehicle_freight_comm").show();
		$("#r_vehicle_freight_final").show();
		$("#r_driver").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_start_edit->terminate();
?>