<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_start_list = new t_trip_start_list();

// Run the page
$t_trip_start_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_start_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_trip_start->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_trip_startlist = currentForm = new ew.Form("ft_trip_startlist", "list");
ft_trip_startlist.formKeyCountName = '<?php echo $t_trip_start_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_trip_startlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_startlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_startlist.lists["x_vehicle_type"] = <?php echo $t_trip_start_list->vehicle_type->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_start_list->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_startlist.lists["x_vehicle"] = <?php echo $t_trip_start_list->vehicle->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_start_list->vehicle->lookupOptions()) ?>;
ft_trip_startlist.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startlist.lists["x_reports_to"] = <?php echo $t_trip_start_list->reports_to->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_start_list->reports_to->lookupOptions()) ?>;
ft_trip_startlist.lists["x_vehicle_freight_type"] = <?php echo $t_trip_start_list->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_start_list->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_startlist.lists["x_buyer"] = <?php echo $t_trip_start_list->buyer->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_start_list->buyer->lookupOptions()) ?>;
ft_trip_startlist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startlist.lists["x_agent"] = <?php echo $t_trip_start_list->agent->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_agent"].options = <?php echo JsonEncode($t_trip_start_list->agent->lookupOptions()) ?>;
ft_trip_startlist.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startlist.lists["x_freight_type"] = <?php echo $t_trip_start_list->freight_type->Lookup->toClientList() ?>;
ft_trip_startlist.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_start_list->freight_type->options(FALSE, TRUE)) ?>;

// Form object for search
var ft_trip_startlistsrch = currentSearchForm = new ew.Form("ft_trip_startlistsrch");

// Validate function for search
ft_trip_startlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_vehicle");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->vehicle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_date->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ft_trip_startlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_startlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_trip_startlistsrch.lists["x_vehicle_type"] = <?php echo $t_trip_start_list->vehicle_type->Lookup->toClientList() ?>;
ft_trip_startlistsrch.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_start_list->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_startlistsrch.lists["x_vehicle"] = <?php echo $t_trip_start_list->vehicle->Lookup->toClientList() ?>;
ft_trip_startlistsrch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_start_list->vehicle->lookupOptions()) ?>;
ft_trip_startlistsrch.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startlistsrch.lists["x_buyer"] = <?php echo $t_trip_start_list->buyer->Lookup->toClientList() ?>;
ft_trip_startlistsrch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_start_list->buyer->lookupOptions()) ?>;
ft_trip_startlistsrch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Filters
ft_trip_startlistsrch.filterList = <?php echo $t_trip_start_list->getFilterList() ?>;

// Init search panel as collapsed
ft_trip_startlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_trip_start->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_trip_start_list->TotalRecs > 0 && $t_trip_start_list->ExportOptions->visible()) { ?>
<?php $t_trip_start_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_start_list->ImportOptions->visible()) { ?>
<?php $t_trip_start_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_start_list->SearchOptions->visible()) { ?>
<?php $t_trip_start_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_trip_start_list->FilterOptions->visible()) { ?>
<?php $t_trip_start_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_trip_start_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_trip_start->isExport() && !$t_trip_start->CurrentAction) { ?>
<form name="ft_trip_startlistsrch" id="ft_trip_startlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_trip_start_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_trip_startlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_trip_start">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$t_trip_start_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$t_trip_start->RowType = ROWTYPE_SEARCH;

// Render row
$t_trip_start->resetAttributes();
$t_trip_start_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($t_trip_start->vehicle_type->Visible) { // vehicle_type ?>
	<div id="xsc_vehicle_type" class="ew-cell form-group">
		<label for="x_vehicle_type" class="ew-search-caption ew-label"><?php echo $t_trip_start->vehicle_type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="="></span>
		<span class="ew-search-field">
<?php $t_trip_start->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_start->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_vehicle_type" data-value-separator="<?php echo $t_trip_start->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_start->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_start->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle->Visible) { // vehicle ?>
	<div id="xsc_vehicle" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_start->vehicle->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_start->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_start->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_start->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->vehicle->ReadOnly || $t_trip_start->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_vehicle" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_start->vehicle->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startlistsrch.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_start->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
	</div>
<?php } ?>
<?php if ($t_trip_start->buyer->Visible) { // buyer ?>
	<div id="xsc_buyer" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $t_trip_start->buyer->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		<span class="ew-search-field">
<?php
$wrkonchange = "" . trim(@$t_trip_start->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_start->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_start->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->buyer->ReadOnly || $t_trip_start->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_start->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startlistsrch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_start->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($t_trip_start->load_date->Visible) { // load_date ?>
	<div id="xsc_load_date" class="ew-cell form-group">
		<label for="x_load_date" class="ew-search-caption ew-label"><?php echo $t_trip_start->load_date->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_date" id="z_load_date" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="t_trip_start" data-field="x_load_date" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_start->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_date->EditValue ?>"<?php echo $t_trip_start->load_date->editAttributes() ?>>
<?php if (!$t_trip_start->load_date->ReadOnly && !$t_trip_start->load_date->Disabled && !isset($t_trip_start->load_date->EditAttrs["readonly"]) && !isset($t_trip_start->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_startlistsrch", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_trip_start_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_trip_start_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_trip_start_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_trip_start_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_trip_start_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_trip_start_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_trip_start_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_trip_start_list->showPageHeader(); ?>
<?php
$t_trip_start_list->showMessage();
?>
<?php if ($t_trip_start_list->TotalRecs > 0 || $t_trip_start->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_trip_start_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_trip_start">
<?php if (!$t_trip_start->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_trip_start->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_start_list->Pager)) $t_trip_start_list->Pager = new PrevNextPager($t_trip_start_list->StartRec, $t_trip_start_list->DisplayRecs, $t_trip_start_list->TotalRecs, $t_trip_start_list->AutoHidePager) ?>
<?php if ($t_trip_start_list->Pager->RecordCount > 0 && $t_trip_start_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_start_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_start_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_start_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_start_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_start_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_start_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_start_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_start_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_start_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_start_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_start_list->TotalRecs > 0 && (!$t_trip_start_list->AutoHidePageSizeSelector || $t_trip_start_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_start">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_start_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_start_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_start_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_start_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_start_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_start->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_start_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_trip_startlist" id="ft_trip_startlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_start_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_start_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_start">
<div id="gmp_t_trip_start" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_trip_start_list->TotalRecs > 0 || $t_trip_start->isGridEdit()) { ?>
<table id="tbl_t_trip_startlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_trip_start_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_trip_start_list->renderListOptions();

// Render list options (header, left)
$t_trip_start_list->ListOptions->render("header", "left");
?>
<?php if ($t_trip_start->id->Visible) { // id ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_trip_start->id->headerCellClass() ?>"><div id="elh_t_trip_start_id" class="t_trip_start_id"><div class="ew-table-header-caption"><?php echo $t_trip_start->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_trip_start->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->id) ?>',2);"><div id="elh_t_trip_start_id" class="t_trip_start_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->vehicle_type->Visible) { // vehicle_type ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->vehicle_type) == "") { ?>
		<th data-name="vehicle_type" class="<?php echo $t_trip_start->vehicle_type->headerCellClass() ?>"><div id="elh_t_trip_start_vehicle_type" class="t_trip_start_vehicle_type"><div class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_type" class="<?php echo $t_trip_start->vehicle_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->vehicle_type) ?>',2);"><div id="elh_t_trip_start_vehicle_type" class="t_trip_start_vehicle_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->vehicle_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->vehicle_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->vehicle->Visible) { // vehicle ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->vehicle) == "") { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_start->vehicle->headerCellClass() ?>"><div id="elh_t_trip_start_vehicle" class="t_trip_start_vehicle"><div class="ew-table-header-caption"><?php echo $t_trip_start->vehicle->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle" class="<?php echo $t_trip_start->vehicle->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->vehicle) ?>',2);"><div id="elh_t_trip_start_vehicle" class="t_trip_start_vehicle">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->vehicle->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->vehicle->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->vehicle->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->reports_to->Visible) { // reports_to ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->reports_to) == "") { ?>
		<th data-name="reports_to" class="<?php echo $t_trip_start->reports_to->headerCellClass() ?>"><div id="elh_t_trip_start_reports_to" class="t_trip_start_reports_to"><div class="ew-table-header-caption"><?php echo $t_trip_start->reports_to->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="reports_to" class="<?php echo $t_trip_start->reports_to->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->reports_to) ?>',2);"><div id="elh_t_trip_start_reports_to" class="t_trip_start_reports_to">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->reports_to->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->reports_to->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->reports_to->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->vehicle_freight_type) == "") { ?>
		<th data-name="vehicle_freight_type" class="<?php echo $t_trip_start->vehicle_freight_type->headerCellClass() ?>"><div id="elh_t_trip_start_vehicle_freight_type" class="t_trip_start_vehicle_freight_type"><div class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_freight_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_type" class="<?php echo $t_trip_start->vehicle_freight_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->vehicle_freight_type) ?>',2);"><div id="elh_t_trip_start_vehicle_freight_type" class="t_trip_start_vehicle_freight_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_freight_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->vehicle_freight_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->vehicle_freight_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->vehicle_freight_amount) == "") { ?>
		<th data-name="vehicle_freight_amount" class="<?php echo $t_trip_start->vehicle_freight_amount->headerCellClass() ?>"><div id="elh_t_trip_start_vehicle_freight_amount" class="t_trip_start_vehicle_freight_amount"><div class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_freight_amount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_amount" class="<?php echo $t_trip_start->vehicle_freight_amount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->vehicle_freight_amount) ?>',2);"><div id="elh_t_trip_start_vehicle_freight_amount" class="t_trip_start_vehicle_freight_amount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_freight_amount->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->vehicle_freight_amount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->vehicle_freight_amount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->material->Visible) { // material ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->material) == "") { ?>
		<th data-name="material" class="<?php echo $t_trip_start->material->headerCellClass() ?>"><div id="elh_t_trip_start_material" class="t_trip_start_material"><div class="ew-table-header-caption"><?php echo $t_trip_start->material->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="material" class="<?php echo $t_trip_start->material->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->material) ?>',2);"><div id="elh_t_trip_start_material" class="t_trip_start_material">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->material->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->material->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->material->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->_40->Visible) { // @ ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->_40) == "") { ?>
		<th data-name="_40" class="<?php echo $t_trip_start->_40->headerCellClass() ?>"><div id="elh_t_trip_start__40" class="t_trip_start__40"><div class="ew-table-header-caption"><?php echo $t_trip_start->_40->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_40" class="<?php echo $t_trip_start->_40->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->_40) ?>',2);"><div id="elh_t_trip_start__40" class="t_trip_start__40">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->_40->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->_40->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->_40->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->buyer->Visible) { // buyer ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $t_trip_start->buyer->headerCellClass() ?>"><div id="elh_t_trip_start_buyer" class="t_trip_start_buyer"><div class="ew-table-header-caption"><?php echo $t_trip_start->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $t_trip_start->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->buyer) ?>',2);"><div id="elh_t_trip_start_buyer" class="t_trip_start_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->buyer->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->agent->Visible) { // agent ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->agent) == "") { ?>
		<th data-name="agent" class="<?php echo $t_trip_start->agent->headerCellClass() ?>"><div id="elh_t_trip_start_agent" class="t_trip_start_agent"><div class="ew-table-header-caption"><?php echo $t_trip_start->agent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="agent" class="<?php echo $t_trip_start->agent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->agent) ?>',2);"><div id="elh_t_trip_start_agent" class="t_trip_start_agent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->agent->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->agent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->agent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->comm->Visible) { // comm ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->comm) == "") { ?>
		<th data-name="comm" class="<?php echo $t_trip_start->comm->headerCellClass() ?>"><div id="elh_t_trip_start_comm" class="t_trip_start_comm"><div class="ew-table-header-caption"><?php echo $t_trip_start->comm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="comm" class="<?php echo $t_trip_start->comm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->comm) ?>',2);"><div id="elh_t_trip_start_comm" class="t_trip_start_comm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->comm->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->comm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->comm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->load_date->Visible) { // load_date ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->load_date) == "") { ?>
		<th data-name="load_date" class="<?php echo $t_trip_start->load_date->headerCellClass() ?>"><div id="elh_t_trip_start_load_date" class="t_trip_start_load_date"><div class="ew-table-header-caption"><?php echo $t_trip_start->load_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_date" class="<?php echo $t_trip_start->load_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->load_date) ?>',2);"><div id="elh_t_trip_start_load_date" class="t_trip_start_load_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->load_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->load_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->load_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->load_weight->Visible) { // load_weight ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->load_weight) == "") { ?>
		<th data-name="load_weight" class="<?php echo $t_trip_start->load_weight->headerCellClass() ?>"><div id="elh_t_trip_start_load_weight" class="t_trip_start_load_weight"><div class="ew-table-header-caption"><?php echo $t_trip_start->load_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_weight" class="<?php echo $t_trip_start->load_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->load_weight) ?>',2);"><div id="elh_t_trip_start_load_weight" class="t_trip_start_load_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->load_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->load_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->load_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->load_km->Visible) { // load_km ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->load_km) == "") { ?>
		<th data-name="load_km" class="<?php echo $t_trip_start->load_km->headerCellClass() ?>"><div id="elh_t_trip_start_load_km" class="t_trip_start_load_km"><div class="ew-table-header-caption"><?php echo $t_trip_start->load_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_km" class="<?php echo $t_trip_start->load_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->load_km) ?>',2);"><div id="elh_t_trip_start_load_km" class="t_trip_start_load_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->load_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->load_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->load_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->gst_percent->Visible) { // gst_percent ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->gst_percent) == "") { ?>
		<th data-name="gst_percent" class="<?php echo $t_trip_start->gst_percent->headerCellClass() ?>"><div id="elh_t_trip_start_gst_percent" class="t_trip_start_gst_percent"><div class="ew-table-header-caption"><?php echo $t_trip_start->gst_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="gst_percent" class="<?php echo $t_trip_start->gst_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->gst_percent) ?>',2);"><div id="elh_t_trip_start_gst_percent" class="t_trip_start_gst_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->gst_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->gst_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->gst_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->driver->Visible) { // driver ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_trip_start->driver->headerCellClass() ?>"><div id="elh_t_trip_start_driver" class="t_trip_start_driver"><div class="ew-table-header-caption"><?php echo $t_trip_start->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_trip_start->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->driver) ?>',2);"><div id="elh_t_trip_start_driver" class="t_trip_start_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->driver->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->vehicle_freight_comm) == "") { ?>
		<th data-name="vehicle_freight_comm" class="<?php echo $t_trip_start->vehicle_freight_comm->headerCellClass() ?>"><div id="elh_t_trip_start_vehicle_freight_comm" class="t_trip_start_vehicle_freight_comm"><div class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_freight_comm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_freight_comm" class="<?php echo $t_trip_start->vehicle_freight_comm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->vehicle_freight_comm) ?>',2);"><div id="elh_t_trip_start_vehicle_freight_comm" class="t_trip_start_vehicle_freight_comm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->vehicle_freight_comm->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->vehicle_freight_comm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->vehicle_freight_comm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->freight_type->Visible) { // freight_type ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->freight_type) == "") { ?>
		<th data-name="freight_type" class="<?php echo $t_trip_start->freight_type->headerCellClass() ?>"><div id="elh_t_trip_start_freight_type" class="t_trip_start_freight_type"><div class="ew-table-header-caption"><?php echo $t_trip_start->freight_type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="freight_type" class="<?php echo $t_trip_start->freight_type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->freight_type) ?>',2);"><div id="elh_t_trip_start_freight_type" class="t_trip_start_freight_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->freight_type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->freight_type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->freight_type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_trip_start->freight->Visible) { // freight ?>
	<?php if ($t_trip_start->sortUrl($t_trip_start->freight) == "") { ?>
		<th data-name="freight" class="<?php echo $t_trip_start->freight->headerCellClass() ?>"><div id="elh_t_trip_start_freight" class="t_trip_start_freight"><div class="ew-table-header-caption"><?php echo $t_trip_start->freight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="freight" class="<?php echo $t_trip_start->freight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_trip_start->SortUrl($t_trip_start->freight) ?>',2);"><div id="elh_t_trip_start_freight" class="t_trip_start_freight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_trip_start->freight->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_trip_start->freight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_trip_start->freight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_trip_start_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_trip_start->ExportAll && $t_trip_start->isExport()) {
	$t_trip_start_list->StopRec = $t_trip_start_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_trip_start_list->TotalRecs > $t_trip_start_list->StartRec + $t_trip_start_list->DisplayRecs - 1)
		$t_trip_start_list->StopRec = $t_trip_start_list->StartRec + $t_trip_start_list->DisplayRecs - 1;
	else
		$t_trip_start_list->StopRec = $t_trip_start_list->TotalRecs;
}
$t_trip_start_list->RecCnt = $t_trip_start_list->StartRec - 1;
if ($t_trip_start_list->Recordset && !$t_trip_start_list->Recordset->EOF) {
	$t_trip_start_list->Recordset->moveFirst();
	$selectLimit = $t_trip_start_list->UseSelectLimit;
	if (!$selectLimit && $t_trip_start_list->StartRec > 1)
		$t_trip_start_list->Recordset->move($t_trip_start_list->StartRec - 1);
} elseif (!$t_trip_start->AllowAddDeleteRow && $t_trip_start_list->StopRec == 0) {
	$t_trip_start_list->StopRec = $t_trip_start->GridAddRowCount;
}

// Initialize aggregate
$t_trip_start->RowType = ROWTYPE_AGGREGATEINIT;
$t_trip_start->resetAttributes();
$t_trip_start_list->renderRow();
while ($t_trip_start_list->RecCnt < $t_trip_start_list->StopRec) {
	$t_trip_start_list->RecCnt++;
	if ($t_trip_start_list->RecCnt >= $t_trip_start_list->StartRec) {
		$t_trip_start_list->RowCnt++;

		// Set up key count
		$t_trip_start_list->KeyCount = $t_trip_start_list->RowIndex;

		// Init row class and style
		$t_trip_start->resetAttributes();
		$t_trip_start->CssClass = "";
		if ($t_trip_start->isGridAdd()) {
		} else {
			$t_trip_start_list->loadRowValues($t_trip_start_list->Recordset); // Load row values
		}
		$t_trip_start->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_trip_start->RowAttrs = array_merge($t_trip_start->RowAttrs, array('data-rowindex'=>$t_trip_start_list->RowCnt, 'id'=>'r' . $t_trip_start_list->RowCnt . '_t_trip_start', 'data-rowtype'=>$t_trip_start->RowType));

		// Render row
		$t_trip_start_list->renderRow();

		// Render list options
		$t_trip_start_list->renderListOptions();
?>
	<tr<?php echo $t_trip_start->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_trip_start_list->ListOptions->render("body", "left", $t_trip_start_list->RowCnt);
?>
	<?php if ($t_trip_start->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_trip_start->id->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_id" class="t_trip_start_id">
<span<?php echo $t_trip_start->id->viewAttributes() ?>>
<?php echo $t_trip_start->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->vehicle_type->Visible) { // vehicle_type ?>
		<td data-name="vehicle_type"<?php echo $t_trip_start->vehicle_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_vehicle_type" class="t_trip_start_vehicle_type">
<span<?php echo $t_trip_start->vehicle_type->viewAttributes() ?>>
<?php echo $t_trip_start->vehicle_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->vehicle->Visible) { // vehicle ?>
		<td data-name="vehicle"<?php echo $t_trip_start->vehicle->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_vehicle" class="t_trip_start_vehicle">
<span<?php echo $t_trip_start->vehicle->viewAttributes() ?>>
<?php echo $t_trip_start->vehicle->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->reports_to->Visible) { // reports_to ?>
		<td data-name="reports_to"<?php echo $t_trip_start->reports_to->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_reports_to" class="t_trip_start_reports_to">
<span<?php echo $t_trip_start->reports_to->viewAttributes() ?>>
<?php echo $t_trip_start->reports_to->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
		<td data-name="vehicle_freight_type"<?php echo $t_trip_start->vehicle_freight_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_vehicle_freight_type" class="t_trip_start_vehicle_freight_type">
<span<?php echo $t_trip_start->vehicle_freight_type->viewAttributes() ?>>
<?php echo $t_trip_start->vehicle_freight_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
		<td data-name="vehicle_freight_amount"<?php echo $t_trip_start->vehicle_freight_amount->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_vehicle_freight_amount" class="t_trip_start_vehicle_freight_amount">
<span<?php echo $t_trip_start->vehicle_freight_amount->viewAttributes() ?>>
<?php echo $t_trip_start->vehicle_freight_amount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->material->Visible) { // material ?>
		<td data-name="material"<?php echo $t_trip_start->material->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_material" class="t_trip_start_material">
<span<?php echo $t_trip_start->material->viewAttributes() ?>>
<?php echo $t_trip_start->material->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->_40->Visible) { // @ ?>
		<td data-name="_40"<?php echo $t_trip_start->_40->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start__40" class="t_trip_start__40">
<span<?php echo $t_trip_start->_40->viewAttributes() ?>>
<?php echo $t_trip_start->_40->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $t_trip_start->buyer->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_buyer" class="t_trip_start_buyer">
<span<?php echo $t_trip_start->buyer->viewAttributes() ?>>
<?php echo $t_trip_start->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->agent->Visible) { // agent ?>
		<td data-name="agent"<?php echo $t_trip_start->agent->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_agent" class="t_trip_start_agent">
<span<?php echo $t_trip_start->agent->viewAttributes() ?>>
<?php echo $t_trip_start->agent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->comm->Visible) { // comm ?>
		<td data-name="comm"<?php echo $t_trip_start->comm->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_comm" class="t_trip_start_comm">
<span<?php echo $t_trip_start->comm->viewAttributes() ?>>
<?php echo $t_trip_start->comm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->load_date->Visible) { // load_date ?>
		<td data-name="load_date"<?php echo $t_trip_start->load_date->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_load_date" class="t_trip_start_load_date">
<span<?php echo $t_trip_start->load_date->viewAttributes() ?>>
<?php echo $t_trip_start->load_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->load_weight->Visible) { // load_weight ?>
		<td data-name="load_weight"<?php echo $t_trip_start->load_weight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_load_weight" class="t_trip_start_load_weight">
<span<?php echo $t_trip_start->load_weight->viewAttributes() ?>>
<?php echo $t_trip_start->load_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->load_km->Visible) { // load_km ?>
		<td data-name="load_km"<?php echo $t_trip_start->load_km->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_load_km" class="t_trip_start_load_km">
<span<?php echo $t_trip_start->load_km->viewAttributes() ?>>
<?php echo $t_trip_start->load_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->gst_percent->Visible) { // gst_percent ?>
		<td data-name="gst_percent"<?php echo $t_trip_start->gst_percent->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_gst_percent" class="t_trip_start_gst_percent">
<span<?php echo $t_trip_start->gst_percent->viewAttributes() ?>>
<?php echo $t_trip_start->gst_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_trip_start->driver->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_driver" class="t_trip_start_driver">
<span<?php echo $t_trip_start->driver->viewAttributes() ?>>
<?php echo $t_trip_start->driver->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
		<td data-name="vehicle_freight_comm"<?php echo $t_trip_start->vehicle_freight_comm->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_vehicle_freight_comm" class="t_trip_start_vehicle_freight_comm">
<span<?php echo $t_trip_start->vehicle_freight_comm->viewAttributes() ?>>
<?php echo $t_trip_start->vehicle_freight_comm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->freight_type->Visible) { // freight_type ?>
		<td data-name="freight_type"<?php echo $t_trip_start->freight_type->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_freight_type" class="t_trip_start_freight_type">
<span<?php echo $t_trip_start->freight_type->viewAttributes() ?>>
<?php echo $t_trip_start->freight_type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_trip_start->freight->Visible) { // freight ?>
		<td data-name="freight"<?php echo $t_trip_start->freight->cellAttributes() ?>>
<span id="el<?php echo $t_trip_start_list->RowCnt ?>_t_trip_start_freight" class="t_trip_start_freight">
<span<?php echo $t_trip_start->freight->viewAttributes() ?>>
<?php echo $t_trip_start->freight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_trip_start_list->ListOptions->render("body", "right", $t_trip_start_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_trip_start->isGridAdd())
		$t_trip_start_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_trip_start->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_trip_start_list->Recordset)
	$t_trip_start_list->Recordset->Close();
?>
<?php if (!$t_trip_start->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_trip_start->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_trip_start_list->Pager)) $t_trip_start_list->Pager = new PrevNextPager($t_trip_start_list->StartRec, $t_trip_start_list->DisplayRecs, $t_trip_start_list->TotalRecs, $t_trip_start_list->AutoHidePager) ?>
<?php if ($t_trip_start_list->Pager->RecordCount > 0 && $t_trip_start_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_trip_start_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_trip_start_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_trip_start_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_trip_start_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_trip_start_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_trip_start_list->pageUrl() ?>start=<?php echo $t_trip_start_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_trip_start_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_trip_start_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_trip_start_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_trip_start_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_trip_start_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_trip_start_list->TotalRecs > 0 && (!$t_trip_start_list->AutoHidePageSizeSelector || $t_trip_start_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_trip_start">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_trip_start_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_trip_start_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_trip_start_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_trip_start_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_trip_start_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_trip_start->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_trip_start_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_trip_start_list->TotalRecs == 0 && !$t_trip_start->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_trip_start_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_trip_start_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_trip_start->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_trip_start->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_trip_start", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_trip_start_list->terminate();
?>