<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_trip_start_search = new t_trip_start_search();

// Run the page
$t_trip_start_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_trip_start_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_trip_start_search->IsModal) { ?>
var ft_trip_startsearch = currentAdvancedSearchForm = new ew.Form("ft_trip_startsearch", "search");
<?php } else { ?>
var ft_trip_startsearch = currentForm = new ew.Form("ft_trip_startsearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_trip_startsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_trip_startsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Multi-Page
ft_trip_startsearch.multiPage = new ew.MultiPage("ft_trip_startsearch");

// Dynamic selection lists
ft_trip_startsearch.lists["x_vehicle_type"] = <?php echo $t_trip_start_search->vehicle_type->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_vehicle_type"].options = <?php echo JsonEncode($t_trip_start_search->vehicle_type->options(FALSE, TRUE)) ?>;
ft_trip_startsearch.lists["x_vehicle"] = <?php echo $t_trip_start_search->vehicle->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_vehicle"].options = <?php echo JsonEncode($t_trip_start_search->vehicle->lookupOptions()) ?>;
ft_trip_startsearch.autoSuggests["x_vehicle"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startsearch.lists["x__route"] = <?php echo $t_trip_start_search->_route->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x__route"].options = <?php echo JsonEncode($t_trip_start_search->_route->lookupOptions()) ?>;
ft_trip_startsearch.autoSuggests["x__route"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startsearch.lists["x_reports_to"] = <?php echo $t_trip_start_search->reports_to->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_reports_to"].options = <?php echo JsonEncode($t_trip_start_search->reports_to->lookupOptions()) ?>;
ft_trip_startsearch.lists["x_vehicle_freight_type"] = <?php echo $t_trip_start_search->vehicle_freight_type->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_vehicle_freight_type"].options = <?php echo JsonEncode($t_trip_start_search->vehicle_freight_type->options(FALSE, TRUE)) ?>;
ft_trip_startsearch.lists["x_buyer"] = <?php echo $t_trip_start_search->buyer->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_buyer"].options = <?php echo JsonEncode($t_trip_start_search->buyer->lookupOptions()) ?>;
ft_trip_startsearch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startsearch.lists["x_agent"] = <?php echo $t_trip_start_search->agent->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_agent"].options = <?php echo JsonEncode($t_trip_start_search->agent->lookupOptions()) ?>;
ft_trip_startsearch.autoSuggests["x_agent"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ft_trip_startsearch.lists["x_freight_type"] = <?php echo $t_trip_start_search->freight_type->Lookup->toClientList() ?>;
ft_trip_startsearch.lists["x_freight_type"].options = <?php echo JsonEncode($t_trip_start_search->freight_type->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

ft_trip_startsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->vehicle->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__route");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->_route->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_freight_amount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->vehicle_freight_amount->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "__40");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->_40->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_buyer");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->buyer->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_comm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->comm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_weight");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->load_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_gst_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->gst_percent->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_vehicle_freight_comm");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->vehicle_freight_comm->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_freight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_trip_start->freight->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_trip_start_search->showPageHeader(); ?>
<?php
$t_trip_start_search->showMessage();
?>
<form name="ft_trip_startsearch" id="ft_trip_startsearch" class="<?php echo $t_trip_start_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_trip_start_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_trip_start_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_trip_start">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_trip_start_search->IsModal ?>">
<?php if ($t_trip_start_search->MultiPages->Items[0]->Visible) { ?>
<div class="ew-search-div"><!-- page0 -->
<?php if ($t_trip_start->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_id"><?php echo $t_trip_start->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->id->cellAttributes() ?>>
			<span id="el_t_trip_start_id">
<input type="text" data-table="t_trip_start" data-field="x_id" data-page="0" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($t_trip_start->id->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->id->EditValue ?>"<?php echo $t_trip_start->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_type->Visible) { // vehicle_type ?>
	<div id="r_vehicle_type" class="form-group row">
		<label for="x_vehicle_type" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_type"><?php echo $t_trip_start->vehicle_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_type" id="z_vehicle_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_type->cellAttributes() ?>>
			<span id="el_t_trip_start_vehicle_type">
<?php $t_trip_start->vehicle_type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_trip_start->vehicle_type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_vehicle_type" data-page="0" data-value-separator="<?php echo $t_trip_start->vehicle_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_type" name="x_vehicle_type"<?php echo $t_trip_start->vehicle_type->editAttributes() ?>>
		<?php echo $t_trip_start->vehicle_type->selectOptionListHtml("x_vehicle_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle->Visible) { // vehicle ?>
	<div id="r_vehicle" class="form-group row">
		<label class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle"><?php echo $t_trip_start->vehicle->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle" id="z_vehicle" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle->cellAttributes() ?>>
			<span id="el_t_trip_start_vehicle">
<?php
$wrkonchange = "" . trim(@$t_trip_start->vehicle->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->vehicle->EditAttrs["onchange"] = "";
?>
<span id="as_x_vehicle" class="text-nowrap" style="z-index: 8970">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_vehicle" id="sv_x_vehicle" value="<?php echo RemoveHtml($t_trip_start->vehicle->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->vehicle->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->vehicle->getPlaceHolder()) ?>"<?php echo $t_trip_start->vehicle->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->vehicle->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_vehicle',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->vehicle->ReadOnly || $t_trip_start->vehicle->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_vehicle" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->vehicle->displayValueSeparatorAttribute() ?>" name="x_vehicle" id="x_vehicle" value="<?php echo HtmlEncode($t_trip_start->vehicle->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startsearch.createAutoSuggest({"id":"x_vehicle","forceSelect":true});
</script>
<?php echo $t_trip_start->vehicle->Lookup->getParamTag("p_x_vehicle") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->_route->Visible) { // route ?>
	<div id="r__route" class="form-group row">
		<label class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start__route"><?php echo $t_trip_start->_route->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__route" id="z__route" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->_route->cellAttributes() ?>>
			<span id="el_t_trip_start__route">
<?php
$wrkonchange = "" . trim(@$t_trip_start->_route->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->_route->EditAttrs["onchange"] = "";
?>
<span id="as_x__route" class="text-nowrap" style="z-index: 8960">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x__route" id="sv_x__route" value="<?php echo RemoveHtml($t_trip_start->_route->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->_route->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->_route->getPlaceHolder()) ?>"<?php echo $t_trip_start->_route->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->_route->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x__route',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->_route->ReadOnly || $t_trip_start->_route->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x__route" data-page="0" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->_route->displayValueSeparatorAttribute() ?>" name="x__route" id="x__route" value="<?php echo HtmlEncode($t_trip_start->_route->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startsearch.createAutoSuggest({"id":"x__route","forceSelect":true});
</script>
<?php echo $t_trip_start->_route->Lookup->getParamTag("p_x__route") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_type->Visible) { // vehicle_freight_type ?>
	<div id="r_vehicle_freight_type" class="form-group row">
		<label for="x_vehicle_freight_type" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_freight_type"><?php echo $t_trip_start->vehicle_freight_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_type" id="z_vehicle_freight_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_freight_type->cellAttributes() ?>>
			<span id="el_t_trip_start_vehicle_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_vehicle_freight_type" data-page="0" data-value-separator="<?php echo $t_trip_start->vehicle_freight_type->displayValueSeparatorAttribute() ?>" id="x_vehicle_freight_type" name="x_vehicle_freight_type"<?php echo $t_trip_start->vehicle_freight_type->editAttributes() ?>>
		<?php echo $t_trip_start->vehicle_freight_type->selectOptionListHtml("x_vehicle_freight_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_amount->Visible) { // vehicle_freight_amount ?>
	<div id="r_vehicle_freight_amount" class="form-group row">
		<label for="x_vehicle_freight_amount" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_freight_amount"><?php echo $t_trip_start->vehicle_freight_amount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_amount" id="z_vehicle_freight_amount" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_freight_amount->cellAttributes() ?>>
			<span id="el_t_trip_start_vehicle_freight_amount">
<input type="text" data-table="t_trip_start" data-field="x_vehicle_freight_amount" data-page="0" name="x_vehicle_freight_amount" id="x_vehicle_freight_amount" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->vehicle_freight_amount->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->vehicle_freight_amount->EditValue ?>"<?php echo $t_trip_start->vehicle_freight_amount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label for="x_driver" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_driver"><?php echo $t_trip_start->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->driver->cellAttributes() ?>>
			<span id="el_t_trip_start_driver">
<input type="text" data-table="t_trip_start" data-field="x_driver" data-page="0" name="x_driver" id="x_driver" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->driver->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->driver->EditValue ?>"<?php echo $t_trip_start->driver->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->vehicle_freight_comm->Visible) { // vehicle_freight_comm ?>
	<div id="r_vehicle_freight_comm" class="form-group row">
		<label for="x_vehicle_freight_comm" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_vehicle_freight_comm"><?php echo $t_trip_start->vehicle_freight_comm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_freight_comm" id="z_vehicle_freight_comm" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->vehicle_freight_comm->cellAttributes() ?>>
			<span id="el_t_trip_start_vehicle_freight_comm">
<input type="text" data-table="t_trip_start" data-field="x_vehicle_freight_comm" data-page="0" name="x_vehicle_freight_comm" id="x_vehicle_freight_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->vehicle_freight_comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->vehicle_freight_comm->EditValue ?>"<?php echo $t_trip_start->vehicle_freight_comm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page0 -->
<?php } ?>
<div class="ew-multi-page"><!-- multi-page -->
<div class="accordion ew-accordion" id="t_trip_start_search"><!-- multi-page accordion -->
	<div class="card ew-accordion-card<?php echo $t_trip_start_search->MultiPages->pageStyle("1") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_start_search->MultiPages->isActive("1")) ?>" href="#tab_t_trip_start1"><?php echo $t_trip_start->pageCaption(1) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_start_search->MultiPages->pageStyle("1") ?>" data-parent="<?php echo $t_trip_start_search->MultiPages->Parent ?>" id="tab_t_trip_start1"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_start->reports_to->Visible) { // reports_to ?>
	<div id="r_reports_to" class="form-group row">
		<label for="x_reports_to" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_reports_to"><?php echo $t_trip_start->reports_to->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reports_to" id="z_reports_to" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->reports_to->cellAttributes() ?>>
			<span id="el_t_trip_start_reports_to">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_reports_to" data-page="1" data-value-separator="<?php echo $t_trip_start->reports_to->displayValueSeparatorAttribute() ?>" id="x_reports_to" name="x_reports_to"<?php echo $t_trip_start->reports_to->editAttributes() ?>>
		<?php echo $t_trip_start->reports_to->selectOptionListHtml("x_reports_to") ?>
	</select>
</div>
<?php echo $t_trip_start->reports_to->Lookup->getParamTag("p_x_reports_to") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->material->Visible) { // material ?>
	<div id="r_material" class="form-group row">
		<label for="x_material" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_material"><?php echo $t_trip_start->material->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_material" id="z_material" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->material->cellAttributes() ?>>
			<span id="el_t_trip_start_material">
<input type="text" data-table="t_trip_start" data-field="x_material" data-page="1" name="x_material" id="x_material" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->material->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->material->EditValue ?>"<?php echo $t_trip_start->material->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->_40->Visible) { // @ ?>
	<div id="r__40" class="form-group row">
		<label for="x__40" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start__40"><?php echo $t_trip_start->_40->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z__40" id="z__40" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->_40->cellAttributes() ?>>
			<span id="el_t_trip_start__40">
<input type="text" data-table="t_trip_start" data-field="x__40" data-page="1" name="x__40" id="x__40" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->_40->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->_40->EditValue ?>"<?php echo $t_trip_start->_40->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_buyer"><?php echo $t_trip_start->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->buyer->cellAttributes() ?>>
			<span id="el_t_trip_start_buyer">
<?php
$wrkonchange = "" . trim(@$t_trip_start->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8900">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($t_trip_start->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->buyer->getPlaceHolder()) ?>"<?php echo $t_trip_start->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->buyer->ReadOnly || $t_trip_start->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_buyer" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($t_trip_start->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startsearch.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $t_trip_start->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->agent->Visible) { // agent ?>
	<div id="r_agent" class="form-group row">
		<label class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_agent"><?php echo $t_trip_start->agent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_agent" id="z_agent" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->agent->cellAttributes() ?>>
			<span id="el_t_trip_start_agent">
<?php
$wrkonchange = "" . trim(@$t_trip_start->agent->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$t_trip_start->agent->EditAttrs["onchange"] = "";
?>
<span id="as_x_agent" class="text-nowrap" style="z-index: 8890">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_agent" id="sv_x_agent" value="<?php echo RemoveHtml($t_trip_start->agent->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->agent->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($t_trip_start->agent->getPlaceHolder()) ?>"<?php echo $t_trip_start->agent->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($t_trip_start->agent->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_agent',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($t_trip_start->agent->ReadOnly || $t_trip_start->agent->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="t_trip_start" data-field="x_agent" data-page="1" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $t_trip_start->agent->displayValueSeparatorAttribute() ?>" name="x_agent" id="x_agent" value="<?php echo HtmlEncode($t_trip_start->agent->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ft_trip_startsearch.createAutoSuggest({"id":"x_agent","forceSelect":false});
</script>
<?php echo $t_trip_start->agent->Lookup->getParamTag("p_x_agent") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->comm->Visible) { // comm ?>
	<div id="r_comm" class="form-group row">
		<label for="x_comm" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_comm"><?php echo $t_trip_start->comm->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_comm" id="z_comm" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->comm->cellAttributes() ?>>
			<span id="el_t_trip_start_comm">
<input type="text" data-table="t_trip_start" data-field="x_comm" data-page="1" name="x_comm" id="x_comm" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->comm->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->comm->EditValue ?>"<?php echo $t_trip_start->comm->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_remarks"><?php echo $t_trip_start->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->remarks->cellAttributes() ?>>
			<span id="el_t_trip_start_remarks">
<input type="text" data-table="t_trip_start" data-field="x_remarks" data-page="1" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($t_trip_start->remarks->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->remarks->EditValue ?>"<?php echo $t_trip_start->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_start_search->MultiPages->pageStyle("2") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_start_search->MultiPages->isActive("2")) ?>" href="#tab_t_trip_start2"><?php echo $t_trip_start->pageCaption(2) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_start_search->MultiPages->pageStyle("2") ?>" data-parent="<?php echo $t_trip_start_search->MultiPages->Parent ?>" id="tab_t_trip_start2"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_start->gst_percent->Visible) { // gst_percent ?>
	<div id="r_gst_percent" class="form-group row">
		<label for="x_gst_percent" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_gst_percent"><?php echo $t_trip_start->gst_percent->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_gst_percent" id="z_gst_percent" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->gst_percent->cellAttributes() ?>>
			<span id="el_t_trip_start_gst_percent">
<input type="text" data-table="t_trip_start" data-field="x_gst_percent" data-page="2" name="x_gst_percent" id="x_gst_percent" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->gst_percent->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->gst_percent->EditValue ?>"<?php echo $t_trip_start->gst_percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->freight_type->Visible) { // freight_type ?>
	<div id="r_freight_type" class="form-group row">
		<label for="x_freight_type" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_freight_type"><?php echo $t_trip_start->freight_type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_freight_type" id="z_freight_type" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->freight_type->cellAttributes() ?>>
			<span id="el_t_trip_start_freight_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_trip_start" data-field="x_freight_type" data-page="2" data-value-separator="<?php echo $t_trip_start->freight_type->displayValueSeparatorAttribute() ?>" id="x_freight_type" name="x_freight_type"<?php echo $t_trip_start->freight_type->editAttributes() ?>>
		<?php echo $t_trip_start->freight_type->selectOptionListHtml("x_freight_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->freight->Visible) { // freight ?>
	<div id="r_freight" class="form-group row">
		<label for="x_freight" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_freight"><?php echo $t_trip_start->freight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_freight" id="z_freight" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->freight->cellAttributes() ?>>
			<span id="el_t_trip_start_freight">
<input type="text" data-table="t_trip_start" data-field="x_freight" data-page="2" name="x_freight" id="x_freight" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->freight->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->freight->EditValue ?>"<?php echo $t_trip_start->freight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
	<div class="card ew-accordion-card<?php echo $t_trip_start_search->MultiPages->pageStyle("3") ?>">
		<div class="card-header">
			<h4 class="card-title">
				<a data-toggle="collapse" role="button" class="collapsed" aria-expanded="<?php echo JsonEncode($t_trip_start_search->MultiPages->isActive("3")) ?>" href="#tab_t_trip_start3"><?php echo $t_trip_start->pageCaption(3) ?></a>
			</h4>
		</div>
		<div class="collapse<?php echo $t_trip_start_search->MultiPages->pageStyle("3") ?>" data-parent="<?php echo $t_trip_start_search->MultiPages->Parent ?>" id="tab_t_trip_start3"><!-- multi-page accordion .collapse -->
			<div class="card-body"><!-- multi-page accordion .card-body -->
<div class="ew-search-div"><!-- page* -->
<?php if ($t_trip_start->load_date->Visible) { // load_date ?>
	<div id="r_load_date" class="form-group row">
		<label for="x_load_date" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_load_date"><?php echo $t_trip_start->load_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_date" id="z_load_date" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->load_date->cellAttributes() ?>>
			<span id="el_t_trip_start_load_date">
<input type="text" data-table="t_trip_start" data-field="x_load_date" data-page="3" data-format="1" name="x_load_date" id="x_load_date" placeholder="<?php echo HtmlEncode($t_trip_start->load_date->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_date->EditValue ?>"<?php echo $t_trip_start->load_date->editAttributes() ?>>
<?php if (!$t_trip_start->load_date->ReadOnly && !$t_trip_start->load_date->Disabled && !isset($t_trip_start->load_date->EditAttrs["readonly"]) && !isset($t_trip_start->load_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_trip_startsearch", "x_load_date", {"ignoreReadonly":true,"useCurrent":false,"format":1});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->load_weight->Visible) { // load_weight ?>
	<div id="r_load_weight" class="form-group row">
		<label for="x_load_weight" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_load_weight"><?php echo $t_trip_start->load_weight->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_weight" id="z_load_weight" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->load_weight->cellAttributes() ?>>
			<span id="el_t_trip_start_load_weight">
<input type="text" data-table="t_trip_start" data-field="x_load_weight" data-page="3" name="x_load_weight" id="x_load_weight" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->load_weight->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_weight->EditValue ?>"<?php echo $t_trip_start->load_weight->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_trip_start->load_km->Visible) { // load_km ?>
	<div id="r_load_km" class="form-group row">
		<label for="x_load_km" class="<?php echo $t_trip_start_search->LeftColumnClass ?>"><span id="elh_t_trip_start_load_km"><?php echo $t_trip_start->load_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_km" id="z_load_km" value="="></span>
		</label>
		<div class="<?php echo $t_trip_start_search->RightColumnClass ?>"><div<?php echo $t_trip_start->load_km->cellAttributes() ?>>
			<span id="el_t_trip_start_load_km">
<input type="text" data-table="t_trip_start" data-field="x_load_km" data-page="3" name="x_load_km" id="x_load_km" size="30" placeholder="<?php echo HtmlEncode($t_trip_start->load_km->getPlaceHolder()) ?>" value="<?php echo $t_trip_start->load_km->EditValue ?>"<?php echo $t_trip_start->load_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
			</div><!-- /multi-page accordion .card-body -->
		</div><!-- /multi-page accordion .collapse -->
	</div>
</div><!-- /multi-page accordion -->
</div><!-- /multi-page -->
<?php if (!$t_trip_start_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_trip_start_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_trip_start_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_trip_start_search->terminate();
?>