<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_tyre_info_list = new t_tyre_info_list();

// Run the page
$t_tyre_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_tyre_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_tyre_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_tyre_infolist = currentForm = new ew.Form("ft_tyre_infolist", "list");
ft_tyre_infolist.formKeyCountName = '<?php echo $t_tyre_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_tyre_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_tyre_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_tyre_infolist.lists["x_vehicle_no"] = <?php echo $t_tyre_info_list->vehicle_no->Lookup->toClientList() ?>;
ft_tyre_infolist.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_tyre_info_list->vehicle_no->lookupOptions()) ?>;
ft_tyre_infolist.lists["x_head"] = <?php echo $t_tyre_info_list->head->Lookup->toClientList() ?>;
ft_tyre_infolist.lists["x_head"].options = <?php echo JsonEncode($t_tyre_info_list->head->lookupOptions()) ?>;
ft_tyre_infolist.lists["x_sub_head"] = <?php echo $t_tyre_info_list->sub_head->Lookup->toClientList() ?>;
ft_tyre_infolist.lists["x_sub_head"].options = <?php echo JsonEncode($t_tyre_info_list->sub_head->lookupOptions()) ?>;
ft_tyre_infolist.lists["x_status"] = <?php echo $t_tyre_info_list->status->Lookup->toClientList() ?>;
ft_tyre_infolist.lists["x_status"].options = <?php echo JsonEncode($t_tyre_info_list->status->options(FALSE, TRUE)) ?>;
ft_tyre_infolist.lists["x_operator"] = <?php echo $t_tyre_info_list->operator->Lookup->toClientList() ?>;
ft_tyre_infolist.lists["x_operator"].options = <?php echo JsonEncode($t_tyre_info_list->operator->lookupOptions()) ?>;

// Form object for search
var ft_tyre_infolistsrch = currentSearchForm = new ew.Form("ft_tyre_infolistsrch");

// Filters
ft_tyre_infolistsrch.filterList = <?php echo $t_tyre_info_list->getFilterList() ?>;

// Init search panel as collapsed
ft_tyre_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_tyre_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_tyre_info_list->TotalRecs > 0 && $t_tyre_info_list->ExportOptions->visible()) { ?>
<?php $t_tyre_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_tyre_info_list->ImportOptions->visible()) { ?>
<?php $t_tyre_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_tyre_info_list->SearchOptions->visible()) { ?>
<?php $t_tyre_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_tyre_info_list->FilterOptions->visible()) { ?>
<?php $t_tyre_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_tyre_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_tyre_info->isExport() && !$t_tyre_info->CurrentAction) { ?>
<form name="ft_tyre_infolistsrch" id="ft_tyre_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_tyre_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_tyre_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_tyre_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_tyre_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_tyre_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_tyre_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_tyre_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_tyre_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_tyre_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_tyre_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_tyre_info_list->showPageHeader(); ?>
<?php
$t_tyre_info_list->showMessage();
?>
<?php if ($t_tyre_info_list->TotalRecs > 0 || $t_tyre_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_tyre_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_tyre_info">
<?php if (!$t_tyre_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_tyre_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_tyre_info_list->Pager)) $t_tyre_info_list->Pager = new PrevNextPager($t_tyre_info_list->StartRec, $t_tyre_info_list->DisplayRecs, $t_tyre_info_list->TotalRecs, $t_tyre_info_list->AutoHidePager) ?>
<?php if ($t_tyre_info_list->Pager->RecordCount > 0 && $t_tyre_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_tyre_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_tyre_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_tyre_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_tyre_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_tyre_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_tyre_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_tyre_info_list->TotalRecs > 0 && (!$t_tyre_info_list->AutoHidePageSizeSelector || $t_tyre_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_tyre_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_tyre_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_tyre_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_tyre_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_tyre_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_tyre_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_tyre_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_tyre_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_tyre_infolist" id="ft_tyre_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_tyre_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_tyre_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_tyre_info">
<div id="gmp_t_tyre_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_tyre_info_list->TotalRecs > 0 || $t_tyre_info->isGridEdit()) { ?>
<table id="tbl_t_tyre_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_tyre_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_tyre_info_list->renderListOptions();

// Render list options (header, left)
$t_tyre_info_list->ListOptions->render("header", "left");
?>
<?php if ($t_tyre_info->id->Visible) { // id ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_tyre_info->id->headerCellClass() ?>"><div id="elh_t_tyre_info_id" class="t_tyre_info_id"><div class="ew-table-header-caption"><?php echo $t_tyre_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_tyre_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->id) ?>',2);"><div id="elh_t_tyre_info_id" class="t_tyre_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->vehicle_no->Visible) { // vehicle_no ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->vehicle_no) == "") { ?>
		<th data-name="vehicle_no" class="<?php echo $t_tyre_info->vehicle_no->headerCellClass() ?>"><div id="elh_t_tyre_info_vehicle_no" class="t_tyre_info_vehicle_no"><div class="ew-table-header-caption"><?php echo $t_tyre_info->vehicle_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_no" class="<?php echo $t_tyre_info->vehicle_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->vehicle_no) ?>',2);"><div id="elh_t_tyre_info_vehicle_no" class="t_tyre_info_vehicle_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->vehicle_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->vehicle_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->vehicle_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->head->Visible) { // head ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->head) == "") { ?>
		<th data-name="head" class="<?php echo $t_tyre_info->head->headerCellClass() ?>"><div id="elh_t_tyre_info_head" class="t_tyre_info_head"><div class="ew-table-header-caption"><?php echo $t_tyre_info->head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="head" class="<?php echo $t_tyre_info->head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->head) ?>',2);"><div id="elh_t_tyre_info_head" class="t_tyre_info_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->head->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->sub_head->Visible) { // sub_head ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->sub_head) == "") { ?>
		<th data-name="sub_head" class="<?php echo $t_tyre_info->sub_head->headerCellClass() ?>"><div id="elh_t_tyre_info_sub_head" class="t_tyre_info_sub_head"><div class="ew-table-header-caption"><?php echo $t_tyre_info->sub_head->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sub_head" class="<?php echo $t_tyre_info->sub_head->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->sub_head) ?>',2);"><div id="elh_t_tyre_info_sub_head" class="t_tyre_info_sub_head">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->sub_head->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->sub_head->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->sub_head->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->s_no->Visible) { // s_no ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->s_no) == "") { ?>
		<th data-name="s_no" class="<?php echo $t_tyre_info->s_no->headerCellClass() ?>"><div id="elh_t_tyre_info_s_no" class="t_tyre_info_s_no"><div class="ew-table-header-caption"><?php echo $t_tyre_info->s_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_no" class="<?php echo $t_tyre_info->s_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->s_no) ?>',2);"><div id="elh_t_tyre_info_s_no" class="t_tyre_info_s_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->s_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->s_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->s_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->km->Visible) { // km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->km) == "") { ?>
		<th data-name="km" class="<?php echo $t_tyre_info->km->headerCellClass() ?>"><div id="elh_t_tyre_info_km" class="t_tyre_info_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="km" class="<?php echo $t_tyre_info->km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->km) ?>',2);"><div id="elh_t_tyre_info_km" class="t_tyre_info_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->life_km->Visible) { // life_km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->life_km) == "") { ?>
		<th data-name="life_km" class="<?php echo $t_tyre_info->life_km->headerCellClass() ?>"><div id="elh_t_tyre_info_life_km" class="t_tyre_info_life_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->life_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="life_km" class="<?php echo $t_tyre_info->life_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->life_km) ?>',2);"><div id="elh_t_tyre_info_life_km" class="t_tyre_info_life_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->life_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->life_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->life_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->recycle_after_km->Visible) { // recycle_after_km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->recycle_after_km) == "") { ?>
		<th data-name="recycle_after_km" class="<?php echo $t_tyre_info->recycle_after_km->headerCellClass() ?>"><div id="elh_t_tyre_info_recycle_after_km" class="t_tyre_info_recycle_after_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->recycle_after_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="recycle_after_km" class="<?php echo $t_tyre_info->recycle_after_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->recycle_after_km) ?>',2);"><div id="elh_t_tyre_info_recycle_after_km" class="t_tyre_info_recycle_after_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->recycle_after_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->recycle_after_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->recycle_after_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->next_km->Visible) { // next_km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->next_km) == "") { ?>
		<th data-name="next_km" class="<?php echo $t_tyre_info->next_km->headerCellClass() ?>"><div id="elh_t_tyre_info_next_km" class="t_tyre_info_next_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->next_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="next_km" class="<?php echo $t_tyre_info->next_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->next_km) ?>',2);"><div id="elh_t_tyre_info_next_km" class="t_tyre_info_next_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->next_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->next_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->next_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->recycle_next_km->Visible) { // recycle_next_km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->recycle_next_km) == "") { ?>
		<th data-name="recycle_next_km" class="<?php echo $t_tyre_info->recycle_next_km->headerCellClass() ?>"><div id="elh_t_tyre_info_recycle_next_km" class="t_tyre_info_recycle_next_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->recycle_next_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="recycle_next_km" class="<?php echo $t_tyre_info->recycle_next_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->recycle_next_km) ?>',2);"><div id="elh_t_tyre_info_recycle_next_km" class="t_tyre_info_recycle_next_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->recycle_next_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->recycle_next_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->recycle_next_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->puncture->Visible) { // puncture ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->puncture) == "") { ?>
		<th data-name="puncture" class="<?php echo $t_tyre_info->puncture->headerCellClass() ?>"><div id="elh_t_tyre_info_puncture" class="t_tyre_info_puncture"><div class="ew-table-header-caption"><?php echo $t_tyre_info->puncture->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="puncture" class="<?php echo $t_tyre_info->puncture->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->puncture) ?>',2);"><div id="elh_t_tyre_info_puncture" class="t_tyre_info_puncture">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->puncture->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->puncture->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->puncture->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->current_km->Visible) { // current_km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->current_km) == "") { ?>
		<th data-name="current_km" class="<?php echo $t_tyre_info->current_km->headerCellClass() ?>"><div id="elh_t_tyre_info_current_km" class="t_tyre_info_current_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->current_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="current_km" class="<?php echo $t_tyre_info->current_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->current_km) ?>',2);"><div id="elh_t_tyre_info_current_km" class="t_tyre_info_current_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->current_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->current_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->current_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->remaining_km->Visible) { // remaining_km ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->remaining_km) == "") { ?>
		<th data-name="remaining_km" class="<?php echo $t_tyre_info->remaining_km->headerCellClass() ?>"><div id="elh_t_tyre_info_remaining_km" class="t_tyre_info_remaining_km"><div class="ew-table-header-caption"><?php echo $t_tyre_info->remaining_km->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remaining_km" class="<?php echo $t_tyre_info->remaining_km->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->remaining_km) ?>',2);"><div id="elh_t_tyre_info_remaining_km" class="t_tyre_info_remaining_km">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->remaining_km->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->remaining_km->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->remaining_km->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->status->Visible) { // status ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $t_tyre_info->status->headerCellClass() ?>"><div id="elh_t_tyre_info_status" class="t_tyre_info_status"><div class="ew-table-header-caption"><?php echo $t_tyre_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $t_tyre_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->status) ?>',2);"><div id="elh_t_tyre_info_status" class="t_tyre_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->operator->Visible) { // operator ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_tyre_info->operator->headerCellClass() ?>"><div id="elh_t_tyre_info_operator" class="t_tyre_info_operator"><div class="ew-table-header-caption"><?php echo $t_tyre_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_tyre_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->operator) ?>',2);"><div id="elh_t_tyre_info_operator" class="t_tyre_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_info->datetime->Visible) { // datetime ?>
	<?php if ($t_tyre_info->sortUrl($t_tyre_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_tyre_info->datetime->headerCellClass() ?>"><div id="elh_t_tyre_info_datetime" class="t_tyre_info_datetime"><div class="ew-table-header-caption"><?php echo $t_tyre_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_tyre_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_info->SortUrl($t_tyre_info->datetime) ?>',2);"><div id="elh_t_tyre_info_datetime" class="t_tyre_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_tyre_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_tyre_info->ExportAll && $t_tyre_info->isExport()) {
	$t_tyre_info_list->StopRec = $t_tyre_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_tyre_info_list->TotalRecs > $t_tyre_info_list->StartRec + $t_tyre_info_list->DisplayRecs - 1)
		$t_tyre_info_list->StopRec = $t_tyre_info_list->StartRec + $t_tyre_info_list->DisplayRecs - 1;
	else
		$t_tyre_info_list->StopRec = $t_tyre_info_list->TotalRecs;
}
$t_tyre_info_list->RecCnt = $t_tyre_info_list->StartRec - 1;
if ($t_tyre_info_list->Recordset && !$t_tyre_info_list->Recordset->EOF) {
	$t_tyre_info_list->Recordset->moveFirst();
	$selectLimit = $t_tyre_info_list->UseSelectLimit;
	if (!$selectLimit && $t_tyre_info_list->StartRec > 1)
		$t_tyre_info_list->Recordset->move($t_tyre_info_list->StartRec - 1);
} elseif (!$t_tyre_info->AllowAddDeleteRow && $t_tyre_info_list->StopRec == 0) {
	$t_tyre_info_list->StopRec = $t_tyre_info->GridAddRowCount;
}

// Initialize aggregate
$t_tyre_info->RowType = ROWTYPE_AGGREGATEINIT;
$t_tyre_info->resetAttributes();
$t_tyre_info_list->renderRow();
while ($t_tyre_info_list->RecCnt < $t_tyre_info_list->StopRec) {
	$t_tyre_info_list->RecCnt++;
	if ($t_tyre_info_list->RecCnt >= $t_tyre_info_list->StartRec) {
		$t_tyre_info_list->RowCnt++;

		// Set up key count
		$t_tyre_info_list->KeyCount = $t_tyre_info_list->RowIndex;

		// Init row class and style
		$t_tyre_info->resetAttributes();
		$t_tyre_info->CssClass = "";
		if ($t_tyre_info->isGridAdd()) {
		} else {
			$t_tyre_info_list->loadRowValues($t_tyre_info_list->Recordset); // Load row values
		}
		$t_tyre_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_tyre_info->RowAttrs = array_merge($t_tyre_info->RowAttrs, array('data-rowindex'=>$t_tyre_info_list->RowCnt, 'id'=>'r' . $t_tyre_info_list->RowCnt . '_t_tyre_info', 'data-rowtype'=>$t_tyre_info->RowType));

		// Render row
		$t_tyre_info_list->renderRow();

		// Render list options
		$t_tyre_info_list->renderListOptions();
?>
	<tr<?php echo $t_tyre_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_tyre_info_list->ListOptions->render("body", "left", $t_tyre_info_list->RowCnt);
?>
	<?php if ($t_tyre_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_tyre_info->id->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_id" class="t_tyre_info_id">
<span<?php echo $t_tyre_info->id->viewAttributes() ?>>
<?php echo $t_tyre_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->vehicle_no->Visible) { // vehicle_no ?>
		<td data-name="vehicle_no"<?php echo $t_tyre_info->vehicle_no->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_vehicle_no" class="t_tyre_info_vehicle_no">
<span<?php echo $t_tyre_info->vehicle_no->viewAttributes() ?>>
<?php echo $t_tyre_info->vehicle_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->head->Visible) { // head ?>
		<td data-name="head"<?php echo $t_tyre_info->head->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_head" class="t_tyre_info_head">
<span<?php echo $t_tyre_info->head->viewAttributes() ?>>
<?php echo $t_tyre_info->head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->sub_head->Visible) { // sub_head ?>
		<td data-name="sub_head"<?php echo $t_tyre_info->sub_head->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_sub_head" class="t_tyre_info_sub_head">
<span<?php echo $t_tyre_info->sub_head->viewAttributes() ?>>
<?php echo $t_tyre_info->sub_head->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->s_no->Visible) { // s_no ?>
		<td data-name="s_no"<?php echo $t_tyre_info->s_no->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_s_no" class="t_tyre_info_s_no">
<span<?php echo $t_tyre_info->s_no->viewAttributes() ?>>
<?php echo $t_tyre_info->s_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->km->Visible) { // km ?>
		<td data-name="km"<?php echo $t_tyre_info->km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_km" class="t_tyre_info_km">
<span<?php echo $t_tyre_info->km->viewAttributes() ?>>
<?php echo $t_tyre_info->km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->life_km->Visible) { // life_km ?>
		<td data-name="life_km"<?php echo $t_tyre_info->life_km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_life_km" class="t_tyre_info_life_km">
<span<?php echo $t_tyre_info->life_km->viewAttributes() ?>>
<?php echo $t_tyre_info->life_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->recycle_after_km->Visible) { // recycle_after_km ?>
		<td data-name="recycle_after_km"<?php echo $t_tyre_info->recycle_after_km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_recycle_after_km" class="t_tyre_info_recycle_after_km">
<span<?php echo $t_tyre_info->recycle_after_km->viewAttributes() ?>>
<?php echo $t_tyre_info->recycle_after_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->next_km->Visible) { // next_km ?>
		<td data-name="next_km"<?php echo $t_tyre_info->next_km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_next_km" class="t_tyre_info_next_km">
<span<?php echo $t_tyre_info->next_km->viewAttributes() ?>>
<?php echo $t_tyre_info->next_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->recycle_next_km->Visible) { // recycle_next_km ?>
		<td data-name="recycle_next_km"<?php echo $t_tyre_info->recycle_next_km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_recycle_next_km" class="t_tyre_info_recycle_next_km">
<span<?php echo $t_tyre_info->recycle_next_km->viewAttributes() ?>>
<?php echo $t_tyre_info->recycle_next_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->puncture->Visible) { // puncture ?>
		<td data-name="puncture"<?php echo $t_tyre_info->puncture->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_puncture" class="t_tyre_info_puncture">
<span<?php echo $t_tyre_info->puncture->viewAttributes() ?>>
<?php echo $t_tyre_info->puncture->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->current_km->Visible) { // current_km ?>
		<td data-name="current_km"<?php echo $t_tyre_info->current_km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_current_km" class="t_tyre_info_current_km">
<span<?php echo $t_tyre_info->current_km->viewAttributes() ?>>
<?php echo $t_tyre_info->current_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->remaining_km->Visible) { // remaining_km ?>
		<td data-name="remaining_km"<?php echo $t_tyre_info->remaining_km->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_remaining_km" class="t_tyre_info_remaining_km">
<span<?php echo $t_tyre_info->remaining_km->viewAttributes() ?>>
<?php echo $t_tyre_info->remaining_km->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $t_tyre_info->status->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_status" class="t_tyre_info_status">
<span<?php echo $t_tyre_info->status->viewAttributes() ?>>
<?php echo $t_tyre_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_tyre_info->operator->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_operator" class="t_tyre_info_operator">
<span<?php echo $t_tyre_info->operator->viewAttributes() ?>>
<?php echo $t_tyre_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_tyre_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_info_list->RowCnt ?>_t_tyre_info_datetime" class="t_tyre_info_datetime">
<span<?php echo $t_tyre_info->datetime->viewAttributes() ?>>
<?php echo $t_tyre_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_tyre_info_list->ListOptions->render("body", "right", $t_tyre_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_tyre_info->isGridAdd())
		$t_tyre_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_tyre_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_tyre_info_list->Recordset)
	$t_tyre_info_list->Recordset->Close();
?>
<?php if (!$t_tyre_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_tyre_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_tyre_info_list->Pager)) $t_tyre_info_list->Pager = new PrevNextPager($t_tyre_info_list->StartRec, $t_tyre_info_list->DisplayRecs, $t_tyre_info_list->TotalRecs, $t_tyre_info_list->AutoHidePager) ?>
<?php if ($t_tyre_info_list->Pager->RecordCount > 0 && $t_tyre_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_tyre_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_tyre_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_tyre_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_tyre_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_tyre_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_tyre_info_list->pageUrl() ?>start=<?php echo $t_tyre_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_tyre_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_tyre_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_tyre_info_list->TotalRecs > 0 && (!$t_tyre_info_list->AutoHidePageSizeSelector || $t_tyre_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_tyre_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_tyre_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_tyre_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_tyre_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_tyre_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_tyre_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_tyre_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_tyre_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_tyre_info_list->TotalRecs == 0 && !$t_tyre_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_tyre_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_tyre_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_tyre_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_tyre_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_tyre_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_tyre_info_list->terminate();
?>