<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_tyre_info_search = new t_tyre_info_search();

// Run the page
$t_tyre_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_tyre_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_tyre_info_search->IsModal) { ?>
var ft_tyre_infosearch = currentAdvancedSearchForm = new ew.Form("ft_tyre_infosearch", "search");
<?php } else { ?>
var ft_tyre_infosearch = currentForm = new ew.Form("ft_tyre_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_tyre_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_tyre_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_tyre_infosearch.lists["x_vehicle_no"] = <?php echo $t_tyre_info_search->vehicle_no->Lookup->toClientList() ?>;
ft_tyre_infosearch.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_tyre_info_search->vehicle_no->lookupOptions()) ?>;
ft_tyre_infosearch.lists["x_head"] = <?php echo $t_tyre_info_search->head->Lookup->toClientList() ?>;
ft_tyre_infosearch.lists["x_head"].options = <?php echo JsonEncode($t_tyre_info_search->head->lookupOptions()) ?>;
ft_tyre_infosearch.lists["x_sub_head"] = <?php echo $t_tyre_info_search->sub_head->Lookup->toClientList() ?>;
ft_tyre_infosearch.lists["x_sub_head"].options = <?php echo JsonEncode($t_tyre_info_search->sub_head->lookupOptions()) ?>;
ft_tyre_infosearch.lists["x_status"] = <?php echo $t_tyre_info_search->status->Lookup->toClientList() ?>;
ft_tyre_infosearch.lists["x_status"].options = <?php echo JsonEncode($t_tyre_info_search->status->options(FALSE, TRUE)) ?>;
ft_tyre_infosearch.lists["x_operator"] = <?php echo $t_tyre_info_search->operator->Lookup->toClientList() ?>;
ft_tyre_infosearch.lists["x_operator"].options = <?php echo JsonEncode($t_tyre_info_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ft_tyre_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_life_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->life_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_recycle_after_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->recycle_after_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_next_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->next_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_recycle_next_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->recycle_next_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_puncture");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->puncture->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_current_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->current_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_remaining_km");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->remaining_km->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_tyre_info_search->showPageHeader(); ?>
<?php
$t_tyre_info_search->showMessage();
?>
<form name="ft_tyre_infosearch" id="ft_tyre_infosearch" class="<?php echo $t_tyre_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_tyre_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_tyre_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_tyre_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_tyre_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_tyre_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_id"><?php echo $t_tyre_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->id->cellAttributes() ?>>
			<span id="el_t_tyre_info_id">
<input type="text" data-table="t_tyre_info" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->id->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->id->EditValue ?>"<?php echo $t_tyre_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label for="x_vehicle_no" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_vehicle_no"><?php echo $t_tyre_info->vehicle_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->vehicle_no->cellAttributes() ?>>
			<span id="el_t_tyre_info_vehicle_no">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_info" data-field="x_vehicle_no" data-value-separator="<?php echo $t_tyre_info->vehicle_no->displayValueSeparatorAttribute() ?>" id="x_vehicle_no" name="x_vehicle_no"<?php echo $t_tyre_info->vehicle_no->editAttributes() ?>>
		<?php echo $t_tyre_info->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
	</select>
</div>
<?php echo $t_tyre_info->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->head->Visible) { // head ?>
	<div id="r_head" class="form-group row">
		<label for="x_head" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_head"><?php echo $t_tyre_info->head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_head" id="z_head" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->head->cellAttributes() ?>>
			<span id="el_t_tyre_info_head">
<?php $t_tyre_info->head->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_tyre_info->head->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_info" data-field="x_head" data-value-separator="<?php echo $t_tyre_info->head->displayValueSeparatorAttribute() ?>" id="x_head" name="x_head"<?php echo $t_tyre_info->head->editAttributes() ?>>
		<?php echo $t_tyre_info->head->selectOptionListHtml("x_head") ?>
	</select>
</div>
<?php echo $t_tyre_info->head->Lookup->getParamTag("p_x_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->sub_head->Visible) { // sub_head ?>
	<div id="r_sub_head" class="form-group row">
		<label for="x_sub_head" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_sub_head"><?php echo $t_tyre_info->sub_head->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_sub_head" id="z_sub_head" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->sub_head->cellAttributes() ?>>
			<span id="el_t_tyre_info_sub_head">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_info" data-field="x_sub_head" data-value-separator="<?php echo $t_tyre_info->sub_head->displayValueSeparatorAttribute() ?>" id="x_sub_head" name="x_sub_head"<?php echo $t_tyre_info->sub_head->editAttributes() ?>>
		<?php echo $t_tyre_info->sub_head->selectOptionListHtml("x_sub_head") ?>
	</select>
</div>
<?php echo $t_tyre_info->sub_head->Lookup->getParamTag("p_x_sub_head") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->s_no->Visible) { // s_no ?>
	<div id="r_s_no" class="form-group row">
		<label for="x_s_no" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_s_no"><?php echo $t_tyre_info->s_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_s_no" id="z_s_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->s_no->cellAttributes() ?>>
			<span id="el_t_tyre_info_s_no">
<input type="text" data-table="t_tyre_info" data-field="x_s_no" name="x_s_no" id="x_s_no" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($t_tyre_info->s_no->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->s_no->EditValue ?>"<?php echo $t_tyre_info->s_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->km->Visible) { // km ?>
	<div id="r_km" class="form-group row">
		<label for="x_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_km"><?php echo $t_tyre_info->km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_km" id="z_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->km->cellAttributes() ?>>
			<span id="el_t_tyre_info_km">
<input type="text" data-table="t_tyre_info" data-field="x_km" name="x_km" id="x_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->km->EditValue ?>"<?php echo $t_tyre_info->km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->life_km->Visible) { // life_km ?>
	<div id="r_life_km" class="form-group row">
		<label for="x_life_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_life_km"><?php echo $t_tyre_info->life_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_life_km" id="z_life_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->life_km->cellAttributes() ?>>
			<span id="el_t_tyre_info_life_km">
<input type="text" data-table="t_tyre_info" data-field="x_life_km" name="x_life_km" id="x_life_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->life_km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->life_km->EditValue ?>"<?php echo $t_tyre_info->life_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->recycle_after_km->Visible) { // recycle_after_km ?>
	<div id="r_recycle_after_km" class="form-group row">
		<label for="x_recycle_after_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_recycle_after_km"><?php echo $t_tyre_info->recycle_after_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_recycle_after_km" id="z_recycle_after_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->recycle_after_km->cellAttributes() ?>>
			<span id="el_t_tyre_info_recycle_after_km">
<input type="text" data-table="t_tyre_info" data-field="x_recycle_after_km" name="x_recycle_after_km" id="x_recycle_after_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->recycle_after_km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->recycle_after_km->EditValue ?>"<?php echo $t_tyre_info->recycle_after_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->next_km->Visible) { // next_km ?>
	<div id="r_next_km" class="form-group row">
		<label for="x_next_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_next_km"><?php echo $t_tyre_info->next_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_next_km" id="z_next_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->next_km->cellAttributes() ?>>
			<span id="el_t_tyre_info_next_km">
<input type="text" data-table="t_tyre_info" data-field="x_next_km" name="x_next_km" id="x_next_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->next_km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->next_km->EditValue ?>"<?php echo $t_tyre_info->next_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->recycle_next_km->Visible) { // recycle_next_km ?>
	<div id="r_recycle_next_km" class="form-group row">
		<label for="x_recycle_next_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_recycle_next_km"><?php echo $t_tyre_info->recycle_next_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_recycle_next_km" id="z_recycle_next_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->recycle_next_km->cellAttributes() ?>>
			<span id="el_t_tyre_info_recycle_next_km">
<input type="text" data-table="t_tyre_info" data-field="x_recycle_next_km" name="x_recycle_next_km" id="x_recycle_next_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->recycle_next_km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->recycle_next_km->EditValue ?>"<?php echo $t_tyre_info->recycle_next_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->puncture->Visible) { // puncture ?>
	<div id="r_puncture" class="form-group row">
		<label for="x_puncture" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_puncture"><?php echo $t_tyre_info->puncture->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_puncture" id="z_puncture" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->puncture->cellAttributes() ?>>
			<span id="el_t_tyre_info_puncture">
<input type="text" data-table="t_tyre_info" data-field="x_puncture" name="x_puncture" id="x_puncture" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->puncture->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->puncture->EditValue ?>"<?php echo $t_tyre_info->puncture->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->current_km->Visible) { // current_km ?>
	<div id="r_current_km" class="form-group row">
		<label for="x_current_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_current_km"><?php echo $t_tyre_info->current_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_current_km" id="z_current_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->current_km->cellAttributes() ?>>
			<span id="el_t_tyre_info_current_km">
<input type="text" data-table="t_tyre_info" data-field="x_current_km" name="x_current_km" id="x_current_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->current_km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->current_km->EditValue ?>"<?php echo $t_tyre_info->current_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->remaining_km->Visible) { // remaining_km ?>
	<div id="r_remaining_km" class="form-group row">
		<label for="x_remaining_km" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_remaining_km"><?php echo $t_tyre_info->remaining_km->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_remaining_km" id="z_remaining_km" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->remaining_km->cellAttributes() ?>>
			<span id="el_t_tyre_info_remaining_km">
<input type="text" data-table="t_tyre_info" data-field="x_remaining_km" name="x_remaining_km" id="x_remaining_km" size="30" placeholder="<?php echo HtmlEncode($t_tyre_info->remaining_km->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->remaining_km->EditValue ?>"<?php echo $t_tyre_info->remaining_km->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_remarks"><?php echo $t_tyre_info->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->remarks->cellAttributes() ?>>
			<span id="el_t_tyre_info_remarks">
<input type="text" data-table="t_tyre_info" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($t_tyre_info->remarks->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->remarks->EditValue ?>"<?php echo $t_tyre_info->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_status"><?php echo $t_tyre_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->status->cellAttributes() ?>>
			<span id="el_t_tyre_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_info" data-field="x_status" data-value-separator="<?php echo $t_tyre_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $t_tyre_info->status->editAttributes() ?>>
		<?php echo $t_tyre_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_operator"><?php echo $t_tyre_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->operator->cellAttributes() ?>>
			<span id="el_t_tyre_info_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_info" data-field="x_operator" data-value-separator="<?php echo $t_tyre_info->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $t_tyre_info->operator->editAttributes() ?>>
		<?php echo $t_tyre_info->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $t_tyre_info->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_tyre_info_search->LeftColumnClass ?>"><span id="elh_t_tyre_info_datetime"><?php echo $t_tyre_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_info_search->RightColumnClass ?>"><div<?php echo $t_tyre_info->datetime->cellAttributes() ?>>
			<span id="el_t_tyre_info_datetime">
<input type="text" data-table="t_tyre_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_tyre_info->datetime->getPlaceHolder()) ?>" value="<?php echo $t_tyre_info->datetime->EditValue ?>"<?php echo $t_tyre_info->datetime->editAttributes() ?>>
<?php if (!$t_tyre_info->datetime->ReadOnly && !$t_tyre_info->datetime->Disabled && !isset($t_tyre_info->datetime->EditAttrs["readonly"]) && !isset($t_tyre_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_tyre_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_tyre_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_tyre_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_tyre_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_tyre_info_search->terminate();
?>