<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_tyre_info_view = new t_tyre_info_view();

// Run the page
$t_tyre_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_tyre_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_tyre_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_tyre_infoview = currentForm = new ew.Form("ft_tyre_infoview", "view");

// Form_CustomValidate event
ft_tyre_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_tyre_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_tyre_infoview.lists["x_vehicle_no"] = <?php echo $t_tyre_info_view->vehicle_no->Lookup->toClientList() ?>;
ft_tyre_infoview.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_tyre_info_view->vehicle_no->lookupOptions()) ?>;
ft_tyre_infoview.lists["x_head"] = <?php echo $t_tyre_info_view->head->Lookup->toClientList() ?>;
ft_tyre_infoview.lists["x_head"].options = <?php echo JsonEncode($t_tyre_info_view->head->lookupOptions()) ?>;
ft_tyre_infoview.lists["x_sub_head"] = <?php echo $t_tyre_info_view->sub_head->Lookup->toClientList() ?>;
ft_tyre_infoview.lists["x_sub_head"].options = <?php echo JsonEncode($t_tyre_info_view->sub_head->lookupOptions()) ?>;
ft_tyre_infoview.lists["x_status"] = <?php echo $t_tyre_info_view->status->Lookup->toClientList() ?>;
ft_tyre_infoview.lists["x_status"].options = <?php echo JsonEncode($t_tyre_info_view->status->options(FALSE, TRUE)) ?>;
ft_tyre_infoview.lists["x_operator"] = <?php echo $t_tyre_info_view->operator->Lookup->toClientList() ?>;
ft_tyre_infoview.lists["x_operator"].options = <?php echo JsonEncode($t_tyre_info_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_tyre_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_tyre_info_view->ExportOptions->render("body") ?>
<?php $t_tyre_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_tyre_info_view->showPageHeader(); ?>
<?php
$t_tyre_info_view->showMessage();
?>
<form name="ft_tyre_infoview" id="ft_tyre_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_tyre_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_tyre_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_tyre_info">
<input type="hidden" name="modal" value="<?php echo (int)$t_tyre_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_tyre_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_id"><?php echo $t_tyre_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_tyre_info->id->cellAttributes() ?>>
<span id="el_t_tyre_info_id">
<span<?php echo $t_tyre_info->id->viewAttributes() ?>>
<?php echo $t_tyre_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->vehicle_no->Visible) { // vehicle_no ?>
	<tr id="r_vehicle_no">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_vehicle_no"><?php echo $t_tyre_info->vehicle_no->caption() ?></span></td>
		<td data-name="vehicle_no"<?php echo $t_tyre_info->vehicle_no->cellAttributes() ?>>
<span id="el_t_tyre_info_vehicle_no">
<span<?php echo $t_tyre_info->vehicle_no->viewAttributes() ?>>
<?php echo $t_tyre_info->vehicle_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->head->Visible) { // head ?>
	<tr id="r_head">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_head"><?php echo $t_tyre_info->head->caption() ?></span></td>
		<td data-name="head"<?php echo $t_tyre_info->head->cellAttributes() ?>>
<span id="el_t_tyre_info_head">
<span<?php echo $t_tyre_info->head->viewAttributes() ?>>
<?php echo $t_tyre_info->head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->sub_head->Visible) { // sub_head ?>
	<tr id="r_sub_head">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_sub_head"><?php echo $t_tyre_info->sub_head->caption() ?></span></td>
		<td data-name="sub_head"<?php echo $t_tyre_info->sub_head->cellAttributes() ?>>
<span id="el_t_tyre_info_sub_head">
<span<?php echo $t_tyre_info->sub_head->viewAttributes() ?>>
<?php echo $t_tyre_info->sub_head->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->s_no->Visible) { // s_no ?>
	<tr id="r_s_no">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_s_no"><?php echo $t_tyre_info->s_no->caption() ?></span></td>
		<td data-name="s_no"<?php echo $t_tyre_info->s_no->cellAttributes() ?>>
<span id="el_t_tyre_info_s_no">
<span<?php echo $t_tyre_info->s_no->viewAttributes() ?>>
<?php echo $t_tyre_info->s_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->km->Visible) { // km ?>
	<tr id="r_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_km"><?php echo $t_tyre_info->km->caption() ?></span></td>
		<td data-name="km"<?php echo $t_tyre_info->km->cellAttributes() ?>>
<span id="el_t_tyre_info_km">
<span<?php echo $t_tyre_info->km->viewAttributes() ?>>
<?php echo $t_tyre_info->km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->life_km->Visible) { // life_km ?>
	<tr id="r_life_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_life_km"><?php echo $t_tyre_info->life_km->caption() ?></span></td>
		<td data-name="life_km"<?php echo $t_tyre_info->life_km->cellAttributes() ?>>
<span id="el_t_tyre_info_life_km">
<span<?php echo $t_tyre_info->life_km->viewAttributes() ?>>
<?php echo $t_tyre_info->life_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->recycle_after_km->Visible) { // recycle_after_km ?>
	<tr id="r_recycle_after_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_recycle_after_km"><?php echo $t_tyre_info->recycle_after_km->caption() ?></span></td>
		<td data-name="recycle_after_km"<?php echo $t_tyre_info->recycle_after_km->cellAttributes() ?>>
<span id="el_t_tyre_info_recycle_after_km">
<span<?php echo $t_tyre_info->recycle_after_km->viewAttributes() ?>>
<?php echo $t_tyre_info->recycle_after_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->next_km->Visible) { // next_km ?>
	<tr id="r_next_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_next_km"><?php echo $t_tyre_info->next_km->caption() ?></span></td>
		<td data-name="next_km"<?php echo $t_tyre_info->next_km->cellAttributes() ?>>
<span id="el_t_tyre_info_next_km">
<span<?php echo $t_tyre_info->next_km->viewAttributes() ?>>
<?php echo $t_tyre_info->next_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->recycle_next_km->Visible) { // recycle_next_km ?>
	<tr id="r_recycle_next_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_recycle_next_km"><?php echo $t_tyre_info->recycle_next_km->caption() ?></span></td>
		<td data-name="recycle_next_km"<?php echo $t_tyre_info->recycle_next_km->cellAttributes() ?>>
<span id="el_t_tyre_info_recycle_next_km">
<span<?php echo $t_tyre_info->recycle_next_km->viewAttributes() ?>>
<?php echo $t_tyre_info->recycle_next_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->puncture->Visible) { // puncture ?>
	<tr id="r_puncture">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_puncture"><?php echo $t_tyre_info->puncture->caption() ?></span></td>
		<td data-name="puncture"<?php echo $t_tyre_info->puncture->cellAttributes() ?>>
<span id="el_t_tyre_info_puncture">
<span<?php echo $t_tyre_info->puncture->viewAttributes() ?>>
<?php echo $t_tyre_info->puncture->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->current_km->Visible) { // current_km ?>
	<tr id="r_current_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_current_km"><?php echo $t_tyre_info->current_km->caption() ?></span></td>
		<td data-name="current_km"<?php echo $t_tyre_info->current_km->cellAttributes() ?>>
<span id="el_t_tyre_info_current_km">
<span<?php echo $t_tyre_info->current_km->viewAttributes() ?>>
<?php echo $t_tyre_info->current_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->remaining_km->Visible) { // remaining_km ?>
	<tr id="r_remaining_km">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_remaining_km"><?php echo $t_tyre_info->remaining_km->caption() ?></span></td>
		<td data-name="remaining_km"<?php echo $t_tyre_info->remaining_km->cellAttributes() ?>>
<span id="el_t_tyre_info_remaining_km">
<span<?php echo $t_tyre_info->remaining_km->viewAttributes() ?>>
<?php echo $t_tyre_info->remaining_km->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_remarks"><?php echo $t_tyre_info->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_tyre_info->remarks->cellAttributes() ?>>
<span id="el_t_tyre_info_remarks">
<span<?php echo $t_tyre_info->remarks->viewAttributes() ?>>
<?php echo $t_tyre_info->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_status"><?php echo $t_tyre_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $t_tyre_info->status->cellAttributes() ?>>
<span id="el_t_tyre_info_status">
<span<?php echo $t_tyre_info->status->viewAttributes() ?>>
<?php echo $t_tyre_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_operator"><?php echo $t_tyre_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_tyre_info->operator->cellAttributes() ?>>
<span id="el_t_tyre_info_operator">
<span<?php echo $t_tyre_info->operator->viewAttributes() ?>>
<?php echo $t_tyre_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_tyre_info_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_info_datetime"><?php echo $t_tyre_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_tyre_info->datetime->cellAttributes() ?>>
<span id="el_t_tyre_info_datetime">
<span<?php echo $t_tyre_info->datetime->viewAttributes() ?>>
<?php echo $t_tyre_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_tyre_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_tyre_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_tyre_info_view->terminate();
?>