<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_tyre_maintenance_list = new t_tyre_maintenance_list();

// Run the page
$t_tyre_maintenance_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_tyre_maintenance_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ft_tyre_maintenancelist = currentForm = new ew.Form("ft_tyre_maintenancelist", "list");
ft_tyre_maintenancelist.formKeyCountName = '<?php echo $t_tyre_maintenance_list->FormKeyCountName ?>';

// Form_CustomValidate event
ft_tyre_maintenancelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_tyre_maintenancelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_tyre_maintenancelist.lists["x_vehicle_no"] = <?php echo $t_tyre_maintenance_list->vehicle_no->Lookup->toClientList() ?>;
ft_tyre_maintenancelist.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_tyre_maintenance_list->vehicle_no->lookupOptions()) ?>;
ft_tyre_maintenancelist.lists["x_driver"] = <?php echo $t_tyre_maintenance_list->driver->Lookup->toClientList() ?>;
ft_tyre_maintenancelist.lists["x_driver"].options = <?php echo JsonEncode($t_tyre_maintenance_list->driver->lookupOptions()) ?>;
ft_tyre_maintenancelist.lists["x_tyre_id"] = <?php echo $t_tyre_maintenance_list->tyre_id->Lookup->toClientList() ?>;
ft_tyre_maintenancelist.lists["x_tyre_id"].options = <?php echo JsonEncode($t_tyre_maintenance_list->tyre_id->lookupOptions()) ?>;
ft_tyre_maintenancelist.lists["x_type"] = <?php echo $t_tyre_maintenance_list->type->Lookup->toClientList() ?>;
ft_tyre_maintenancelist.lists["x_type"].options = <?php echo JsonEncode($t_tyre_maintenance_list->type->options(FALSE, TRUE)) ?>;

// Form object for search
var ft_tyre_maintenancelistsrch = currentSearchForm = new ew.Form("ft_tyre_maintenancelistsrch");

// Filters
ft_tyre_maintenancelistsrch.filterList = <?php echo $t_tyre_maintenance_list->getFilterList() ?>;

// Init search panel as collapsed
ft_tyre_maintenancelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($t_tyre_maintenance_list->TotalRecs > 0 && $t_tyre_maintenance_list->ExportOptions->visible()) { ?>
<?php $t_tyre_maintenance_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($t_tyre_maintenance_list->ImportOptions->visible()) { ?>
<?php $t_tyre_maintenance_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($t_tyre_maintenance_list->SearchOptions->visible()) { ?>
<?php $t_tyre_maintenance_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($t_tyre_maintenance_list->FilterOptions->visible()) { ?>
<?php $t_tyre_maintenance_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$t_tyre_maintenance_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$t_tyre_maintenance->isExport() && !$t_tyre_maintenance->CurrentAction) { ?>
<form name="ft_tyre_maintenancelistsrch" id="ft_tyre_maintenancelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($t_tyre_maintenance_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ft_tyre_maintenancelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="t_tyre_maintenance">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($t_tyre_maintenance_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($t_tyre_maintenance_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $t_tyre_maintenance_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($t_tyre_maintenance_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($t_tyre_maintenance_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($t_tyre_maintenance_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($t_tyre_maintenance_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $t_tyre_maintenance_list->showPageHeader(); ?>
<?php
$t_tyre_maintenance_list->showMessage();
?>
<?php if ($t_tyre_maintenance_list->TotalRecs > 0 || $t_tyre_maintenance->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($t_tyre_maintenance_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> t_tyre_maintenance">
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$t_tyre_maintenance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_tyre_maintenance_list->Pager)) $t_tyre_maintenance_list->Pager = new PrevNextPager($t_tyre_maintenance_list->StartRec, $t_tyre_maintenance_list->DisplayRecs, $t_tyre_maintenance_list->TotalRecs, $t_tyre_maintenance_list->AutoHidePager) ?>
<?php if ($t_tyre_maintenance_list->Pager->RecordCount > 0 && $t_tyre_maintenance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_tyre_maintenance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_tyre_maintenance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_tyre_maintenance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_tyre_maintenance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_tyre_maintenance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_tyre_maintenance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_tyre_maintenance_list->TotalRecs > 0 && (!$t_tyre_maintenance_list->AutoHidePageSizeSelector || $t_tyre_maintenance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_tyre_maintenance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_tyre_maintenance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_tyre_maintenance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_tyre_maintenance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_tyre_maintenance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_tyre_maintenance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_tyre_maintenance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_tyre_maintenance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ft_tyre_maintenancelist" id="ft_tyre_maintenancelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_tyre_maintenance_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_tyre_maintenance_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_tyre_maintenance">
<div id="gmp_t_tyre_maintenance" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($t_tyre_maintenance_list->TotalRecs > 0 || $t_tyre_maintenance->isGridEdit()) { ?>
<table id="tbl_t_tyre_maintenancelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$t_tyre_maintenance_list->RowType = ROWTYPE_HEADER;

// Render list options
$t_tyre_maintenance_list->renderListOptions();

// Render list options (header, left)
$t_tyre_maintenance_list->ListOptions->render("header", "left");
?>
<?php if ($t_tyre_maintenance->id->Visible) { // id ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->id) == "") { ?>
		<th data-name="id" class="<?php echo $t_tyre_maintenance->id->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_id" class="t_tyre_maintenance_id"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $t_tyre_maintenance->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->id) ?>',2);"><div id="elh_t_tyre_maintenance_id" class="t_tyre_maintenance_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->vehicle_no->Visible) { // vehicle_no ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->vehicle_no) == "") { ?>
		<th data-name="vehicle_no" class="<?php echo $t_tyre_maintenance->vehicle_no->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_vehicle_no" class="t_tyre_maintenance_vehicle_no"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->vehicle_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_no" class="<?php echo $t_tyre_maintenance->vehicle_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->vehicle_no) ?>',2);"><div id="elh_t_tyre_maintenance_vehicle_no" class="t_tyre_maintenance_vehicle_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->vehicle_no->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->vehicle_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->vehicle_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->driver->Visible) { // driver ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->driver) == "") { ?>
		<th data-name="driver" class="<?php echo $t_tyre_maintenance->driver->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_driver" class="t_tyre_maintenance_driver"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->driver->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver" class="<?php echo $t_tyre_maintenance->driver->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->driver) ?>',2);"><div id="elh_t_tyre_maintenance_driver" class="t_tyre_maintenance_driver">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->driver->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->driver->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->driver->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->tyre_id->Visible) { // tyre_id ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->tyre_id) == "") { ?>
		<th data-name="tyre_id" class="<?php echo $t_tyre_maintenance->tyre_id->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_tyre_id" class="t_tyre_maintenance_tyre_id"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->tyre_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tyre_id" class="<?php echo $t_tyre_maintenance->tyre_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->tyre_id) ?>',2);"><div id="elh_t_tyre_maintenance_tyre_id" class="t_tyre_maintenance_tyre_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->tyre_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->tyre_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->tyre_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->type->Visible) { // type ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->type) == "") { ?>
		<th data-name="type" class="<?php echo $t_tyre_maintenance->type->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_type" class="t_tyre_maintenance_type"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $t_tyre_maintenance->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->type) ?>',2);"><div id="elh_t_tyre_maintenance_type" class="t_tyre_maintenance_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->no->Visible) { // no ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->no) == "") { ?>
		<th data-name="no" class="<?php echo $t_tyre_maintenance->no->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_no" class="t_tyre_maintenance_no"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no" class="<?php echo $t_tyre_maintenance->no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->no) ?>',2);"><div id="elh_t_tyre_maintenance_no" class="t_tyre_maintenance_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->no->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->old_puncture->Visible) { // old_puncture ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->old_puncture) == "") { ?>
		<th data-name="old_puncture" class="<?php echo $t_tyre_maintenance->old_puncture->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_old_puncture" class="t_tyre_maintenance_old_puncture"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->old_puncture->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="old_puncture" class="<?php echo $t_tyre_maintenance->old_puncture->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->old_puncture) ?>',2);"><div id="elh_t_tyre_maintenance_old_puncture" class="t_tyre_maintenance_old_puncture">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->old_puncture->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->old_puncture->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->old_puncture->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->puncture_date->Visible) { // puncture_date ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->puncture_date) == "") { ?>
		<th data-name="puncture_date" class="<?php echo $t_tyre_maintenance->puncture_date->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_puncture_date" class="t_tyre_maintenance_puncture_date"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->puncture_date->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="puncture_date" class="<?php echo $t_tyre_maintenance->puncture_date->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->puncture_date) ?>',2);"><div id="elh_t_tyre_maintenance_puncture_date" class="t_tyre_maintenance_puncture_date">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->puncture_date->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->puncture_date->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->puncture_date->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->remarks->Visible) { // remarks ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->remarks) == "") { ?>
		<th data-name="remarks" class="<?php echo $t_tyre_maintenance->remarks->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_remarks" class="t_tyre_maintenance_remarks"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->remarks->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="remarks" class="<?php echo $t_tyre_maintenance->remarks->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->remarks) ?>',2);"><div id="elh_t_tyre_maintenance_remarks" class="t_tyre_maintenance_remarks">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->remarks->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->remarks->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->remarks->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->operator->Visible) { // operator ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $t_tyre_maintenance->operator->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_operator" class="t_tyre_maintenance_operator"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $t_tyre_maintenance->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->operator) ?>',2);"><div id="elh_t_tyre_maintenance_operator" class="t_tyre_maintenance_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($t_tyre_maintenance->datetime->Visible) { // datetime ?>
	<?php if ($t_tyre_maintenance->sortUrl($t_tyre_maintenance->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $t_tyre_maintenance->datetime->headerCellClass() ?>"><div id="elh_t_tyre_maintenance_datetime" class="t_tyre_maintenance_datetime"><div class="ew-table-header-caption"><?php echo $t_tyre_maintenance->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $t_tyre_maintenance->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $t_tyre_maintenance->SortUrl($t_tyre_maintenance->datetime) ?>',2);"><div id="elh_t_tyre_maintenance_datetime" class="t_tyre_maintenance_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $t_tyre_maintenance->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($t_tyre_maintenance->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($t_tyre_maintenance->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$t_tyre_maintenance_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($t_tyre_maintenance->ExportAll && $t_tyre_maintenance->isExport()) {
	$t_tyre_maintenance_list->StopRec = $t_tyre_maintenance_list->TotalRecs;
} else {

	// Set the last record to display
	if ($t_tyre_maintenance_list->TotalRecs > $t_tyre_maintenance_list->StartRec + $t_tyre_maintenance_list->DisplayRecs - 1)
		$t_tyre_maintenance_list->StopRec = $t_tyre_maintenance_list->StartRec + $t_tyre_maintenance_list->DisplayRecs - 1;
	else
		$t_tyre_maintenance_list->StopRec = $t_tyre_maintenance_list->TotalRecs;
}
$t_tyre_maintenance_list->RecCnt = $t_tyre_maintenance_list->StartRec - 1;
if ($t_tyre_maintenance_list->Recordset && !$t_tyre_maintenance_list->Recordset->EOF) {
	$t_tyre_maintenance_list->Recordset->moveFirst();
	$selectLimit = $t_tyre_maintenance_list->UseSelectLimit;
	if (!$selectLimit && $t_tyre_maintenance_list->StartRec > 1)
		$t_tyre_maintenance_list->Recordset->move($t_tyre_maintenance_list->StartRec - 1);
} elseif (!$t_tyre_maintenance->AllowAddDeleteRow && $t_tyre_maintenance_list->StopRec == 0) {
	$t_tyre_maintenance_list->StopRec = $t_tyre_maintenance->GridAddRowCount;
}

// Initialize aggregate
$t_tyre_maintenance->RowType = ROWTYPE_AGGREGATEINIT;
$t_tyre_maintenance->resetAttributes();
$t_tyre_maintenance_list->renderRow();
while ($t_tyre_maintenance_list->RecCnt < $t_tyre_maintenance_list->StopRec) {
	$t_tyre_maintenance_list->RecCnt++;
	if ($t_tyre_maintenance_list->RecCnt >= $t_tyre_maintenance_list->StartRec) {
		$t_tyre_maintenance_list->RowCnt++;

		// Set up key count
		$t_tyre_maintenance_list->KeyCount = $t_tyre_maintenance_list->RowIndex;

		// Init row class and style
		$t_tyre_maintenance->resetAttributes();
		$t_tyre_maintenance->CssClass = "";
		if ($t_tyre_maintenance->isGridAdd()) {
		} else {
			$t_tyre_maintenance_list->loadRowValues($t_tyre_maintenance_list->Recordset); // Load row values
		}
		$t_tyre_maintenance->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$t_tyre_maintenance->RowAttrs = array_merge($t_tyre_maintenance->RowAttrs, array('data-rowindex'=>$t_tyre_maintenance_list->RowCnt, 'id'=>'r' . $t_tyre_maintenance_list->RowCnt . '_t_tyre_maintenance', 'data-rowtype'=>$t_tyre_maintenance->RowType));

		// Render row
		$t_tyre_maintenance_list->renderRow();

		// Render list options
		$t_tyre_maintenance_list->renderListOptions();
?>
	<tr<?php echo $t_tyre_maintenance->rowAttributes() ?>>
<?php

// Render list options (body, left)
$t_tyre_maintenance_list->ListOptions->render("body", "left", $t_tyre_maintenance_list->RowCnt);
?>
	<?php if ($t_tyre_maintenance->id->Visible) { // id ?>
		<td data-name="id"<?php echo $t_tyre_maintenance->id->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_id" class="t_tyre_maintenance_id">
<span<?php echo $t_tyre_maintenance->id->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->vehicle_no->Visible) { // vehicle_no ?>
		<td data-name="vehicle_no"<?php echo $t_tyre_maintenance->vehicle_no->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_vehicle_no" class="t_tyre_maintenance_vehicle_no">
<span<?php echo $t_tyre_maintenance->vehicle_no->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->vehicle_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->driver->Visible) { // driver ?>
		<td data-name="driver"<?php echo $t_tyre_maintenance->driver->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_driver" class="t_tyre_maintenance_driver">
<span<?php echo $t_tyre_maintenance->driver->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->driver->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->tyre_id->Visible) { // tyre_id ?>
		<td data-name="tyre_id"<?php echo $t_tyre_maintenance->tyre_id->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_tyre_id" class="t_tyre_maintenance_tyre_id">
<span<?php echo $t_tyre_maintenance->tyre_id->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->tyre_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->type->Visible) { // type ?>
		<td data-name="type"<?php echo $t_tyre_maintenance->type->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_type" class="t_tyre_maintenance_type">
<span<?php echo $t_tyre_maintenance->type->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->no->Visible) { // no ?>
		<td data-name="no"<?php echo $t_tyre_maintenance->no->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_no" class="t_tyre_maintenance_no">
<span<?php echo $t_tyre_maintenance->no->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->old_puncture->Visible) { // old_puncture ?>
		<td data-name="old_puncture"<?php echo $t_tyre_maintenance->old_puncture->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_old_puncture" class="t_tyre_maintenance_old_puncture">
<span<?php echo $t_tyre_maintenance->old_puncture->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->old_puncture->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->puncture_date->Visible) { // puncture_date ?>
		<td data-name="puncture_date"<?php echo $t_tyre_maintenance->puncture_date->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_puncture_date" class="t_tyre_maintenance_puncture_date">
<span<?php echo $t_tyre_maintenance->puncture_date->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->puncture_date->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->remarks->Visible) { // remarks ?>
		<td data-name="remarks"<?php echo $t_tyre_maintenance->remarks->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_remarks" class="t_tyre_maintenance_remarks">
<span<?php echo $t_tyre_maintenance->remarks->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->remarks->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $t_tyre_maintenance->operator->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_operator" class="t_tyre_maintenance_operator">
<span<?php echo $t_tyre_maintenance->operator->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($t_tyre_maintenance->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $t_tyre_maintenance->datetime->cellAttributes() ?>>
<span id="el<?php echo $t_tyre_maintenance_list->RowCnt ?>_t_tyre_maintenance_datetime" class="t_tyre_maintenance_datetime">
<span<?php echo $t_tyre_maintenance->datetime->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$t_tyre_maintenance_list->ListOptions->render("body", "right", $t_tyre_maintenance_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$t_tyre_maintenance->isGridAdd())
		$t_tyre_maintenance_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$t_tyre_maintenance->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($t_tyre_maintenance_list->Recordset)
	$t_tyre_maintenance_list->Recordset->Close();
?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$t_tyre_maintenance->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($t_tyre_maintenance_list->Pager)) $t_tyre_maintenance_list->Pager = new PrevNextPager($t_tyre_maintenance_list->StartRec, $t_tyre_maintenance_list->DisplayRecs, $t_tyre_maintenance_list->TotalRecs, $t_tyre_maintenance_list->AutoHidePager) ?>
<?php if ($t_tyre_maintenance_list->Pager->RecordCount > 0 && $t_tyre_maintenance_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($t_tyre_maintenance_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($t_tyre_maintenance_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $t_tyre_maintenance_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($t_tyre_maintenance_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($t_tyre_maintenance_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $t_tyre_maintenance_list->pageUrl() ?>start=<?php echo $t_tyre_maintenance_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($t_tyre_maintenance_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $t_tyre_maintenance_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($t_tyre_maintenance_list->TotalRecs > 0 && (!$t_tyre_maintenance_list->AutoHidePageSizeSelector || $t_tyre_maintenance_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="t_tyre_maintenance">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($t_tyre_maintenance_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($t_tyre_maintenance_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($t_tyre_maintenance_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($t_tyre_maintenance_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($t_tyre_maintenance_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($t_tyre_maintenance->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $t_tyre_maintenance_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($t_tyre_maintenance_list->TotalRecs == 0 && !$t_tyre_maintenance->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $t_tyre_maintenance_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$t_tyre_maintenance_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<script>
ew.scrollableTable("gmp_t_tyre_maintenance", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_tyre_maintenance_list->terminate();
?>