<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_tyre_maintenance_search = new t_tyre_maintenance_search();

// Run the page
$t_tyre_maintenance_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_tyre_maintenance_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($t_tyre_maintenance_search->IsModal) { ?>
var ft_tyre_maintenancesearch = currentAdvancedSearchForm = new ew.Form("ft_tyre_maintenancesearch", "search");
<?php } else { ?>
var ft_tyre_maintenancesearch = currentForm = new ew.Form("ft_tyre_maintenancesearch", "search");
<?php } ?>

// Form_CustomValidate event
ft_tyre_maintenancesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_tyre_maintenancesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_tyre_maintenancesearch.lists["x_vehicle_no"] = <?php echo $t_tyre_maintenance_search->vehicle_no->Lookup->toClientList() ?>;
ft_tyre_maintenancesearch.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_tyre_maintenance_search->vehicle_no->lookupOptions()) ?>;
ft_tyre_maintenancesearch.lists["x_driver"] = <?php echo $t_tyre_maintenance_search->driver->Lookup->toClientList() ?>;
ft_tyre_maintenancesearch.lists["x_driver"].options = <?php echo JsonEncode($t_tyre_maintenance_search->driver->lookupOptions()) ?>;
ft_tyre_maintenancesearch.lists["x_tyre_id"] = <?php echo $t_tyre_maintenance_search->tyre_id->Lookup->toClientList() ?>;
ft_tyre_maintenancesearch.lists["x_tyre_id"].options = <?php echo JsonEncode($t_tyre_maintenance_search->tyre_id->lookupOptions()) ?>;
ft_tyre_maintenancesearch.lists["x_type"] = <?php echo $t_tyre_maintenance_search->type->Lookup->toClientList() ?>;
ft_tyre_maintenancesearch.lists["x_type"].options = <?php echo JsonEncode($t_tyre_maintenance_search->type->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

ft_tyre_maintenancesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_maintenance->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_no");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_maintenance->no->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_old_puncture");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_maintenance->old_puncture->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_puncture_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_maintenance->puncture_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_maintenance->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($t_tyre_maintenance->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $t_tyre_maintenance_search->showPageHeader(); ?>
<?php
$t_tyre_maintenance_search->showMessage();
?>
<form name="ft_tyre_maintenancesearch" id="ft_tyre_maintenancesearch" class="<?php echo $t_tyre_maintenance_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_tyre_maintenance_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_tyre_maintenance_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_tyre_maintenance">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$t_tyre_maintenance_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($t_tyre_maintenance->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_id"><?php echo $t_tyre_maintenance->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->id->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_id">
<input type="text" data-table="t_tyre_maintenance" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->id->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->id->EditValue ?>"<?php echo $t_tyre_maintenance->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->vehicle_no->Visible) { // vehicle_no ?>
	<div id="r_vehicle_no" class="form-group row">
		<label for="x_vehicle_no" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_vehicle_no"><?php echo $t_tyre_maintenance->vehicle_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_no" id="z_vehicle_no" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->vehicle_no->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_vehicle_no">
<?php $t_tyre_maintenance->vehicle_no->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$t_tyre_maintenance->vehicle_no->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_maintenance" data-field="x_vehicle_no" data-value-separator="<?php echo $t_tyre_maintenance->vehicle_no->displayValueSeparatorAttribute() ?>" id="x_vehicle_no" name="x_vehicle_no"<?php echo $t_tyre_maintenance->vehicle_no->editAttributes() ?>>
		<?php echo $t_tyre_maintenance->vehicle_no->selectOptionListHtml("x_vehicle_no") ?>
	</select>
</div>
<?php echo $t_tyre_maintenance->vehicle_no->Lookup->getParamTag("p_x_vehicle_no") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label for="x_driver" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_driver"><?php echo $t_tyre_maintenance->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->driver->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_maintenance" data-field="x_driver" data-value-separator="<?php echo $t_tyre_maintenance->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $t_tyre_maintenance->driver->editAttributes() ?>>
		<?php echo $t_tyre_maintenance->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $t_tyre_maintenance->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->tyre_id->Visible) { // tyre_id ?>
	<div id="r_tyre_id" class="form-group row">
		<label for="x_tyre_id" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_tyre_id"><?php echo $t_tyre_maintenance->tyre_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_tyre_id" id="z_tyre_id" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->tyre_id->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_tyre_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="t_tyre_maintenance" data-field="x_tyre_id" data-value-separator="<?php echo $t_tyre_maintenance->tyre_id->displayValueSeparatorAttribute() ?>" id="x_tyre_id" name="x_tyre_id"<?php echo $t_tyre_maintenance->tyre_id->editAttributes() ?>>
		<?php echo $t_tyre_maintenance->tyre_id->selectOptionListHtml("x_tyre_id") ?>
	</select>
</div>
<?php echo $t_tyre_maintenance->tyre_id->Lookup->getParamTag("p_x_tyre_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_type"><?php echo $t_tyre_maintenance->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->type->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_type">
<div id="tp_x_type" class="ew-template"><input type="radio" class="form-check-input" data-table="t_tyre_maintenance" data-field="x_type" data-value-separator="<?php echo $t_tyre_maintenance->type->displayValueSeparatorAttribute() ?>" name="x_type" id="x_type" value="{value}"<?php echo $t_tyre_maintenance->type->editAttributes() ?>></div>
<div id="dsl_x_type" data-repeatcolumn="5" class="ew-item-list d-none"><div>
<?php echo $t_tyre_maintenance->type->radioButtonListHtml(FALSE, "x_type") ?>
</div></div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label for="x_no" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_no"><?php echo $t_tyre_maintenance->no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_no" id="z_no" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->no->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_no">
<input type="text" data-table="t_tyre_maintenance" data-field="x_no" name="x_no" id="x_no" size="30" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->no->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->no->EditValue ?>"<?php echo $t_tyre_maintenance->no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->old_puncture->Visible) { // old_puncture ?>
	<div id="r_old_puncture" class="form-group row">
		<label for="x_old_puncture" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_old_puncture"><?php echo $t_tyre_maintenance->old_puncture->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_old_puncture" id="z_old_puncture" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->old_puncture->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_old_puncture">
<input type="text" data-table="t_tyre_maintenance" data-field="x_old_puncture" name="x_old_puncture" id="x_old_puncture" size="30" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->old_puncture->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->old_puncture->EditValue ?>"<?php echo $t_tyre_maintenance->old_puncture->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->puncture_date->Visible) { // puncture_date ?>
	<div id="r_puncture_date" class="form-group row">
		<label for="x_puncture_date" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_puncture_date"><?php echo $t_tyre_maintenance->puncture_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_puncture_date" id="z_puncture_date" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->puncture_date->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_puncture_date">
<input type="text" data-table="t_tyre_maintenance" data-field="x_puncture_date" name="x_puncture_date" id="x_puncture_date" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->puncture_date->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->puncture_date->EditValue ?>"<?php echo $t_tyre_maintenance->puncture_date->editAttributes() ?>>
<?php if (!$t_tyre_maintenance->puncture_date->ReadOnly && !$t_tyre_maintenance->puncture_date->Disabled && !isset($t_tyre_maintenance->puncture_date->EditAttrs["readonly"]) && !isset($t_tyre_maintenance->puncture_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_tyre_maintenancesearch", "x_puncture_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_remarks"><?php echo $t_tyre_maintenance->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->remarks->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_remarks">
<input type="text" data-table="t_tyre_maintenance" data-field="x_remarks" name="x_remarks" id="x_remarks" maxlength="192" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->remarks->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->remarks->EditValue ?>"<?php echo $t_tyre_maintenance->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_operator"><?php echo $t_tyre_maintenance->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->operator->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_operator">
<input type="text" data-table="t_tyre_maintenance" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->operator->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->operator->EditValue ?>"<?php echo $t_tyre_maintenance->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($t_tyre_maintenance->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $t_tyre_maintenance_search->LeftColumnClass ?>"><span id="elh_t_tyre_maintenance_datetime"><?php echo $t_tyre_maintenance->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $t_tyre_maintenance_search->RightColumnClass ?>"><div<?php echo $t_tyre_maintenance->datetime->cellAttributes() ?>>
			<span id="el_t_tyre_maintenance_datetime">
<input type="text" data-table="t_tyre_maintenance" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($t_tyre_maintenance->datetime->getPlaceHolder()) ?>" value="<?php echo $t_tyre_maintenance->datetime->EditValue ?>"<?php echo $t_tyre_maintenance->datetime->editAttributes() ?>>
<?php if (!$t_tyre_maintenance->datetime->ReadOnly && !$t_tyre_maintenance->datetime->Disabled && !isset($t_tyre_maintenance->datetime->EditAttrs["readonly"]) && !isset($t_tyre_maintenance->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ft_tyre_maintenancesearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$t_tyre_maintenance_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $t_tyre_maintenance_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$t_tyre_maintenance_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$t_tyre_maintenance_search->terminate();
?>