<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$t_tyre_maintenance_view = new t_tyre_maintenance_view();

// Run the page
$t_tyre_maintenance_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$t_tyre_maintenance_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ft_tyre_maintenanceview = currentForm = new ew.Form("ft_tyre_maintenanceview", "view");

// Form_CustomValidate event
ft_tyre_maintenanceview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ft_tyre_maintenanceview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ft_tyre_maintenanceview.lists["x_vehicle_no"] = <?php echo $t_tyre_maintenance_view->vehicle_no->Lookup->toClientList() ?>;
ft_tyre_maintenanceview.lists["x_vehicle_no"].options = <?php echo JsonEncode($t_tyre_maintenance_view->vehicle_no->lookupOptions()) ?>;
ft_tyre_maintenanceview.lists["x_driver"] = <?php echo $t_tyre_maintenance_view->driver->Lookup->toClientList() ?>;
ft_tyre_maintenanceview.lists["x_driver"].options = <?php echo JsonEncode($t_tyre_maintenance_view->driver->lookupOptions()) ?>;
ft_tyre_maintenanceview.lists["x_tyre_id"] = <?php echo $t_tyre_maintenance_view->tyre_id->Lookup->toClientList() ?>;
ft_tyre_maintenanceview.lists["x_tyre_id"].options = <?php echo JsonEncode($t_tyre_maintenance_view->tyre_id->lookupOptions()) ?>;
ft_tyre_maintenanceview.lists["x_type"] = <?php echo $t_tyre_maintenance_view->type->Lookup->toClientList() ?>;
ft_tyre_maintenanceview.lists["x_type"].options = <?php echo JsonEncode($t_tyre_maintenance_view->type->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $t_tyre_maintenance_view->ExportOptions->render("body") ?>
<?php $t_tyre_maintenance_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $t_tyre_maintenance_view->showPageHeader(); ?>
<?php
$t_tyre_maintenance_view->showMessage();
?>
<form name="ft_tyre_maintenanceview" id="ft_tyre_maintenanceview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($t_tyre_maintenance_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $t_tyre_maintenance_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="t_tyre_maintenance">
<input type="hidden" name="modal" value="<?php echo (int)$t_tyre_maintenance_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($t_tyre_maintenance->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_id"><?php echo $t_tyre_maintenance->id->caption() ?></span></td>
		<td data-name="id"<?php echo $t_tyre_maintenance->id->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_id">
<span<?php echo $t_tyre_maintenance->id->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->vehicle_no->Visible) { // vehicle_no ?>
	<tr id="r_vehicle_no">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_vehicle_no"><?php echo $t_tyre_maintenance->vehicle_no->caption() ?></span></td>
		<td data-name="vehicle_no"<?php echo $t_tyre_maintenance->vehicle_no->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_vehicle_no">
<span<?php echo $t_tyre_maintenance->vehicle_no->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->vehicle_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->driver->Visible) { // driver ?>
	<tr id="r_driver">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_driver"><?php echo $t_tyre_maintenance->driver->caption() ?></span></td>
		<td data-name="driver"<?php echo $t_tyre_maintenance->driver->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_driver">
<span<?php echo $t_tyre_maintenance->driver->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->driver->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->tyre_id->Visible) { // tyre_id ?>
	<tr id="r_tyre_id">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_tyre_id"><?php echo $t_tyre_maintenance->tyre_id->caption() ?></span></td>
		<td data-name="tyre_id"<?php echo $t_tyre_maintenance->tyre_id->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_tyre_id">
<span<?php echo $t_tyre_maintenance->tyre_id->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->tyre_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_type"><?php echo $t_tyre_maintenance->type->caption() ?></span></td>
		<td data-name="type"<?php echo $t_tyre_maintenance->type->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_type">
<span<?php echo $t_tyre_maintenance->type->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->no->Visible) { // no ?>
	<tr id="r_no">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_no"><?php echo $t_tyre_maintenance->no->caption() ?></span></td>
		<td data-name="no"<?php echo $t_tyre_maintenance->no->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_no">
<span<?php echo $t_tyre_maintenance->no->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->old_puncture->Visible) { // old_puncture ?>
	<tr id="r_old_puncture">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_old_puncture"><?php echo $t_tyre_maintenance->old_puncture->caption() ?></span></td>
		<td data-name="old_puncture"<?php echo $t_tyre_maintenance->old_puncture->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_old_puncture">
<span<?php echo $t_tyre_maintenance->old_puncture->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->old_puncture->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->puncture_date->Visible) { // puncture_date ?>
	<tr id="r_puncture_date">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_puncture_date"><?php echo $t_tyre_maintenance->puncture_date->caption() ?></span></td>
		<td data-name="puncture_date"<?php echo $t_tyre_maintenance->puncture_date->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_puncture_date">
<span<?php echo $t_tyre_maintenance->puncture_date->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->puncture_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->remarks->Visible) { // remarks ?>
	<tr id="r_remarks">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_remarks"><?php echo $t_tyre_maintenance->remarks->caption() ?></span></td>
		<td data-name="remarks"<?php echo $t_tyre_maintenance->remarks->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_remarks">
<span<?php echo $t_tyre_maintenance->remarks->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->remarks->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_operator"><?php echo $t_tyre_maintenance->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $t_tyre_maintenance->operator->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_operator">
<span<?php echo $t_tyre_maintenance->operator->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($t_tyre_maintenance->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $t_tyre_maintenance_view->TableLeftColumnClass ?>"><span id="elh_t_tyre_maintenance_datetime"><?php echo $t_tyre_maintenance->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $t_tyre_maintenance->datetime->cellAttributes() ?>>
<span id="el_t_tyre_maintenance_datetime">
<span<?php echo $t_tyre_maintenance->datetime->viewAttributes() ?>>
<?php echo $t_tyre_maintenance->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$t_tyre_maintenance_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$t_tyre_maintenance->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$t_tyre_maintenance_view->terminate();
?>