<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tax_category_add = new tax_category_add();

// Run the page
$tax_category_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tax_category_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var ftax_categoryadd = currentForm = new ew.Form("ftax_categoryadd", "add");

// Validate form
ftax_categoryadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($tax_category_add->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->grp->caption(), $tax_category->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_add->tax_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->tax_percent->caption(), $tax_category->tax_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tax_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($tax_category->tax_percent->errorMessage()) ?>");
		<?php if ($tax_category_add->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->item->caption(), $tax_category->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_add->hsn_code->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->hsn_code->caption(), $tax_category->hsn_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->status->caption(), $tax_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->operator->caption(), $tax_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->datetime->caption(), $tax_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ftax_categoryadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftax_categoryadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftax_categoryadd.lists["x_grp"] = <?php echo $tax_category_add->grp->Lookup->toClientList() ?>;
ftax_categoryadd.lists["x_grp"].options = <?php echo JsonEncode($tax_category_add->grp->lookupOptions()) ?>;
ftax_categoryadd.lists["x_status"] = <?php echo $tax_category_add->status->Lookup->toClientList() ?>;
ftax_categoryadd.lists["x_status"].options = <?php echo JsonEncode($tax_category_add->status->options(FALSE, TRUE)) ?>;
ftax_categoryadd.lists["x_operator"] = <?php echo $tax_category_add->operator->Lookup->toClientList() ?>;
ftax_categoryadd.lists["x_operator"].options = <?php echo JsonEncode($tax_category_add->operator->lookupOptions()) ?>;
ftax_categoryadd.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tax_category_add->showPageHeader(); ?>
<?php
$tax_category_add->showMessage();
?>
<form name="ftax_categoryadd" id="ftax_categoryadd" class="<?php echo $tax_category_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tax_category_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tax_category_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tax_category">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$tax_category_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($tax_category->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label id="elh_tax_category_grp" for="x_grp" class="<?php echo $tax_category_add->LeftColumnClass ?>"><?php echo $tax_category->grp->caption() ?><?php echo ($tax_category->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tax_category_add->RightColumnClass ?>"><div<?php echo $tax_category->grp->cellAttributes() ?>>
<span id="el_tax_category_grp">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tax_category" data-field="x_grp" data-value-separator="<?php echo $tax_category->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $tax_category->grp->editAttributes() ?>>
		<?php echo $tax_category->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $tax_category->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
<?php echo $tax_category->grp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
	<div id="r_tax_percent" class="form-group row">
		<label id="elh_tax_category_tax_percent" for="x_tax_percent" class="<?php echo $tax_category_add->LeftColumnClass ?>"><?php echo $tax_category->tax_percent->caption() ?><?php echo ($tax_category->tax_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tax_category_add->RightColumnClass ?>"><div<?php echo $tax_category->tax_percent->cellAttributes() ?>>
<span id="el_tax_category_tax_percent">
<input type="text" data-table="tax_category" data-field="x_tax_percent" name="x_tax_percent" id="x_tax_percent" size="30" placeholder="<?php echo HtmlEncode($tax_category->tax_percent->getPlaceHolder()) ?>" value="<?php echo $tax_category->tax_percent->EditValue ?>"<?php echo $tax_category->tax_percent->editAttributes() ?>>
</span>
<?php echo $tax_category->tax_percent->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tax_category->item->Visible) { // item ?>
	<div id="r_item" class="form-group row">
		<label id="elh_tax_category_item" for="x_item" class="<?php echo $tax_category_add->LeftColumnClass ?>"><?php echo $tax_category->item->caption() ?><?php echo ($tax_category->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tax_category_add->RightColumnClass ?>"><div<?php echo $tax_category->item->cellAttributes() ?>>
<span id="el_tax_category_item">
<input type="text" data-table="tax_category" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($tax_category->item->getPlaceHolder()) ?>" value="<?php echo $tax_category->item->EditValue ?>"<?php echo $tax_category->item->editAttributes() ?>>
</span>
<?php echo $tax_category->item->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
	<div id="r_hsn_code" class="form-group row">
		<label id="elh_tax_category_hsn_code" for="x_hsn_code" class="<?php echo $tax_category_add->LeftColumnClass ?>"><?php echo $tax_category->hsn_code->caption() ?><?php echo ($tax_category->hsn_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tax_category_add->RightColumnClass ?>"><div<?php echo $tax_category->hsn_code->cellAttributes() ?>>
<span id="el_tax_category_hsn_code">
<input type="text" data-table="tax_category" data-field="x_hsn_code" name="x_hsn_code" id="x_hsn_code" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($tax_category->hsn_code->getPlaceHolder()) ?>" value="<?php echo $tax_category->hsn_code->EditValue ?>"<?php echo $tax_category->hsn_code->editAttributes() ?>>
</span>
<?php echo $tax_category->hsn_code->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tax_category->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_tax_category_status" for="x_status" class="<?php echo $tax_category_add->LeftColumnClass ?>"><?php echo $tax_category->status->caption() ?><?php echo ($tax_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tax_category_add->RightColumnClass ?>"><div<?php echo $tax_category->status->cellAttributes() ?>>
<span id="el_tax_category_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tax_category" data-field="x_status" data-value-separator="<?php echo $tax_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $tax_category->status->editAttributes() ?>>
		<?php echo $tax_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $tax_category->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$tax_category_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tax_category_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tax_category_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tax_category_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tax_category_add->terminate();
?>