<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tax_category_addopt = new tax_category_addopt();

// Run the page
$tax_category_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tax_category_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var ftax_categoryaddopt = currentForm = new ew.Form("ftax_categoryaddopt", "addopt");

// Validate form
ftax_categoryaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($tax_category_addopt->grp->Required) { ?>
			elm = this.getElements("x" + infix + "_grp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->grp->caption(), $tax_category->grp->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_addopt->tax_percent->Required) { ?>
			elm = this.getElements("x" + infix + "_tax_percent");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->tax_percent->caption(), $tax_category->tax_percent->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_tax_percent");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($tax_category->tax_percent->errorMessage()) ?>");
		<?php if ($tax_category_addopt->item->Required) { ?>
			elm = this.getElements("x" + infix + "_item");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->item->caption(), $tax_category->item->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_addopt->hsn_code->Required) { ?>
			elm = this.getElements("x" + infix + "_hsn_code");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->hsn_code->caption(), $tax_category->hsn_code->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_addopt->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->status->caption(), $tax_category->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->operator->caption(), $tax_category->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tax_category_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tax_category->datetime->caption(), $tax_category->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
ftax_categoryaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftax_categoryaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftax_categoryaddopt.lists["x_grp"] = <?php echo $tax_category_addopt->grp->Lookup->toClientList() ?>;
ftax_categoryaddopt.lists["x_grp"].options = <?php echo JsonEncode($tax_category_addopt->grp->lookupOptions()) ?>;
ftax_categoryaddopt.lists["x_status"] = <?php echo $tax_category_addopt->status->Lookup->toClientList() ?>;
ftax_categoryaddopt.lists["x_status"].options = <?php echo JsonEncode($tax_category_addopt->status->options(FALSE, TRUE)) ?>;
ftax_categoryaddopt.lists["x_operator"] = <?php echo $tax_category_addopt->operator->Lookup->toClientList() ?>;
ftax_categoryaddopt.lists["x_operator"].options = <?php echo JsonEncode($tax_category_addopt->operator->lookupOptions()) ?>;
ftax_categoryaddopt.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tax_category_addopt->showPageHeader(); ?>
<?php
$tax_category_addopt->showMessage();
?>
<form name="ftax_categoryaddopt" id="ftax_categoryaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($tax_category_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tax_category_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $tax_category_addopt->TableVar ?>">
<?php if ($tax_category->grp->Visible) { // grp ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_grp"><?php echo $tax_category->grp->caption() ?><?php echo ($tax_category->grp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tax_category" data-field="x_grp" data-value-separator="<?php echo $tax_category->grp->displayValueSeparatorAttribute() ?>" id="x_grp" name="x_grp"<?php echo $tax_category->grp->editAttributes() ?>>
		<?php echo $tax_category->grp->selectOptionListHtml("x_grp") ?>
	</select>
</div>
<?php echo $tax_category->grp->Lookup->getParamTag("p_x_grp") ?>
<?php echo $tax_category->grp->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_tax_percent"><?php echo $tax_category->tax_percent->caption() ?><?php echo ($tax_category->tax_percent->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="tax_category" data-field="x_tax_percent" name="x_tax_percent" id="x_tax_percent" size="30" placeholder="<?php echo HtmlEncode($tax_category->tax_percent->getPlaceHolder()) ?>" value="<?php echo $tax_category->tax_percent->EditValue ?>"<?php echo $tax_category->tax_percent->editAttributes() ?>>
<?php echo $tax_category->tax_percent->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($tax_category->item->Visible) { // item ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_item"><?php echo $tax_category->item->caption() ?><?php echo ($tax_category->item->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="tax_category" data-field="x_item" name="x_item" id="x_item" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($tax_category->item->getPlaceHolder()) ?>" value="<?php echo $tax_category->item->EditValue ?>"<?php echo $tax_category->item->editAttributes() ?>>
<?php echo $tax_category->item->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_hsn_code"><?php echo $tax_category->hsn_code->caption() ?><?php echo ($tax_category->hsn_code->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="tax_category" data-field="x_hsn_code" name="x_hsn_code" id="x_hsn_code" size="30" maxlength="8" placeholder="<?php echo HtmlEncode($tax_category->hsn_code->getPlaceHolder()) ?>" value="<?php echo $tax_category->hsn_code->EditValue ?>"<?php echo $tax_category->hsn_code->editAttributes() ?>>
<?php echo $tax_category->hsn_code->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($tax_category->status->Visible) { // status ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_status"><?php echo $tax_category->status->caption() ?><?php echo ($tax_category->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tax_category" data-field="x_status" data-value-separator="<?php echo $tax_category->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $tax_category->status->editAttributes() ?>>
		<?php echo $tax_category->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
<?php echo $tax_category->status->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($tax_category->operator->Visible) { // operator ?>
	<input type="hidden" data-table="tax_category" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($tax_category->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($tax_category->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="tax_category" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($tax_category->datetime->CurrentValue) ?>">
	<?php if (!$tax_category->datetime->ReadOnly && !$tax_category->datetime->Disabled && !isset($tax_category->datetime->EditAttrs["readonly"]) && !isset($tax_category->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("ftax_categoryaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$tax_category_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$tax_category_addopt->terminate();
?>