<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tax_category_delete = new tax_category_delete();

// Run the page
$tax_category_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tax_category_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var ftax_categorydelete = currentForm = new ew.Form("ftax_categorydelete", "delete");

// Form_CustomValidate event
ftax_categorydelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftax_categorydelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftax_categorydelete.lists["x_grp"] = <?php echo $tax_category_delete->grp->Lookup->toClientList() ?>;
ftax_categorydelete.lists["x_grp"].options = <?php echo JsonEncode($tax_category_delete->grp->lookupOptions()) ?>;
ftax_categorydelete.lists["x_status"] = <?php echo $tax_category_delete->status->Lookup->toClientList() ?>;
ftax_categorydelete.lists["x_status"].options = <?php echo JsonEncode($tax_category_delete->status->options(FALSE, TRUE)) ?>;
ftax_categorydelete.lists["x_operator"] = <?php echo $tax_category_delete->operator->Lookup->toClientList() ?>;
ftax_categorydelete.lists["x_operator"].options = <?php echo JsonEncode($tax_category_delete->operator->lookupOptions()) ?>;
ftax_categorydelete.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tax_category_delete->showPageHeader(); ?>
<?php
$tax_category_delete->showMessage();
?>
<form name="ftax_categorydelete" id="ftax_categorydelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tax_category_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tax_category_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tax_category">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($tax_category_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($tax_category->id->Visible) { // id ?>
		<th class="<?php echo $tax_category->id->headerCellClass() ?>"><span id="elh_tax_category_id" class="tax_category_id"><?php echo $tax_category->id->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->grp->Visible) { // grp ?>
		<th class="<?php echo $tax_category->grp->headerCellClass() ?>"><span id="elh_tax_category_grp" class="tax_category_grp"><?php echo $tax_category->grp->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
		<th class="<?php echo $tax_category->tax_percent->headerCellClass() ?>"><span id="elh_tax_category_tax_percent" class="tax_category_tax_percent"><?php echo $tax_category->tax_percent->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->item->Visible) { // item ?>
		<th class="<?php echo $tax_category->item->headerCellClass() ?>"><span id="elh_tax_category_item" class="tax_category_item"><?php echo $tax_category->item->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
		<th class="<?php echo $tax_category->hsn_code->headerCellClass() ?>"><span id="elh_tax_category_hsn_code" class="tax_category_hsn_code"><?php echo $tax_category->hsn_code->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->status->Visible) { // status ?>
		<th class="<?php echo $tax_category->status->headerCellClass() ?>"><span id="elh_tax_category_status" class="tax_category_status"><?php echo $tax_category->status->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->operator->Visible) { // operator ?>
		<th class="<?php echo $tax_category->operator->headerCellClass() ?>"><span id="elh_tax_category_operator" class="tax_category_operator"><?php echo $tax_category->operator->caption() ?></span></th>
<?php } ?>
<?php if ($tax_category->datetime->Visible) { // datetime ?>
		<th class="<?php echo $tax_category->datetime->headerCellClass() ?>"><span id="elh_tax_category_datetime" class="tax_category_datetime"><?php echo $tax_category->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$tax_category_delete->RecCnt = 0;
$i = 0;
while (!$tax_category_delete->Recordset->EOF) {
	$tax_category_delete->RecCnt++;
	$tax_category_delete->RowCnt++;

	// Set row properties
	$tax_category->resetAttributes();
	$tax_category->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$tax_category_delete->loadRowValues($tax_category_delete->Recordset);

	// Render row
	$tax_category_delete->renderRow();
?>
	<tr<?php echo $tax_category->rowAttributes() ?>>
<?php if ($tax_category->id->Visible) { // id ?>
		<td<?php echo $tax_category->id->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_id" class="tax_category_id">
<span<?php echo $tax_category->id->viewAttributes() ?>>
<?php echo $tax_category->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->grp->Visible) { // grp ?>
		<td<?php echo $tax_category->grp->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_grp" class="tax_category_grp">
<span<?php echo $tax_category->grp->viewAttributes() ?>>
<?php echo $tax_category->grp->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
		<td<?php echo $tax_category->tax_percent->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_tax_percent" class="tax_category_tax_percent">
<span<?php echo $tax_category->tax_percent->viewAttributes() ?>>
<?php echo $tax_category->tax_percent->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->item->Visible) { // item ?>
		<td<?php echo $tax_category->item->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_item" class="tax_category_item">
<span<?php echo $tax_category->item->viewAttributes() ?>>
<?php echo $tax_category->item->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
		<td<?php echo $tax_category->hsn_code->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_hsn_code" class="tax_category_hsn_code">
<span<?php echo $tax_category->hsn_code->viewAttributes() ?>>
<?php echo $tax_category->hsn_code->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->status->Visible) { // status ?>
		<td<?php echo $tax_category->status->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_status" class="tax_category_status">
<span<?php echo $tax_category->status->viewAttributes() ?>>
<?php echo $tax_category->status->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->operator->Visible) { // operator ?>
		<td<?php echo $tax_category->operator->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_operator" class="tax_category_operator">
<span<?php echo $tax_category->operator->viewAttributes() ?>>
<?php echo $tax_category->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tax_category->datetime->Visible) { // datetime ?>
		<td<?php echo $tax_category->datetime->cellAttributes() ?>>
<span id="el<?php echo $tax_category_delete->RowCnt ?>_tax_category_datetime" class="tax_category_datetime">
<span<?php echo $tax_category->datetime->viewAttributes() ?>>
<?php echo $tax_category->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$tax_category_delete->Recordset->moveNext();
}
$tax_category_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tax_category_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$tax_category_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tax_category_delete->terminate();
?>