<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tax_category_list = new tax_category_list();

// Run the page
$tax_category_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tax_category_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$tax_category->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ftax_categorylist = currentForm = new ew.Form("ftax_categorylist", "list");
ftax_categorylist.formKeyCountName = '<?php echo $tax_category_list->FormKeyCountName ?>';

// Form_CustomValidate event
ftax_categorylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftax_categorylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftax_categorylist.lists["x_grp"] = <?php echo $tax_category_list->grp->Lookup->toClientList() ?>;
ftax_categorylist.lists["x_grp"].options = <?php echo JsonEncode($tax_category_list->grp->lookupOptions()) ?>;
ftax_categorylist.lists["x_status"] = <?php echo $tax_category_list->status->Lookup->toClientList() ?>;
ftax_categorylist.lists["x_status"].options = <?php echo JsonEncode($tax_category_list->status->options(FALSE, TRUE)) ?>;
ftax_categorylist.lists["x_operator"] = <?php echo $tax_category_list->operator->Lookup->toClientList() ?>;
ftax_categorylist.lists["x_operator"].options = <?php echo JsonEncode($tax_category_list->operator->lookupOptions()) ?>;
ftax_categorylist.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
var ftax_categorylistsrch = currentSearchForm = new ew.Form("ftax_categorylistsrch");

// Filters
ftax_categorylistsrch.filterList = <?php echo $tax_category_list->getFilterList() ?>;

// Init search panel as collapsed
ftax_categorylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$tax_category->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tax_category_list->TotalRecs > 0 && $tax_category_list->ExportOptions->visible()) { ?>
<?php $tax_category_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tax_category_list->ImportOptions->visible()) { ?>
<?php $tax_category_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tax_category_list->SearchOptions->visible()) { ?>
<?php $tax_category_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tax_category_list->FilterOptions->visible()) { ?>
<?php $tax_category_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tax_category_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tax_category->isExport() && !$tax_category->CurrentAction) { ?>
<form name="ftax_categorylistsrch" id="ftax_categorylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($tax_category_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ftax_categorylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tax_category">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($tax_category_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($tax_category_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tax_category_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tax_category_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tax_category_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tax_category_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tax_category_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $tax_category_list->showPageHeader(); ?>
<?php
$tax_category_list->showMessage();
?>
<?php if ($tax_category_list->TotalRecs > 0 || $tax_category->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tax_category_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tax_category">
<?php if (!$tax_category->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$tax_category->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($tax_category_list->Pager)) $tax_category_list->Pager = new PrevNextPager($tax_category_list->StartRec, $tax_category_list->DisplayRecs, $tax_category_list->TotalRecs, $tax_category_list->AutoHidePager) ?>
<?php if ($tax_category_list->Pager->RecordCount > 0 && $tax_category_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($tax_category_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($tax_category_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $tax_category_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($tax_category_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($tax_category_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $tax_category_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($tax_category_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tax_category_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tax_category_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tax_category_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($tax_category_list->TotalRecs > 0 && (!$tax_category_list->AutoHidePageSizeSelector || $tax_category_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="tax_category">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($tax_category_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($tax_category_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($tax_category_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($tax_category_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($tax_category_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($tax_category->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tax_category_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftax_categorylist" id="ftax_categorylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tax_category_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tax_category_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tax_category">
<div id="gmp_tax_category" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($tax_category_list->TotalRecs > 0 || $tax_category->isGridEdit()) { ?>
<table id="tbl_tax_categorylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tax_category_list->RowType = ROWTYPE_HEADER;

// Render list options
$tax_category_list->renderListOptions();

// Render list options (header, left)
$tax_category_list->ListOptions->render("header", "left");
?>
<?php if ($tax_category->id->Visible) { // id ?>
	<?php if ($tax_category->sortUrl($tax_category->id) == "") { ?>
		<th data-name="id" class="<?php echo $tax_category->id->headerCellClass() ?>"><div id="elh_tax_category_id" class="tax_category_id"><div class="ew-table-header-caption"><?php echo $tax_category->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $tax_category->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->id) ?>',2);"><div id="elh_tax_category_id" class="tax_category_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($tax_category->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->grp->Visible) { // grp ?>
	<?php if ($tax_category->sortUrl($tax_category->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $tax_category->grp->headerCellClass() ?>"><div id="elh_tax_category_grp" class="tax_category_grp"><div class="ew-table-header-caption"><?php echo $tax_category->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $tax_category->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->grp) ?>',2);"><div id="elh_tax_category_grp" class="tax_category_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($tax_category->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
	<?php if ($tax_category->sortUrl($tax_category->tax_percent) == "") { ?>
		<th data-name="tax_percent" class="<?php echo $tax_category->tax_percent->headerCellClass() ?>"><div id="elh_tax_category_tax_percent" class="tax_category_tax_percent"><div class="ew-table-header-caption"><?php echo $tax_category->tax_percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tax_percent" class="<?php echo $tax_category->tax_percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->tax_percent) ?>',2);"><div id="elh_tax_category_tax_percent" class="tax_category_tax_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->tax_percent->caption() ?></span><span class="ew-table-header-sort"><?php if ($tax_category->tax_percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->tax_percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->item->Visible) { // item ?>
	<?php if ($tax_category->sortUrl($tax_category->item) == "") { ?>
		<th data-name="item" class="<?php echo $tax_category->item->headerCellClass() ?>"><div id="elh_tax_category_item" class="tax_category_item"><div class="ew-table-header-caption"><?php echo $tax_category->item->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="item" class="<?php echo $tax_category->item->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->item) ?>',2);"><div id="elh_tax_category_item" class="tax_category_item">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->item->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tax_category->item->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->item->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
	<?php if ($tax_category->sortUrl($tax_category->hsn_code) == "") { ?>
		<th data-name="hsn_code" class="<?php echo $tax_category->hsn_code->headerCellClass() ?>"><div id="elh_tax_category_hsn_code" class="tax_category_hsn_code"><div class="ew-table-header-caption"><?php echo $tax_category->hsn_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="hsn_code" class="<?php echo $tax_category->hsn_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->hsn_code) ?>',2);"><div id="elh_tax_category_hsn_code" class="tax_category_hsn_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->hsn_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tax_category->hsn_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->hsn_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->status->Visible) { // status ?>
	<?php if ($tax_category->sortUrl($tax_category->status) == "") { ?>
		<th data-name="status" class="<?php echo $tax_category->status->headerCellClass() ?>"><div id="elh_tax_category_status" class="tax_category_status"><div class="ew-table-header-caption"><?php echo $tax_category->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $tax_category->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->status) ?>',2);"><div id="elh_tax_category_status" class="tax_category_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($tax_category->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->operator->Visible) { // operator ?>
	<?php if ($tax_category->sortUrl($tax_category->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $tax_category->operator->headerCellClass() ?>"><div id="elh_tax_category_operator" class="tax_category_operator"><div class="ew-table-header-caption"><?php echo $tax_category->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $tax_category->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->operator) ?>',2);"><div id="elh_tax_category_operator" class="tax_category_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($tax_category->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tax_category->datetime->Visible) { // datetime ?>
	<?php if ($tax_category->sortUrl($tax_category->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $tax_category->datetime->headerCellClass() ?>"><div id="elh_tax_category_datetime" class="tax_category_datetime"><div class="ew-table-header-caption"><?php echo $tax_category->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $tax_category->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tax_category->SortUrl($tax_category->datetime) ?>',2);"><div id="elh_tax_category_datetime" class="tax_category_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tax_category->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($tax_category->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tax_category->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tax_category_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tax_category->ExportAll && $tax_category->isExport()) {
	$tax_category_list->StopRec = $tax_category_list->TotalRecs;
} else {

	// Set the last record to display
	if ($tax_category_list->TotalRecs > $tax_category_list->StartRec + $tax_category_list->DisplayRecs - 1)
		$tax_category_list->StopRec = $tax_category_list->StartRec + $tax_category_list->DisplayRecs - 1;
	else
		$tax_category_list->StopRec = $tax_category_list->TotalRecs;
}
$tax_category_list->RecCnt = $tax_category_list->StartRec - 1;
if ($tax_category_list->Recordset && !$tax_category_list->Recordset->EOF) {
	$tax_category_list->Recordset->moveFirst();
	$selectLimit = $tax_category_list->UseSelectLimit;
	if (!$selectLimit && $tax_category_list->StartRec > 1)
		$tax_category_list->Recordset->move($tax_category_list->StartRec - 1);
} elseif (!$tax_category->AllowAddDeleteRow && $tax_category_list->StopRec == 0) {
	$tax_category_list->StopRec = $tax_category->GridAddRowCount;
}

// Initialize aggregate
$tax_category->RowType = ROWTYPE_AGGREGATEINIT;
$tax_category->resetAttributes();
$tax_category_list->renderRow();
while ($tax_category_list->RecCnt < $tax_category_list->StopRec) {
	$tax_category_list->RecCnt++;
	if ($tax_category_list->RecCnt >= $tax_category_list->StartRec) {
		$tax_category_list->RowCnt++;

		// Set up key count
		$tax_category_list->KeyCount = $tax_category_list->RowIndex;

		// Init row class and style
		$tax_category->resetAttributes();
		$tax_category->CssClass = "";
		if ($tax_category->isGridAdd()) {
		} else {
			$tax_category_list->loadRowValues($tax_category_list->Recordset); // Load row values
		}
		$tax_category->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tax_category->RowAttrs = array_merge($tax_category->RowAttrs, array('data-rowindex'=>$tax_category_list->RowCnt, 'id'=>'r' . $tax_category_list->RowCnt . '_tax_category', 'data-rowtype'=>$tax_category->RowType));

		// Render row
		$tax_category_list->renderRow();

		// Render list options
		$tax_category_list->renderListOptions();
?>
	<tr<?php echo $tax_category->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tax_category_list->ListOptions->render("body", "left", $tax_category_list->RowCnt);
?>
	<?php if ($tax_category->id->Visible) { // id ?>
		<td data-name="id"<?php echo $tax_category->id->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_id" class="tax_category_id">
<span<?php echo $tax_category->id->viewAttributes() ?>>
<?php echo $tax_category->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $tax_category->grp->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_grp" class="tax_category_grp">
<span<?php echo $tax_category->grp->viewAttributes() ?>>
<?php echo $tax_category->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
		<td data-name="tax_percent"<?php echo $tax_category->tax_percent->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_tax_percent" class="tax_category_tax_percent">
<span<?php echo $tax_category->tax_percent->viewAttributes() ?>>
<?php echo $tax_category->tax_percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->item->Visible) { // item ?>
		<td data-name="item"<?php echo $tax_category->item->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_item" class="tax_category_item">
<span<?php echo $tax_category->item->viewAttributes() ?>>
<?php echo $tax_category->item->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
		<td data-name="hsn_code"<?php echo $tax_category->hsn_code->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_hsn_code" class="tax_category_hsn_code">
<span<?php echo $tax_category->hsn_code->viewAttributes() ?>>
<?php echo $tax_category->hsn_code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->status->Visible) { // status ?>
		<td data-name="status"<?php echo $tax_category->status->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_status" class="tax_category_status">
<span<?php echo $tax_category->status->viewAttributes() ?>>
<?php echo $tax_category->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $tax_category->operator->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_operator" class="tax_category_operator">
<span<?php echo $tax_category->operator->viewAttributes() ?>>
<?php echo $tax_category->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tax_category->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $tax_category->datetime->cellAttributes() ?>>
<span id="el<?php echo $tax_category_list->RowCnt ?>_tax_category_datetime" class="tax_category_datetime">
<span<?php echo $tax_category->datetime->viewAttributes() ?>>
<?php echo $tax_category->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tax_category_list->ListOptions->render("body", "right", $tax_category_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$tax_category->isGridAdd())
		$tax_category_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$tax_category->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tax_category_list->Recordset)
	$tax_category_list->Recordset->Close();
?>
<?php if (!$tax_category->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tax_category->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($tax_category_list->Pager)) $tax_category_list->Pager = new PrevNextPager($tax_category_list->StartRec, $tax_category_list->DisplayRecs, $tax_category_list->TotalRecs, $tax_category_list->AutoHidePager) ?>
<?php if ($tax_category_list->Pager->RecordCount > 0 && $tax_category_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($tax_category_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($tax_category_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $tax_category_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($tax_category_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($tax_category_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $tax_category_list->pageUrl() ?>start=<?php echo $tax_category_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $tax_category_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($tax_category_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tax_category_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tax_category_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tax_category_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($tax_category_list->TotalRecs > 0 && (!$tax_category_list->AutoHidePageSizeSelector || $tax_category_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="tax_category">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($tax_category_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($tax_category_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($tax_category_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($tax_category_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($tax_category_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($tax_category->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tax_category_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tax_category_list->TotalRecs == 0 && !$tax_category->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tax_category_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tax_category_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$tax_category->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$tax_category->isExport()) { ?>
<script>
ew.scrollableTable("gmp_tax_category", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$tax_category_list->terminate();
?>