<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tax_category_view = new tax_category_view();

// Run the page
$tax_category_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tax_category_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$tax_category->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var ftax_categoryview = currentForm = new ew.Form("ftax_categoryview", "view");

// Form_CustomValidate event
ftax_categoryview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftax_categoryview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftax_categoryview.lists["x_grp"] = <?php echo $tax_category_view->grp->Lookup->toClientList() ?>;
ftax_categoryview.lists["x_grp"].options = <?php echo JsonEncode($tax_category_view->grp->lookupOptions()) ?>;
ftax_categoryview.lists["x_status"] = <?php echo $tax_category_view->status->Lookup->toClientList() ?>;
ftax_categoryview.lists["x_status"].options = <?php echo JsonEncode($tax_category_view->status->options(FALSE, TRUE)) ?>;
ftax_categoryview.lists["x_operator"] = <?php echo $tax_category_view->operator->Lookup->toClientList() ?>;
ftax_categoryview.lists["x_operator"].options = <?php echo JsonEncode($tax_category_view->operator->lookupOptions()) ?>;
ftax_categoryview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$tax_category->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $tax_category_view->ExportOptions->render("body") ?>
<?php $tax_category_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $tax_category_view->showPageHeader(); ?>
<?php
$tax_category_view->showMessage();
?>
<form name="ftax_categoryview" id="ftax_categoryview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tax_category_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tax_category_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tax_category">
<input type="hidden" name="modal" value="<?php echo (int)$tax_category_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($tax_category->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_id"><?php echo $tax_category->id->caption() ?></span></td>
		<td data-name="id"<?php echo $tax_category->id->cellAttributes() ?>>
<span id="el_tax_category_id">
<span<?php echo $tax_category->id->viewAttributes() ?>>
<?php echo $tax_category->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_grp"><?php echo $tax_category->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $tax_category->grp->cellAttributes() ?>>
<span id="el_tax_category_grp">
<span<?php echo $tax_category->grp->viewAttributes() ?>>
<?php echo $tax_category->grp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->tax_percent->Visible) { // tax_percent ?>
	<tr id="r_tax_percent">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_tax_percent"><?php echo $tax_category->tax_percent->caption() ?></span></td>
		<td data-name="tax_percent"<?php echo $tax_category->tax_percent->cellAttributes() ?>>
<span id="el_tax_category_tax_percent">
<span<?php echo $tax_category->tax_percent->viewAttributes() ?>>
<?php echo $tax_category->tax_percent->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->item->Visible) { // item ?>
	<tr id="r_item">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_item"><?php echo $tax_category->item->caption() ?></span></td>
		<td data-name="item"<?php echo $tax_category->item->cellAttributes() ?>>
<span id="el_tax_category_item">
<span<?php echo $tax_category->item->viewAttributes() ?>>
<?php echo $tax_category->item->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->hsn_code->Visible) { // hsn_code ?>
	<tr id="r_hsn_code">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_hsn_code"><?php echo $tax_category->hsn_code->caption() ?></span></td>
		<td data-name="hsn_code"<?php echo $tax_category->hsn_code->cellAttributes() ?>>
<span id="el_tax_category_hsn_code">
<span<?php echo $tax_category->hsn_code->viewAttributes() ?>>
<?php echo $tax_category->hsn_code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_status"><?php echo $tax_category->status->caption() ?></span></td>
		<td data-name="status"<?php echo $tax_category->status->cellAttributes() ?>>
<span id="el_tax_category_status">
<span<?php echo $tax_category->status->viewAttributes() ?>>
<?php echo $tax_category->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_operator"><?php echo $tax_category->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $tax_category->operator->cellAttributes() ?>>
<span id="el_tax_category_operator">
<span<?php echo $tax_category->operator->viewAttributes() ?>>
<?php echo $tax_category->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($tax_category->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $tax_category_view->TableLeftColumnClass ?>"><span id="elh_tax_category_datetime"><?php echo $tax_category->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $tax_category->datetime->cellAttributes() ?>>
<span id="el_tax_category_datetime">
<span<?php echo $tax_category->datetime->viewAttributes() ?>>
<?php echo $tax_category->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$tax_category_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$tax_category->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$tax_category_view->terminate();
?>