<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$test_report_g_list = new test_report_g_list();

// Run the page
$test_report_g_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$test_report_g_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$test_report_g->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ftest_report_glist = currentForm = new ew.Form("ftest_report_glist", "list");
ftest_report_glist.formKeyCountName = '<?php echo $test_report_g_list->FormKeyCountName ?>';

// Form_CustomValidate event
ftest_report_glist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftest_report_glist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftest_report_glist.lists["x_grp"] = <?php echo $test_report_g_list->grp->Lookup->toClientList() ?>;
ftest_report_glist.lists["x_grp"].options = <?php echo JsonEncode($test_report_g_list->grp->lookupOptions()) ?>;
ftest_report_glist.lists["x_s_grp"] = <?php echo $test_report_g_list->s_grp->Lookup->toClientList() ?>;
ftest_report_glist.lists["x_s_grp"].options = <?php echo JsonEncode($test_report_g_list->s_grp->lookupOptions()) ?>;
ftest_report_glist.lists["x_product"] = <?php echo $test_report_g_list->product->Lookup->toClientList() ?>;
ftest_report_glist.lists["x_product"].options = <?php echo JsonEncode($test_report_g_list->product->lookupOptions()) ?>;
ftest_report_glist.lists["x_operator"] = <?php echo $test_report_g_list->operator->Lookup->toClientList() ?>;
ftest_report_glist.lists["x_operator"].options = <?php echo JsonEncode($test_report_g_list->operator->lookupOptions()) ?>;

// Form object for search
var ftest_report_glistsrch = currentSearchForm = new ew.Form("ftest_report_glistsrch");

// Filters
ftest_report_glistsrch.filterList = <?php echo $test_report_g_list->getFilterList() ?>;

// Init search panel as collapsed
ftest_report_glistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$test_report_g->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($test_report_g_list->TotalRecs > 0 && $test_report_g_list->ExportOptions->visible()) { ?>
<?php $test_report_g_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($test_report_g_list->ImportOptions->visible()) { ?>
<?php $test_report_g_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($test_report_g_list->SearchOptions->visible()) { ?>
<?php $test_report_g_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($test_report_g_list->FilterOptions->visible()) { ?>
<?php $test_report_g_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$test_report_g_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$test_report_g->isExport() && !$test_report_g->CurrentAction) { ?>
<form name="ftest_report_glistsrch" id="ftest_report_glistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($test_report_g_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ftest_report_glistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="test_report_g">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($test_report_g_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($test_report_g_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $test_report_g_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($test_report_g_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($test_report_g_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($test_report_g_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($test_report_g_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $test_report_g_list->showPageHeader(); ?>
<?php
$test_report_g_list->showMessage();
?>
<?php if ($test_report_g_list->TotalRecs > 0 || $test_report_g->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($test_report_g_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> test_report_g">
<?php if (!$test_report_g->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$test_report_g->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($test_report_g_list->Pager)) $test_report_g_list->Pager = new PrevNextPager($test_report_g_list->StartRec, $test_report_g_list->DisplayRecs, $test_report_g_list->TotalRecs, $test_report_g_list->AutoHidePager) ?>
<?php if ($test_report_g_list->Pager->RecordCount > 0 && $test_report_g_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($test_report_g_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($test_report_g_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $test_report_g_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($test_report_g_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($test_report_g_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $test_report_g_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($test_report_g_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $test_report_g_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $test_report_g_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $test_report_g_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($test_report_g_list->TotalRecs > 0 && (!$test_report_g_list->AutoHidePageSizeSelector || $test_report_g_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="test_report_g">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($test_report_g_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($test_report_g_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($test_report_g_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($test_report_g_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($test_report_g_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($test_report_g->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $test_report_g_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftest_report_glist" id="ftest_report_glist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($test_report_g_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $test_report_g_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="test_report_g">
<div id="gmp_test_report_g" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($test_report_g_list->TotalRecs > 0 || $test_report_g->isGridEdit()) { ?>
<table id="tbl_test_report_glist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$test_report_g_list->RowType = ROWTYPE_HEADER;

// Render list options
$test_report_g_list->renderListOptions();

// Render list options (header, left)
$test_report_g_list->ListOptions->render("header", "left");
?>
<?php if ($test_report_g->id->Visible) { // id ?>
	<?php if ($test_report_g->sortUrl($test_report_g->id) == "") { ?>
		<th data-name="id" class="<?php echo $test_report_g->id->headerCellClass() ?>"><div id="elh_test_report_g_id" class="test_report_g_id"><div class="ew-table-header-caption"><?php echo $test_report_g->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $test_report_g->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->id) ?>',2);"><div id="elh_test_report_g_id" class="test_report_g_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->grp->Visible) { // grp ?>
	<?php if ($test_report_g->sortUrl($test_report_g->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $test_report_g->grp->headerCellClass() ?>"><div id="elh_test_report_g_grp" class="test_report_g_grp"><div class="ew-table-header-caption"><?php echo $test_report_g->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $test_report_g->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->grp) ?>',2);"><div id="elh_test_report_g_grp" class="test_report_g_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->s_grp->Visible) { // s_grp ?>
	<?php if ($test_report_g->sortUrl($test_report_g->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $test_report_g->s_grp->headerCellClass() ?>"><div id="elh_test_report_g_s_grp" class="test_report_g_s_grp"><div class="ew-table-header-caption"><?php echo $test_report_g->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $test_report_g->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->s_grp) ?>',2);"><div id="elh_test_report_g_s_grp" class="test_report_g_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->product->Visible) { // product ?>
	<?php if ($test_report_g->sortUrl($test_report_g->product) == "") { ?>
		<th data-name="product" class="<?php echo $test_report_g->product->headerCellClass() ?>"><div id="elh_test_report_g_product" class="test_report_g_product"><div class="ew-table-header-caption"><?php echo $test_report_g->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $test_report_g->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->product) ?>',2);"><div id="elh_test_report_g_product" class="test_report_g_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->ref->Visible) { // ref ?>
	<?php if ($test_report_g->sortUrl($test_report_g->ref) == "") { ?>
		<th data-name="ref" class="<?php echo $test_report_g->ref->headerCellClass() ?>"><div id="elh_test_report_g_ref" class="test_report_g_ref"><div class="ew-table-header-caption"><?php echo $test_report_g->ref->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ref" class="<?php echo $test_report_g->ref->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->ref) ?>',2);"><div id="elh_test_report_g_ref" class="test_report_g_ref">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->ref->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->ref->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->ref->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->lot_no->Visible) { // lot_no ?>
	<?php if ($test_report_g->sortUrl($test_report_g->lot_no) == "") { ?>
		<th data-name="lot_no" class="<?php echo $test_report_g->lot_no->headerCellClass() ?>"><div id="elh_test_report_g_lot_no" class="test_report_g_lot_no"><div class="ew-table-header-caption"><?php echo $test_report_g->lot_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lot_no" class="<?php echo $test_report_g->lot_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->lot_no) ?>',2);"><div id="elh_test_report_g_lot_no" class="test_report_g_lot_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->lot_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->lot_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->lot_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->dated->Visible) { // dated ?>
	<?php if ($test_report_g->sortUrl($test_report_g->dated) == "") { ?>
		<th data-name="dated" class="<?php echo $test_report_g->dated->headerCellClass() ?>"><div id="elh_test_report_g_dated" class="test_report_g_dated"><div class="ew-table-header-caption"><?php echo $test_report_g->dated->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dated" class="<?php echo $test_report_g->dated->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->dated) ?>',2);"><div id="elh_test_report_g_dated" class="test_report_g_dated">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->dated->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->dated->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->dated->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_01->Visible) { // d_01 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_01) == "") { ?>
		<th data-name="d_01" class="<?php echo $test_report_g->d_01->headerCellClass() ?>"><div id="elh_test_report_g_d_01" class="test_report_g_d_01"><div class="ew-table-header-caption"><?php echo $test_report_g->d_01->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_01" class="<?php echo $test_report_g->d_01->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_01) ?>',2);"><div id="elh_test_report_g_d_01" class="test_report_g_d_01">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_01->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_01->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_01->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_02->Visible) { // d_02 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_02) == "") { ?>
		<th data-name="d_02" class="<?php echo $test_report_g->d_02->headerCellClass() ?>"><div id="elh_test_report_g_d_02" class="test_report_g_d_02"><div class="ew-table-header-caption"><?php echo $test_report_g->d_02->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_02" class="<?php echo $test_report_g->d_02->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_02) ?>',2);"><div id="elh_test_report_g_d_02" class="test_report_g_d_02">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_02->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_02->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_02->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_03->Visible) { // d_03 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_03) == "") { ?>
		<th data-name="d_03" class="<?php echo $test_report_g->d_03->headerCellClass() ?>"><div id="elh_test_report_g_d_03" class="test_report_g_d_03"><div class="ew-table-header-caption"><?php echo $test_report_g->d_03->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_03" class="<?php echo $test_report_g->d_03->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_03) ?>',2);"><div id="elh_test_report_g_d_03" class="test_report_g_d_03">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_03->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_03->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_03->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_04->Visible) { // d_04 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_04) == "") { ?>
		<th data-name="d_04" class="<?php echo $test_report_g->d_04->headerCellClass() ?>"><div id="elh_test_report_g_d_04" class="test_report_g_d_04"><div class="ew-table-header-caption"><?php echo $test_report_g->d_04->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_04" class="<?php echo $test_report_g->d_04->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_04) ?>',2);"><div id="elh_test_report_g_d_04" class="test_report_g_d_04">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_04->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_04->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_04->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_05->Visible) { // d_05 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_05) == "") { ?>
		<th data-name="d_05" class="<?php echo $test_report_g->d_05->headerCellClass() ?>"><div id="elh_test_report_g_d_05" class="test_report_g_d_05"><div class="ew-table-header-caption"><?php echo $test_report_g->d_05->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_05" class="<?php echo $test_report_g->d_05->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_05) ?>',2);"><div id="elh_test_report_g_d_05" class="test_report_g_d_05">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_05->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_05->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_05->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_06->Visible) { // d_06 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_06) == "") { ?>
		<th data-name="d_06" class="<?php echo $test_report_g->d_06->headerCellClass() ?>"><div id="elh_test_report_g_d_06" class="test_report_g_d_06"><div class="ew-table-header-caption"><?php echo $test_report_g->d_06->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_06" class="<?php echo $test_report_g->d_06->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_06) ?>',2);"><div id="elh_test_report_g_d_06" class="test_report_g_d_06">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_06->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_06->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_06->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_07->Visible) { // d_07 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_07) == "") { ?>
		<th data-name="d_07" class="<?php echo $test_report_g->d_07->headerCellClass() ?>"><div id="elh_test_report_g_d_07" class="test_report_g_d_07"><div class="ew-table-header-caption"><?php echo $test_report_g->d_07->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_07" class="<?php echo $test_report_g->d_07->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_07) ?>',2);"><div id="elh_test_report_g_d_07" class="test_report_g_d_07">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_07->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_07->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_07->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_08->Visible) { // d_08 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_08) == "") { ?>
		<th data-name="d_08" class="<?php echo $test_report_g->d_08->headerCellClass() ?>"><div id="elh_test_report_g_d_08" class="test_report_g_d_08"><div class="ew-table-header-caption"><?php echo $test_report_g->d_08->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_08" class="<?php echo $test_report_g->d_08->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_08) ?>',2);"><div id="elh_test_report_g_d_08" class="test_report_g_d_08">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_08->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_08->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_08->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_09->Visible) { // d_09 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_09) == "") { ?>
		<th data-name="d_09" class="<?php echo $test_report_g->d_09->headerCellClass() ?>"><div id="elh_test_report_g_d_09" class="test_report_g_d_09"><div class="ew-table-header-caption"><?php echo $test_report_g->d_09->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_09" class="<?php echo $test_report_g->d_09->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_09) ?>',2);"><div id="elh_test_report_g_d_09" class="test_report_g_d_09">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_09->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_09->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_09->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_10->Visible) { // d_10 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_10) == "") { ?>
		<th data-name="d_10" class="<?php echo $test_report_g->d_10->headerCellClass() ?>"><div id="elh_test_report_g_d_10" class="test_report_g_d_10"><div class="ew-table-header-caption"><?php echo $test_report_g->d_10->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_10" class="<?php echo $test_report_g->d_10->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_10) ?>',2);"><div id="elh_test_report_g_d_10" class="test_report_g_d_10">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_10->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_10->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_10->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_11->Visible) { // d_11 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_11) == "") { ?>
		<th data-name="d_11" class="<?php echo $test_report_g->d_11->headerCellClass() ?>"><div id="elh_test_report_g_d_11" class="test_report_g_d_11"><div class="ew-table-header-caption"><?php echo $test_report_g->d_11->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_11" class="<?php echo $test_report_g->d_11->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_11) ?>',2);"><div id="elh_test_report_g_d_11" class="test_report_g_d_11">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_11->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_11->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_11->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_12->Visible) { // d_12 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_12) == "") { ?>
		<th data-name="d_12" class="<?php echo $test_report_g->d_12->headerCellClass() ?>"><div id="elh_test_report_g_d_12" class="test_report_g_d_12"><div class="ew-table-header-caption"><?php echo $test_report_g->d_12->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_12" class="<?php echo $test_report_g->d_12->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_12) ?>',2);"><div id="elh_test_report_g_d_12" class="test_report_g_d_12">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_12->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_12->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_12->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_13->Visible) { // d_13 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_13) == "") { ?>
		<th data-name="d_13" class="<?php echo $test_report_g->d_13->headerCellClass() ?>"><div id="elh_test_report_g_d_13" class="test_report_g_d_13"><div class="ew-table-header-caption"><?php echo $test_report_g->d_13->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_13" class="<?php echo $test_report_g->d_13->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_13) ?>',2);"><div id="elh_test_report_g_d_13" class="test_report_g_d_13">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_13->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_13->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_13->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_14->Visible) { // d_14 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_14) == "") { ?>
		<th data-name="d_14" class="<?php echo $test_report_g->d_14->headerCellClass() ?>"><div id="elh_test_report_g_d_14" class="test_report_g_d_14"><div class="ew-table-header-caption"><?php echo $test_report_g->d_14->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_14" class="<?php echo $test_report_g->d_14->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_14) ?>',2);"><div id="elh_test_report_g_d_14" class="test_report_g_d_14">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_14->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_14->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_14->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_15->Visible) { // d_15 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_15) == "") { ?>
		<th data-name="d_15" class="<?php echo $test_report_g->d_15->headerCellClass() ?>"><div id="elh_test_report_g_d_15" class="test_report_g_d_15"><div class="ew-table-header-caption"><?php echo $test_report_g->d_15->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_15" class="<?php echo $test_report_g->d_15->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_15) ?>',2);"><div id="elh_test_report_g_d_15" class="test_report_g_d_15">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_15->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_15->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_15->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_16->Visible) { // d_16 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_16) == "") { ?>
		<th data-name="d_16" class="<?php echo $test_report_g->d_16->headerCellClass() ?>"><div id="elh_test_report_g_d_16" class="test_report_g_d_16"><div class="ew-table-header-caption"><?php echo $test_report_g->d_16->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_16" class="<?php echo $test_report_g->d_16->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_16) ?>',2);"><div id="elh_test_report_g_d_16" class="test_report_g_d_16">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_16->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_16->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_16->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_17->Visible) { // d_17 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_17) == "") { ?>
		<th data-name="d_17" class="<?php echo $test_report_g->d_17->headerCellClass() ?>"><div id="elh_test_report_g_d_17" class="test_report_g_d_17"><div class="ew-table-header-caption"><?php echo $test_report_g->d_17->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_17" class="<?php echo $test_report_g->d_17->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_17) ?>',2);"><div id="elh_test_report_g_d_17" class="test_report_g_d_17">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_17->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_17->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_17->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_18->Visible) { // d_18 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_18) == "") { ?>
		<th data-name="d_18" class="<?php echo $test_report_g->d_18->headerCellClass() ?>"><div id="elh_test_report_g_d_18" class="test_report_g_d_18"><div class="ew-table-header-caption"><?php echo $test_report_g->d_18->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_18" class="<?php echo $test_report_g->d_18->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_18) ?>',2);"><div id="elh_test_report_g_d_18" class="test_report_g_d_18">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_18->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_18->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_18->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_19->Visible) { // d_19 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_19) == "") { ?>
		<th data-name="d_19" class="<?php echo $test_report_g->d_19->headerCellClass() ?>"><div id="elh_test_report_g_d_19" class="test_report_g_d_19"><div class="ew-table-header-caption"><?php echo $test_report_g->d_19->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_19" class="<?php echo $test_report_g->d_19->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_19) ?>',2);"><div id="elh_test_report_g_d_19" class="test_report_g_d_19">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_19->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_19->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_19->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->d_20->Visible) { // d_20 ?>
	<?php if ($test_report_g->sortUrl($test_report_g->d_20) == "") { ?>
		<th data-name="d_20" class="<?php echo $test_report_g->d_20->headerCellClass() ?>"><div id="elh_test_report_g_d_20" class="test_report_g_d_20"><div class="ew-table-header-caption"><?php echo $test_report_g->d_20->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="d_20" class="<?php echo $test_report_g->d_20->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->d_20) ?>',2);"><div id="elh_test_report_g_d_20" class="test_report_g_d_20">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->d_20->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->d_20->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->d_20->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->operator->Visible) { // operator ?>
	<?php if ($test_report_g->sortUrl($test_report_g->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $test_report_g->operator->headerCellClass() ?>"><div id="elh_test_report_g_operator" class="test_report_g_operator"><div class="ew-table-header-caption"><?php echo $test_report_g->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $test_report_g->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->operator) ?>',2);"><div id="elh_test_report_g_operator" class="test_report_g_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($test_report_g->datetime->Visible) { // datetime ?>
	<?php if ($test_report_g->sortUrl($test_report_g->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $test_report_g->datetime->headerCellClass() ?>"><div id="elh_test_report_g_datetime" class="test_report_g_datetime"><div class="ew-table-header-caption"><?php echo $test_report_g->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $test_report_g->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $test_report_g->SortUrl($test_report_g->datetime) ?>',2);"><div id="elh_test_report_g_datetime" class="test_report_g_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $test_report_g->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($test_report_g->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($test_report_g->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$test_report_g_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($test_report_g->ExportAll && $test_report_g->isExport()) {
	$test_report_g_list->StopRec = $test_report_g_list->TotalRecs;
} else {

	// Set the last record to display
	if ($test_report_g_list->TotalRecs > $test_report_g_list->StartRec + $test_report_g_list->DisplayRecs - 1)
		$test_report_g_list->StopRec = $test_report_g_list->StartRec + $test_report_g_list->DisplayRecs - 1;
	else
		$test_report_g_list->StopRec = $test_report_g_list->TotalRecs;
}
$test_report_g_list->RecCnt = $test_report_g_list->StartRec - 1;
if ($test_report_g_list->Recordset && !$test_report_g_list->Recordset->EOF) {
	$test_report_g_list->Recordset->moveFirst();
	$selectLimit = $test_report_g_list->UseSelectLimit;
	if (!$selectLimit && $test_report_g_list->StartRec > 1)
		$test_report_g_list->Recordset->move($test_report_g_list->StartRec - 1);
} elseif (!$test_report_g->AllowAddDeleteRow && $test_report_g_list->StopRec == 0) {
	$test_report_g_list->StopRec = $test_report_g->GridAddRowCount;
}

// Initialize aggregate
$test_report_g->RowType = ROWTYPE_AGGREGATEINIT;
$test_report_g->resetAttributes();
$test_report_g_list->renderRow();
while ($test_report_g_list->RecCnt < $test_report_g_list->StopRec) {
	$test_report_g_list->RecCnt++;
	if ($test_report_g_list->RecCnt >= $test_report_g_list->StartRec) {
		$test_report_g_list->RowCnt++;

		// Set up key count
		$test_report_g_list->KeyCount = $test_report_g_list->RowIndex;

		// Init row class and style
		$test_report_g->resetAttributes();
		$test_report_g->CssClass = "";
		if ($test_report_g->isGridAdd()) {
		} else {
			$test_report_g_list->loadRowValues($test_report_g_list->Recordset); // Load row values
		}
		$test_report_g->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$test_report_g->RowAttrs = array_merge($test_report_g->RowAttrs, array('data-rowindex'=>$test_report_g_list->RowCnt, 'id'=>'r' . $test_report_g_list->RowCnt . '_test_report_g', 'data-rowtype'=>$test_report_g->RowType));

		// Render row
		$test_report_g_list->renderRow();

		// Render list options
		$test_report_g_list->renderListOptions();
?>
	<tr<?php echo $test_report_g->rowAttributes() ?>>
<?php

// Render list options (body, left)
$test_report_g_list->ListOptions->render("body", "left", $test_report_g_list->RowCnt);
?>
	<?php if ($test_report_g->id->Visible) { // id ?>
		<td data-name="id"<?php echo $test_report_g->id->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_id" class="test_report_g_id">
<span<?php echo $test_report_g->id->viewAttributes() ?>>
<?php echo $test_report_g->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $test_report_g->grp->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_grp" class="test_report_g_grp">
<span<?php echo $test_report_g->grp->viewAttributes() ?>>
<?php echo $test_report_g->grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $test_report_g->s_grp->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_s_grp" class="test_report_g_s_grp">
<span<?php echo $test_report_g->s_grp->viewAttributes() ?>>
<?php echo $test_report_g->s_grp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->product->Visible) { // product ?>
		<td data-name="product"<?php echo $test_report_g->product->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_product" class="test_report_g_product">
<span<?php echo $test_report_g->product->viewAttributes() ?>>
<?php echo $test_report_g->product->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->ref->Visible) { // ref ?>
		<td data-name="ref"<?php echo $test_report_g->ref->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_ref" class="test_report_g_ref">
<span<?php echo $test_report_g->ref->viewAttributes() ?>>
<?php echo $test_report_g->ref->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->lot_no->Visible) { // lot_no ?>
		<td data-name="lot_no"<?php echo $test_report_g->lot_no->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_lot_no" class="test_report_g_lot_no">
<span<?php echo $test_report_g->lot_no->viewAttributes() ?>>
<?php echo $test_report_g->lot_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->dated->Visible) { // dated ?>
		<td data-name="dated"<?php echo $test_report_g->dated->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_dated" class="test_report_g_dated">
<span<?php echo $test_report_g->dated->viewAttributes() ?>>
<?php echo $test_report_g->dated->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_01->Visible) { // d_01 ?>
		<td data-name="d_01"<?php echo $test_report_g->d_01->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_01" class="test_report_g_d_01">
<span<?php echo $test_report_g->d_01->viewAttributes() ?>>
<?php echo $test_report_g->d_01->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_02->Visible) { // d_02 ?>
		<td data-name="d_02"<?php echo $test_report_g->d_02->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_02" class="test_report_g_d_02">
<span<?php echo $test_report_g->d_02->viewAttributes() ?>>
<?php echo $test_report_g->d_02->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_03->Visible) { // d_03 ?>
		<td data-name="d_03"<?php echo $test_report_g->d_03->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_03" class="test_report_g_d_03">
<span<?php echo $test_report_g->d_03->viewAttributes() ?>>
<?php echo $test_report_g->d_03->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_04->Visible) { // d_04 ?>
		<td data-name="d_04"<?php echo $test_report_g->d_04->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_04" class="test_report_g_d_04">
<span<?php echo $test_report_g->d_04->viewAttributes() ?>>
<?php echo $test_report_g->d_04->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_05->Visible) { // d_05 ?>
		<td data-name="d_05"<?php echo $test_report_g->d_05->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_05" class="test_report_g_d_05">
<span<?php echo $test_report_g->d_05->viewAttributes() ?>>
<?php echo $test_report_g->d_05->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_06->Visible) { // d_06 ?>
		<td data-name="d_06"<?php echo $test_report_g->d_06->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_06" class="test_report_g_d_06">
<span<?php echo $test_report_g->d_06->viewAttributes() ?>>
<?php echo $test_report_g->d_06->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_07->Visible) { // d_07 ?>
		<td data-name="d_07"<?php echo $test_report_g->d_07->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_07" class="test_report_g_d_07">
<span<?php echo $test_report_g->d_07->viewAttributes() ?>>
<?php echo $test_report_g->d_07->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_08->Visible) { // d_08 ?>
		<td data-name="d_08"<?php echo $test_report_g->d_08->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_08" class="test_report_g_d_08">
<span<?php echo $test_report_g->d_08->viewAttributes() ?>>
<?php echo $test_report_g->d_08->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_09->Visible) { // d_09 ?>
		<td data-name="d_09"<?php echo $test_report_g->d_09->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_09" class="test_report_g_d_09">
<span<?php echo $test_report_g->d_09->viewAttributes() ?>>
<?php echo $test_report_g->d_09->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_10->Visible) { // d_10 ?>
		<td data-name="d_10"<?php echo $test_report_g->d_10->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_10" class="test_report_g_d_10">
<span<?php echo $test_report_g->d_10->viewAttributes() ?>>
<?php echo $test_report_g->d_10->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_11->Visible) { // d_11 ?>
		<td data-name="d_11"<?php echo $test_report_g->d_11->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_11" class="test_report_g_d_11">
<span<?php echo $test_report_g->d_11->viewAttributes() ?>>
<?php echo $test_report_g->d_11->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_12->Visible) { // d_12 ?>
		<td data-name="d_12"<?php echo $test_report_g->d_12->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_12" class="test_report_g_d_12">
<span<?php echo $test_report_g->d_12->viewAttributes() ?>>
<?php echo $test_report_g->d_12->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_13->Visible) { // d_13 ?>
		<td data-name="d_13"<?php echo $test_report_g->d_13->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_13" class="test_report_g_d_13">
<span<?php echo $test_report_g->d_13->viewAttributes() ?>>
<?php echo $test_report_g->d_13->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_14->Visible) { // d_14 ?>
		<td data-name="d_14"<?php echo $test_report_g->d_14->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_14" class="test_report_g_d_14">
<span<?php echo $test_report_g->d_14->viewAttributes() ?>>
<?php echo $test_report_g->d_14->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_15->Visible) { // d_15 ?>
		<td data-name="d_15"<?php echo $test_report_g->d_15->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_15" class="test_report_g_d_15">
<span<?php echo $test_report_g->d_15->viewAttributes() ?>>
<?php echo $test_report_g->d_15->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_16->Visible) { // d_16 ?>
		<td data-name="d_16"<?php echo $test_report_g->d_16->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_16" class="test_report_g_d_16">
<span<?php echo $test_report_g->d_16->viewAttributes() ?>>
<?php echo $test_report_g->d_16->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_17->Visible) { // d_17 ?>
		<td data-name="d_17"<?php echo $test_report_g->d_17->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_17" class="test_report_g_d_17">
<span<?php echo $test_report_g->d_17->viewAttributes() ?>>
<?php echo $test_report_g->d_17->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_18->Visible) { // d_18 ?>
		<td data-name="d_18"<?php echo $test_report_g->d_18->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_18" class="test_report_g_d_18">
<span<?php echo $test_report_g->d_18->viewAttributes() ?>>
<?php echo $test_report_g->d_18->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_19->Visible) { // d_19 ?>
		<td data-name="d_19"<?php echo $test_report_g->d_19->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_19" class="test_report_g_d_19">
<span<?php echo $test_report_g->d_19->viewAttributes() ?>>
<?php echo $test_report_g->d_19->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->d_20->Visible) { // d_20 ?>
		<td data-name="d_20"<?php echo $test_report_g->d_20->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_d_20" class="test_report_g_d_20">
<span<?php echo $test_report_g->d_20->viewAttributes() ?>>
<?php echo $test_report_g->d_20->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $test_report_g->operator->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_operator" class="test_report_g_operator">
<span<?php echo $test_report_g->operator->viewAttributes() ?>>
<?php echo $test_report_g->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($test_report_g->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $test_report_g->datetime->cellAttributes() ?>>
<span id="el<?php echo $test_report_g_list->RowCnt ?>_test_report_g_datetime" class="test_report_g_datetime">
<span<?php echo $test_report_g->datetime->viewAttributes() ?>>
<?php echo $test_report_g->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$test_report_g_list->ListOptions->render("body", "right", $test_report_g_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$test_report_g->isGridAdd())
		$test_report_g_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$test_report_g->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($test_report_g_list->Recordset)
	$test_report_g_list->Recordset->Close();
?>
<?php if (!$test_report_g->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$test_report_g->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($test_report_g_list->Pager)) $test_report_g_list->Pager = new PrevNextPager($test_report_g_list->StartRec, $test_report_g_list->DisplayRecs, $test_report_g_list->TotalRecs, $test_report_g_list->AutoHidePager) ?>
<?php if ($test_report_g_list->Pager->RecordCount > 0 && $test_report_g_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($test_report_g_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($test_report_g_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $test_report_g_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($test_report_g_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($test_report_g_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $test_report_g_list->pageUrl() ?>start=<?php echo $test_report_g_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $test_report_g_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($test_report_g_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $test_report_g_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $test_report_g_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $test_report_g_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($test_report_g_list->TotalRecs > 0 && (!$test_report_g_list->AutoHidePageSizeSelector || $test_report_g_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="test_report_g">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($test_report_g_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($test_report_g_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($test_report_g_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($test_report_g_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($test_report_g_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($test_report_g->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $test_report_g_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($test_report_g_list->TotalRecs == 0 && !$test_report_g->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $test_report_g_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$test_report_g_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$test_report_g->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$test_report_g->isExport()) { ?>
<script>
ew.scrollableTable("gmp_test_report_g", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$test_report_g_list->terminate();
?>