<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tmp_lot_query_list = new tmp_lot_query_list();

// Run the page
$tmp_lot_query_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tmp_lot_query_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$tmp_lot_query->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ftmp_lot_querylist = currentForm = new ew.Form("ftmp_lot_querylist", "list");
ftmp_lot_querylist.formKeyCountName = '<?php echo $tmp_lot_query_list->FormKeyCountName ?>';

// Form_CustomValidate event
ftmp_lot_querylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_lot_querylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_lot_querylist.lists["x_product[]"] = <?php echo $tmp_lot_query_list->product->Lookup->toClientList() ?>;
ftmp_lot_querylist.lists["x_product[]"].options = <?php echo JsonEncode($tmp_lot_query_list->product->lookupOptions()) ?>;
ftmp_lot_querylist.lists["x_product_code[]"] = <?php echo $tmp_lot_query_list->product_code->Lookup->toClientList() ?>;
ftmp_lot_querylist.lists["x_product_code[]"].options = <?php echo JsonEncode($tmp_lot_query_list->product_code->lookupOptions()) ?>;

// Form object for search
var ftmp_lot_querylistsrch = currentSearchForm = new ew.Form("ftmp_lot_querylistsrch");

// Validate function for search
ftmp_lot_querylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->percent->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
ftmp_lot_querylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_lot_querylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_lot_querylistsrch.lists["x_product[]"] = <?php echo $tmp_lot_query_list->product->Lookup->toClientList() ?>;
ftmp_lot_querylistsrch.lists["x_product[]"].options = <?php echo JsonEncode($tmp_lot_query_list->product->lookupOptions()) ?>;
ftmp_lot_querylistsrch.lists["x_product_code[]"] = <?php echo $tmp_lot_query_list->product_code->Lookup->toClientList() ?>;
ftmp_lot_querylistsrch.lists["x_product_code[]"].options = <?php echo JsonEncode($tmp_lot_query_list->product_code->lookupOptions()) ?>;

// Filters
ftmp_lot_querylistsrch.filterList = <?php echo $tmp_lot_query_list->getFilterList() ?>;

// Init search panel as collapsed
ftmp_lot_querylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$tmp_lot_query->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tmp_lot_query_list->TotalRecs > 0 && $tmp_lot_query_list->ExportOptions->visible()) { ?>
<?php $tmp_lot_query_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tmp_lot_query_list->ImportOptions->visible()) { ?>
<?php $tmp_lot_query_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tmp_lot_query_list->SearchOptions->visible()) { ?>
<?php $tmp_lot_query_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tmp_lot_query_list->FilterOptions->visible()) { ?>
<?php $tmp_lot_query_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tmp_lot_query_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tmp_lot_query->isExport() && !$tmp_lot_query->CurrentAction) { ?>
<form name="ftmp_lot_querylistsrch" id="ftmp_lot_querylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($tmp_lot_query_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ftmp_lot_querylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tmp_lot_query">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$tmp_lot_query_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$tmp_lot_query->RowType = ROWTYPE_SEARCH;

// Render row
$tmp_lot_query->resetAttributes();
$tmp_lot_query_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($tmp_lot_query->product->Visible) { // product ?>
	<div id="xsc_product" class="ew-cell form-group">
		<label for="x_product" class="ew-search-caption ew-label"><?php echo $tmp_lot_query->product->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		<span class="ew-search-field">
<?php $tmp_lot_query->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$tmp_lot_query->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tmp_lot_query" data-field="x_product" data-value-separator="<?php echo $tmp_lot_query->product->displayValueSeparatorAttribute() ?>" id="x_product[]" name="x_product[]" multiple="multiple"<?php echo $tmp_lot_query->product->editAttributes() ?>>
		<?php echo $tmp_lot_query->product->selectOptionListHtml("x_product[]") ?>
	</select>
</div>
<?php echo $tmp_lot_query->product->Lookup->getParamTag("p_x_product") ?>
</span>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->product_code->Visible) { // product_code ?>
	<div id="xsc_product_code" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $tmp_lot_query->product_code->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_code" id="z_product_code" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_product_code" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_lot_query" data-field="x_product_code" data-value-separator="<?php echo $tmp_lot_query->product_code->displayValueSeparatorAttribute() ?>" name="x_product_code[]" id="x_product_code[]" value="{value}"<?php echo $tmp_lot_query->product_code->editAttributes() ?>></div>
<div id="dsl_x_product_code" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $tmp_lot_query->product_code->checkBoxListHtml(FALSE, "x_product_code[]") ?>
</div></div>
<?php echo $tmp_lot_query->product_code->Lookup->getParamTag("p_x_product_code") ?>
</span>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->OUT->Visible) { // OUT ?>
	<div id="xsc_OUT" class="ew-cell form-group">
		<label for="x_OUT" class="ew-search-caption ew-label"><?php echo $tmp_lot_query->OUT->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="tmp_lot_query" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->OUT->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->OUT->EditValue ?>"<?php echo $tmp_lot_query->OUT->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($tmp_lot_query->IN->Visible) { // IN ?>
	<div id="xsc_IN" class="ew-cell form-group">
		<label for="x_IN" class="ew-search-caption ew-label"><?php echo $tmp_lot_query->IN->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="tmp_lot_query" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->IN->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->IN->EditValue ?>"<?php echo $tmp_lot_query->IN->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->tmp_lot->Visible) { // tmp_lot ?>
	<div id="xsc_tmp_lot" class="ew-cell form-group">
		<label for="x_tmp_lot" class="ew-search-caption ew-label"><?php echo $tmp_lot_query->tmp_lot->caption() ?></label>
		<span class="ew-search-operator"><select name="z_tmp_lot" id="z_tmp_lot" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="tmp_lot_query" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->tmp_lot->EditValue ?>"<?php echo $tmp_lot_query->tmp_lot->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_tmp_lot style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_tmp_lot style="d-none"">
<input type="text" data-table="tmp_lot_query" data-field="x_tmp_lot" name="y_tmp_lot" id="y_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->tmp_lot->EditValue2 ?>"<?php echo $tmp_lot_query->tmp_lot->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->percent->Visible) { // percent ?>
	<div id="xsc_percent" class="ew-cell form-group">
		<label for="x_percent" class="ew-search-caption ew-label"><?php echo $tmp_lot_query->percent->caption() ?></label>
		<span class="ew-search-operator"><select name="z_percent" id="z_percent" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="tmp_lot_query" data-field="x_percent" name="x_percent" id="x_percent" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->percent->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->percent->EditValue ?>"<?php echo $tmp_lot_query->percent->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_percent style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_percent style="d-none"">
<input type="text" data-table="tmp_lot_query" data-field="x_percent" name="y_percent" id="y_percent" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->percent->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->percent->EditValue2 ?>"<?php echo $tmp_lot_query->percent->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($tmp_lot_query_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($tmp_lot_query_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tmp_lot_query_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tmp_lot_query_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tmp_lot_query_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tmp_lot_query_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tmp_lot_query_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $tmp_lot_query_list->showPageHeader(); ?>
<?php
$tmp_lot_query_list->showMessage();
?>
<?php if ($tmp_lot_query_list->TotalRecs > 0 || $tmp_lot_query->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tmp_lot_query_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tmp_lot_query">
<?php if (!$tmp_lot_query->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$tmp_lot_query->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($tmp_lot_query_list->Pager)) $tmp_lot_query_list->Pager = new PrevNextPager($tmp_lot_query_list->StartRec, $tmp_lot_query_list->DisplayRecs, $tmp_lot_query_list->TotalRecs, $tmp_lot_query_list->AutoHidePager) ?>
<?php if ($tmp_lot_query_list->Pager->RecordCount > 0 && $tmp_lot_query_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($tmp_lot_query_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($tmp_lot_query_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $tmp_lot_query_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($tmp_lot_query_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($tmp_lot_query_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($tmp_lot_query_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($tmp_lot_query_list->TotalRecs > 0 && (!$tmp_lot_query_list->AutoHidePageSizeSelector || $tmp_lot_query_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="tmp_lot_query">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($tmp_lot_query_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($tmp_lot_query_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($tmp_lot_query_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($tmp_lot_query_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($tmp_lot_query_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($tmp_lot_query->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tmp_lot_query_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftmp_lot_querylist" id="ftmp_lot_querylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tmp_lot_query_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tmp_lot_query_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tmp_lot_query">
<div id="gmp_tmp_lot_query" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($tmp_lot_query_list->TotalRecs > 0 || $tmp_lot_query->isGridEdit()) { ?>
<table id="tbl_tmp_lot_querylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tmp_lot_query_list->RowType = ROWTYPE_HEADER;

// Render list options
$tmp_lot_query_list->renderListOptions();

// Render list options (header, left)
$tmp_lot_query_list->ListOptions->render("header", "left");
?>
<?php if ($tmp_lot_query->product->Visible) { // product ?>
	<?php if ($tmp_lot_query->sortUrl($tmp_lot_query->product) == "") { ?>
		<th data-name="product" class="<?php echo $tmp_lot_query->product->headerCellClass() ?>"><div id="elh_tmp_lot_query_product" class="tmp_lot_query_product"><div class="ew-table-header-caption"><?php echo $tmp_lot_query->product->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product" class="<?php echo $tmp_lot_query->product->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_lot_query->SortUrl($tmp_lot_query->product) ?>',2);"><div id="elh_tmp_lot_query_product" class="tmp_lot_query_product">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_lot_query->product->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_lot_query->product->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_lot_query->product->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_lot_query->product_code->Visible) { // product_code ?>
	<?php if ($tmp_lot_query->sortUrl($tmp_lot_query->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $tmp_lot_query->product_code->headerCellClass() ?>" style="width: 200px;"><div id="elh_tmp_lot_query_product_code" class="tmp_lot_query_product_code"><div class="ew-table-header-caption"><?php echo $tmp_lot_query->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $tmp_lot_query->product_code->headerCellClass() ?>" style="width: 200px;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_lot_query->SortUrl($tmp_lot_query->product_code) ?>',2);"><div id="elh_tmp_lot_query_product_code" class="tmp_lot_query_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_lot_query->product_code->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_lot_query->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_lot_query->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_lot_query->OUT->Visible) { // OUT ?>
	<?php if ($tmp_lot_query->sortUrl($tmp_lot_query->OUT) == "") { ?>
		<th data-name="OUT" class="<?php echo $tmp_lot_query->OUT->headerCellClass() ?>"><div id="elh_tmp_lot_query_OUT" class="tmp_lot_query_OUT"><div class="ew-table-header-caption"><?php echo $tmp_lot_query->OUT->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="OUT" class="<?php echo $tmp_lot_query->OUT->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_lot_query->SortUrl($tmp_lot_query->OUT) ?>',2);"><div id="elh_tmp_lot_query_OUT" class="tmp_lot_query_OUT">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_lot_query->OUT->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tmp_lot_query->OUT->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_lot_query->OUT->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_lot_query->IN->Visible) { // IN ?>
	<?php if ($tmp_lot_query->sortUrl($tmp_lot_query->IN) == "") { ?>
		<th data-name="IN" class="<?php echo $tmp_lot_query->IN->headerCellClass() ?>"><div id="elh_tmp_lot_query_IN" class="tmp_lot_query_IN"><div class="ew-table-header-caption"><?php echo $tmp_lot_query->IN->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IN" class="<?php echo $tmp_lot_query->IN->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_lot_query->SortUrl($tmp_lot_query->IN) ?>',2);"><div id="elh_tmp_lot_query_IN" class="tmp_lot_query_IN">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_lot_query->IN->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tmp_lot_query->IN->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_lot_query->IN->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_lot_query->tmp_lot->Visible) { // tmp_lot ?>
	<?php if ($tmp_lot_query->sortUrl($tmp_lot_query->tmp_lot) == "") { ?>
		<th data-name="tmp_lot" class="<?php echo $tmp_lot_query->tmp_lot->headerCellClass() ?>"><div id="elh_tmp_lot_query_tmp_lot" class="tmp_lot_query_tmp_lot"><div class="ew-table-header-caption"><?php echo $tmp_lot_query->tmp_lot->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tmp_lot" class="<?php echo $tmp_lot_query->tmp_lot->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_lot_query->SortUrl($tmp_lot_query->tmp_lot) ?>',2);"><div id="elh_tmp_lot_query_tmp_lot" class="tmp_lot_query_tmp_lot">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_lot_query->tmp_lot->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tmp_lot_query->tmp_lot->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_lot_query->tmp_lot->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_lot_query->percent->Visible) { // percent ?>
	<?php if ($tmp_lot_query->sortUrl($tmp_lot_query->percent) == "") { ?>
		<th data-name="percent" class="<?php echo $tmp_lot_query->percent->headerCellClass() ?>"><div id="elh_tmp_lot_query_percent" class="tmp_lot_query_percent"><div class="ew-table-header-caption"><?php echo $tmp_lot_query->percent->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="percent" class="<?php echo $tmp_lot_query->percent->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_lot_query->SortUrl($tmp_lot_query->percent) ?>',2);"><div id="elh_tmp_lot_query_percent" class="tmp_lot_query_percent">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_lot_query->percent->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($tmp_lot_query->percent->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_lot_query->percent->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tmp_lot_query_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tmp_lot_query->ExportAll && $tmp_lot_query->isExport()) {
	$tmp_lot_query_list->StopRec = $tmp_lot_query_list->TotalRecs;
} else {

	// Set the last record to display
	if ($tmp_lot_query_list->TotalRecs > $tmp_lot_query_list->StartRec + $tmp_lot_query_list->DisplayRecs - 1)
		$tmp_lot_query_list->StopRec = $tmp_lot_query_list->StartRec + $tmp_lot_query_list->DisplayRecs - 1;
	else
		$tmp_lot_query_list->StopRec = $tmp_lot_query_list->TotalRecs;
}
$tmp_lot_query_list->RecCnt = $tmp_lot_query_list->StartRec - 1;
if ($tmp_lot_query_list->Recordset && !$tmp_lot_query_list->Recordset->EOF) {
	$tmp_lot_query_list->Recordset->moveFirst();
	$selectLimit = $tmp_lot_query_list->UseSelectLimit;
	if (!$selectLimit && $tmp_lot_query_list->StartRec > 1)
		$tmp_lot_query_list->Recordset->move($tmp_lot_query_list->StartRec - 1);
} elseif (!$tmp_lot_query->AllowAddDeleteRow && $tmp_lot_query_list->StopRec == 0) {
	$tmp_lot_query_list->StopRec = $tmp_lot_query->GridAddRowCount;
}

// Initialize aggregate
$tmp_lot_query->RowType = ROWTYPE_AGGREGATEINIT;
$tmp_lot_query->resetAttributes();
$tmp_lot_query_list->renderRow();
while ($tmp_lot_query_list->RecCnt < $tmp_lot_query_list->StopRec) {
	$tmp_lot_query_list->RecCnt++;
	if ($tmp_lot_query_list->RecCnt >= $tmp_lot_query_list->StartRec) {
		$tmp_lot_query_list->RowCnt++;

		// Set up key count
		$tmp_lot_query_list->KeyCount = $tmp_lot_query_list->RowIndex;

		// Init row class and style
		$tmp_lot_query->resetAttributes();
		$tmp_lot_query->CssClass = "";
		if ($tmp_lot_query->isGridAdd()) {
		} else {
			$tmp_lot_query_list->loadRowValues($tmp_lot_query_list->Recordset); // Load row values
		}
		$tmp_lot_query->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tmp_lot_query->RowAttrs = array_merge($tmp_lot_query->RowAttrs, array('data-rowindex'=>$tmp_lot_query_list->RowCnt, 'id'=>'r' . $tmp_lot_query_list->RowCnt . '_tmp_lot_query', 'data-rowtype'=>$tmp_lot_query->RowType));

		// Render row
		$tmp_lot_query_list->renderRow();

		// Render list options
		$tmp_lot_query_list->renderListOptions();
?>
	<tr<?php echo $tmp_lot_query->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tmp_lot_query_list->ListOptions->render("body", "left", $tmp_lot_query_list->RowCnt);
?>
	<?php if ($tmp_lot_query->product->Visible) { // product ?>
		<td data-name="product"<?php echo $tmp_lot_query->product->cellAttributes() ?>>
<span id="el<?php echo $tmp_lot_query_list->RowCnt ?>_tmp_lot_query_product" class="tmp_lot_query_product">
<span<?php echo $tmp_lot_query->product->viewAttributes() ?>>
<?php if ((!EmptyString($tmp_lot_query->product->getViewValue())) && $tmp_lot_query->product->linkAttributes() <> "") { ?>
<a<?php echo $tmp_lot_query->product->linkAttributes() ?>><?php echo $tmp_lot_query->product->getViewValue() ?></a>
<?php } else { ?>
<?php echo $tmp_lot_query->product->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_lot_query->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $tmp_lot_query->product_code->cellAttributes() ?>>
<span id="el<?php echo $tmp_lot_query_list->RowCnt ?>_tmp_lot_query_product_code" class="tmp_lot_query_product_code">
<span<?php echo $tmp_lot_query->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($tmp_lot_query->product_code->getViewValue())) && $tmp_lot_query->product_code->linkAttributes() <> "") { ?>
<a<?php echo $tmp_lot_query->product_code->linkAttributes() ?>><?php echo $tmp_lot_query->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $tmp_lot_query->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_lot_query->OUT->Visible) { // OUT ?>
		<td data-name="OUT"<?php echo $tmp_lot_query->OUT->cellAttributes() ?>>
<span id="el<?php echo $tmp_lot_query_list->RowCnt ?>_tmp_lot_query_OUT" class="tmp_lot_query_OUT">
<span<?php echo $tmp_lot_query->OUT->viewAttributes() ?>>
<?php echo $tmp_lot_query->OUT->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_lot_query->IN->Visible) { // IN ?>
		<td data-name="IN"<?php echo $tmp_lot_query->IN->cellAttributes() ?>>
<span id="el<?php echo $tmp_lot_query_list->RowCnt ?>_tmp_lot_query_IN" class="tmp_lot_query_IN">
<span<?php echo $tmp_lot_query->IN->viewAttributes() ?>>
<?php echo $tmp_lot_query->IN->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_lot_query->tmp_lot->Visible) { // tmp_lot ?>
		<td data-name="tmp_lot"<?php echo $tmp_lot_query->tmp_lot->cellAttributes() ?>>
<span id="el<?php echo $tmp_lot_query_list->RowCnt ?>_tmp_lot_query_tmp_lot" class="tmp_lot_query_tmp_lot">
<span<?php echo $tmp_lot_query->tmp_lot->viewAttributes() ?>>
<?php echo $tmp_lot_query->tmp_lot->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_lot_query->percent->Visible) { // percent ?>
		<td data-name="percent"<?php echo $tmp_lot_query->percent->cellAttributes() ?>>
<span id="el<?php echo $tmp_lot_query_list->RowCnt ?>_tmp_lot_query_percent" class="tmp_lot_query_percent">
<span<?php echo $tmp_lot_query->percent->viewAttributes() ?>>
<?php echo $tmp_lot_query->percent->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tmp_lot_query_list->ListOptions->render("body", "right", $tmp_lot_query_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$tmp_lot_query->isGridAdd())
		$tmp_lot_query_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$tmp_lot_query->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tmp_lot_query_list->Recordset)
	$tmp_lot_query_list->Recordset->Close();
?>
<?php if (!$tmp_lot_query->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tmp_lot_query->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($tmp_lot_query_list->Pager)) $tmp_lot_query_list->Pager = new PrevNextPager($tmp_lot_query_list->StartRec, $tmp_lot_query_list->DisplayRecs, $tmp_lot_query_list->TotalRecs, $tmp_lot_query_list->AutoHidePager) ?>
<?php if ($tmp_lot_query_list->Pager->RecordCount > 0 && $tmp_lot_query_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($tmp_lot_query_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($tmp_lot_query_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $tmp_lot_query_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($tmp_lot_query_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($tmp_lot_query_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $tmp_lot_query_list->pageUrl() ?>start=<?php echo $tmp_lot_query_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($tmp_lot_query_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tmp_lot_query_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($tmp_lot_query_list->TotalRecs > 0 && (!$tmp_lot_query_list->AutoHidePageSizeSelector || $tmp_lot_query_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="tmp_lot_query">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($tmp_lot_query_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($tmp_lot_query_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($tmp_lot_query_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($tmp_lot_query_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($tmp_lot_query_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($tmp_lot_query->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tmp_lot_query_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tmp_lot_query_list->TotalRecs == 0 && !$tmp_lot_query->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tmp_lot_query_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tmp_lot_query_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$tmp_lot_query->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$tmp_lot_query->isExport()) { ?>
<script>
ew.scrollableTable("gmp_tmp_lot_query", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$tmp_lot_query_list->terminate();
?>