<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tmp_lot_query_search = new tmp_lot_query_search();

// Run the page
$tmp_lot_query_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tmp_lot_query_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($tmp_lot_query_search->IsModal) { ?>
var ftmp_lot_querysearch = currentAdvancedSearchForm = new ew.Form("ftmp_lot_querysearch", "search");
<?php } else { ?>
var ftmp_lot_querysearch = currentForm = new ew.Form("ftmp_lot_querysearch", "search");
<?php } ?>

// Form_CustomValidate event
ftmp_lot_querysearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_lot_querysearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_lot_querysearch.lists["x_product[]"] = <?php echo $tmp_lot_query_search->product->Lookup->toClientList() ?>;
ftmp_lot_querysearch.lists["x_product[]"].options = <?php echo JsonEncode($tmp_lot_query_search->product->lookupOptions()) ?>;
ftmp_lot_querysearch.lists["x_product_code[]"] = <?php echo $tmp_lot_query_search->product_code->Lookup->toClientList() ?>;
ftmp_lot_querysearch.lists["x_product_code[]"].options = <?php echo JsonEncode($tmp_lot_query_search->product_code->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ftmp_lot_querysearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_OUT");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->OUT->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_IN");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->IN->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_tmp_lot");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->tmp_lot->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_percent");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_lot_query->percent->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tmp_lot_query_search->showPageHeader(); ?>
<?php
$tmp_lot_query_search->showMessage();
?>
<form name="ftmp_lot_querysearch" id="ftmp_lot_querysearch" class="<?php echo $tmp_lot_query_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tmp_lot_query_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tmp_lot_query_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tmp_lot_query">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$tmp_lot_query_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($tmp_lot_query->rid->Visible) { // rid ?>
	<div id="r_rid" class="form-group row">
		<label class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_rid"><?php echo $tmp_lot_query->rid->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->rid->cellAttributes() ?>>
			<span id="el_tmp_lot_query_rid">
<input type="text" data-table="tmp_lot_query" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->rid->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->rid->EditValue ?>"<?php echo $tmp_lot_query->rid->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->product->Visible) { // product ?>
	<div id="r_product" class="form-group row">
		<label for="x_product" class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_product"><?php echo $tmp_lot_query->product->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product" id="z_product" value="="></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->product->cellAttributes() ?>>
			<span id="el_tmp_lot_query_product">
<?php $tmp_lot_query->product->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$tmp_lot_query->product->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="tmp_lot_query" data-field="x_product" data-value-separator="<?php echo $tmp_lot_query->product->displayValueSeparatorAttribute() ?>" id="x_product[]" name="x_product[]" multiple="multiple"<?php echo $tmp_lot_query->product->editAttributes() ?>>
		<?php echo $tmp_lot_query->product->selectOptionListHtml("x_product[]") ?>
	</select>
</div>
<?php echo $tmp_lot_query->product->Lookup->getParamTag("p_x_product") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->product_code->Visible) { // product_code ?>
	<div id="r_product_code" class="form-group row">
		<label class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_product_code"><?php echo $tmp_lot_query->product_code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_product_code" id="z_product_code" value="="></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->product_code->cellAttributes() ?>>
			<span id="el_tmp_lot_query_product_code">
<div id="tp_x_product_code" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_lot_query" data-field="x_product_code" data-value-separator="<?php echo $tmp_lot_query->product_code->displayValueSeparatorAttribute() ?>" name="x_product_code[]" id="x_product_code[]" value="{value}"<?php echo $tmp_lot_query->product_code->editAttributes() ?>></div>
<div id="dsl_x_product_code" data-repeatcolumn="2" class="ew-item-list d-none"><div>
<?php echo $tmp_lot_query->product_code->checkBoxListHtml(FALSE, "x_product_code[]") ?>
</div></div>
<?php echo $tmp_lot_query->product_code->Lookup->getParamTag("p_x_product_code") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->OUT->Visible) { // OUT ?>
	<div id="r_OUT" class="form-group row">
		<label for="x_OUT" class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_OUT"><?php echo $tmp_lot_query->OUT->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_OUT" id="z_OUT" value="="></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->OUT->cellAttributes() ?>>
			<span id="el_tmp_lot_query_OUT">
<input type="text" data-table="tmp_lot_query" data-field="x_OUT" name="x_OUT" id="x_OUT" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->OUT->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->OUT->EditValue ?>"<?php echo $tmp_lot_query->OUT->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->IN->Visible) { // IN ?>
	<div id="r_IN" class="form-group row">
		<label for="x_IN" class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_IN"><?php echo $tmp_lot_query->IN->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_IN" id="z_IN" value="="></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->IN->cellAttributes() ?>>
			<span id="el_tmp_lot_query_IN">
<input type="text" data-table="tmp_lot_query" data-field="x_IN" name="x_IN" id="x_IN" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->IN->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->IN->EditValue ?>"<?php echo $tmp_lot_query->IN->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->tmp_lot->Visible) { // tmp_lot ?>
	<div id="r_tmp_lot" class="form-group row">
		<label for="x_tmp_lot" class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_tmp_lot"><?php echo $tmp_lot_query->tmp_lot->caption() ?></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->tmp_lot->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_tmp_lot" id="z_tmp_lot" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="LIKE"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("LIKE") ?></option><option value="NOT LIKE"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "NOT LIKE") ? " selected" : "" ?> ><?php echo $Language->phrase("NOT LIKE") ?></option><option value="STARTS WITH"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "STARTS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("STARTS WITH") ?></option><option value="ENDS WITH"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "ENDS WITH") ? " selected" : "" ?> ><?php echo $Language->phrase("ENDS WITH") ?></option><option value="IS NULL"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($tmp_lot_query->tmp_lot->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_tmp_lot_query_tmp_lot">
<input type="text" data-table="tmp_lot_query" data-field="x_tmp_lot" name="x_tmp_lot" id="x_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->tmp_lot->EditValue ?>"<?php echo $tmp_lot_query->tmp_lot->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_tmp_lot d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_tmp_lot_query_tmp_lot" class="btw1_tmp_lot d-none">
<input type="text" data-table="tmp_lot_query" data-field="x_tmp_lot" name="y_tmp_lot" id="y_tmp_lot" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->tmp_lot->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->tmp_lot->EditValue2 ?>"<?php echo $tmp_lot_query->tmp_lot->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->percent->Visible) { // percent ?>
	<div id="r_percent" class="form-group row">
		<label for="x_percent" class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_percent"><?php echo $tmp_lot_query->percent->caption() ?></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->percent->cellAttributes() ?>>
		<span class="ew-search-operator"><select name="z_percent" id="z_percent" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($tmp_lot_query->percent->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
			<span id="el_tmp_lot_query_percent">
<input type="text" data-table="tmp_lot_query" data-field="x_percent" name="x_percent" id="x_percent" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->percent->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->percent->EditValue ?>"<?php echo $tmp_lot_query->percent->editAttributes() ?>>
</span>
			<span class="ew-search-cond btw1_percent d-none"><label><?php echo $Language->Phrase("AND") ?></label></span>
			<span id="e2_tmp_lot_query_percent" class="btw1_percent d-none">
<input type="text" data-table="tmp_lot_query" data-field="x_percent" name="y_percent" id="y_percent" size="30" placeholder="<?php echo HtmlEncode($tmp_lot_query->percent->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->percent->EditValue2 ?>"<?php echo $tmp_lot_query->percent->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_lot_query->process->Visible) { // process ?>
	<div id="r_process" class="form-group row">
		<label for="x_process" class="<?php echo $tmp_lot_query_search->LeftColumnClass ?>"><span id="elh_tmp_lot_query_process"><?php echo $tmp_lot_query->process->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_process" id="z_process" value="LIKE"></span>
		</label>
		<div class="<?php echo $tmp_lot_query_search->RightColumnClass ?>"><div<?php echo $tmp_lot_query->process->cellAttributes() ?>>
			<span id="el_tmp_lot_query_process">
<input type="text" data-table="tmp_lot_query" data-field="x_process" name="x_process" id="x_process" size="35" placeholder="<?php echo HtmlEncode($tmp_lot_query->process->getPlaceHolder()) ?>" value="<?php echo $tmp_lot_query->process->EditValue ?>"<?php echo $tmp_lot_query->process->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$tmp_lot_query_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tmp_lot_query_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tmp_lot_query_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tmp_lot_query_search->terminate();
?>