<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tmp_notes_bc_add = new tmp_notes_bc_add();

// Run the page
$tmp_notes_bc_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tmp_notes_bc_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var ftmp_notes_bcadd = currentForm = new ew.Form("ftmp_notes_bcadd", "add");

// Validate form
ftmp_notes_bcadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($tmp_notes_bc_add->buyer->Required) { ?>
			elm = this.getElements("x" + infix + "_buyer");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->buyer->caption(), $tmp_notes_bc->buyer->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tmp_notes_bc_add->design->Required) { ?>
			elm = this.getElements("x" + infix + "_design[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->design->caption(), $tmp_notes_bc->design->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tmp_notes_bc_add->size->Required) { ?>
			elm = this.getElements("x" + infix + "_size[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->size->caption(), $tmp_notes_bc->size->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tmp_notes_bc_add->_barcode->Required) { ?>
			elm = this.getElements("x" + infix + "__barcode[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->_barcode->caption(), $tmp_notes_bc->_barcode->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tmp_notes_bc_add->delivery_date_new->Required) { ?>
			elm = this.getElements("x" + infix + "_delivery_date_new");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->delivery_date_new->caption(), $tmp_notes_bc->delivery_date_new->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_delivery_date_new");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($tmp_notes_bc->delivery_date_new->errorMessage()) ?>");
		<?php if ($tmp_notes_bc_add->remarks->Required) { ?>
			elm = this.getElements("x" + infix + "_remarks");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->remarks->caption(), $tmp_notes_bc->remarks->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tmp_notes_bc_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->operator->caption(), $tmp_notes_bc->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($tmp_notes_bc_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $tmp_notes_bc->datetime->caption(), $tmp_notes_bc->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
ftmp_notes_bcadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_notes_bcadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_notes_bcadd.lists["x_buyer"] = <?php echo $tmp_notes_bc_add->buyer->Lookup->toClientList() ?>;
ftmp_notes_bcadd.lists["x_buyer"].options = <?php echo JsonEncode($tmp_notes_bc_add->buyer->lookupOptions()) ?>;
ftmp_notes_bcadd.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ftmp_notes_bcadd.lists["x_design[]"] = <?php echo $tmp_notes_bc_add->design->Lookup->toClientList() ?>;
ftmp_notes_bcadd.lists["x_design[]"].options = <?php echo JsonEncode($tmp_notes_bc_add->design->lookupOptions()) ?>;
ftmp_notes_bcadd.lists["x_size[]"] = <?php echo $tmp_notes_bc_add->size->Lookup->toClientList() ?>;
ftmp_notes_bcadd.lists["x_size[]"].options = <?php echo JsonEncode($tmp_notes_bc_add->size->lookupOptions()) ?>;
ftmp_notes_bcadd.lists["x__barcode[]"] = <?php echo $tmp_notes_bc_add->_barcode->Lookup->toClientList() ?>;
ftmp_notes_bcadd.lists["x__barcode[]"].options = <?php echo JsonEncode($tmp_notes_bc_add->_barcode->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tmp_notes_bc_add->showPageHeader(); ?>
<?php
$tmp_notes_bc_add->showMessage();
?>
<form name="ftmp_notes_bcadd" id="ftmp_notes_bcadd" class="<?php echo $tmp_notes_bc_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tmp_notes_bc_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tmp_notes_bc_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tmp_notes_bc">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$tmp_notes_bc_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($tmp_notes_bc->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label id="elh_tmp_notes_bc_buyer" class="<?php echo $tmp_notes_bc_add->LeftColumnClass ?>"><?php echo $tmp_notes_bc->buyer->caption() ?><?php echo ($tmp_notes_bc->buyer->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tmp_notes_bc_add->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->buyer->cellAttributes() ?>>
<span id="el_tmp_notes_bc_buyer">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$tmp_notes_bc->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$tmp_notes_bc->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($tmp_notes_bc->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($tmp_notes_bc->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tmp_notes_bc->buyer->getPlaceHolder()) ?>"<?php echo $tmp_notes_bc->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tmp_notes_bc->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:false});" class="ew-lookup-btn btn btn-default"<?php echo (($tmp_notes_bc->buyer->ReadOnly || $tmp_notes_bc->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="tmp_notes_bc" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tmp_notes_bc->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($tmp_notes_bc->buyer->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
ftmp_notes_bcadd.createAutoSuggest({"id":"x_buyer","forceSelect":true});
</script>
<?php echo $tmp_notes_bc->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
<?php echo $tmp_notes_bc->buyer->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label id="elh_tmp_notes_bc_design" class="<?php echo $tmp_notes_bc_add->LeftColumnClass ?>"><?php echo $tmp_notes_bc->design->caption() ?><?php echo ($tmp_notes_bc->design->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tmp_notes_bc_add->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->design->cellAttributes() ?>>
<span id="el_tmp_notes_bc_design">
<?php $tmp_notes_bc->design->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$tmp_notes_bc->design->EditAttrs["onclick"]; ?>
<div id="tp_x_design" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_design" data-value-separator="<?php echo $tmp_notes_bc->design->displayValueSeparatorAttribute() ?>" name="x_design[]" id="x_design[]" value="{value}"<?php echo $tmp_notes_bc->design->editAttributes() ?>></div>
<div id="dsl_x_design" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $tmp_notes_bc->design->checkBoxListHtml(FALSE, "x_design[]") ?>
</div></div>
<?php echo $tmp_notes_bc->design->Lookup->getParamTag("p_x_design") ?>
</span>
<?php echo $tmp_notes_bc->design->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label id="elh_tmp_notes_bc_size" class="<?php echo $tmp_notes_bc_add->LeftColumnClass ?>"><?php echo $tmp_notes_bc->size->caption() ?><?php echo ($tmp_notes_bc->size->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tmp_notes_bc_add->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->size->cellAttributes() ?>>
<span id="el_tmp_notes_bc_size">
<?php $tmp_notes_bc->size->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$tmp_notes_bc->size->EditAttrs["onclick"]; ?>
<div id="tp_x_size" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_size" data-value-separator="<?php echo $tmp_notes_bc->size->displayValueSeparatorAttribute() ?>" name="x_size[]" id="x_size[]" value="{value}"<?php echo $tmp_notes_bc->size->editAttributes() ?>></div>
<div id="dsl_x_size" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $tmp_notes_bc->size->checkBoxListHtml(FALSE, "x_size[]") ?>
</div></div>
<?php echo $tmp_notes_bc->size->Lookup->getParamTag("p_x_size") ?>
</span>
<?php echo $tmp_notes_bc->size->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label id="elh_tmp_notes_bc__barcode" class="<?php echo $tmp_notes_bc_add->LeftColumnClass ?>"><?php echo $tmp_notes_bc->_barcode->caption() ?><?php echo ($tmp_notes_bc->_barcode->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tmp_notes_bc_add->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->_barcode->cellAttributes() ?>>
<span id="el_tmp_notes_bc__barcode">
<div id="tp_x__barcode" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x__barcode" data-value-separator="<?php echo $tmp_notes_bc->_barcode->displayValueSeparatorAttribute() ?>" name="x__barcode[]" id="x__barcode[]" value="{value}"<?php echo $tmp_notes_bc->_barcode->editAttributes() ?>></div>
<div id="dsl_x__barcode" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $tmp_notes_bc->_barcode->checkBoxListHtml(FALSE, "x__barcode[]") ?>
</div></div>
<?php echo $tmp_notes_bc->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
<?php echo $tmp_notes_bc->_barcode->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->delivery_date_new->Visible) { // delivery_date_new ?>
	<div id="r_delivery_date_new" class="form-group row">
		<label id="elh_tmp_notes_bc_delivery_date_new" for="x_delivery_date_new" class="<?php echo $tmp_notes_bc_add->LeftColumnClass ?>"><?php echo $tmp_notes_bc->delivery_date_new->caption() ?><?php echo ($tmp_notes_bc->delivery_date_new->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tmp_notes_bc_add->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->delivery_date_new->cellAttributes() ?>>
<span id="el_tmp_notes_bc_delivery_date_new">
<input type="text" data-table="tmp_notes_bc" data-field="x_delivery_date_new" name="x_delivery_date_new" id="x_delivery_date_new" size="30" placeholder="<?php echo HtmlEncode($tmp_notes_bc->delivery_date_new->getPlaceHolder()) ?>" value="<?php echo $tmp_notes_bc->delivery_date_new->EditValue ?>"<?php echo $tmp_notes_bc->delivery_date_new->editAttributes() ?>>
<?php if (!$tmp_notes_bc->delivery_date_new->ReadOnly && !$tmp_notes_bc->delivery_date_new->Disabled && !isset($tmp_notes_bc->delivery_date_new->EditAttrs["readonly"]) && !isset($tmp_notes_bc->delivery_date_new->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ftmp_notes_bcadd", "x_delivery_date_new", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $tmp_notes_bc->delivery_date_new->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label id="elh_tmp_notes_bc_remarks" for="x_remarks" class="<?php echo $tmp_notes_bc_add->LeftColumnClass ?>"><?php echo $tmp_notes_bc->remarks->caption() ?><?php echo ($tmp_notes_bc->remarks->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $tmp_notes_bc_add->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->remarks->cellAttributes() ?>>
<span id="el_tmp_notes_bc_remarks">
<textarea data-table="tmp_notes_bc" data-field="x_remarks" name="x_remarks" id="x_remarks" cols="35" rows="4" placeholder="<?php echo HtmlEncode($tmp_notes_bc->remarks->getPlaceHolder()) ?>"<?php echo $tmp_notes_bc->remarks->editAttributes() ?>><?php echo $tmp_notes_bc->remarks->EditValue ?></textarea>
</span>
<?php echo $tmp_notes_bc->remarks->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$tmp_notes_bc_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tmp_notes_bc_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tmp_notes_bc_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tmp_notes_bc_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tmp_notes_bc_add->terminate();
?>