<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tmp_notes_bc_delete = new tmp_notes_bc_delete();

// Run the page
$tmp_notes_bc_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tmp_notes_bc_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var ftmp_notes_bcdelete = currentForm = new ew.Form("ftmp_notes_bcdelete", "delete");

// Form_CustomValidate event
ftmp_notes_bcdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_notes_bcdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_notes_bcdelete.lists["x_buyer"] = <?php echo $tmp_notes_bc_delete->buyer->Lookup->toClientList() ?>;
ftmp_notes_bcdelete.lists["x_buyer"].options = <?php echo JsonEncode($tmp_notes_bc_delete->buyer->lookupOptions()) ?>;
ftmp_notes_bcdelete.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ftmp_notes_bcdelete.lists["x_design[]"] = <?php echo $tmp_notes_bc_delete->design->Lookup->toClientList() ?>;
ftmp_notes_bcdelete.lists["x_design[]"].options = <?php echo JsonEncode($tmp_notes_bc_delete->design->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tmp_notes_bc_delete->showPageHeader(); ?>
<?php
$tmp_notes_bc_delete->showMessage();
?>
<form name="ftmp_notes_bcdelete" id="ftmp_notes_bcdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tmp_notes_bc_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tmp_notes_bc_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tmp_notes_bc">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($tmp_notes_bc_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($tmp_notes_bc->id->Visible) { // id ?>
		<th class="<?php echo $tmp_notes_bc->id->headerCellClass() ?>"><span id="elh_tmp_notes_bc_id" class="tmp_notes_bc_id"><?php echo $tmp_notes_bc->id->caption() ?></span></th>
<?php } ?>
<?php if ($tmp_notes_bc->buyer->Visible) { // buyer ?>
		<th class="<?php echo $tmp_notes_bc->buyer->headerCellClass() ?>"><span id="elh_tmp_notes_bc_buyer" class="tmp_notes_bc_buyer"><?php echo $tmp_notes_bc->buyer->caption() ?></span></th>
<?php } ?>
<?php if ($tmp_notes_bc->design->Visible) { // design ?>
		<th class="<?php echo $tmp_notes_bc->design->headerCellClass() ?>"><span id="elh_tmp_notes_bc_design" class="tmp_notes_bc_design"><?php echo $tmp_notes_bc->design->caption() ?></span></th>
<?php } ?>
<?php if ($tmp_notes_bc->delivery_date_new->Visible) { // delivery_date_new ?>
		<th class="<?php echo $tmp_notes_bc->delivery_date_new->headerCellClass() ?>"><span id="elh_tmp_notes_bc_delivery_date_new" class="tmp_notes_bc_delivery_date_new"><?php echo $tmp_notes_bc->delivery_date_new->caption() ?></span></th>
<?php } ?>
<?php if ($tmp_notes_bc->operator->Visible) { // operator ?>
		<th class="<?php echo $tmp_notes_bc->operator->headerCellClass() ?>"><span id="elh_tmp_notes_bc_operator" class="tmp_notes_bc_operator"><?php echo $tmp_notes_bc->operator->caption() ?></span></th>
<?php } ?>
<?php if ($tmp_notes_bc->datetime->Visible) { // datetime ?>
		<th class="<?php echo $tmp_notes_bc->datetime->headerCellClass() ?>"><span id="elh_tmp_notes_bc_datetime" class="tmp_notes_bc_datetime"><?php echo $tmp_notes_bc->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$tmp_notes_bc_delete->RecCnt = 0;
$i = 0;
while (!$tmp_notes_bc_delete->Recordset->EOF) {
	$tmp_notes_bc_delete->RecCnt++;
	$tmp_notes_bc_delete->RowCnt++;

	// Set row properties
	$tmp_notes_bc->resetAttributes();
	$tmp_notes_bc->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$tmp_notes_bc_delete->loadRowValues($tmp_notes_bc_delete->Recordset);

	// Render row
	$tmp_notes_bc_delete->renderRow();
?>
	<tr<?php echo $tmp_notes_bc->rowAttributes() ?>>
<?php if ($tmp_notes_bc->id->Visible) { // id ?>
		<td<?php echo $tmp_notes_bc->id->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_delete->RowCnt ?>_tmp_notes_bc_id" class="tmp_notes_bc_id">
<span<?php echo $tmp_notes_bc->id->viewAttributes() ?>>
<?php echo $tmp_notes_bc->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tmp_notes_bc->buyer->Visible) { // buyer ?>
		<td<?php echo $tmp_notes_bc->buyer->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_delete->RowCnt ?>_tmp_notes_bc_buyer" class="tmp_notes_bc_buyer">
<span<?php echo $tmp_notes_bc->buyer->viewAttributes() ?>>
<?php echo $tmp_notes_bc->buyer->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tmp_notes_bc->design->Visible) { // design ?>
		<td<?php echo $tmp_notes_bc->design->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_delete->RowCnt ?>_tmp_notes_bc_design" class="tmp_notes_bc_design">
<span<?php echo $tmp_notes_bc->design->viewAttributes() ?>>
<?php echo $tmp_notes_bc->design->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tmp_notes_bc->delivery_date_new->Visible) { // delivery_date_new ?>
		<td<?php echo $tmp_notes_bc->delivery_date_new->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_delete->RowCnt ?>_tmp_notes_bc_delivery_date_new" class="tmp_notes_bc_delivery_date_new">
<span<?php echo $tmp_notes_bc->delivery_date_new->viewAttributes() ?>>
<?php echo $tmp_notes_bc->delivery_date_new->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tmp_notes_bc->operator->Visible) { // operator ?>
		<td<?php echo $tmp_notes_bc->operator->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_delete->RowCnt ?>_tmp_notes_bc_operator" class="tmp_notes_bc_operator">
<span<?php echo $tmp_notes_bc->operator->viewAttributes() ?>>
<?php echo $tmp_notes_bc->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($tmp_notes_bc->datetime->Visible) { // datetime ?>
		<td<?php echo $tmp_notes_bc->datetime->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_delete->RowCnt ?>_tmp_notes_bc_datetime" class="tmp_notes_bc_datetime">
<span<?php echo $tmp_notes_bc->datetime->viewAttributes() ?>>
<?php echo $tmp_notes_bc->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$tmp_notes_bc_delete->Recordset->moveNext();
}
$tmp_notes_bc_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $tmp_notes_bc_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$tmp_notes_bc_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tmp_notes_bc_delete->terminate();
?>