<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tmp_notes_bc_list = new tmp_notes_bc_list();

// Run the page
$tmp_notes_bc_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tmp_notes_bc_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$tmp_notes_bc->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var ftmp_notes_bclist = currentForm = new ew.Form("ftmp_notes_bclist", "list");
ftmp_notes_bclist.formKeyCountName = '<?php echo $tmp_notes_bc_list->FormKeyCountName ?>';

// Form_CustomValidate event
ftmp_notes_bclist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_notes_bclist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_notes_bclist.lists["x_buyer"] = <?php echo $tmp_notes_bc_list->buyer->Lookup->toClientList() ?>;
ftmp_notes_bclist.lists["x_buyer"].options = <?php echo JsonEncode($tmp_notes_bc_list->buyer->lookupOptions()) ?>;
ftmp_notes_bclist.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ftmp_notes_bclist.lists["x_design[]"] = <?php echo $tmp_notes_bc_list->design->Lookup->toClientList() ?>;
ftmp_notes_bclist.lists["x_design[]"].options = <?php echo JsonEncode($tmp_notes_bc_list->design->lookupOptions()) ?>;

// Form object for search
var ftmp_notes_bclistsrch = currentSearchForm = new ew.Form("ftmp_notes_bclistsrch");

// Filters
ftmp_notes_bclistsrch.filterList = <?php echo $tmp_notes_bc_list->getFilterList() ?>;

// Init search panel as collapsed
ftmp_notes_bclistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$tmp_notes_bc->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($tmp_notes_bc_list->TotalRecs > 0 && $tmp_notes_bc_list->ExportOptions->visible()) { ?>
<?php $tmp_notes_bc_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($tmp_notes_bc_list->ImportOptions->visible()) { ?>
<?php $tmp_notes_bc_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($tmp_notes_bc_list->SearchOptions->visible()) { ?>
<?php $tmp_notes_bc_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($tmp_notes_bc_list->FilterOptions->visible()) { ?>
<?php $tmp_notes_bc_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$tmp_notes_bc_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$tmp_notes_bc->isExport() && !$tmp_notes_bc->CurrentAction) { ?>
<form name="ftmp_notes_bclistsrch" id="ftmp_notes_bclistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($tmp_notes_bc_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="ftmp_notes_bclistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="tmp_notes_bc">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($tmp_notes_bc_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($tmp_notes_bc_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $tmp_notes_bc_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($tmp_notes_bc_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($tmp_notes_bc_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($tmp_notes_bc_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($tmp_notes_bc_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $tmp_notes_bc_list->showPageHeader(); ?>
<?php
$tmp_notes_bc_list->showMessage();
?>
<?php if ($tmp_notes_bc_list->TotalRecs > 0 || $tmp_notes_bc->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($tmp_notes_bc_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> tmp_notes_bc">
<?php if (!$tmp_notes_bc->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$tmp_notes_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($tmp_notes_bc_list->Pager)) $tmp_notes_bc_list->Pager = new PrevNextPager($tmp_notes_bc_list->StartRec, $tmp_notes_bc_list->DisplayRecs, $tmp_notes_bc_list->TotalRecs, $tmp_notes_bc_list->AutoHidePager) ?>
<?php if ($tmp_notes_bc_list->Pager->RecordCount > 0 && $tmp_notes_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($tmp_notes_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($tmp_notes_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $tmp_notes_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($tmp_notes_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($tmp_notes_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($tmp_notes_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($tmp_notes_bc_list->TotalRecs > 0 && (!$tmp_notes_bc_list->AutoHidePageSizeSelector || $tmp_notes_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="tmp_notes_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($tmp_notes_bc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($tmp_notes_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($tmp_notes_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($tmp_notes_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($tmp_notes_bc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($tmp_notes_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tmp_notes_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="ftmp_notes_bclist" id="ftmp_notes_bclist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tmp_notes_bc_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tmp_notes_bc_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tmp_notes_bc">
<div id="gmp_tmp_notes_bc" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($tmp_notes_bc_list->TotalRecs > 0 || $tmp_notes_bc->isGridEdit()) { ?>
<table id="tbl_tmp_notes_bclist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$tmp_notes_bc_list->RowType = ROWTYPE_HEADER;

// Render list options
$tmp_notes_bc_list->renderListOptions();

// Render list options (header, left)
$tmp_notes_bc_list->ListOptions->render("header", "left");
?>
<?php if ($tmp_notes_bc->id->Visible) { // id ?>
	<?php if ($tmp_notes_bc->sortUrl($tmp_notes_bc->id) == "") { ?>
		<th data-name="id" class="<?php echo $tmp_notes_bc->id->headerCellClass() ?>"><div id="elh_tmp_notes_bc_id" class="tmp_notes_bc_id"><div class="ew-table-header-caption"><?php echo $tmp_notes_bc->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $tmp_notes_bc->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_notes_bc->SortUrl($tmp_notes_bc->id) ?>',2);"><div id="elh_tmp_notes_bc_id" class="tmp_notes_bc_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_notes_bc->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_notes_bc->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_notes_bc->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_notes_bc->buyer->Visible) { // buyer ?>
	<?php if ($tmp_notes_bc->sortUrl($tmp_notes_bc->buyer) == "") { ?>
		<th data-name="buyer" class="<?php echo $tmp_notes_bc->buyer->headerCellClass() ?>"><div id="elh_tmp_notes_bc_buyer" class="tmp_notes_bc_buyer"><div class="ew-table-header-caption"><?php echo $tmp_notes_bc->buyer->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyer" class="<?php echo $tmp_notes_bc->buyer->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_notes_bc->SortUrl($tmp_notes_bc->buyer) ?>',2);"><div id="elh_tmp_notes_bc_buyer" class="tmp_notes_bc_buyer">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_notes_bc->buyer->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_notes_bc->buyer->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_notes_bc->buyer->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_notes_bc->design->Visible) { // design ?>
	<?php if ($tmp_notes_bc->sortUrl($tmp_notes_bc->design) == "") { ?>
		<th data-name="design" class="<?php echo $tmp_notes_bc->design->headerCellClass() ?>"><div id="elh_tmp_notes_bc_design" class="tmp_notes_bc_design"><div class="ew-table-header-caption"><?php echo $tmp_notes_bc->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $tmp_notes_bc->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_notes_bc->SortUrl($tmp_notes_bc->design) ?>',2);"><div id="elh_tmp_notes_bc_design" class="tmp_notes_bc_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_notes_bc->design->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_notes_bc->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_notes_bc->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_notes_bc->delivery_date_new->Visible) { // delivery_date_new ?>
	<?php if ($tmp_notes_bc->sortUrl($tmp_notes_bc->delivery_date_new) == "") { ?>
		<th data-name="delivery_date_new" class="<?php echo $tmp_notes_bc->delivery_date_new->headerCellClass() ?>"><div id="elh_tmp_notes_bc_delivery_date_new" class="tmp_notes_bc_delivery_date_new"><div class="ew-table-header-caption"><?php echo $tmp_notes_bc->delivery_date_new->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="delivery_date_new" class="<?php echo $tmp_notes_bc->delivery_date_new->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_notes_bc->SortUrl($tmp_notes_bc->delivery_date_new) ?>',2);"><div id="elh_tmp_notes_bc_delivery_date_new" class="tmp_notes_bc_delivery_date_new">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_notes_bc->delivery_date_new->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_notes_bc->delivery_date_new->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_notes_bc->delivery_date_new->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_notes_bc->operator->Visible) { // operator ?>
	<?php if ($tmp_notes_bc->sortUrl($tmp_notes_bc->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $tmp_notes_bc->operator->headerCellClass() ?>"><div id="elh_tmp_notes_bc_operator" class="tmp_notes_bc_operator"><div class="ew-table-header-caption"><?php echo $tmp_notes_bc->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $tmp_notes_bc->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_notes_bc->SortUrl($tmp_notes_bc->operator) ?>',2);"><div id="elh_tmp_notes_bc_operator" class="tmp_notes_bc_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_notes_bc->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_notes_bc->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_notes_bc->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($tmp_notes_bc->datetime->Visible) { // datetime ?>
	<?php if ($tmp_notes_bc->sortUrl($tmp_notes_bc->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $tmp_notes_bc->datetime->headerCellClass() ?>"><div id="elh_tmp_notes_bc_datetime" class="tmp_notes_bc_datetime"><div class="ew-table-header-caption"><?php echo $tmp_notes_bc->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $tmp_notes_bc->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $tmp_notes_bc->SortUrl($tmp_notes_bc->datetime) ?>',2);"><div id="elh_tmp_notes_bc_datetime" class="tmp_notes_bc_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $tmp_notes_bc->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($tmp_notes_bc->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($tmp_notes_bc->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$tmp_notes_bc_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($tmp_notes_bc->ExportAll && $tmp_notes_bc->isExport()) {
	$tmp_notes_bc_list->StopRec = $tmp_notes_bc_list->TotalRecs;
} else {

	// Set the last record to display
	if ($tmp_notes_bc_list->TotalRecs > $tmp_notes_bc_list->StartRec + $tmp_notes_bc_list->DisplayRecs - 1)
		$tmp_notes_bc_list->StopRec = $tmp_notes_bc_list->StartRec + $tmp_notes_bc_list->DisplayRecs - 1;
	else
		$tmp_notes_bc_list->StopRec = $tmp_notes_bc_list->TotalRecs;
}
$tmp_notes_bc_list->RecCnt = $tmp_notes_bc_list->StartRec - 1;
if ($tmp_notes_bc_list->Recordset && !$tmp_notes_bc_list->Recordset->EOF) {
	$tmp_notes_bc_list->Recordset->moveFirst();
	$selectLimit = $tmp_notes_bc_list->UseSelectLimit;
	if (!$selectLimit && $tmp_notes_bc_list->StartRec > 1)
		$tmp_notes_bc_list->Recordset->move($tmp_notes_bc_list->StartRec - 1);
} elseif (!$tmp_notes_bc->AllowAddDeleteRow && $tmp_notes_bc_list->StopRec == 0) {
	$tmp_notes_bc_list->StopRec = $tmp_notes_bc->GridAddRowCount;
}

// Initialize aggregate
$tmp_notes_bc->RowType = ROWTYPE_AGGREGATEINIT;
$tmp_notes_bc->resetAttributes();
$tmp_notes_bc_list->renderRow();
while ($tmp_notes_bc_list->RecCnt < $tmp_notes_bc_list->StopRec) {
	$tmp_notes_bc_list->RecCnt++;
	if ($tmp_notes_bc_list->RecCnt >= $tmp_notes_bc_list->StartRec) {
		$tmp_notes_bc_list->RowCnt++;

		// Set up key count
		$tmp_notes_bc_list->KeyCount = $tmp_notes_bc_list->RowIndex;

		// Init row class and style
		$tmp_notes_bc->resetAttributes();
		$tmp_notes_bc->CssClass = "";
		if ($tmp_notes_bc->isGridAdd()) {
		} else {
			$tmp_notes_bc_list->loadRowValues($tmp_notes_bc_list->Recordset); // Load row values
		}
		$tmp_notes_bc->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$tmp_notes_bc->RowAttrs = array_merge($tmp_notes_bc->RowAttrs, array('data-rowindex'=>$tmp_notes_bc_list->RowCnt, 'id'=>'r' . $tmp_notes_bc_list->RowCnt . '_tmp_notes_bc', 'data-rowtype'=>$tmp_notes_bc->RowType));

		// Render row
		$tmp_notes_bc_list->renderRow();

		// Render list options
		$tmp_notes_bc_list->renderListOptions();
?>
	<tr<?php echo $tmp_notes_bc->rowAttributes() ?>>
<?php

// Render list options (body, left)
$tmp_notes_bc_list->ListOptions->render("body", "left", $tmp_notes_bc_list->RowCnt);
?>
	<?php if ($tmp_notes_bc->id->Visible) { // id ?>
		<td data-name="id"<?php echo $tmp_notes_bc->id->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_list->RowCnt ?>_tmp_notes_bc_id" class="tmp_notes_bc_id">
<span<?php echo $tmp_notes_bc->id->viewAttributes() ?>>
<?php echo $tmp_notes_bc->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_notes_bc->buyer->Visible) { // buyer ?>
		<td data-name="buyer"<?php echo $tmp_notes_bc->buyer->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_list->RowCnt ?>_tmp_notes_bc_buyer" class="tmp_notes_bc_buyer">
<span<?php echo $tmp_notes_bc->buyer->viewAttributes() ?>>
<?php echo $tmp_notes_bc->buyer->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_notes_bc->design->Visible) { // design ?>
		<td data-name="design"<?php echo $tmp_notes_bc->design->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_list->RowCnt ?>_tmp_notes_bc_design" class="tmp_notes_bc_design">
<span<?php echo $tmp_notes_bc->design->viewAttributes() ?>>
<?php echo $tmp_notes_bc->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_notes_bc->delivery_date_new->Visible) { // delivery_date_new ?>
		<td data-name="delivery_date_new"<?php echo $tmp_notes_bc->delivery_date_new->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_list->RowCnt ?>_tmp_notes_bc_delivery_date_new" class="tmp_notes_bc_delivery_date_new">
<span<?php echo $tmp_notes_bc->delivery_date_new->viewAttributes() ?>>
<?php echo $tmp_notes_bc->delivery_date_new->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_notes_bc->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $tmp_notes_bc->operator->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_list->RowCnt ?>_tmp_notes_bc_operator" class="tmp_notes_bc_operator">
<span<?php echo $tmp_notes_bc->operator->viewAttributes() ?>>
<?php echo $tmp_notes_bc->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($tmp_notes_bc->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $tmp_notes_bc->datetime->cellAttributes() ?>>
<span id="el<?php echo $tmp_notes_bc_list->RowCnt ?>_tmp_notes_bc_datetime" class="tmp_notes_bc_datetime">
<span<?php echo $tmp_notes_bc->datetime->viewAttributes() ?>>
<?php echo $tmp_notes_bc->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$tmp_notes_bc_list->ListOptions->render("body", "right", $tmp_notes_bc_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$tmp_notes_bc->isGridAdd())
		$tmp_notes_bc_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$tmp_notes_bc->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($tmp_notes_bc_list->Recordset)
	$tmp_notes_bc_list->Recordset->Close();
?>
<?php if (!$tmp_notes_bc->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$tmp_notes_bc->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($tmp_notes_bc_list->Pager)) $tmp_notes_bc_list->Pager = new PrevNextPager($tmp_notes_bc_list->StartRec, $tmp_notes_bc_list->DisplayRecs, $tmp_notes_bc_list->TotalRecs, $tmp_notes_bc_list->AutoHidePager) ?>
<?php if ($tmp_notes_bc_list->Pager->RecordCount > 0 && $tmp_notes_bc_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($tmp_notes_bc_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($tmp_notes_bc_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $tmp_notes_bc_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($tmp_notes_bc_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($tmp_notes_bc_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $tmp_notes_bc_list->pageUrl() ?>start=<?php echo $tmp_notes_bc_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($tmp_notes_bc_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $tmp_notes_bc_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($tmp_notes_bc_list->TotalRecs > 0 && (!$tmp_notes_bc_list->AutoHidePageSizeSelector || $tmp_notes_bc_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="tmp_notes_bc">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($tmp_notes_bc_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($tmp_notes_bc_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($tmp_notes_bc_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($tmp_notes_bc_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($tmp_notes_bc_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($tmp_notes_bc->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $tmp_notes_bc_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($tmp_notes_bc_list->TotalRecs == 0 && !$tmp_notes_bc->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $tmp_notes_bc_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$tmp_notes_bc_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$tmp_notes_bc->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$tmp_notes_bc->isExport()) { ?>
<script>
ew.scrollableTable("gmp_tmp_notes_bc", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$tmp_notes_bc_list->terminate();
?>