<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$tmp_notes_bc_search = new tmp_notes_bc_search();

// Run the page
$tmp_notes_bc_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$tmp_notes_bc_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($tmp_notes_bc_search->IsModal) { ?>
var ftmp_notes_bcsearch = currentAdvancedSearchForm = new ew.Form("ftmp_notes_bcsearch", "search");
<?php } else { ?>
var ftmp_notes_bcsearch = currentForm = new ew.Form("ftmp_notes_bcsearch", "search");
<?php } ?>

// Form_CustomValidate event
ftmp_notes_bcsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
ftmp_notes_bcsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
ftmp_notes_bcsearch.lists["x_buyer"] = <?php echo $tmp_notes_bc_search->buyer->Lookup->toClientList() ?>;
ftmp_notes_bcsearch.lists["x_buyer"].options = <?php echo JsonEncode($tmp_notes_bc_search->buyer->lookupOptions()) ?>;
ftmp_notes_bcsearch.autoSuggests["x_buyer"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
ftmp_notes_bcsearch.lists["x_design[]"] = <?php echo $tmp_notes_bc_search->design->Lookup->toClientList() ?>;
ftmp_notes_bcsearch.lists["x_design[]"].options = <?php echo JsonEncode($tmp_notes_bc_search->design->lookupOptions()) ?>;
ftmp_notes_bcsearch.lists["x_size[]"] = <?php echo $tmp_notes_bc_search->size->Lookup->toClientList() ?>;
ftmp_notes_bcsearch.lists["x_size[]"].options = <?php echo JsonEncode($tmp_notes_bc_search->size->lookupOptions()) ?>;
ftmp_notes_bcsearch.lists["x__barcode[]"] = <?php echo $tmp_notes_bc_search->_barcode->Lookup->toClientList() ?>;
ftmp_notes_bcsearch.lists["x__barcode[]"].options = <?php echo JsonEncode($tmp_notes_bc_search->_barcode->lookupOptions()) ?>;

// Form object for search
// Validate function for search

ftmp_notes_bcsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_notes_bc->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_delivery_date_new");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_notes_bc->delivery_date_new->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_notes_bc->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($tmp_notes_bc->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $tmp_notes_bc_search->showPageHeader(); ?>
<?php
$tmp_notes_bc_search->showMessage();
?>
<form name="ftmp_notes_bcsearch" id="ftmp_notes_bcsearch" class="<?php echo $tmp_notes_bc_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($tmp_notes_bc_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $tmp_notes_bc_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="tmp_notes_bc">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$tmp_notes_bc_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($tmp_notes_bc->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_id"><?php echo $tmp_notes_bc->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->id->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_id">
<input type="text" data-table="tmp_notes_bc" data-field="x_id" name="x_id" id="x_id" size="30" placeholder="<?php echo HtmlEncode($tmp_notes_bc->id->getPlaceHolder()) ?>" value="<?php echo $tmp_notes_bc->id->EditValue ?>"<?php echo $tmp_notes_bc->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->buyer->Visible) { // buyer ?>
	<div id="r_buyer" class="form-group row">
		<label class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_buyer"><?php echo $tmp_notes_bc->buyer->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_buyer" id="z_buyer" value="="></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->buyer->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_buyer">
<?php
$wrkonchange = "ew.updateOptions.call(this);" . trim(@$tmp_notes_bc->buyer->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$tmp_notes_bc->buyer->EditAttrs["onchange"] = "";
?>
<span id="as_x_buyer" class="text-nowrap" style="z-index: 8980">
	<div class="input-group mb-3">
		<input type="text" class="form-control" name="sv_x_buyer" id="sv_x_buyer" value="<?php echo RemoveHtml($tmp_notes_bc->buyer->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($tmp_notes_bc->buyer->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($tmp_notes_bc->buyer->getPlaceHolder()) ?>"<?php echo $tmp_notes_bc->buyer->editAttributes() ?>>
		<div class="input-group-append">
			<button type="button" title="<?php echo HtmlEncode(str_replace("%s", RemoveHtml($tmp_notes_bc->buyer->caption()), $Language->phrase("LookupLink", TRUE))) ?>" onclick="ew.modalLookupShow({lnk:this,el:'x_buyer',m:0,n:10,srch:true});" class="ew-lookup-btn btn btn-default"<?php echo (($tmp_notes_bc->buyer->ReadOnly || $tmp_notes_bc->buyer->Disabled) ? " disabled" : "")?>><i class="fa fa-search ew-icon"></i></button>
		</div>
	</div>
</span>
<input type="hidden" data-table="tmp_notes_bc" data-field="x_buyer" data-multiple="0" data-lookup="1" data-value-separator="<?php echo $tmp_notes_bc->buyer->displayValueSeparatorAttribute() ?>" name="x_buyer" id="x_buyer" value="<?php echo HtmlEncode($tmp_notes_bc->buyer->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
ftmp_notes_bcsearch.createAutoSuggest({"id":"x_buyer","forceSelect":false});
</script>
<?php echo $tmp_notes_bc->buyer->Lookup->getParamTag("p_x_buyer") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->design->Visible) { // design ?>
	<div id="r_design" class="form-group row">
		<label class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_design"><?php echo $tmp_notes_bc->design->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->design->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_design">
<?php $tmp_notes_bc->design->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$tmp_notes_bc->design->EditAttrs["onclick"]; ?>
<div id="tp_x_design" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_design" data-value-separator="<?php echo $tmp_notes_bc->design->displayValueSeparatorAttribute() ?>" name="x_design[]" id="x_design[]" value="{value}"<?php echo $tmp_notes_bc->design->editAttributes() ?>></div>
<div id="dsl_x_design" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $tmp_notes_bc->design->checkBoxListHtml(FALSE, "x_design[]") ?>
</div></div>
<?php echo $tmp_notes_bc->design->Lookup->getParamTag("p_x_design") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->size->Visible) { // size ?>
	<div id="r_size" class="form-group row">
		<label class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_size"><?php echo $tmp_notes_bc->size->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->size->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_size">
<?php $tmp_notes_bc->size->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$tmp_notes_bc->size->EditAttrs["onclick"]; ?>
<div id="tp_x_size" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x_size" data-value-separator="<?php echo $tmp_notes_bc->size->displayValueSeparatorAttribute() ?>" name="x_size[]" id="x_size[]" value="{value}"<?php echo $tmp_notes_bc->size->editAttributes() ?>></div>
<div id="dsl_x_size" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $tmp_notes_bc->size->checkBoxListHtml(FALSE, "x_size[]") ?>
</div></div>
<?php echo $tmp_notes_bc->size->Lookup->getParamTag("p_x_size") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->_barcode->Visible) { // barcode ?>
	<div id="r__barcode" class="form-group row">
		<label class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc__barcode"><?php echo $tmp_notes_bc->_barcode->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__barcode" id="z__barcode" value="LIKE"></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->_barcode->cellAttributes() ?>>
			<span id="el_tmp_notes_bc__barcode">
<div id="tp_x__barcode" class="ew-template"><input type="checkbox" class="form-check-input" data-table="tmp_notes_bc" data-field="x__barcode" data-value-separator="<?php echo $tmp_notes_bc->_barcode->displayValueSeparatorAttribute() ?>" name="x__barcode[]" id="x__barcode[]" value="{value}"<?php echo $tmp_notes_bc->_barcode->editAttributes() ?>></div>
<div id="dsl_x__barcode" data-repeatcolumn="1" class="ew-item-list d-none"><div>
<?php echo $tmp_notes_bc->_barcode->checkBoxListHtml(FALSE, "x__barcode[]") ?>
</div></div>
<?php echo $tmp_notes_bc->_barcode->Lookup->getParamTag("p_x__barcode") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->delivery_date_new->Visible) { // delivery_date_new ?>
	<div id="r_delivery_date_new" class="form-group row">
		<label for="x_delivery_date_new" class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_delivery_date_new"><?php echo $tmp_notes_bc->delivery_date_new->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_delivery_date_new" id="z_delivery_date_new" value="="></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->delivery_date_new->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_delivery_date_new">
<input type="text" data-table="tmp_notes_bc" data-field="x_delivery_date_new" name="x_delivery_date_new" id="x_delivery_date_new" size="30" placeholder="<?php echo HtmlEncode($tmp_notes_bc->delivery_date_new->getPlaceHolder()) ?>" value="<?php echo $tmp_notes_bc->delivery_date_new->EditValue ?>"<?php echo $tmp_notes_bc->delivery_date_new->editAttributes() ?>>
<?php if (!$tmp_notes_bc->delivery_date_new->ReadOnly && !$tmp_notes_bc->delivery_date_new->Disabled && !isset($tmp_notes_bc->delivery_date_new->EditAttrs["readonly"]) && !isset($tmp_notes_bc->delivery_date_new->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ftmp_notes_bcsearch", "x_delivery_date_new", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->remarks->Visible) { // remarks ?>
	<div id="r_remarks" class="form-group row">
		<label for="x_remarks" class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_remarks"><?php echo $tmp_notes_bc->remarks->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_remarks" id="z_remarks" value="LIKE"></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->remarks->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_remarks">
<input type="text" data-table="tmp_notes_bc" data-field="x_remarks" name="x_remarks" id="x_remarks" size="35" placeholder="<?php echo HtmlEncode($tmp_notes_bc->remarks->getPlaceHolder()) ?>" value="<?php echo $tmp_notes_bc->remarks->EditValue ?>"<?php echo $tmp_notes_bc->remarks->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_operator"><?php echo $tmp_notes_bc->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->operator->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_operator">
<input type="text" data-table="tmp_notes_bc" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($tmp_notes_bc->operator->getPlaceHolder()) ?>" value="<?php echo $tmp_notes_bc->operator->EditValue ?>"<?php echo $tmp_notes_bc->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($tmp_notes_bc->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $tmp_notes_bc_search->LeftColumnClass ?>"><span id="elh_tmp_notes_bc_datetime"><?php echo $tmp_notes_bc->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $tmp_notes_bc_search->RightColumnClass ?>"><div<?php echo $tmp_notes_bc->datetime->cellAttributes() ?>>
			<span id="el_tmp_notes_bc_datetime">
<input type="text" data-table="tmp_notes_bc" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($tmp_notes_bc->datetime->getPlaceHolder()) ?>" value="<?php echo $tmp_notes_bc->datetime->EditValue ?>"<?php echo $tmp_notes_bc->datetime->editAttributes() ?>>
<?php if (!$tmp_notes_bc->datetime->ReadOnly && !$tmp_notes_bc->datetime->Disabled && !isset($tmp_notes_bc->datetime->EditAttrs["readonly"]) && !isset($tmp_notes_bc->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("ftmp_notes_bcsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$tmp_notes_bc_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $tmp_notes_bc_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$tmp_notes_bc_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$tmp_notes_bc_search->terminate();
?>