<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$unit_add = new unit_add();

// Run the page
$unit_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$unit_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var funitadd = currentForm = new ew.Form("funitadd", "add");

// Validate form
funitadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($unit_add->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->description->caption(), $unit->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_add->sign->Required) { ?>
			elm = this.getElements("x" + infix + "_sign");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->sign->caption(), $unit->sign->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->operator->caption(), $unit->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->datetime->caption(), $unit->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
funitadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
funitadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
funitadd.lists["x_operator"] = <?php echo $unit_add->operator->Lookup->toClientList() ?>;
funitadd.lists["x_operator"].options = <?php echo JsonEncode($unit_add->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $unit_add->showPageHeader(); ?>
<?php
$unit_add->showMessage();
?>
<form name="funitadd" id="funitadd" class="<?php echo $unit_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($unit_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $unit_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="unit">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$unit_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($unit->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_unit_description" for="x_description" class="<?php echo $unit_add->LeftColumnClass ?>"><?php echo $unit->description->caption() ?><?php echo ($unit->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $unit_add->RightColumnClass ?>"><div<?php echo $unit->description->cellAttributes() ?>>
<span id="el_unit_description">
<input type="text" data-table="unit" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($unit->description->getPlaceHolder()) ?>" value="<?php echo $unit->description->EditValue ?>"<?php echo $unit->description->editAttributes() ?>>
</span>
<?php echo $unit->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($unit->sign->Visible) { // sign ?>
	<div id="r_sign" class="form-group row">
		<label id="elh_unit_sign" for="x_sign" class="<?php echo $unit_add->LeftColumnClass ?>"><?php echo $unit->sign->caption() ?><?php echo ($unit->sign->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $unit_add->RightColumnClass ?>"><div<?php echo $unit->sign->cellAttributes() ?>>
<span id="el_unit_sign">
<input type="text" data-table="unit" data-field="x_sign" name="x_sign" id="x_sign" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($unit->sign->getPlaceHolder()) ?>" value="<?php echo $unit->sign->EditValue ?>"<?php echo $unit->sign->editAttributes() ?>>
</span>
<?php echo $unit->sign->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$unit_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $unit_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $unit_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$unit_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$unit_add->terminate();
?>