<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$unit_delete = new unit_delete();

// Run the page
$unit_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$unit_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var funitdelete = currentForm = new ew.Form("funitdelete", "delete");

// Form_CustomValidate event
funitdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
funitdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
funitdelete.lists["x_operator"] = <?php echo $unit_delete->operator->Lookup->toClientList() ?>;
funitdelete.lists["x_operator"].options = <?php echo JsonEncode($unit_delete->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $unit_delete->showPageHeader(); ?>
<?php
$unit_delete->showMessage();
?>
<form name="funitdelete" id="funitdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($unit_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $unit_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="unit">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($unit_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($unit->id->Visible) { // id ?>
		<th class="<?php echo $unit->id->headerCellClass() ?>"><span id="elh_unit_id" class="unit_id"><?php echo $unit->id->caption() ?></span></th>
<?php } ?>
<?php if ($unit->description->Visible) { // description ?>
		<th class="<?php echo $unit->description->headerCellClass() ?>"><span id="elh_unit_description" class="unit_description"><?php echo $unit->description->caption() ?></span></th>
<?php } ?>
<?php if ($unit->sign->Visible) { // sign ?>
		<th class="<?php echo $unit->sign->headerCellClass() ?>"><span id="elh_unit_sign" class="unit_sign"><?php echo $unit->sign->caption() ?></span></th>
<?php } ?>
<?php if ($unit->operator->Visible) { // operator ?>
		<th class="<?php echo $unit->operator->headerCellClass() ?>"><span id="elh_unit_operator" class="unit_operator"><?php echo $unit->operator->caption() ?></span></th>
<?php } ?>
<?php if ($unit->datetime->Visible) { // datetime ?>
		<th class="<?php echo $unit->datetime->headerCellClass() ?>"><span id="elh_unit_datetime" class="unit_datetime"><?php echo $unit->datetime->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$unit_delete->RecCnt = 0;
$i = 0;
while (!$unit_delete->Recordset->EOF) {
	$unit_delete->RecCnt++;
	$unit_delete->RowCnt++;

	// Set row properties
	$unit->resetAttributes();
	$unit->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$unit_delete->loadRowValues($unit_delete->Recordset);

	// Render row
	$unit_delete->renderRow();
?>
	<tr<?php echo $unit->rowAttributes() ?>>
<?php if ($unit->id->Visible) { // id ?>
		<td<?php echo $unit->id->cellAttributes() ?>>
<span id="el<?php echo $unit_delete->RowCnt ?>_unit_id" class="unit_id">
<span<?php echo $unit->id->viewAttributes() ?>>
<?php echo $unit->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($unit->description->Visible) { // description ?>
		<td<?php echo $unit->description->cellAttributes() ?>>
<span id="el<?php echo $unit_delete->RowCnt ?>_unit_description" class="unit_description">
<span<?php echo $unit->description->viewAttributes() ?>>
<?php echo $unit->description->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($unit->sign->Visible) { // sign ?>
		<td<?php echo $unit->sign->cellAttributes() ?>>
<span id="el<?php echo $unit_delete->RowCnt ?>_unit_sign" class="unit_sign">
<span<?php echo $unit->sign->viewAttributes() ?>>
<?php echo $unit->sign->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($unit->operator->Visible) { // operator ?>
		<td<?php echo $unit->operator->cellAttributes() ?>>
<span id="el<?php echo $unit_delete->RowCnt ?>_unit_operator" class="unit_operator">
<span<?php echo $unit->operator->viewAttributes() ?>>
<?php echo $unit->operator->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($unit->datetime->Visible) { // datetime ?>
		<td<?php echo $unit->datetime->cellAttributes() ?>>
<span id="el<?php echo $unit_delete->RowCnt ?>_unit_datetime" class="unit_datetime">
<span<?php echo $unit->datetime->viewAttributes() ?>>
<?php echo $unit->datetime->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$unit_delete->Recordset->moveNext();
}
$unit_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $unit_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$unit_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$unit_delete->terminate();
?>