<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$unit_edit = new unit_edit();

// Run the page
$unit_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$unit_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var funitedit = currentForm = new ew.Form("funitedit", "edit");

// Validate form
funitedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($unit_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->id->caption(), $unit->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_edit->description->Required) { ?>
			elm = this.getElements("x" + infix + "_description");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->description->caption(), $unit->description->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_edit->sign->Required) { ?>
			elm = this.getElements("x" + infix + "_sign");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->sign->caption(), $unit->sign->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->operator->caption(), $unit->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($unit_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $unit->datetime->caption(), $unit->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
funitedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
funitedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
funitedit.lists["x_operator"] = <?php echo $unit_edit->operator->Lookup->toClientList() ?>;
funitedit.lists["x_operator"].options = <?php echo JsonEncode($unit_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $unit_edit->showPageHeader(); ?>
<?php
$unit_edit->showMessage();
?>
<form name="funitedit" id="funitedit" class="<?php echo $unit_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($unit_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $unit_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="unit">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$unit_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($unit->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_unit_id" class="<?php echo $unit_edit->LeftColumnClass ?>"><?php echo $unit->id->caption() ?><?php echo ($unit->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $unit_edit->RightColumnClass ?>"><div<?php echo $unit->id->cellAttributes() ?>>
<span id="el_unit_id">
<span<?php echo $unit->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($unit->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="unit" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($unit->id->CurrentValue) ?>">
<?php echo $unit->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($unit->description->Visible) { // description ?>
	<div id="r_description" class="form-group row">
		<label id="elh_unit_description" for="x_description" class="<?php echo $unit_edit->LeftColumnClass ?>"><?php echo $unit->description->caption() ?><?php echo ($unit->description->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $unit_edit->RightColumnClass ?>"><div<?php echo $unit->description->cellAttributes() ?>>
<span id="el_unit_description">
<input type="text" data-table="unit" data-field="x_description" name="x_description" id="x_description" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($unit->description->getPlaceHolder()) ?>" value="<?php echo $unit->description->EditValue ?>"<?php echo $unit->description->editAttributes() ?>>
</span>
<?php echo $unit->description->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($unit->sign->Visible) { // sign ?>
	<div id="r_sign" class="form-group row">
		<label id="elh_unit_sign" for="x_sign" class="<?php echo $unit_edit->LeftColumnClass ?>"><?php echo $unit->sign->caption() ?><?php echo ($unit->sign->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $unit_edit->RightColumnClass ?>"><div<?php echo $unit->sign->cellAttributes() ?>>
<span id="el_unit_sign">
<input type="text" data-table="unit" data-field="x_sign" name="x_sign" id="x_sign" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($unit->sign->getPlaceHolder()) ?>" value="<?php echo $unit->sign->EditValue ?>"<?php echo $unit->sign->editAttributes() ?>>
</span>
<?php echo $unit->sign->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$unit_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $unit_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $unit_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$unit_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$unit_edit->terminate();
?>