<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$unit_list = new unit_list();

// Run the page
$unit_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$unit_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$unit->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var funitlist = currentForm = new ew.Form("funitlist", "list");
funitlist.formKeyCountName = '<?php echo $unit_list->FormKeyCountName ?>';

// Form_CustomValidate event
funitlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
funitlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
funitlist.lists["x_operator"] = <?php echo $unit_list->operator->Lookup->toClientList() ?>;
funitlist.lists["x_operator"].options = <?php echo JsonEncode($unit_list->operator->lookupOptions()) ?>;

// Form object for search
var funitlistsrch = currentSearchForm = new ew.Form("funitlistsrch");

// Filters
funitlistsrch.filterList = <?php echo $unit_list->getFilterList() ?>;

// Init search panel as collapsed
funitlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$unit->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($unit_list->TotalRecs > 0 && $unit_list->ExportOptions->visible()) { ?>
<?php $unit_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($unit_list->ImportOptions->visible()) { ?>
<?php $unit_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($unit_list->SearchOptions->visible()) { ?>
<?php $unit_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($unit_list->FilterOptions->visible()) { ?>
<?php $unit_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$unit_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$unit->isExport() && !$unit->CurrentAction) { ?>
<form name="funitlistsrch" id="funitlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($unit_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="funitlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="unit">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($unit_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($unit_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $unit_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($unit_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($unit_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($unit_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($unit_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $unit_list->showPageHeader(); ?>
<?php
$unit_list->showMessage();
?>
<?php if ($unit_list->TotalRecs > 0 || $unit->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($unit_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> unit">
<?php if (!$unit->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$unit->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($unit_list->Pager)) $unit_list->Pager = new PrevNextPager($unit_list->StartRec, $unit_list->DisplayRecs, $unit_list->TotalRecs, $unit_list->AutoHidePager) ?>
<?php if ($unit_list->Pager->RecordCount > 0 && $unit_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($unit_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($unit_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $unit_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($unit_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($unit_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $unit_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($unit_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $unit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $unit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $unit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($unit_list->TotalRecs > 0 && (!$unit_list->AutoHidePageSizeSelector || $unit_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="unit">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($unit_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($unit_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($unit_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($unit_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($unit_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($unit->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $unit_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="funitlist" id="funitlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($unit_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $unit_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="unit">
<div id="gmp_unit" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($unit_list->TotalRecs > 0 || $unit->isGridEdit()) { ?>
<table id="tbl_unitlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$unit_list->RowType = ROWTYPE_HEADER;

// Render list options
$unit_list->renderListOptions();

// Render list options (header, left)
$unit_list->ListOptions->render("header", "left");
?>
<?php if ($unit->id->Visible) { // id ?>
	<?php if ($unit->sortUrl($unit->id) == "") { ?>
		<th data-name="id" class="<?php echo $unit->id->headerCellClass() ?>"><div id="elh_unit_id" class="unit_id"><div class="ew-table-header-caption"><?php echo $unit->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $unit->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $unit->SortUrl($unit->id) ?>',2);"><div id="elh_unit_id" class="unit_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $unit->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($unit->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($unit->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($unit->description->Visible) { // description ?>
	<?php if ($unit->sortUrl($unit->description) == "") { ?>
		<th data-name="description" class="<?php echo $unit->description->headerCellClass() ?>"><div id="elh_unit_description" class="unit_description"><div class="ew-table-header-caption"><?php echo $unit->description->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="description" class="<?php echo $unit->description->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $unit->SortUrl($unit->description) ?>',2);"><div id="elh_unit_description" class="unit_description">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $unit->description->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($unit->description->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($unit->description->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($unit->sign->Visible) { // sign ?>
	<?php if ($unit->sortUrl($unit->sign) == "") { ?>
		<th data-name="sign" class="<?php echo $unit->sign->headerCellClass() ?>"><div id="elh_unit_sign" class="unit_sign"><div class="ew-table-header-caption"><?php echo $unit->sign->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sign" class="<?php echo $unit->sign->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $unit->SortUrl($unit->sign) ?>',2);"><div id="elh_unit_sign" class="unit_sign">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $unit->sign->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($unit->sign->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($unit->sign->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($unit->operator->Visible) { // operator ?>
	<?php if ($unit->sortUrl($unit->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $unit->operator->headerCellClass() ?>"><div id="elh_unit_operator" class="unit_operator"><div class="ew-table-header-caption"><?php echo $unit->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $unit->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $unit->SortUrl($unit->operator) ?>',2);"><div id="elh_unit_operator" class="unit_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $unit->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($unit->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($unit->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($unit->datetime->Visible) { // datetime ?>
	<?php if ($unit->sortUrl($unit->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $unit->datetime->headerCellClass() ?>"><div id="elh_unit_datetime" class="unit_datetime"><div class="ew-table-header-caption"><?php echo $unit->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $unit->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $unit->SortUrl($unit->datetime) ?>',2);"><div id="elh_unit_datetime" class="unit_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $unit->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($unit->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($unit->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$unit_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($unit->ExportAll && $unit->isExport()) {
	$unit_list->StopRec = $unit_list->TotalRecs;
} else {

	// Set the last record to display
	if ($unit_list->TotalRecs > $unit_list->StartRec + $unit_list->DisplayRecs - 1)
		$unit_list->StopRec = $unit_list->StartRec + $unit_list->DisplayRecs - 1;
	else
		$unit_list->StopRec = $unit_list->TotalRecs;
}
$unit_list->RecCnt = $unit_list->StartRec - 1;
if ($unit_list->Recordset && !$unit_list->Recordset->EOF) {
	$unit_list->Recordset->moveFirst();
	$selectLimit = $unit_list->UseSelectLimit;
	if (!$selectLimit && $unit_list->StartRec > 1)
		$unit_list->Recordset->move($unit_list->StartRec - 1);
} elseif (!$unit->AllowAddDeleteRow && $unit_list->StopRec == 0) {
	$unit_list->StopRec = $unit->GridAddRowCount;
}

// Initialize aggregate
$unit->RowType = ROWTYPE_AGGREGATEINIT;
$unit->resetAttributes();
$unit_list->renderRow();
while ($unit_list->RecCnt < $unit_list->StopRec) {
	$unit_list->RecCnt++;
	if ($unit_list->RecCnt >= $unit_list->StartRec) {
		$unit_list->RowCnt++;

		// Set up key count
		$unit_list->KeyCount = $unit_list->RowIndex;

		// Init row class and style
		$unit->resetAttributes();
		$unit->CssClass = "";
		if ($unit->isGridAdd()) {
		} else {
			$unit_list->loadRowValues($unit_list->Recordset); // Load row values
		}
		$unit->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$unit->RowAttrs = array_merge($unit->RowAttrs, array('data-rowindex'=>$unit_list->RowCnt, 'id'=>'r' . $unit_list->RowCnt . '_unit', 'data-rowtype'=>$unit->RowType));

		// Render row
		$unit_list->renderRow();

		// Render list options
		$unit_list->renderListOptions();
?>
	<tr<?php echo $unit->rowAttributes() ?>>
<?php

// Render list options (body, left)
$unit_list->ListOptions->render("body", "left", $unit_list->RowCnt);
?>
	<?php if ($unit->id->Visible) { // id ?>
		<td data-name="id"<?php echo $unit->id->cellAttributes() ?>>
<span id="el<?php echo $unit_list->RowCnt ?>_unit_id" class="unit_id">
<span<?php echo $unit->id->viewAttributes() ?>>
<?php echo $unit->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($unit->description->Visible) { // description ?>
		<td data-name="description"<?php echo $unit->description->cellAttributes() ?>>
<span id="el<?php echo $unit_list->RowCnt ?>_unit_description" class="unit_description">
<span<?php echo $unit->description->viewAttributes() ?>>
<?php echo $unit->description->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($unit->sign->Visible) { // sign ?>
		<td data-name="sign"<?php echo $unit->sign->cellAttributes() ?>>
<span id="el<?php echo $unit_list->RowCnt ?>_unit_sign" class="unit_sign">
<span<?php echo $unit->sign->viewAttributes() ?>>
<?php echo $unit->sign->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($unit->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $unit->operator->cellAttributes() ?>>
<span id="el<?php echo $unit_list->RowCnt ?>_unit_operator" class="unit_operator">
<span<?php echo $unit->operator->viewAttributes() ?>>
<?php echo $unit->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($unit->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $unit->datetime->cellAttributes() ?>>
<span id="el<?php echo $unit_list->RowCnt ?>_unit_datetime" class="unit_datetime">
<span<?php echo $unit->datetime->viewAttributes() ?>>
<?php echo $unit->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$unit_list->ListOptions->render("body", "right", $unit_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$unit->isGridAdd())
		$unit_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$unit->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($unit_list->Recordset)
	$unit_list->Recordset->Close();
?>
<?php if (!$unit->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$unit->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($unit_list->Pager)) $unit_list->Pager = new PrevNextPager($unit_list->StartRec, $unit_list->DisplayRecs, $unit_list->TotalRecs, $unit_list->AutoHidePager) ?>
<?php if ($unit_list->Pager->RecordCount > 0 && $unit_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($unit_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($unit_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $unit_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($unit_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($unit_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $unit_list->pageUrl() ?>start=<?php echo $unit_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $unit_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($unit_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $unit_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $unit_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $unit_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($unit_list->TotalRecs > 0 && (!$unit_list->AutoHidePageSizeSelector || $unit_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="unit">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($unit_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($unit_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($unit_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($unit_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($unit_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($unit->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $unit_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($unit_list->TotalRecs == 0 && !$unit->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $unit_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$unit_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$unit->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$unit->isExport()) { ?>
<script>
ew.scrollableTable("gmp_unit", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$unit_list->terminate();
?>