<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$unit_view = new unit_view();

// Run the page
$unit_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$unit_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$unit->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var funitview = currentForm = new ew.Form("funitview", "view");

// Form_CustomValidate event
funitview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
funitview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
funitview.lists["x_operator"] = <?php echo $unit_view->operator->Lookup->toClientList() ?>;
funitview.lists["x_operator"].options = <?php echo JsonEncode($unit_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$unit->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $unit_view->ExportOptions->render("body") ?>
<?php $unit_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $unit_view->showPageHeader(); ?>
<?php
$unit_view->showMessage();
?>
<form name="funitview" id="funitview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($unit_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $unit_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="unit">
<input type="hidden" name="modal" value="<?php echo (int)$unit_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($unit->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $unit_view->TableLeftColumnClass ?>"><span id="elh_unit_id"><?php echo $unit->id->caption() ?></span></td>
		<td data-name="id"<?php echo $unit->id->cellAttributes() ?>>
<span id="el_unit_id">
<span<?php echo $unit->id->viewAttributes() ?>>
<?php echo $unit->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($unit->description->Visible) { // description ?>
	<tr id="r_description">
		<td class="<?php echo $unit_view->TableLeftColumnClass ?>"><span id="elh_unit_description"><?php echo $unit->description->caption() ?></span></td>
		<td data-name="description"<?php echo $unit->description->cellAttributes() ?>>
<span id="el_unit_description">
<span<?php echo $unit->description->viewAttributes() ?>>
<?php echo $unit->description->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($unit->sign->Visible) { // sign ?>
	<tr id="r_sign">
		<td class="<?php echo $unit_view->TableLeftColumnClass ?>"><span id="elh_unit_sign"><?php echo $unit->sign->caption() ?></span></td>
		<td data-name="sign"<?php echo $unit->sign->cellAttributes() ?>>
<span id="el_unit_sign">
<span<?php echo $unit->sign->viewAttributes() ?>>
<?php echo $unit->sign->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($unit->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $unit_view->TableLeftColumnClass ?>"><span id="elh_unit_operator"><?php echo $unit->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $unit->operator->cellAttributes() ?>>
<span id="el_unit_operator">
<span<?php echo $unit->operator->viewAttributes() ?>>
<?php echo $unit->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($unit->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $unit_view->TableLeftColumnClass ?>"><span id="elh_unit_datetime"><?php echo $unit->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $unit->datetime->cellAttributes() ?>>
<span id="el_unit_datetime">
<span<?php echo $unit->datetime->viewAttributes() ?>>
<?php echo $unit->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$unit_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$unit->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$unit_view->terminate();
?>