<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$user_add = new user_add();

// Run the page
$user_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$user_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fuseradd = currentForm = new ew.Form("fuseradd", "add");

// Validate form
fuseradd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($user_add->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->mobile->caption(), $user->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->user_name->Required) { ?>
			elm = this.getElements("x" + infix + "_user_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->user_name->caption(), $user->user_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->password->Required) { ?>
			elm = this.getElements("x" + infix + "_password");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->password->caption(), $user->password->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->name->caption(), $user->name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->_email->Required) { ?>
			elm = this.getElements("x" + infix + "__email");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->_email->caption(), $user->_email->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->category->Required) { ?>
			elm = this.getElements("x" + infix + "_category[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->category->caption(), $user->category->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->reg_date->Required) { ?>
			elm = this.getElements("x" + infix + "_reg_date");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->reg_date->caption(), $user->reg_date->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->operator->caption(), $user->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->datetime->caption(), $user->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($user_add->max_discount->Required) { ?>
			elm = this.getElements("x" + infix + "_max_discount");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $user->max_discount->caption(), $user->max_discount->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_max_discount");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($user->max_discount->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fuseradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fuseradd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fuseradd.lists["x_mobile"] = <?php echo $user_add->mobile->Lookup->toClientList() ?>;
fuseradd.lists["x_mobile"].options = <?php echo JsonEncode($user_add->mobile->lookupOptions()) ?>;
fuseradd.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuseradd.lists["x_name"] = <?php echo $user_add->name->Lookup->toClientList() ?>;
fuseradd.lists["x_name"].options = <?php echo JsonEncode($user_add->name->lookupOptions()) ?>;
fuseradd.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuseradd.lists["x_category[]"] = <?php echo $user_add->category->Lookup->toClientList() ?>;
fuseradd.lists["x_category[]"].options = <?php echo JsonEncode($user_add->category->lookupOptions()) ?>;
fuseradd.lists["x_operator"] = <?php echo $user_add->operator->Lookup->toClientList() ?>;
fuseradd.lists["x_operator"].options = <?php echo JsonEncode($user_add->operator->lookupOptions()) ?>;
fuseradd.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $user_add->showPageHeader(); ?>
<?php
$user_add->showMessage();
?>
<form name="fuseradd" id="fuseradd" class="<?php echo $user_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($user_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $user_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="user">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$user_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($user->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_user_mobile" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->mobile->caption() ?><?php echo ($user->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->mobile->cellAttributes() ?>>
<span id="el_user_mobile">
<?php
$wrkonchange = "" . trim(@$user->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$user->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8990">
	<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($user->mobile->EditValue) ?>" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($user->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($user->mobile->getPlaceHolder()) ?>"<?php echo $user->mobile->editAttributes() ?>>
</span>
<input type="hidden" data-table="user" data-field="x_mobile" data-value-separator="<?php echo $user->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($user->mobile->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fuseradd.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $user->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
<?php echo $user->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($user->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label id="elh_user_user_name" for="x_user_name" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->user_name->caption() ?><?php echo ($user->user_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->user_name->cellAttributes() ?>>
<span id="el_user_user_name">
<input type="text" data-table="user" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($user->user_name->getPlaceHolder()) ?>" value="<?php echo $user->user_name->EditValue ?>"<?php echo $user->user_name->editAttributes() ?>>
</span>
<?php echo $user->user_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($user->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label id="elh_user_password" for="x_password" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->password->caption() ?><?php echo ($user->password->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->password->cellAttributes() ?>>
<span id="el_user_password">
<input type="text" data-table="user" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($user->password->getPlaceHolder()) ?>" value="<?php echo $user->password->EditValue ?>"<?php echo $user->password->editAttributes() ?>>
</span>
<?php echo $user->password->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($user->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_user_name" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->name->caption() ?><?php echo ($user->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->name->cellAttributes() ?>>
<span id="el_user_name">
<?php
$wrkonchange = "" . trim(@$user->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$user->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($user->name->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($user->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($user->name->getPlaceHolder()) ?>"<?php echo $user->name->editAttributes() ?>>
</span>
<input type="hidden" data-table="user" data-field="x_name" data-value-separator="<?php echo $user->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($user->name->CurrentValue) ?>"<?php echo $wrkonchange ?>>
<script>
fuseradd.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $user->name->Lookup->getParamTag("p_x_name") ?>
</span>
<?php echo $user->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($user->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label id="elh_user__email" for="x__email" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->_email->caption() ?><?php echo ($user->_email->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->_email->cellAttributes() ?>>
<span id="el_user__email">
<input type="text" data-table="user" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($user->_email->getPlaceHolder()) ?>" value="<?php echo $user->_email->EditValue ?>"<?php echo $user->_email->editAttributes() ?>>
</span>
<?php echo $user->_email->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($user->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label id="elh_user_category" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->category->caption() ?><?php echo ($user->category->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->category->cellAttributes() ?>>
<span id="el_user_category">
<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="user" data-field="x_category" data-value-separator="<?php echo $user->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $user->category->editAttributes() ?>></div>
<div id="dsl_x_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $user->category->checkBoxListHtml(FALSE, "x_category[]") ?>
</div></div>
<?php echo $user->category->Lookup->getParamTag("p_x_category") ?>
</span>
<?php echo $user->category->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($user->max_discount->Visible) { // max_discount ?>
	<div id="r_max_discount" class="form-group row">
		<label id="elh_user_max_discount" for="x_max_discount" class="<?php echo $user_add->LeftColumnClass ?>"><?php echo $user->max_discount->caption() ?><?php echo ($user->max_discount->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $user_add->RightColumnClass ?>"><div<?php echo $user->max_discount->cellAttributes() ?>>
<span id="el_user_max_discount">
<input type="text" data-table="user" data-field="x_max_discount" name="x_max_discount" id="x_max_discount" size="30" placeholder="<?php echo HtmlEncode($user->max_discount->getPlaceHolder()) ?>" value="<?php echo $user->max_discount->EditValue ?>"<?php echo $user->max_discount->editAttributes() ?>>
</span>
<?php echo $user->max_discount->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$user_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $user_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $user_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$user_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$user_add->terminate();
?>