<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$user_delete = new user_delete();

// Run the page
$user_delete->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$user_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "delete";
var fuserdelete = currentForm = new ew.Form("fuserdelete", "delete");

// Form_CustomValidate event
fuserdelete.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fuserdelete.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fuserdelete.lists["x_mobile"] = <?php echo $user_delete->mobile->Lookup->toClientList() ?>;
fuserdelete.lists["x_mobile"].options = <?php echo JsonEncode($user_delete->mobile->lookupOptions()) ?>;
fuserdelete.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuserdelete.lists["x_name"] = <?php echo $user_delete->name->Lookup->toClientList() ?>;
fuserdelete.lists["x_name"].options = <?php echo JsonEncode($user_delete->name->lookupOptions()) ?>;
fuserdelete.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuserdelete.lists["x_category[]"] = <?php echo $user_delete->category->Lookup->toClientList() ?>;
fuserdelete.lists["x_category[]"].options = <?php echo JsonEncode($user_delete->category->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $user_delete->showPageHeader(); ?>
<?php
$user_delete->showMessage();
?>
<form name="fuserdelete" id="fuserdelete" class="form-inline ew-form ew-delete-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($user_delete->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $user_delete->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="user">
<input type="hidden" name="action" id="action" value="delete">
<?php foreach ($user_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo HtmlEncode($keyvalue) ?>">
<?php } ?>
<div class="card ew-card ew-grid">
<div class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<table class="table ew-table">
	<thead>
	<tr class="ew-table-header">
<?php if ($user->mobile->Visible) { // mobile ?>
		<th class="<?php echo $user->mobile->headerCellClass() ?>"><span id="elh_user_mobile" class="user_mobile"><?php echo $user->mobile->caption() ?></span></th>
<?php } ?>
<?php if ($user->name->Visible) { // name ?>
		<th class="<?php echo $user->name->headerCellClass() ?>"><span id="elh_user_name" class="user_name"><?php echo $user->name->caption() ?></span></th>
<?php } ?>
<?php if ($user->_email->Visible) { // email ?>
		<th class="<?php echo $user->_email->headerCellClass() ?>"><span id="elh_user__email" class="user__email"><?php echo $user->_email->caption() ?></span></th>
<?php } ?>
<?php if ($user->category->Visible) { // category ?>
		<th class="<?php echo $user->category->headerCellClass() ?>"><span id="elh_user_category" class="user_category"><?php echo $user->category->caption() ?></span></th>
<?php } ?>
<?php if ($user->id->Visible) { // id ?>
		<th class="<?php echo $user->id->headerCellClass() ?>"><span id="elh_user_id" class="user_id"><?php echo $user->id->caption() ?></span></th>
<?php } ?>
<?php if ($user->max_discount->Visible) { // max_discount ?>
		<th class="<?php echo $user->max_discount->headerCellClass() ?>"><span id="elh_user_max_discount" class="user_max_discount"><?php echo $user->max_discount->caption() ?></span></th>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$user_delete->RecCnt = 0;
$i = 0;
while (!$user_delete->Recordset->EOF) {
	$user_delete->RecCnt++;
	$user_delete->RowCnt++;

	// Set row properties
	$user->resetAttributes();
	$user->RowType = ROWTYPE_VIEW; // View

	// Get the field contents
	$user_delete->loadRowValues($user_delete->Recordset);

	// Render row
	$user_delete->renderRow();
?>
	<tr<?php echo $user->rowAttributes() ?>>
<?php if ($user->mobile->Visible) { // mobile ?>
		<td<?php echo $user->mobile->cellAttributes() ?>>
<span id="el<?php echo $user_delete->RowCnt ?>_user_mobile" class="user_mobile">
<span<?php echo $user->mobile->viewAttributes() ?>>
<?php echo $user->mobile->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($user->name->Visible) { // name ?>
		<td<?php echo $user->name->cellAttributes() ?>>
<span id="el<?php echo $user_delete->RowCnt ?>_user_name" class="user_name">
<span<?php echo $user->name->viewAttributes() ?>>
<?php echo $user->name->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($user->_email->Visible) { // email ?>
		<td<?php echo $user->_email->cellAttributes() ?>>
<span id="el<?php echo $user_delete->RowCnt ?>_user__email" class="user__email">
<span<?php echo $user->_email->viewAttributes() ?>>
<?php echo $user->_email->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($user->category->Visible) { // category ?>
		<td<?php echo $user->category->cellAttributes() ?>>
<span id="el<?php echo $user_delete->RowCnt ?>_user_category" class="user_category">
<span<?php echo $user->category->viewAttributes() ?>>
<?php echo $user->category->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($user->id->Visible) { // id ?>
		<td<?php echo $user->id->cellAttributes() ?>>
<span id="el<?php echo $user_delete->RowCnt ?>_user_id" class="user_id">
<span<?php echo $user->id->viewAttributes() ?>>
<?php echo $user->id->getViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($user->max_discount->Visible) { // max_discount ?>
		<td<?php echo $user->max_discount->cellAttributes() ?>>
<span id="el<?php echo $user_delete->RowCnt ?>_user_max_discount" class="user_max_discount">
<span<?php echo $user->max_discount->viewAttributes() ?>>
<?php echo $user->max_discount->getViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$user_delete->Recordset->moveNext();
}
$user_delete->Recordset->close();
?>
</tbody>
</table>
</div>
</div>
<div>
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("DeleteBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $user_delete->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
</div>
</form>
<?php
$user_delete->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$user_delete->terminate();
?>