<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$user_list = new user_list();

// Run the page
$user_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$user_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$user->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fuserlist = currentForm = new ew.Form("fuserlist", "list");
fuserlist.formKeyCountName = '<?php echo $user_list->FormKeyCountName ?>';

// Form_CustomValidate event
fuserlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fuserlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fuserlist.lists["x_mobile"] = <?php echo $user_list->mobile->Lookup->toClientList() ?>;
fuserlist.lists["x_mobile"].options = <?php echo JsonEncode($user_list->mobile->lookupOptions()) ?>;
fuserlist.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuserlist.lists["x_name"] = <?php echo $user_list->name->Lookup->toClientList() ?>;
fuserlist.lists["x_name"].options = <?php echo JsonEncode($user_list->name->lookupOptions()) ?>;
fuserlist.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuserlist.lists["x_category[]"] = <?php echo $user_list->category->Lookup->toClientList() ?>;
fuserlist.lists["x_category[]"].options = <?php echo JsonEncode($user_list->category->lookupOptions()) ?>;

// Form object for search
var fuserlistsrch = currentSearchForm = new ew.Form("fuserlistsrch");

// Filters
fuserlistsrch.filterList = <?php echo $user_list->getFilterList() ?>;

// Init search panel as collapsed
fuserlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$user->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($user_list->TotalRecs > 0 && $user_list->ExportOptions->visible()) { ?>
<?php $user_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($user_list->ImportOptions->visible()) { ?>
<?php $user_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($user_list->SearchOptions->visible()) { ?>
<?php $user_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($user_list->FilterOptions->visible()) { ?>
<?php $user_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$user_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$user->isExport() && !$user->CurrentAction) { ?>
<form name="fuserlistsrch" id="fuserlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($user_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fuserlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="user">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($user_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($user_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $user_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($user_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($user_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($user_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($user_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $user_list->showPageHeader(); ?>
<?php
$user_list->showMessage();
?>
<?php if ($user_list->TotalRecs > 0 || $user->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($user_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> user">
<?php if (!$user->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$user->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($user_list->Pager)) $user_list->Pager = new PrevNextPager($user_list->StartRec, $user_list->DisplayRecs, $user_list->TotalRecs, $user_list->AutoHidePager) ?>
<?php if ($user_list->Pager->RecordCount > 0 && $user_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($user_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($user_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $user_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($user_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($user_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $user_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($user_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $user_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $user_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $user_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($user_list->TotalRecs > 0 && (!$user_list->AutoHidePageSizeSelector || $user_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="user">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($user_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($user_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($user_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($user_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($user_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($user->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $user_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fuserlist" id="fuserlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($user_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $user_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="user">
<div id="gmp_user" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($user_list->TotalRecs > 0 || $user->isGridEdit()) { ?>
<table id="tbl_userlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$user_list->RowType = ROWTYPE_HEADER;

// Render list options
$user_list->renderListOptions();

// Render list options (header, left)
$user_list->ListOptions->render("header", "left");
?>
<?php if ($user->mobile->Visible) { // mobile ?>
	<?php if ($user->sortUrl($user->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $user->mobile->headerCellClass() ?>"><div id="elh_user_mobile" class="user_mobile"><div class="ew-table-header-caption"><?php echo $user->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $user->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $user->SortUrl($user->mobile) ?>',2);"><div id="elh_user_mobile" class="user_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $user->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($user->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($user->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($user->name->Visible) { // name ?>
	<?php if ($user->sortUrl($user->name) == "") { ?>
		<th data-name="name" class="<?php echo $user->name->headerCellClass() ?>"><div id="elh_user_name" class="user_name"><div class="ew-table-header-caption"><?php echo $user->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $user->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $user->SortUrl($user->name) ?>',2);"><div id="elh_user_name" class="user_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $user->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($user->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($user->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($user->_email->Visible) { // email ?>
	<?php if ($user->sortUrl($user->_email) == "") { ?>
		<th data-name="_email" class="<?php echo $user->_email->headerCellClass() ?>"><div id="elh_user__email" class="user__email"><div class="ew-table-header-caption"><?php echo $user->_email->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_email" class="<?php echo $user->_email->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $user->SortUrl($user->_email) ?>',2);"><div id="elh_user__email" class="user__email">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $user->_email->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($user->_email->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($user->_email->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($user->category->Visible) { // category ?>
	<?php if ($user->sortUrl($user->category) == "") { ?>
		<th data-name="category" class="<?php echo $user->category->headerCellClass() ?>"><div id="elh_user_category" class="user_category"><div class="ew-table-header-caption"><?php echo $user->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $user->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $user->SortUrl($user->category) ?>',2);"><div id="elh_user_category" class="user_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $user->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($user->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($user->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($user->id->Visible) { // id ?>
	<?php if ($user->sortUrl($user->id) == "") { ?>
		<th data-name="id" class="<?php echo $user->id->headerCellClass() ?>"><div id="elh_user_id" class="user_id"><div class="ew-table-header-caption"><?php echo $user->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $user->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $user->SortUrl($user->id) ?>',2);"><div id="elh_user_id" class="user_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $user->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($user->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($user->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($user->max_discount->Visible) { // max_discount ?>
	<?php if ($user->sortUrl($user->max_discount) == "") { ?>
		<th data-name="max_discount" class="<?php echo $user->max_discount->headerCellClass() ?>"><div id="elh_user_max_discount" class="user_max_discount"><div class="ew-table-header-caption"><?php echo $user->max_discount->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="max_discount" class="<?php echo $user->max_discount->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $user->SortUrl($user->max_discount) ?>',2);"><div id="elh_user_max_discount" class="user_max_discount">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $user->max_discount->caption() ?></span><span class="ew-table-header-sort"><?php if ($user->max_discount->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($user->max_discount->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$user_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($user->ExportAll && $user->isExport()) {
	$user_list->StopRec = $user_list->TotalRecs;
} else {

	// Set the last record to display
	if ($user_list->TotalRecs > $user_list->StartRec + $user_list->DisplayRecs - 1)
		$user_list->StopRec = $user_list->StartRec + $user_list->DisplayRecs - 1;
	else
		$user_list->StopRec = $user_list->TotalRecs;
}
$user_list->RecCnt = $user_list->StartRec - 1;
if ($user_list->Recordset && !$user_list->Recordset->EOF) {
	$user_list->Recordset->moveFirst();
	$selectLimit = $user_list->UseSelectLimit;
	if (!$selectLimit && $user_list->StartRec > 1)
		$user_list->Recordset->move($user_list->StartRec - 1);
} elseif (!$user->AllowAddDeleteRow && $user_list->StopRec == 0) {
	$user_list->StopRec = $user->GridAddRowCount;
}

// Initialize aggregate
$user->RowType = ROWTYPE_AGGREGATEINIT;
$user->resetAttributes();
$user_list->renderRow();
while ($user_list->RecCnt < $user_list->StopRec) {
	$user_list->RecCnt++;
	if ($user_list->RecCnt >= $user_list->StartRec) {
		$user_list->RowCnt++;

		// Set up key count
		$user_list->KeyCount = $user_list->RowIndex;

		// Init row class and style
		$user->resetAttributes();
		$user->CssClass = "";
		if ($user->isGridAdd()) {
		} else {
			$user_list->loadRowValues($user_list->Recordset); // Load row values
		}
		$user->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$user->RowAttrs = array_merge($user->RowAttrs, array('data-rowindex'=>$user_list->RowCnt, 'id'=>'r' . $user_list->RowCnt . '_user', 'data-rowtype'=>$user->RowType));

		// Render row
		$user_list->renderRow();

		// Render list options
		$user_list->renderListOptions();
?>
	<tr<?php echo $user->rowAttributes() ?>>
<?php

// Render list options (body, left)
$user_list->ListOptions->render("body", "left", $user_list->RowCnt);
?>
	<?php if ($user->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $user->mobile->cellAttributes() ?>>
<span id="el<?php echo $user_list->RowCnt ?>_user_mobile" class="user_mobile">
<span<?php echo $user->mobile->viewAttributes() ?>>
<?php echo $user->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($user->name->Visible) { // name ?>
		<td data-name="name"<?php echo $user->name->cellAttributes() ?>>
<span id="el<?php echo $user_list->RowCnt ?>_user_name" class="user_name">
<span<?php echo $user->name->viewAttributes() ?>>
<?php echo $user->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($user->_email->Visible) { // email ?>
		<td data-name="_email"<?php echo $user->_email->cellAttributes() ?>>
<span id="el<?php echo $user_list->RowCnt ?>_user__email" class="user__email">
<span<?php echo $user->_email->viewAttributes() ?>>
<?php echo $user->_email->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($user->category->Visible) { // category ?>
		<td data-name="category"<?php echo $user->category->cellAttributes() ?>>
<span id="el<?php echo $user_list->RowCnt ?>_user_category" class="user_category">
<span<?php echo $user->category->viewAttributes() ?>>
<?php echo $user->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($user->id->Visible) { // id ?>
		<td data-name="id"<?php echo $user->id->cellAttributes() ?>>
<span id="el<?php echo $user_list->RowCnt ?>_user_id" class="user_id">
<span<?php echo $user->id->viewAttributes() ?>>
<?php echo $user->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($user->max_discount->Visible) { // max_discount ?>
		<td data-name="max_discount"<?php echo $user->max_discount->cellAttributes() ?>>
<span id="el<?php echo $user_list->RowCnt ?>_user_max_discount" class="user_max_discount">
<span<?php echo $user->max_discount->viewAttributes() ?>>
<?php echo $user->max_discount->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$user_list->ListOptions->render("body", "right", $user_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$user->isGridAdd())
		$user_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$user->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($user_list->Recordset)
	$user_list->Recordset->Close();
?>
<?php if (!$user->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$user->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($user_list->Pager)) $user_list->Pager = new PrevNextPager($user_list->StartRec, $user_list->DisplayRecs, $user_list->TotalRecs, $user_list->AutoHidePager) ?>
<?php if ($user_list->Pager->RecordCount > 0 && $user_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($user_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($user_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $user_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($user_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($user_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $user_list->pageUrl() ?>start=<?php echo $user_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $user_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($user_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $user_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $user_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $user_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($user_list->TotalRecs > 0 && (!$user_list->AutoHidePageSizeSelector || $user_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="user">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($user_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($user_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($user_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($user_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($user_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($user->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $user_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($user_list->TotalRecs == 0 && !$user->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $user_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$user_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$user->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$user->isExport()) { ?>
<script>
ew.scrollableTable("gmp_user", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$user_list->terminate();
?>