<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$user_search = new user_search();

// Run the page
$user_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$user_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($user_search->IsModal) { ?>
var fusersearch = currentAdvancedSearchForm = new ew.Form("fusersearch", "search");
<?php } else { ?>
var fusersearch = currentForm = new ew.Form("fusersearch", "search");
<?php } ?>

// Form_CustomValidate event
fusersearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fusersearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fusersearch.lists["x_mobile"] = <?php echo $user_search->mobile->Lookup->toClientList() ?>;
fusersearch.lists["x_mobile"].options = <?php echo JsonEncode($user_search->mobile->lookupOptions()) ?>;
fusersearch.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fusersearch.lists["x_name"] = <?php echo $user_search->name->Lookup->toClientList() ?>;
fusersearch.lists["x_name"].options = <?php echo JsonEncode($user_search->name->lookupOptions()) ?>;
fusersearch.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fusersearch.lists["x_category[]"] = <?php echo $user_search->category->Lookup->toClientList() ?>;
fusersearch.lists["x_category[]"].options = <?php echo JsonEncode($user_search->category->lookupOptions()) ?>;
fusersearch.lists["x_status"] = <?php echo $user_search->status->Lookup->toClientList() ?>;
fusersearch.lists["x_status"].options = <?php echo JsonEncode($user_search->status->options(FALSE, TRUE)) ?>;
fusersearch.lists["x_operator"] = <?php echo $user_search->operator->Lookup->toClientList() ?>;
fusersearch.lists["x_operator"].options = <?php echo JsonEncode($user_search->operator->lookupOptions()) ?>;
fusersearch.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
// Validate function for search

fusersearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_last_login");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->last_login->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_reg_date");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->reg_date->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_reg_device");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->reg_device->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_app_version");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->app_version->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_cart_number");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->cart_number->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_max_discount");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($user->max_discount->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $user_search->showPageHeader(); ?>
<?php
$user_search->showMessage();
?>
<form name="fusersearch" id="fusersearch" class="<?php echo $user_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($user_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $user_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="user">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$user_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($user->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_mobile"><?php echo $user->mobile->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_mobile" id="z_mobile" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->mobile->cellAttributes() ?>>
			<span id="el_user_mobile">
<?php
$wrkonchange = "" . trim(@$user->mobile->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$user->mobile->EditAttrs["onchange"] = "";
?>
<span id="as_x_mobile" class="text-nowrap" style="z-index: 8990">
	<input type="text" class="form-control" name="sv_x_mobile" id="sv_x_mobile" value="<?php echo RemoveHtml($user->mobile->EditValue) ?>" size="30" maxlength="22" placeholder="<?php echo HtmlEncode($user->mobile->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($user->mobile->getPlaceHolder()) ?>"<?php echo $user->mobile->editAttributes() ?>>
</span>
<input type="hidden" data-table="user" data-field="x_mobile" data-value-separator="<?php echo $user->mobile->displayValueSeparatorAttribute() ?>" name="x_mobile" id="x_mobile" value="<?php echo HtmlEncode($user->mobile->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fusersearch.createAutoSuggest({"id":"x_mobile","forceSelect":false});
</script>
<?php echo $user->mobile->Lookup->getParamTag("p_x_mobile") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->user_name->Visible) { // user_name ?>
	<div id="r_user_name" class="form-group row">
		<label for="x_user_name" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_user_name"><?php echo $user->user_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_user_name" id="z_user_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->user_name->cellAttributes() ?>>
			<span id="el_user_user_name">
<input type="text" data-table="user" data-field="x_user_name" name="x_user_name" id="x_user_name" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($user->user_name->getPlaceHolder()) ?>" value="<?php echo $user->user_name->EditValue ?>"<?php echo $user->user_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->password->Visible) { // password ?>
	<div id="r_password" class="form-group row">
		<label for="x_password" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_password"><?php echo $user->password->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_password" id="z_password" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->password->cellAttributes() ?>>
			<span id="el_user_password">
<input type="text" data-table="user" data-field="x_password" name="x_password" id="x_password" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($user->password->getPlaceHolder()) ?>" value="<?php echo $user->password->EditValue ?>"<?php echo $user->password->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_name"><?php echo $user->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->name->cellAttributes() ?>>
			<span id="el_user_name">
<?php
$wrkonchange = "" . trim(@$user->name->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$user->name->EditAttrs["onchange"] = "";
?>
<span id="as_x_name" class="text-nowrap" style="z-index: 8960">
	<input type="text" class="form-control" name="sv_x_name" id="sv_x_name" value="<?php echo RemoveHtml($user->name->EditValue) ?>" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($user->name->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($user->name->getPlaceHolder()) ?>"<?php echo $user->name->editAttributes() ?>>
</span>
<input type="hidden" data-table="user" data-field="x_name" data-value-separator="<?php echo $user->name->displayValueSeparatorAttribute() ?>" name="x_name" id="x_name" value="<?php echo HtmlEncode($user->name->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fusersearch.createAutoSuggest({"id":"x_name","forceSelect":false});
</script>
<?php echo $user->name->Lookup->getParamTag("p_x_name") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->_email->Visible) { // email ?>
	<div id="r__email" class="form-group row">
		<label for="x__email" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user__email"><?php echo $user->_email->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z__email" id="z__email" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->_email->cellAttributes() ?>>
			<span id="el_user__email">
<input type="text" data-table="user" data-field="x__email" name="x__email" id="x__email" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($user->_email->getPlaceHolder()) ?>" value="<?php echo $user->_email->EditValue ?>"<?php echo $user->_email->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->gst_number->Visible) { // gst_number ?>
	<div id="r_gst_number" class="form-group row">
		<label for="x_gst_number" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_gst_number"><?php echo $user->gst_number->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_gst_number" id="z_gst_number" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->gst_number->cellAttributes() ?>>
			<span id="el_user_gst_number">
<input type="text" data-table="user" data-field="x_gst_number" name="x_gst_number" id="x_gst_number" size="30" maxlength="16" placeholder="<?php echo HtmlEncode($user->gst_number->getPlaceHolder()) ?>" value="<?php echo $user->gst_number->EditValue ?>"<?php echo $user->gst_number->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->category->Visible) { // category ?>
	<div id="r_category" class="form-group row">
		<label class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_category"><?php echo $user->category->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_category" id="z_category" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->category->cellAttributes() ?>>
			<span id="el_user_category">
<div id="tp_x_category" class="ew-template"><input type="checkbox" class="form-check-input" data-table="user" data-field="x_category" data-value-separator="<?php echo $user->category->displayValueSeparatorAttribute() ?>" name="x_category[]" id="x_category[]" value="{value}"<?php echo $user->category->editAttributes() ?>></div>
<div id="dsl_x_category" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $user->category->checkBoxListHtml(FALSE, "x_category[]") ?>
</div></div>
<?php echo $user->category->Lookup->getParamTag("p_x_category") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->last_login->Visible) { // last_login ?>
	<div id="r_last_login" class="form-group row">
		<label for="x_last_login" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_last_login"><?php echo $user->last_login->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_last_login" id="z_last_login" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->last_login->cellAttributes() ?>>
			<span id="el_user_last_login">
<input type="text" data-table="user" data-field="x_last_login" name="x_last_login" id="x_last_login" placeholder="<?php echo HtmlEncode($user->last_login->getPlaceHolder()) ?>" value="<?php echo $user->last_login->EditValue ?>"<?php echo $user->last_login->editAttributes() ?>>
<?php if (!$user->last_login->ReadOnly && !$user->last_login->Disabled && !isset($user->last_login->EditAttrs["readonly"]) && !isset($user->last_login->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersearch", "x_last_login", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->reg_date->Visible) { // reg_date ?>
	<div id="r_reg_date" class="form-group row">
		<label for="x_reg_date" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_reg_date"><?php echo $user->reg_date->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reg_date" id="z_reg_date" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->reg_date->cellAttributes() ?>>
			<span id="el_user_reg_date">
<input type="text" data-table="user" data-field="x_reg_date" name="x_reg_date" id="x_reg_date" placeholder="<?php echo HtmlEncode($user->reg_date->getPlaceHolder()) ?>" value="<?php echo $user->reg_date->EditValue ?>"<?php echo $user->reg_date->editAttributes() ?>>
<?php if (!$user->reg_date->ReadOnly && !$user->reg_date->Disabled && !isset($user->reg_date->EditAttrs["readonly"]) && !isset($user->reg_date->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersearch", "x_reg_date", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->reg_device->Visible) { // reg_device ?>
	<div id="r_reg_device" class="form-group row">
		<label for="x_reg_device" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_reg_device"><?php echo $user->reg_device->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_reg_device" id="z_reg_device" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->reg_device->cellAttributes() ?>>
			<span id="el_user_reg_device">
<input type="text" data-table="user" data-field="x_reg_device" name="x_reg_device" id="x_reg_device" size="30" placeholder="<?php echo HtmlEncode($user->reg_device->getPlaceHolder()) ?>" value="<?php echo $user->reg_device->EditValue ?>"<?php echo $user->reg_device->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->app_version->Visible) { // app_version ?>
	<div id="r_app_version" class="form-group row">
		<label for="x_app_version" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_app_version"><?php echo $user->app_version->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_app_version" id="z_app_version" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->app_version->cellAttributes() ?>>
			<span id="el_user_app_version">
<input type="text" data-table="user" data-field="x_app_version" name="x_app_version" id="x_app_version" size="30" placeholder="<?php echo HtmlEncode($user->app_version->getPlaceHolder()) ?>" value="<?php echo $user->app_version->EditValue ?>"<?php echo $user->app_version->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->device_id->Visible) { // device_id ?>
	<div id="r_device_id" class="form-group row">
		<label for="x_device_id" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_device_id"><?php echo $user->device_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_device_id" id="z_device_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->device_id->cellAttributes() ?>>
			<span id="el_user_device_id">
<input type="text" data-table="user" data-field="x_device_id" name="x_device_id" id="x_device_id" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($user->device_id->getPlaceHolder()) ?>" value="<?php echo $user->device_id->EditValue ?>"<?php echo $user->device_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->device_token_id->Visible) { // device_token_id ?>
	<div id="r_device_token_id" class="form-group row">
		<label for="x_device_token_id" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_device_token_id"><?php echo $user->device_token_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_device_token_id" id="z_device_token_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->device_token_id->cellAttributes() ?>>
			<span id="el_user_device_token_id">
<input type="text" data-table="user" data-field="x_device_token_id" name="x_device_token_id" id="x_device_token_id" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($user->device_token_id->getPlaceHolder()) ?>" value="<?php echo $user->device_token_id->EditValue ?>"<?php echo $user->device_token_id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->cart_number->Visible) { // cart_number ?>
	<div id="r_cart_number" class="form-group row">
		<label for="x_cart_number" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_cart_number"><?php echo $user->cart_number->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_cart_number" id="z_cart_number" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->cart_number->cellAttributes() ?>>
			<span id="el_user_cart_number">
<input type="text" data-table="user" data-field="x_cart_number" name="x_cart_number" id="x_cart_number" size="30" placeholder="<?php echo HtmlEncode($user->cart_number->getPlaceHolder()) ?>" value="<?php echo $user->cart_number->EditValue ?>"<?php echo $user->cart_number->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_status"><?php echo $user->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_status" id="z_status" value="LIKE"></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->status->cellAttributes() ?>>
			<span id="el_user_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="user" data-field="x_status" data-value-separator="<?php echo $user->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $user->status->editAttributes() ?>>
		<?php echo $user->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_operator"><?php echo $user->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->operator->cellAttributes() ?>>
			<span id="el_user_operator">
<?php
$wrkonchange = "" . trim(@$user->operator->EditAttrs["onchange"]);
if (trim($wrkonchange) <> "") $wrkonchange = " onchange=\"" . JsEncode($wrkonchange) . "\"";
$user->operator->EditAttrs["onchange"] = "";
?>
<span id="as_x_operator" class="text-nowrap" style="z-index: 8840">
	<input type="text" class="form-control" name="sv_x_operator" id="sv_x_operator" value="<?php echo RemoveHtml($user->operator->EditValue) ?>" size="30" placeholder="<?php echo HtmlEncode($user->operator->getPlaceHolder()) ?>" data-placeholder="<?php echo HtmlEncode($user->operator->getPlaceHolder()) ?>"<?php echo $user->operator->editAttributes() ?>>
</span>
<input type="hidden" data-table="user" data-field="x_operator" data-value-separator="<?php echo $user->operator->displayValueSeparatorAttribute() ?>" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($user->operator->AdvancedSearch->SearchValue) ?>"<?php echo $wrkonchange ?>>
<script>
fusersearch.createAutoSuggest({"id":"x_operator","forceSelect":false});
</script>
<?php echo $user->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_datetime"><?php echo $user->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->datetime->cellAttributes() ?>>
			<span id="el_user_datetime">
<input type="text" data-table="user" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($user->datetime->getPlaceHolder()) ?>" value="<?php echo $user->datetime->EditValue ?>"<?php echo $user->datetime->editAttributes() ?>>
<?php if (!$user->datetime->ReadOnly && !$user->datetime->Disabled && !isset($user->datetime->EditAttrs["readonly"]) && !isset($user->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fusersearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_id"><?php echo $user->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->id->cellAttributes() ?>>
			<span id="el_user_id">
<input type="text" data-table="user" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($user->id->getPlaceHolder()) ?>" value="<?php echo $user->id->EditValue ?>"<?php echo $user->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($user->max_discount->Visible) { // max_discount ?>
	<div id="r_max_discount" class="form-group row">
		<label for="x_max_discount" class="<?php echo $user_search->LeftColumnClass ?>"><span id="elh_user_max_discount"><?php echo $user->max_discount->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_max_discount" id="z_max_discount" value="="></span>
		</label>
		<div class="<?php echo $user_search->RightColumnClass ?>"><div<?php echo $user->max_discount->cellAttributes() ?>>
			<span id="el_user_max_discount">
<input type="text" data-table="user" data-field="x_max_discount" name="x_max_discount" id="x_max_discount" size="30" placeholder="<?php echo HtmlEncode($user->max_discount->getPlaceHolder()) ?>" value="<?php echo $user->max_discount->EditValue ?>"<?php echo $user->max_discount->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$user_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $user_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$user_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$user_search->terminate();
?>