<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$user_view = new user_view();

// Run the page
$user_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$user_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$user->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fuserview = currentForm = new ew.Form("fuserview", "view");

// Form_CustomValidate event
fuserview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fuserview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fuserview.lists["x_mobile"] = <?php echo $user_view->mobile->Lookup->toClientList() ?>;
fuserview.lists["x_mobile"].options = <?php echo JsonEncode($user_view->mobile->lookupOptions()) ?>;
fuserview.autoSuggests["x_mobile"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuserview.lists["x_name"] = <?php echo $user_view->name->Lookup->toClientList() ?>;
fuserview.lists["x_name"].options = <?php echo JsonEncode($user_view->name->lookupOptions()) ?>;
fuserview.autoSuggests["x_name"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;
fuserview.lists["x_category[]"] = <?php echo $user_view->category->Lookup->toClientList() ?>;
fuserview.lists["x_category[]"].options = <?php echo JsonEncode($user_view->category->lookupOptions()) ?>;
fuserview.lists["x_status"] = <?php echo $user_view->status->Lookup->toClientList() ?>;
fuserview.lists["x_status"].options = <?php echo JsonEncode($user_view->status->options(FALSE, TRUE)) ?>;
fuserview.lists["x_operator"] = <?php echo $user_view->operator->Lookup->toClientList() ?>;
fuserview.lists["x_operator"].options = <?php echo JsonEncode($user_view->operator->lookupOptions()) ?>;
fuserview.autoSuggests["x_operator"] = <?php echo json_encode(["data" => "ajax=autosuggest"]) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$user->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $user_view->ExportOptions->render("body") ?>
<?php $user_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $user_view->showPageHeader(); ?>
<?php
$user_view->showMessage();
?>
<form name="fuserview" id="fuserview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($user_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $user_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="user">
<input type="hidden" name="modal" value="<?php echo (int)$user_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($user->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_mobile"><?php echo $user->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $user->mobile->cellAttributes() ?>>
<span id="el_user_mobile">
<span<?php echo $user->mobile->viewAttributes() ?>>
<?php echo $user->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->user_name->Visible) { // user_name ?>
	<tr id="r_user_name">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_user_name"><?php echo $user->user_name->caption() ?></span></td>
		<td data-name="user_name"<?php echo $user->user_name->cellAttributes() ?>>
<span id="el_user_user_name">
<span<?php echo $user->user_name->viewAttributes() ?>>
<?php echo $user->user_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->password->Visible) { // password ?>
	<tr id="r_password">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_password"><?php echo $user->password->caption() ?></span></td>
		<td data-name="password"<?php echo $user->password->cellAttributes() ?>>
<span id="el_user_password">
<span<?php echo $user->password->viewAttributes() ?>>
<?php echo $user->password->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_name"><?php echo $user->name->caption() ?></span></td>
		<td data-name="name"<?php echo $user->name->cellAttributes() ?>>
<span id="el_user_name">
<span<?php echo $user->name->viewAttributes() ?>>
<?php echo $user->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->_email->Visible) { // email ?>
	<tr id="r__email">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user__email"><?php echo $user->_email->caption() ?></span></td>
		<td data-name="_email"<?php echo $user->_email->cellAttributes() ?>>
<span id="el_user__email">
<span<?php echo $user->_email->viewAttributes() ?>>
<?php echo $user->_email->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->gst_number->Visible) { // gst_number ?>
	<tr id="r_gst_number">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_gst_number"><?php echo $user->gst_number->caption() ?></span></td>
		<td data-name="gst_number"<?php echo $user->gst_number->cellAttributes() ?>>
<span id="el_user_gst_number">
<span<?php echo $user->gst_number->viewAttributes() ?>>
<?php echo $user->gst_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->category->Visible) { // category ?>
	<tr id="r_category">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_category"><?php echo $user->category->caption() ?></span></td>
		<td data-name="category"<?php echo $user->category->cellAttributes() ?>>
<span id="el_user_category">
<span<?php echo $user->category->viewAttributes() ?>>
<?php echo $user->category->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->last_login->Visible) { // last_login ?>
	<tr id="r_last_login">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_last_login"><?php echo $user->last_login->caption() ?></span></td>
		<td data-name="last_login"<?php echo $user->last_login->cellAttributes() ?>>
<span id="el_user_last_login">
<span<?php echo $user->last_login->viewAttributes() ?>>
<?php echo $user->last_login->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->reg_date->Visible) { // reg_date ?>
	<tr id="r_reg_date">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_reg_date"><?php echo $user->reg_date->caption() ?></span></td>
		<td data-name="reg_date"<?php echo $user->reg_date->cellAttributes() ?>>
<span id="el_user_reg_date">
<span<?php echo $user->reg_date->viewAttributes() ?>>
<?php echo $user->reg_date->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->reg_device->Visible) { // reg_device ?>
	<tr id="r_reg_device">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_reg_device"><?php echo $user->reg_device->caption() ?></span></td>
		<td data-name="reg_device"<?php echo $user->reg_device->cellAttributes() ?>>
<span id="el_user_reg_device">
<span<?php echo $user->reg_device->viewAttributes() ?>>
<?php echo $user->reg_device->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->app_version->Visible) { // app_version ?>
	<tr id="r_app_version">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_app_version"><?php echo $user->app_version->caption() ?></span></td>
		<td data-name="app_version"<?php echo $user->app_version->cellAttributes() ?>>
<span id="el_user_app_version">
<span<?php echo $user->app_version->viewAttributes() ?>>
<?php echo $user->app_version->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->device_id->Visible) { // device_id ?>
	<tr id="r_device_id">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_device_id"><?php echo $user->device_id->caption() ?></span></td>
		<td data-name="device_id"<?php echo $user->device_id->cellAttributes() ?>>
<span id="el_user_device_id">
<span<?php echo $user->device_id->viewAttributes() ?>>
<?php echo $user->device_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->device_token_id->Visible) { // device_token_id ?>
	<tr id="r_device_token_id">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_device_token_id"><?php echo $user->device_token_id->caption() ?></span></td>
		<td data-name="device_token_id"<?php echo $user->device_token_id->cellAttributes() ?>>
<span id="el_user_device_token_id">
<span<?php echo $user->device_token_id->viewAttributes() ?>>
<?php echo $user->device_token_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->cart_number->Visible) { // cart_number ?>
	<tr id="r_cart_number">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_cart_number"><?php echo $user->cart_number->caption() ?></span></td>
		<td data-name="cart_number"<?php echo $user->cart_number->cellAttributes() ?>>
<span id="el_user_cart_number">
<span<?php echo $user->cart_number->viewAttributes() ?>>
<?php echo $user->cart_number->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_status"><?php echo $user->status->caption() ?></span></td>
		<td data-name="status"<?php echo $user->status->cellAttributes() ?>>
<span id="el_user_status">
<span<?php echo $user->status->viewAttributes() ?>>
<?php echo $user->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_operator"><?php echo $user->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $user->operator->cellAttributes() ?>>
<span id="el_user_operator">
<span<?php echo $user->operator->viewAttributes() ?>>
<?php echo $user->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_datetime"><?php echo $user->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $user->datetime->cellAttributes() ?>>
<span id="el_user_datetime">
<span<?php echo $user->datetime->viewAttributes() ?>>
<?php echo $user->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_id"><?php echo $user->id->caption() ?></span></td>
		<td data-name="id"<?php echo $user->id->cellAttributes() ?>>
<span id="el_user_id">
<span<?php echo $user->id->viewAttributes() ?>>
<?php echo $user->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($user->max_discount->Visible) { // max_discount ?>
	<tr id="r_max_discount">
		<td class="<?php echo $user_view->TableLeftColumnClass ?>"><span id="elh_user_max_discount"><?php echo $user->max_discount->caption() ?></span></td>
		<td data-name="max_discount"<?php echo $user->max_discount->cellAttributes() ?>>
<span id="el_user_max_discount">
<span<?php echo $user->max_discount->viewAttributes() ?>>
<?php echo $user->max_discount->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$user_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$user->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$user_view->terminate();
?>