<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$varient_list = new varient_list();

// Run the page
$varient_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$varient_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$varient->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fvarientlist = currentForm = new ew.Form("fvarientlist", "list");
fvarientlist.formKeyCountName = '<?php echo $varient_list->FormKeyCountName ?>';

// Form_CustomValidate event
fvarientlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvarientlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvarientlist.lists["x_grp"] = <?php echo $varient_list->grp->Lookup->toClientList() ?>;
fvarientlist.lists["x_grp"].options = <?php echo JsonEncode($varient_list->grp->lookupOptions()) ?>;
fvarientlist.lists["x_s_grp[]"] = <?php echo $varient_list->s_grp->Lookup->toClientList() ?>;
fvarientlist.lists["x_s_grp[]"].options = <?php echo JsonEncode($varient_list->s_grp->lookupOptions()) ?>;
fvarientlist.lists["x_type"] = <?php echo $varient_list->type->Lookup->toClientList() ?>;
fvarientlist.lists["x_type"].options = <?php echo JsonEncode($varient_list->type->options(FALSE, TRUE)) ?>;
fvarientlist.lists["x_partner[]"] = <?php echo $varient_list->partner->Lookup->toClientList() ?>;
fvarientlist.lists["x_partner[]"].options = <?php echo JsonEncode($varient_list->partner->lookupOptions()) ?>;
fvarientlist.lists["x_method"] = <?php echo $varient_list->method->Lookup->toClientList() ?>;
fvarientlist.lists["x_method"].options = <?php echo JsonEncode($varient_list->method->options(FALSE, TRUE)) ?>;
fvarientlist.lists["x_status"] = <?php echo $varient_list->status->Lookup->toClientList() ?>;
fvarientlist.lists["x_status"].options = <?php echo JsonEncode($varient_list->status->options(FALSE, TRUE)) ?>;
fvarientlist.lists["x_operator"] = <?php echo $varient_list->operator->Lookup->toClientList() ?>;
fvarientlist.lists["x_operator"].options = <?php echo JsonEncode($varient_list->operator->lookupOptions()) ?>;

// Form object for search
var fvarientlistsrch = currentSearchForm = new ew.Form("fvarientlistsrch");

// Validate function for search
fvarientlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fvarientlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvarientlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvarientlistsrch.lists["x_grp"] = <?php echo $varient_list->grp->Lookup->toClientList() ?>;
fvarientlistsrch.lists["x_grp"].options = <?php echo JsonEncode($varient_list->grp->lookupOptions()) ?>;
fvarientlistsrch.lists["x_s_grp[]"] = <?php echo $varient_list->s_grp->Lookup->toClientList() ?>;
fvarientlistsrch.lists["x_s_grp[]"].options = <?php echo JsonEncode($varient_list->s_grp->lookupOptions()) ?>;
fvarientlistsrch.lists["x_type"] = <?php echo $varient_list->type->Lookup->toClientList() ?>;
fvarientlistsrch.lists["x_type"].options = <?php echo JsonEncode($varient_list->type->options(FALSE, TRUE)) ?>;
fvarientlistsrch.lists["x_partner[]"] = <?php echo $varient_list->partner->Lookup->toClientList() ?>;
fvarientlistsrch.lists["x_partner[]"].options = <?php echo JsonEncode($varient_list->partner->lookupOptions()) ?>;
fvarientlistsrch.lists["x_status"] = <?php echo $varient_list->status->Lookup->toClientList() ?>;
fvarientlistsrch.lists["x_status"].options = <?php echo JsonEncode($varient_list->status->options(FALSE, TRUE)) ?>;

// Filters
fvarientlistsrch.filterList = <?php echo $varient_list->getFilterList() ?>;

// Init search panel as collapsed
fvarientlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$varient->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($varient_list->TotalRecs > 0 && $varient_list->ExportOptions->visible()) { ?>
<?php $varient_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($varient_list->ImportOptions->visible()) { ?>
<?php $varient_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($varient_list->SearchOptions->visible()) { ?>
<?php $varient_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($varient_list->FilterOptions->visible()) { ?>
<?php $varient_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$varient_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$varient->isExport() && !$varient->CurrentAction) { ?>
<form name="fvarientlistsrch" id="fvarientlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($varient_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fvarientlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="varient">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$varient_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$varient->RowType = ROWTYPE_SEARCH;

// Render row
$varient->resetAttributes();
$varient_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($varient->grp->Visible) { // grp ?>
	<div id="xsc_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $varient->grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		<span class="ew-search-field">
<?php $varient->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$varient->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="radio" class="form-check-input" data-table="varient" data-field="x_grp" data-value-separator="<?php echo $varient->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="{value}"<?php echo $varient->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $varient->grp->radioButtonListHtml(FALSE, "x_grp") ?>
</div></div>
<?php echo $varient->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($varient->s_grp->Visible) { // s_grp ?>
	<div id="xsc_s_grp" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $varient->s_grp->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		<span class="ew-search-field">
<?php $varient->s_grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$varient->s_grp->EditAttrs["onclick"]; ?>
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="varient" data-field="x_s_grp" data-value-separator="<?php echo $varient->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $varient->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $varient->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $varient->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
	</div>
<?php } ?>
<?php if ($varient->type->Visible) { // type ?>
	<div id="xsc_type" class="ew-cell form-group">
		<label for="x_type" class="ew-search-caption ew-label"><?php echo $varient->type->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		<span class="ew-search-field">
<?php $varient->type->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$varient->type->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="varient" data-field="x_type" data-value-separator="<?php echo $varient->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $varient->type->editAttributes() ?>>
		<?php echo $varient->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($varient->partner->Visible) { // partner ?>
	<div id="xsc_partner" class="ew-cell form-group">
		<label class="ew-search-caption ew-label"><?php echo $varient->partner->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner" id="z_partner" value="="></span>
		<span class="ew-search-field">
<div id="tp_x_partner" class="ew-template"><input type="checkbox" class="form-check-input" data-table="varient" data-field="x_partner" data-value-separator="<?php echo $varient->partner->displayValueSeparatorAttribute() ?>" name="x_partner[]" id="x_partner[]" value="{value}"<?php echo $varient->partner->editAttributes() ?>></div>
<div id="dsl_x_partner" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $varient->partner->checkBoxListHtml(FALSE, "x_partner[]") ?>
</div></div>
<?php echo $varient->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
	</div>
<?php } ?>
<?php if ($varient->status->Visible) { // status ?>
	<div id="xsc_status" class="ew-cell form-group">
		<label for="x_status" class="ew-search-caption ew-label"><?php echo $varient->status->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="varient" data-field="x_status" data-value-separator="<?php echo $varient->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $varient->status->editAttributes() ?>>
		<?php echo $varient->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($varient_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($varient_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $varient_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($varient_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($varient_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($varient_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($varient_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $varient_list->showPageHeader(); ?>
<?php
$varient_list->showMessage();
?>
<?php if ($varient_list->TotalRecs > 0 || $varient->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($varient_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> varient">
<?php if (!$varient->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$varient->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($varient_list->Pager)) $varient_list->Pager = new PrevNextPager($varient_list->StartRec, $varient_list->DisplayRecs, $varient_list->TotalRecs, $varient_list->AutoHidePager) ?>
<?php if ($varient_list->Pager->RecordCount > 0 && $varient_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($varient_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($varient_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $varient_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($varient_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($varient_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $varient_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($varient_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $varient_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $varient_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $varient_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($varient_list->TotalRecs > 0 && (!$varient_list->AutoHidePageSizeSelector || $varient_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="varient">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($varient_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($varient_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($varient_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($varient_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($varient_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($varient->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $varient_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fvarientlist" id="fvarientlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($varient_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $varient_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="varient">
<div id="gmp_varient" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($varient_list->TotalRecs > 0 || $varient->isGridEdit()) { ?>
<table id="tbl_varientlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$varient_list->RowType = ROWTYPE_HEADER;

// Render list options
$varient_list->renderListOptions();

// Render list options (header, left)
$varient_list->ListOptions->render("header", "left");
?>
<?php if ($varient->id->Visible) { // id ?>
	<?php if ($varient->sortUrl($varient->id) == "") { ?>
		<th data-name="id" class="<?php echo $varient->id->headerCellClass() ?>"><div id="elh_varient_id" class="varient_id"><div class="ew-table-header-caption"><?php echo $varient->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $varient->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->id) ?>',2);"><div id="elh_varient_id" class="varient_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->grp->Visible) { // grp ?>
	<?php if ($varient->sortUrl($varient->grp) == "") { ?>
		<th data-name="grp" class="<?php echo $varient->grp->headerCellClass() ?>"><div id="elh_varient_grp" class="varient_grp"><div class="ew-table-header-caption"><?php echo $varient->grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="grp" class="<?php echo $varient->grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->grp) ?>',2);"><div id="elh_varient_grp" class="varient_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->s_grp->Visible) { // s_grp ?>
	<?php if ($varient->sortUrl($varient->s_grp) == "") { ?>
		<th data-name="s_grp" class="<?php echo $varient->s_grp->headerCellClass() ?>"><div id="elh_varient_s_grp" class="varient_s_grp"><div class="ew-table-header-caption"><?php echo $varient->s_grp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_grp" class="<?php echo $varient->s_grp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->s_grp) ?>',2);"><div id="elh_varient_s_grp" class="varient_s_grp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->s_grp->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->s_grp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->s_grp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->type->Visible) { // type ?>
	<?php if ($varient->sortUrl($varient->type) == "") { ?>
		<th data-name="type" class="<?php echo $varient->type->headerCellClass() ?>"><div id="elh_varient_type" class="varient_type"><div class="ew-table-header-caption"><?php echo $varient->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $varient->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->type) ?>',2);"><div id="elh_varient_type" class="varient_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->no_text->Visible) { // no_text ?>
	<?php if ($varient->sortUrl($varient->no_text) == "") { ?>
		<th data-name="no_text" class="<?php echo $varient->no_text->headerCellClass() ?>" style="white-space: nowrap;"><div id="elh_varient_no_text" class="varient_no_text"><div class="ew-table-header-caption"><?php echo $varient->no_text->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no_text" class="<?php echo $varient->no_text->headerCellClass() ?>" style="white-space: nowrap;"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->no_text) ?>',2);"><div id="elh_varient_no_text" class="varient_no_text">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->no_text->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($varient->no_text->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->no_text->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->name->Visible) { // name ?>
	<?php if ($varient->sortUrl($varient->name) == "") { ?>
		<th data-name="name" class="<?php echo $varient->name->headerCellClass() ?>"><div id="elh_varient_name" class="varient_name"><div class="ew-table-header-caption"><?php echo $varient->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $varient->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->name) ?>',2);"><div id="elh_varient_name" class="varient_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($varient->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->code->Visible) { // code ?>
	<?php if ($varient->sortUrl($varient->code) == "") { ?>
		<th data-name="code" class="<?php echo $varient->code->headerCellClass() ?>"><div id="elh_varient_code" class="varient_code"><div class="ew-table-header-caption"><?php echo $varient->code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code" class="<?php echo $varient->code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->code) ?>',2);"><div id="elh_varient_code" class="varient_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($varient->code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->code_validation->Visible) { // code_validation ?>
	<?php if ($varient->sortUrl($varient->code_validation) == "") { ?>
		<th data-name="code_validation" class="<?php echo $varient->code_validation->headerCellClass() ?>"><div id="elh_varient_code_validation" class="varient_code_validation"><div class="ew-table-header-caption"><?php echo $varient->code_validation->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="code_validation" class="<?php echo $varient->code_validation->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->code_validation) ?>',2);"><div id="elh_varient_code_validation" class="varient_code_validation">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->code_validation->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($varient->code_validation->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->code_validation->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->partner->Visible) { // partner ?>
	<?php if ($varient->sortUrl($varient->partner) == "") { ?>
		<th data-name="partner" class="<?php echo $varient->partner->headerCellClass() ?>"><div id="elh_varient_partner" class="varient_partner"><div class="ew-table-header-caption"><?php echo $varient->partner->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="partner" class="<?php echo $varient->partner->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->partner) ?>',2);"><div id="elh_varient_partner" class="varient_partner">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->partner->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->partner->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->partner->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->method->Visible) { // method ?>
	<?php if ($varient->sortUrl($varient->method) == "") { ?>
		<th data-name="method" class="<?php echo $varient->method->headerCellClass() ?>"><div id="elh_varient_method" class="varient_method"><div class="ew-table-header-caption"><?php echo $varient->method->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="method" class="<?php echo $varient->method->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->method) ?>',2);"><div id="elh_varient_method" class="varient_method">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->method->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->method->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->method->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->price->Visible) { // price ?>
	<?php if ($varient->sortUrl($varient->price) == "") { ?>
		<th data-name="price" class="<?php echo $varient->price->headerCellClass() ?>"><div id="elh_varient_price" class="varient_price"><div class="ew-table-header-caption"><?php echo $varient->price->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="price" class="<?php echo $varient->price->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->price) ?>',2);"><div id="elh_varient_price" class="varient_price">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->price->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->price->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->price->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->status->Visible) { // status ?>
	<?php if ($varient->sortUrl($varient->status) == "") { ?>
		<th data-name="status" class="<?php echo $varient->status->headerCellClass() ?>"><div id="elh_varient_status" class="varient_status"><div class="ew-table-header-caption"><?php echo $varient->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $varient->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->status) ?>',2);"><div id="elh_varient_status" class="varient_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->operator->Visible) { // operator ?>
	<?php if ($varient->sortUrl($varient->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $varient->operator->headerCellClass() ?>"><div id="elh_varient_operator" class="varient_operator"><div class="ew-table-header-caption"><?php echo $varient->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $varient->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->operator) ?>',2);"><div id="elh_varient_operator" class="varient_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($varient->datetime->Visible) { // datetime ?>
	<?php if ($varient->sortUrl($varient->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $varient->datetime->headerCellClass() ?>"><div id="elh_varient_datetime" class="varient_datetime"><div class="ew-table-header-caption"><?php echo $varient->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $varient->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $varient->SortUrl($varient->datetime) ?>',2);"><div id="elh_varient_datetime" class="varient_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $varient->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($varient->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($varient->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$varient_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($varient->ExportAll && $varient->isExport()) {
	$varient_list->StopRec = $varient_list->TotalRecs;
} else {

	// Set the last record to display
	if ($varient_list->TotalRecs > $varient_list->StartRec + $varient_list->DisplayRecs - 1)
		$varient_list->StopRec = $varient_list->StartRec + $varient_list->DisplayRecs - 1;
	else
		$varient_list->StopRec = $varient_list->TotalRecs;
}
$varient_list->RecCnt = $varient_list->StartRec - 1;
if ($varient_list->Recordset && !$varient_list->Recordset->EOF) {
	$varient_list->Recordset->moveFirst();
	$selectLimit = $varient_list->UseSelectLimit;
	if (!$selectLimit && $varient_list->StartRec > 1)
		$varient_list->Recordset->move($varient_list->StartRec - 1);
} elseif (!$varient->AllowAddDeleteRow && $varient_list->StopRec == 0) {
	$varient_list->StopRec = $varient->GridAddRowCount;
}

// Initialize aggregate
$varient->RowType = ROWTYPE_AGGREGATEINIT;
$varient->resetAttributes();
$varient_list->renderRow();
while ($varient_list->RecCnt < $varient_list->StopRec) {
	$varient_list->RecCnt++;
	if ($varient_list->RecCnt >= $varient_list->StartRec) {
		$varient_list->RowCnt++;

		// Set up key count
		$varient_list->KeyCount = $varient_list->RowIndex;

		// Init row class and style
		$varient->resetAttributes();
		$varient->CssClass = "";
		if ($varient->isGridAdd()) {
		} else {
			$varient_list->loadRowValues($varient_list->Recordset); // Load row values
		}
		$varient->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$varient->RowAttrs = array_merge($varient->RowAttrs, array('data-rowindex'=>$varient_list->RowCnt, 'id'=>'r' . $varient_list->RowCnt . '_varient', 'data-rowtype'=>$varient->RowType));

		// Render row
		$varient_list->renderRow();

		// Render list options
		$varient_list->renderListOptions();
?>
	<tr<?php echo $varient->rowAttributes() ?>>
<?php

// Render list options (body, left)
$varient_list->ListOptions->render("body", "left", $varient_list->RowCnt);
?>
	<?php if ($varient->id->Visible) { // id ?>
		<td data-name="id"<?php echo $varient->id->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_id" class="varient_id">
<span<?php echo $varient->id->viewAttributes() ?>>
<?php echo $varient->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->grp->Visible) { // grp ?>
		<td data-name="grp"<?php echo $varient->grp->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_grp" class="varient_grp">
<span<?php echo $varient->grp->viewAttributes() ?>>
<?php if ((!EmptyString($varient->grp->getViewValue())) && $varient->grp->linkAttributes() <> "") { ?>
<a<?php echo $varient->grp->linkAttributes() ?>><?php echo $varient->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->s_grp->Visible) { // s_grp ?>
		<td data-name="s_grp"<?php echo $varient->s_grp->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_s_grp" class="varient_s_grp">
<span<?php echo $varient->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($varient->s_grp->getViewValue())) && $varient->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $varient->s_grp->linkAttributes() ?>><?php echo $varient->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->type->Visible) { // type ?>
		<td data-name="type"<?php echo $varient->type->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_type" class="varient_type">
<span<?php echo $varient->type->viewAttributes() ?>>
<?php if ((!EmptyString($varient->type->getViewValue())) && $varient->type->linkAttributes() <> "") { ?>
<a<?php echo $varient->type->linkAttributes() ?>><?php echo $varient->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->no_text->Visible) { // no_text ?>
		<td data-name="no_text"<?php echo $varient->no_text->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_no_text" class="varient_no_text">
<span<?php echo $varient->no_text->viewAttributes() ?>>
<?php if ((!EmptyString($varient->no_text->getViewValue())) && $varient->no_text->linkAttributes() <> "") { ?>
<a<?php echo $varient->no_text->linkAttributes() ?>><?php echo $varient->no_text->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->no_text->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->name->Visible) { // name ?>
		<td data-name="name"<?php echo $varient->name->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_name" class="varient_name">
<span<?php echo $varient->name->viewAttributes() ?>>
<?php echo $varient->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->code->Visible) { // code ?>
		<td data-name="code"<?php echo $varient->code->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_code" class="varient_code">
<span<?php echo $varient->code->viewAttributes() ?>>
<?php echo $varient->code->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->code_validation->Visible) { // code_validation ?>
		<td data-name="code_validation"<?php echo $varient->code_validation->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_code_validation" class="varient_code_validation">
<span<?php echo $varient->code_validation->viewAttributes() ?>>
<?php echo $varient->code_validation->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->partner->Visible) { // partner ?>
		<td data-name="partner"<?php echo $varient->partner->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_partner" class="varient_partner">
<span<?php echo $varient->partner->viewAttributes() ?>>
<?php echo $varient->partner->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->method->Visible) { // method ?>
		<td data-name="method"<?php echo $varient->method->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_method" class="varient_method">
<span<?php echo $varient->method->viewAttributes() ?>>
<?php echo $varient->method->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->price->Visible) { // price ?>
		<td data-name="price"<?php echo $varient->price->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_price" class="varient_price">
<span<?php echo $varient->price->viewAttributes() ?>>
<?php echo $varient->price->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->status->Visible) { // status ?>
		<td data-name="status"<?php echo $varient->status->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_status" class="varient_status">
<span<?php echo $varient->status->viewAttributes() ?>>
<?php echo $varient->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $varient->operator->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_operator" class="varient_operator">
<span<?php echo $varient->operator->viewAttributes() ?>>
<?php echo $varient->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($varient->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $varient->datetime->cellAttributes() ?>>
<span id="el<?php echo $varient_list->RowCnt ?>_varient_datetime" class="varient_datetime">
<span<?php echo $varient->datetime->viewAttributes() ?>>
<?php echo $varient->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$varient_list->ListOptions->render("body", "right", $varient_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$varient->isGridAdd())
		$varient_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$varient->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($varient_list->Recordset)
	$varient_list->Recordset->Close();
?>
<?php if (!$varient->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$varient->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($varient_list->Pager)) $varient_list->Pager = new PrevNextPager($varient_list->StartRec, $varient_list->DisplayRecs, $varient_list->TotalRecs, $varient_list->AutoHidePager) ?>
<?php if ($varient_list->Pager->RecordCount > 0 && $varient_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($varient_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($varient_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $varient_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($varient_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($varient_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $varient_list->pageUrl() ?>start=<?php echo $varient_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $varient_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($varient_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $varient_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $varient_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $varient_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($varient_list->TotalRecs > 0 && (!$varient_list->AutoHidePageSizeSelector || $varient_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="varient">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($varient_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($varient_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($varient_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($varient_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($varient_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($varient->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $varient_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($varient_list->TotalRecs == 0 && !$varient->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $varient_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$varient_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$varient->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$varient->isExport()) { ?>
<script>
ew.scrollableTable("gmp_varient", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$varient_list->terminate();
?>