<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$varient_search = new varient_search();

// Run the page
$varient_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$varient_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($varient_search->IsModal) { ?>
var fvarientsearch = currentAdvancedSearchForm = new ew.Form("fvarientsearch", "search");
<?php } else { ?>
var fvarientsearch = currentForm = new ew.Form("fvarientsearch", "search");
<?php } ?>

// Form_CustomValidate event
fvarientsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvarientsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvarientsearch.lists["x_grp"] = <?php echo $varient_search->grp->Lookup->toClientList() ?>;
fvarientsearch.lists["x_grp"].options = <?php echo JsonEncode($varient_search->grp->lookupOptions()) ?>;
fvarientsearch.lists["x_s_grp[]"] = <?php echo $varient_search->s_grp->Lookup->toClientList() ?>;
fvarientsearch.lists["x_s_grp[]"].options = <?php echo JsonEncode($varient_search->s_grp->lookupOptions()) ?>;
fvarientsearch.lists["x_type"] = <?php echo $varient_search->type->Lookup->toClientList() ?>;
fvarientsearch.lists["x_type"].options = <?php echo JsonEncode($varient_search->type->options(FALSE, TRUE)) ?>;
fvarientsearch.lists["x_partner[]"] = <?php echo $varient_search->partner->Lookup->toClientList() ?>;
fvarientsearch.lists["x_partner[]"].options = <?php echo JsonEncode($varient_search->partner->lookupOptions()) ?>;
fvarientsearch.lists["x_method"] = <?php echo $varient_search->method->Lookup->toClientList() ?>;
fvarientsearch.lists["x_method"].options = <?php echo JsonEncode($varient_search->method->options(FALSE, TRUE)) ?>;
fvarientsearch.lists["x_status"] = <?php echo $varient_search->status->Lookup->toClientList() ?>;
fvarientsearch.lists["x_status"].options = <?php echo JsonEncode($varient_search->status->options(FALSE, TRUE)) ?>;
fvarientsearch.lists["x_operator"] = <?php echo $varient_search->operator->Lookup->toClientList() ?>;
fvarientsearch.lists["x_operator"].options = <?php echo JsonEncode($varient_search->operator->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fvarientsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($varient->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_price");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($varient->price->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($varient->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $varient_search->showPageHeader(); ?>
<?php
$varient_search->showMessage();
?>
<form name="fvarientsearch" id="fvarientsearch" class="<?php echo $varient_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($varient_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $varient_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="varient">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$varient_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($varient->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_id"><?php echo $varient->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->id->cellAttributes() ?>>
			<span id="el_varient_id">
<input type="text" data-table="varient" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($varient->id->getPlaceHolder()) ?>" value="<?php echo $varient->id->EditValue ?>"<?php echo $varient->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->grp->Visible) { // grp ?>
	<div id="r_grp" class="form-group row">
		<label class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_grp"><?php echo $varient->grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_grp" id="z_grp" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->grp->cellAttributes() ?>>
			<span id="el_varient_grp">
<?php $varient->grp->EditAttrs["onclick"] = "ew.updateOptions.call(this); " . @$varient->grp->EditAttrs["onclick"]; ?>
<div id="tp_x_grp" class="ew-template"><input type="radio" class="form-check-input" data-table="varient" data-field="x_grp" data-value-separator="<?php echo $varient->grp->displayValueSeparatorAttribute() ?>" name="x_grp" id="x_grp" value="{value}"<?php echo $varient->grp->editAttributes() ?>></div>
<div id="dsl_x_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $varient->grp->radioButtonListHtml(FALSE, "x_grp") ?>
</div></div>
<?php echo $varient->grp->Lookup->getParamTag("p_x_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->s_grp->Visible) { // s_grp ?>
	<div id="r_s_grp" class="form-group row">
		<label class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_s_grp"><?php echo $varient->s_grp->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_s_grp" id="z_s_grp" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->s_grp->cellAttributes() ?>>
			<span id="el_varient_s_grp">
<div id="tp_x_s_grp" class="ew-template"><input type="checkbox" class="form-check-input" data-table="varient" data-field="x_s_grp" data-value-separator="<?php echo $varient->s_grp->displayValueSeparatorAttribute() ?>" name="x_s_grp[]" id="x_s_grp[]" value="{value}"<?php echo $varient->s_grp->editAttributes() ?>></div>
<div id="dsl_x_s_grp" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $varient->s_grp->checkBoxListHtml(FALSE, "x_s_grp[]") ?>
</div></div>
<?php echo $varient->s_grp->Lookup->getParamTag("p_x_s_grp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_type"><?php echo $varient->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->type->cellAttributes() ?>>
			<span id="el_varient_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="varient" data-field="x_type" data-value-separator="<?php echo $varient->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $varient->type->editAttributes() ?>>
		<?php echo $varient->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->no_text->Visible) { // no_text ?>
	<div id="r_no_text" class="form-group row">
		<label for="x_no_text" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_no_text"><?php echo $varient->no_text->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_no_text" id="z_no_text" value="LIKE"></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->no_text->cellAttributes() ?>>
			<span id="el_varient_no_text">
<input type="text" data-table="varient" data-field="x_no_text" name="x_no_text" id="x_no_text" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($varient->no_text->getPlaceHolder()) ?>" value="<?php echo $varient->no_text->EditValue ?>"<?php echo $varient->no_text->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_name"><?php echo $varient->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->name->cellAttributes() ?>>
			<span id="el_varient_name">
<input type="text" data-table="varient" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($varient->name->getPlaceHolder()) ?>" value="<?php echo $varient->name->EditValue ?>"<?php echo $varient->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->code->Visible) { // code ?>
	<div id="r_code" class="form-group row">
		<label for="x_code" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_code"><?php echo $varient->code->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code" id="z_code" value="LIKE"></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->code->cellAttributes() ?>>
			<span id="el_varient_code">
<input type="text" data-table="varient" data-field="x_code" name="x_code" id="x_code" size="30" maxlength="30" placeholder="<?php echo HtmlEncode($varient->code->getPlaceHolder()) ?>" value="<?php echo $varient->code->EditValue ?>"<?php echo $varient->code->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->code_validation->Visible) { // code_validation ?>
	<div id="r_code_validation" class="form-group row">
		<label for="x_code_validation" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_code_validation"><?php echo $varient->code_validation->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_code_validation" id="z_code_validation" value="LIKE"></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->code_validation->cellAttributes() ?>>
			<span id="el_varient_code_validation">
<input type="text" data-table="varient" data-field="x_code_validation" name="x_code_validation" id="x_code_validation" size="30" maxlength="12" placeholder="<?php echo HtmlEncode($varient->code_validation->getPlaceHolder()) ?>" value="<?php echo $varient->code_validation->EditValue ?>"<?php echo $varient->code_validation->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->partner->Visible) { // partner ?>
	<div id="r_partner" class="form-group row">
		<label class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_partner"><?php echo $varient->partner->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_partner" id="z_partner" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->partner->cellAttributes() ?>>
			<span id="el_varient_partner">
<div id="tp_x_partner" class="ew-template"><input type="checkbox" class="form-check-input" data-table="varient" data-field="x_partner" data-value-separator="<?php echo $varient->partner->displayValueSeparatorAttribute() ?>" name="x_partner[]" id="x_partner[]" value="{value}"<?php echo $varient->partner->editAttributes() ?>></div>
<div id="dsl_x_partner" data-repeatcolumn="3" class="ew-item-list d-none"><div>
<?php echo $varient->partner->checkBoxListHtml(FALSE, "x_partner[]") ?>
</div></div>
<?php echo $varient->partner->Lookup->getParamTag("p_x_partner") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->method->Visible) { // method ?>
	<div id="r_method" class="form-group row">
		<label for="x_method" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_method"><?php echo $varient->method->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_method" id="z_method" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->method->cellAttributes() ?>>
			<span id="el_varient_method">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="varient" data-field="x_method" data-value-separator="<?php echo $varient->method->displayValueSeparatorAttribute() ?>" id="x_method" name="x_method"<?php echo $varient->method->editAttributes() ?>>
		<?php echo $varient->method->selectOptionListHtml("x_method") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->price->Visible) { // price ?>
	<div id="r_price" class="form-group row">
		<label for="x_price" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_price"><?php echo $varient->price->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_price" id="z_price" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->price->cellAttributes() ?>>
			<span id="el_varient_price">
<input type="text" data-table="varient" data-field="x_price" name="x_price" id="x_price" size="30" placeholder="<?php echo HtmlEncode($varient->price->getPlaceHolder()) ?>" value="<?php echo $varient->price->EditValue ?>"<?php echo $varient->price->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_status"><?php echo $varient->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->status->cellAttributes() ?>>
			<span id="el_varient_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="varient" data-field="x_status" data-value-separator="<?php echo $varient->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $varient->status->editAttributes() ?>>
		<?php echo $varient->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_operator"><?php echo $varient->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->operator->cellAttributes() ?>>
			<span id="el_varient_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="varient" data-field="x_operator" data-value-separator="<?php echo $varient->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $varient->operator->editAttributes() ?>>
		<?php echo $varient->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $varient->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($varient->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $varient_search->LeftColumnClass ?>"><span id="elh_varient_datetime"><?php echo $varient->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $varient_search->RightColumnClass ?>"><div<?php echo $varient->datetime->cellAttributes() ?>>
			<span id="el_varient_datetime">
<input type="text" data-table="varient" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($varient->datetime->getPlaceHolder()) ?>" value="<?php echo $varient->datetime->EditValue ?>"<?php echo $varient->datetime->editAttributes() ?>>
<?php if (!$varient->datetime->ReadOnly && !$varient->datetime->Disabled && !isset($varient->datetime->EditAttrs["readonly"]) && !isset($varient->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvarientsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$varient_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $varient_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$varient_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$varient_search->terminate();
?>