<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$varient_view = new varient_view();

// Run the page
$varient_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$varient_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$varient->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fvarientview = currentForm = new ew.Form("fvarientview", "view");

// Form_CustomValidate event
fvarientview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvarientview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvarientview.lists["x_grp"] = <?php echo $varient_view->grp->Lookup->toClientList() ?>;
fvarientview.lists["x_grp"].options = <?php echo JsonEncode($varient_view->grp->lookupOptions()) ?>;
fvarientview.lists["x_s_grp[]"] = <?php echo $varient_view->s_grp->Lookup->toClientList() ?>;
fvarientview.lists["x_s_grp[]"].options = <?php echo JsonEncode($varient_view->s_grp->lookupOptions()) ?>;
fvarientview.lists["x_type"] = <?php echo $varient_view->type->Lookup->toClientList() ?>;
fvarientview.lists["x_type"].options = <?php echo JsonEncode($varient_view->type->options(FALSE, TRUE)) ?>;
fvarientview.lists["x_partner[]"] = <?php echo $varient_view->partner->Lookup->toClientList() ?>;
fvarientview.lists["x_partner[]"].options = <?php echo JsonEncode($varient_view->partner->lookupOptions()) ?>;
fvarientview.lists["x_method"] = <?php echo $varient_view->method->Lookup->toClientList() ?>;
fvarientview.lists["x_method"].options = <?php echo JsonEncode($varient_view->method->options(FALSE, TRUE)) ?>;
fvarientview.lists["x_status"] = <?php echo $varient_view->status->Lookup->toClientList() ?>;
fvarientview.lists["x_status"].options = <?php echo JsonEncode($varient_view->status->options(FALSE, TRUE)) ?>;
fvarientview.lists["x_operator"] = <?php echo $varient_view->operator->Lookup->toClientList() ?>;
fvarientview.lists["x_operator"].options = <?php echo JsonEncode($varient_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$varient->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $varient_view->ExportOptions->render("body") ?>
<?php $varient_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $varient_view->showPageHeader(); ?>
<?php
$varient_view->showMessage();
?>
<form name="fvarientview" id="fvarientview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($varient_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $varient_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="varient">
<input type="hidden" name="modal" value="<?php echo (int)$varient_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($varient->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_id"><?php echo $varient->id->caption() ?></span></td>
		<td data-name="id"<?php echo $varient->id->cellAttributes() ?>>
<span id="el_varient_id">
<span<?php echo $varient->id->viewAttributes() ?>>
<?php echo $varient->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->grp->Visible) { // grp ?>
	<tr id="r_grp">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_grp"><?php echo $varient->grp->caption() ?></span></td>
		<td data-name="grp"<?php echo $varient->grp->cellAttributes() ?>>
<span id="el_varient_grp">
<span<?php echo $varient->grp->viewAttributes() ?>>
<?php if ((!EmptyString($varient->grp->getViewValue())) && $varient->grp->linkAttributes() <> "") { ?>
<a<?php echo $varient->grp->linkAttributes() ?>><?php echo $varient->grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->s_grp->Visible) { // s_grp ?>
	<tr id="r_s_grp">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_s_grp"><?php echo $varient->s_grp->caption() ?></span></td>
		<td data-name="s_grp"<?php echo $varient->s_grp->cellAttributes() ?>>
<span id="el_varient_s_grp">
<span<?php echo $varient->s_grp->viewAttributes() ?>>
<?php if ((!EmptyString($varient->s_grp->getViewValue())) && $varient->s_grp->linkAttributes() <> "") { ?>
<a<?php echo $varient->s_grp->linkAttributes() ?>><?php echo $varient->s_grp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->s_grp->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_type"><?php echo $varient->type->caption() ?></span></td>
		<td data-name="type"<?php echo $varient->type->cellAttributes() ?>>
<span id="el_varient_type">
<span<?php echo $varient->type->viewAttributes() ?>>
<?php if ((!EmptyString($varient->type->getViewValue())) && $varient->type->linkAttributes() <> "") { ?>
<a<?php echo $varient->type->linkAttributes() ?>><?php echo $varient->type->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->type->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->no_text->Visible) { // no_text ?>
	<tr id="r_no_text">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_no_text"><?php echo $varient->no_text->caption() ?></span></td>
		<td data-name="no_text"<?php echo $varient->no_text->cellAttributes() ?>>
<span id="el_varient_no_text">
<span<?php echo $varient->no_text->viewAttributes() ?>>
<?php if ((!EmptyString($varient->no_text->getViewValue())) && $varient->no_text->linkAttributes() <> "") { ?>
<a<?php echo $varient->no_text->linkAttributes() ?>><?php echo $varient->no_text->getViewValue() ?></a>
<?php } else { ?>
<?php echo $varient->no_text->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->name->Visible) { // name ?>
	<tr id="r_name">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_name"><?php echo $varient->name->caption() ?></span></td>
		<td data-name="name"<?php echo $varient->name->cellAttributes() ?>>
<span id="el_varient_name">
<span<?php echo $varient->name->viewAttributes() ?>>
<?php echo $varient->name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->code->Visible) { // code ?>
	<tr id="r_code">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_code"><?php echo $varient->code->caption() ?></span></td>
		<td data-name="code"<?php echo $varient->code->cellAttributes() ?>>
<span id="el_varient_code">
<span<?php echo $varient->code->viewAttributes() ?>>
<?php echo $varient->code->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->code_validation->Visible) { // code_validation ?>
	<tr id="r_code_validation">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_code_validation"><?php echo $varient->code_validation->caption() ?></span></td>
		<td data-name="code_validation"<?php echo $varient->code_validation->cellAttributes() ?>>
<span id="el_varient_code_validation">
<span<?php echo $varient->code_validation->viewAttributes() ?>>
<?php echo $varient->code_validation->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->partner->Visible) { // partner ?>
	<tr id="r_partner">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_partner"><?php echo $varient->partner->caption() ?></span></td>
		<td data-name="partner"<?php echo $varient->partner->cellAttributes() ?>>
<span id="el_varient_partner">
<span<?php echo $varient->partner->viewAttributes() ?>>
<?php echo $varient->partner->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->method->Visible) { // method ?>
	<tr id="r_method">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_method"><?php echo $varient->method->caption() ?></span></td>
		<td data-name="method"<?php echo $varient->method->cellAttributes() ?>>
<span id="el_varient_method">
<span<?php echo $varient->method->viewAttributes() ?>>
<?php echo $varient->method->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->price->Visible) { // price ?>
	<tr id="r_price">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_price"><?php echo $varient->price->caption() ?></span></td>
		<td data-name="price"<?php echo $varient->price->cellAttributes() ?>>
<span id="el_varient_price">
<span<?php echo $varient->price->viewAttributes() ?>>
<?php echo $varient->price->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_status"><?php echo $varient->status->caption() ?></span></td>
		<td data-name="status"<?php echo $varient->status->cellAttributes() ?>>
<span id="el_varient_status">
<span<?php echo $varient->status->viewAttributes() ?>>
<?php echo $varient->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_operator"><?php echo $varient->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $varient->operator->cellAttributes() ?>>
<span id="el_varient_operator">
<span<?php echo $varient->operator->viewAttributes() ?>>
<?php echo $varient->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($varient->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $varient_view->TableLeftColumnClass ?>"><span id="elh_varient_datetime"><?php echo $varient->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $varient->datetime->cellAttributes() ?>>
<span id="el_varient_datetime">
<span<?php echo $varient->datetime->viewAttributes() ?>>
<?php echo $varient->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$varient_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$varient->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

var type = $("#x_type").val();
		if (type != 1)
		{
		$("#r_code").hide()
		$("#r_code_validation").hide()
		} else {
		$("#r_code").show()
		$("#r_code_validation").show()
		}
</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$varient_view->terminate();
?>