<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$vehicle_info_addopt = new vehicle_info_addopt();

// Run the page
$vehicle_info_addopt->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$vehicle_info_addopt->Page_Render();
?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "addopt";
var fvehicle_infoaddopt = currentForm = new ew.Form("fvehicle_infoaddopt", "addopt");

// Validate form
fvehicle_infoaddopt.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($vehicle_info_addopt->no->Required) { ?>
			elm = this.getElements("x" + infix + "_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->no->caption(), $vehicle_info->no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_addopt->driver_name->Required) { ?>
			elm = this.getElements("x" + infix + "_driver_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->driver_name->caption(), $vehicle_info->driver_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_addopt->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->operator->caption(), $vehicle_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_addopt->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->datetime->caption(), $vehicle_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}
	return true;
}

// Form_CustomValidate event
fvehicle_infoaddopt.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvehicle_infoaddopt.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvehicle_infoaddopt.lists["x_operator"] = <?php echo $vehicle_info_addopt->operator->Lookup->toClientList() ?>;
fvehicle_infoaddopt.lists["x_operator"].options = <?php echo JsonEncode($vehicle_info_addopt->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $vehicle_info_addopt->showPageHeader(); ?>
<?php
$vehicle_info_addopt->showMessage();
?>
<form name="fvehicle_infoaddopt" id="fvehicle_infoaddopt" class="ew-form ew-horizontal" action="<?php echo API_URL ?>" method="post">
<?php //if ($vehicle_info_addopt->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $vehicle_info_addopt->Token ?>">
<?php //} ?>
<input type="hidden" name="<?php echo API_ACTION_NAME ?>" id="<?php echo API_ACTION_NAME ?>" value="<?php echo API_ADD_ACTION ?>">
<input type="hidden" name="<?php echo API_OBJECT_NAME ?>" id="<?php echo API_OBJECT_NAME ?>" value="<?php echo $vehicle_info_addopt->TableVar ?>">
<?php if ($vehicle_info->no->Visible) { // no ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_no"><?php echo $vehicle_info->no->caption() ?><?php echo ($vehicle_info->no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="vehicle_info" data-field="x_no" name="x_no" id="x_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($vehicle_info->no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->no->EditValue ?>"<?php echo $vehicle_info->no->editAttributes() ?>>
<?php echo $vehicle_info->no->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->driver_name->Visible) { // driver_name ?>
	<div class="form-group row">
		<label class="col-sm-2 col-form-label ew-label" for="x_driver_name"><?php echo $vehicle_info->driver_name->caption() ?><?php echo ($vehicle_info->driver_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="col-sm-10">
<input type="text" data-table="vehicle_info" data-field="x_driver_name" name="x_driver_name" id="x_driver_name" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($vehicle_info->driver_name->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->driver_name->EditValue ?>"<?php echo $vehicle_info->driver_name->editAttributes() ?>>
<?php echo $vehicle_info->driver_name->CustomMsg ?></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->operator->Visible) { // operator ?>
	<input type="hidden" data-table="vehicle_info" data-field="x_operator" name="x_operator" id="x_operator" value="<?php echo HtmlEncode($vehicle_info->operator->CurrentValue) ?>">
<?php } ?>
<?php if ($vehicle_info->datetime->Visible) { // datetime ?>
	<input type="hidden" data-table="vehicle_info" data-field="x_datetime" name="x_datetime" id="x_datetime" value="<?php echo HtmlEncode($vehicle_info->datetime->CurrentValue) ?>">
	<?php if (!$vehicle_info->datetime->ReadOnly && !$vehicle_info->datetime->Disabled && !isset($vehicle_info->datetime->EditAttrs["readonly"]) && !isset($vehicle_info->datetime->EditAttrs["disabled"])) { ?>
	<script>
	ew.createDateTimePicker("fvehicle_infoaddopt", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
	</script>
	<?php } ?>
<?php } ?>
</form>
<?php
$vehicle_info_addopt->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php
$vehicle_info_addopt->terminate();
?>