<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$vehicle_info_edit = new vehicle_info_edit();

// Run the page
$vehicle_info_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$vehicle_info_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fvehicle_infoedit = currentForm = new ew.Form("fvehicle_infoedit", "edit");

// Validate form
fvehicle_infoedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($vehicle_info_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->id->caption(), $vehicle_info->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->type->Required) { ?>
			elm = this.getElements("x" + infix + "_type");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->type->caption(), $vehicle_info->type->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->vehicle_owner->Required) { ?>
			elm = this.getElements("x" + infix + "_vehicle_owner");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->vehicle_owner->caption(), $vehicle_info->vehicle_owner->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->no->Required) { ?>
			elm = this.getElements("x" + infix + "_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->no->caption(), $vehicle_info->no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->driver->Required) { ?>
			elm = this.getElements("x" + infix + "_driver");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->driver->caption(), $vehicle_info->driver->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->driver_name->Required) { ?>
			elm = this.getElements("x" + infix + "_driver_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->driver_name->caption(), $vehicle_info->driver_name->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->dor->Required) { ?>
			elm = this.getElements("x" + infix + "_dor");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->dor->caption(), $vehicle_info->dor->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_dor");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->dor->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->km_hour->Required) { ?>
			elm = this.getElements("x" + infix + "_km_hour");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->km_hour->caption(), $vehicle_info->km_hour->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_km_hour");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->km_hour->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->chassis_no->Required) { ?>
			elm = this.getElements("x" + infix + "_chassis_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->chassis_no->caption(), $vehicle_info->chassis_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->engine_no->Required) { ?>
			elm = this.getElements("x" + infix + "_engine_no");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->engine_no->caption(), $vehicle_info->engine_no->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->load_average->Required) { ?>
			elm = this.getElements("x" + infix + "_load_average");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->load_average->caption(), $vehicle_info->load_average->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_average");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->load_average->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->unload_average->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_average");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->unload_average->caption(), $vehicle_info->unload_average->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_average");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->unload_average->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->load_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->load_expenses->caption(), $vehicle_info->load_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_load_expenses");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->load_expenses->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->unload_expenses->Required) { ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->unload_expenses->caption(), $vehicle_info->unload_expenses->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_unload_expenses");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->unload_expenses->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->insurance->Required) { ?>
			elm = this.getElements("x" + infix + "_insurance");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->insurance->caption(), $vehicle_info->insurance->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_insurance");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->insurance->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->state_tax->Required) { ?>
			elm = this.getElements("x" + infix + "_state_tax");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->state_tax->caption(), $vehicle_info->state_tax->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_state_tax");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->state_tax->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->national_permit->Required) { ?>
			elm = this.getElements("x" + infix + "_national_permit");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->national_permit->caption(), $vehicle_info->national_permit->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_national_permit");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->national_permit->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->pollution->Required) { ?>
			elm = this.getElements("x" + infix + "_pollution");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->pollution->caption(), $vehicle_info->pollution->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_pollution");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->pollution->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->fitness->Required) { ?>
			elm = this.getElements("x" + infix + "_fitness");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->fitness->caption(), $vehicle_info->fitness->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_fitness");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->fitness->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->other_due->Required) { ?>
			elm = this.getElements("x" + infix + "_other_due");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->other_due->caption(), $vehicle_info->other_due->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_other_due");
			if (elm && !ew.checkDateDef(elm.value))
				return this.onError(elm, "<?php echo JsEncode($vehicle_info->other_due->errorMessage()) ?>");
		<?php if ($vehicle_info_edit->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->status->caption(), $vehicle_info->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->operator->caption(), $vehicle_info->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->datetime->caption(), $vehicle_info->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($vehicle_info_edit->running_status->Required) { ?>
			elm = this.getElements("x" + infix + "_running_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $vehicle_info->running_status->caption(), $vehicle_info->running_status->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fvehicle_infoedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvehicle_infoedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvehicle_infoedit.lists["x_type"] = <?php echo $vehicle_info_edit->type->Lookup->toClientList() ?>;
fvehicle_infoedit.lists["x_type"].options = <?php echo JsonEncode($vehicle_info_edit->type->options(FALSE, TRUE)) ?>;
fvehicle_infoedit.lists["x_vehicle_owner"] = <?php echo $vehicle_info_edit->vehicle_owner->Lookup->toClientList() ?>;
fvehicle_infoedit.lists["x_vehicle_owner"].options = <?php echo JsonEncode($vehicle_info_edit->vehicle_owner->lookupOptions()) ?>;
fvehicle_infoedit.lists["x_driver"] = <?php echo $vehicle_info_edit->driver->Lookup->toClientList() ?>;
fvehicle_infoedit.lists["x_driver"].options = <?php echo JsonEncode($vehicle_info_edit->driver->lookupOptions()) ?>;
fvehicle_infoedit.lists["x_status"] = <?php echo $vehicle_info_edit->status->Lookup->toClientList() ?>;
fvehicle_infoedit.lists["x_status"].options = <?php echo JsonEncode($vehicle_info_edit->status->options(FALSE, TRUE)) ?>;
fvehicle_infoedit.lists["x_operator"] = <?php echo $vehicle_info_edit->operator->Lookup->toClientList() ?>;
fvehicle_infoedit.lists["x_operator"].options = <?php echo JsonEncode($vehicle_info_edit->operator->lookupOptions()) ?>;
fvehicle_infoedit.lists["x_running_status"] = <?php echo $vehicle_info_edit->running_status->Lookup->toClientList() ?>;
fvehicle_infoedit.lists["x_running_status"].options = <?php echo JsonEncode($vehicle_info_edit->running_status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $vehicle_info_edit->showPageHeader(); ?>
<?php
$vehicle_info_edit->showMessage();
?>
<form name="fvehicle_infoedit" id="fvehicle_infoedit" class="<?php echo $vehicle_info_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($vehicle_info_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $vehicle_info_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="vehicle_info">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$vehicle_info_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($vehicle_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_vehicle_info_id" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->id->caption() ?><?php echo ($vehicle_info->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->id->cellAttributes() ?>>
<span id="el_vehicle_info_id">
<span<?php echo $vehicle_info->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($vehicle_info->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="vehicle_info" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($vehicle_info->id->CurrentValue) ?>">
<?php echo $vehicle_info->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label id="elh_vehicle_info_type" for="x_type" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->type->caption() ?><?php echo ($vehicle_info->type->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->type->cellAttributes() ?>>
<span id="el_vehicle_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_type" data-value-separator="<?php echo $vehicle_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $vehicle_info->type->editAttributes() ?>>
		<?php echo $vehicle_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
<?php echo $vehicle_info->type->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->vehicle_owner->Visible) { // vehicle_owner ?>
	<div id="r_vehicle_owner" class="form-group row">
		<label id="elh_vehicle_info_vehicle_owner" for="x_vehicle_owner" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->vehicle_owner->caption() ?><?php echo ($vehicle_info->vehicle_owner->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->vehicle_owner->cellAttributes() ?>>
<span id="el_vehicle_info_vehicle_owner">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_vehicle_owner" data-value-separator="<?php echo $vehicle_info->vehicle_owner->displayValueSeparatorAttribute() ?>" id="x_vehicle_owner" name="x_vehicle_owner"<?php echo $vehicle_info->vehicle_owner->editAttributes() ?>>
		<?php echo $vehicle_info->vehicle_owner->selectOptionListHtml("x_vehicle_owner") ?>
	</select>
</div>
<?php echo $vehicle_info->vehicle_owner->Lookup->getParamTag("p_x_vehicle_owner") ?>
</span>
<?php echo $vehicle_info->vehicle_owner->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label id="elh_vehicle_info_no" for="x_no" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->no->caption() ?><?php echo ($vehicle_info->no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->no->cellAttributes() ?>>
<span id="el_vehicle_info_no">
<input type="text" data-table="vehicle_info" data-field="x_no" name="x_no" id="x_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($vehicle_info->no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->no->EditValue ?>"<?php echo $vehicle_info->no->editAttributes() ?>>
</span>
<?php echo $vehicle_info->no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label id="elh_vehicle_info_driver" for="x_driver" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->driver->caption() ?><?php echo ($vehicle_info->driver->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->driver->cellAttributes() ?>>
<span id="el_vehicle_info_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_driver" data-value-separator="<?php echo $vehicle_info->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $vehicle_info->driver->editAttributes() ?>>
		<?php echo $vehicle_info->driver->selectOptionListHtml("x_driver") ?>
	</select>
<?php if (AllowAdd(CurrentProjectID() . "t_driver_info") && !$vehicle_info->driver->ReadOnly) { ?>
<div class="input-group-append"><button type="button" class="btn btn-default ew-add-opt-btn" id="aol_x_driver" title="<?php echo HtmlTitle($Language->phrase("AddLink")) . "&nbsp;" . $vehicle_info->driver->caption() ?>" data-title="<?php echo $vehicle_info->driver->caption() ?>" onclick="ew.addOptionDialogShow({lnk:this,el:'x_driver',url:'t_driver_infoaddopt.php'});"><i class="fa fa-plus ew-icon"></i></button></div>
<?php } ?>
</div>
<?php echo $vehicle_info->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
<?php echo $vehicle_info->driver->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->driver_name->Visible) { // driver_name ?>
	<div id="r_driver_name" class="form-group row">
		<label id="elh_vehicle_info_driver_name" for="x_driver_name" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->driver_name->caption() ?><?php echo ($vehicle_info->driver_name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->driver_name->cellAttributes() ?>>
<span id="el_vehicle_info_driver_name">
<input type="text" data-table="vehicle_info" data-field="x_driver_name" name="x_driver_name" id="x_driver_name" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($vehicle_info->driver_name->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->driver_name->EditValue ?>"<?php echo $vehicle_info->driver_name->editAttributes() ?>>
</span>
<?php echo $vehicle_info->driver_name->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->dor->Visible) { // dor ?>
	<div id="r_dor" class="form-group row">
		<label id="elh_vehicle_info_dor" for="x_dor" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->dor->caption() ?><?php echo ($vehicle_info->dor->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->dor->cellAttributes() ?>>
<span id="el_vehicle_info_dor">
<input type="text" data-table="vehicle_info" data-field="x_dor" name="x_dor" id="x_dor" placeholder="<?php echo HtmlEncode($vehicle_info->dor->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->dor->EditValue ?>"<?php echo $vehicle_info->dor->editAttributes() ?>>
<?php if (!$vehicle_info->dor->ReadOnly && !$vehicle_info->dor->Disabled && !isset($vehicle_info->dor->EditAttrs["readonly"]) && !isset($vehicle_info->dor->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_dor", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->dor->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->km_hour->Visible) { // km_hour ?>
	<div id="r_km_hour" class="form-group row">
		<label id="elh_vehicle_info_km_hour" for="x_km_hour" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->km_hour->caption() ?><?php echo ($vehicle_info->km_hour->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->km_hour->cellAttributes() ?>>
<span id="el_vehicle_info_km_hour">
<input type="text" data-table="vehicle_info" data-field="x_km_hour" name="x_km_hour" id="x_km_hour" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->km_hour->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->km_hour->EditValue ?>"<?php echo $vehicle_info->km_hour->editAttributes() ?>>
</span>
<?php echo $vehicle_info->km_hour->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->chassis_no->Visible) { // chassis_no ?>
	<div id="r_chassis_no" class="form-group row">
		<label id="elh_vehicle_info_chassis_no" for="x_chassis_no" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->chassis_no->caption() ?><?php echo ($vehicle_info->chassis_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->chassis_no->cellAttributes() ?>>
<span id="el_vehicle_info_chassis_no">
<input type="text" data-table="vehicle_info" data-field="x_chassis_no" name="x_chassis_no" id="x_chassis_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($vehicle_info->chassis_no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->chassis_no->EditValue ?>"<?php echo $vehicle_info->chassis_no->editAttributes() ?>>
</span>
<?php echo $vehicle_info->chassis_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->engine_no->Visible) { // engine_no ?>
	<div id="r_engine_no" class="form-group row">
		<label id="elh_vehicle_info_engine_no" for="x_engine_no" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->engine_no->caption() ?><?php echo ($vehicle_info->engine_no->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->engine_no->cellAttributes() ?>>
<span id="el_vehicle_info_engine_no">
<input type="text" data-table="vehicle_info" data-field="x_engine_no" name="x_engine_no" id="x_engine_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($vehicle_info->engine_no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->engine_no->EditValue ?>"<?php echo $vehicle_info->engine_no->editAttributes() ?>>
</span>
<?php echo $vehicle_info->engine_no->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->load_average->Visible) { // load_average ?>
	<div id="r_load_average" class="form-group row">
		<label id="elh_vehicle_info_load_average" for="x_load_average" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->load_average->caption() ?><?php echo ($vehicle_info->load_average->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->load_average->cellAttributes() ?>>
<span id="el_vehicle_info_load_average">
<input type="text" data-table="vehicle_info" data-field="x_load_average" name="x_load_average" id="x_load_average" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->load_average->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->load_average->EditValue ?>"<?php echo $vehicle_info->load_average->editAttributes() ?>>
</span>
<?php echo $vehicle_info->load_average->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->unload_average->Visible) { // unload_average ?>
	<div id="r_unload_average" class="form-group row">
		<label id="elh_vehicle_info_unload_average" for="x_unload_average" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->unload_average->caption() ?><?php echo ($vehicle_info->unload_average->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->unload_average->cellAttributes() ?>>
<span id="el_vehicle_info_unload_average">
<input type="text" data-table="vehicle_info" data-field="x_unload_average" name="x_unload_average" id="x_unload_average" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->unload_average->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->unload_average->EditValue ?>"<?php echo $vehicle_info->unload_average->editAttributes() ?>>
</span>
<?php echo $vehicle_info->unload_average->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->load_expenses->Visible) { // load_expenses ?>
	<div id="r_load_expenses" class="form-group row">
		<label id="elh_vehicle_info_load_expenses" for="x_load_expenses" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->load_expenses->caption() ?><?php echo ($vehicle_info->load_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->load_expenses->cellAttributes() ?>>
<span id="el_vehicle_info_load_expenses">
<input type="text" data-table="vehicle_info" data-field="x_load_expenses" name="x_load_expenses" id="x_load_expenses" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->load_expenses->EditValue ?>"<?php echo $vehicle_info->load_expenses->editAttributes() ?>>
</span>
<?php echo $vehicle_info->load_expenses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->unload_expenses->Visible) { // unload_expenses ?>
	<div id="r_unload_expenses" class="form-group row">
		<label id="elh_vehicle_info_unload_expenses" for="x_unload_expenses" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->unload_expenses->caption() ?><?php echo ($vehicle_info->unload_expenses->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->unload_expenses->cellAttributes() ?>>
<span id="el_vehicle_info_unload_expenses">
<input type="text" data-table="vehicle_info" data-field="x_unload_expenses" name="x_unload_expenses" id="x_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->unload_expenses->EditValue ?>"<?php echo $vehicle_info->unload_expenses->editAttributes() ?>>
</span>
<?php echo $vehicle_info->unload_expenses->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->insurance->Visible) { // insurance ?>
	<div id="r_insurance" class="form-group row">
		<label id="elh_vehicle_info_insurance" for="x_insurance" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->insurance->caption() ?><?php echo ($vehicle_info->insurance->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->insurance->cellAttributes() ?>>
<span id="el_vehicle_info_insurance">
<input type="text" data-table="vehicle_info" data-field="x_insurance" name="x_insurance" id="x_insurance" placeholder="<?php echo HtmlEncode($vehicle_info->insurance->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->insurance->EditValue ?>"<?php echo $vehicle_info->insurance->editAttributes() ?>>
<?php if (!$vehicle_info->insurance->ReadOnly && !$vehicle_info->insurance->Disabled && !isset($vehicle_info->insurance->EditAttrs["readonly"]) && !isset($vehicle_info->insurance->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_insurance", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->insurance->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->state_tax->Visible) { // state_tax ?>
	<div id="r_state_tax" class="form-group row">
		<label id="elh_vehicle_info_state_tax" for="x_state_tax" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->state_tax->caption() ?><?php echo ($vehicle_info->state_tax->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->state_tax->cellAttributes() ?>>
<span id="el_vehicle_info_state_tax">
<input type="text" data-table="vehicle_info" data-field="x_state_tax" name="x_state_tax" id="x_state_tax" placeholder="<?php echo HtmlEncode($vehicle_info->state_tax->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->state_tax->EditValue ?>"<?php echo $vehicle_info->state_tax->editAttributes() ?>>
<?php if (!$vehicle_info->state_tax->ReadOnly && !$vehicle_info->state_tax->Disabled && !isset($vehicle_info->state_tax->EditAttrs["readonly"]) && !isset($vehicle_info->state_tax->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_state_tax", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->state_tax->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->national_permit->Visible) { // national_permit ?>
	<div id="r_national_permit" class="form-group row">
		<label id="elh_vehicle_info_national_permit" for="x_national_permit" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->national_permit->caption() ?><?php echo ($vehicle_info->national_permit->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->national_permit->cellAttributes() ?>>
<span id="el_vehicle_info_national_permit">
<input type="text" data-table="vehicle_info" data-field="x_national_permit" name="x_national_permit" id="x_national_permit" placeholder="<?php echo HtmlEncode($vehicle_info->national_permit->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->national_permit->EditValue ?>"<?php echo $vehicle_info->national_permit->editAttributes() ?>>
<?php if (!$vehicle_info->national_permit->ReadOnly && !$vehicle_info->national_permit->Disabled && !isset($vehicle_info->national_permit->EditAttrs["readonly"]) && !isset($vehicle_info->national_permit->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_national_permit", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->national_permit->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->pollution->Visible) { // pollution ?>
	<div id="r_pollution" class="form-group row">
		<label id="elh_vehicle_info_pollution" for="x_pollution" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->pollution->caption() ?><?php echo ($vehicle_info->pollution->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->pollution->cellAttributes() ?>>
<span id="el_vehicle_info_pollution">
<input type="text" data-table="vehicle_info" data-field="x_pollution" name="x_pollution" id="x_pollution" placeholder="<?php echo HtmlEncode($vehicle_info->pollution->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->pollution->EditValue ?>"<?php echo $vehicle_info->pollution->editAttributes() ?>>
<?php if (!$vehicle_info->pollution->ReadOnly && !$vehicle_info->pollution->Disabled && !isset($vehicle_info->pollution->EditAttrs["readonly"]) && !isset($vehicle_info->pollution->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_pollution", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->pollution->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->fitness->Visible) { // fitness ?>
	<div id="r_fitness" class="form-group row">
		<label id="elh_vehicle_info_fitness" for="x_fitness" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->fitness->caption() ?><?php echo ($vehicle_info->fitness->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->fitness->cellAttributes() ?>>
<span id="el_vehicle_info_fitness">
<input type="text" data-table="vehicle_info" data-field="x_fitness" name="x_fitness" id="x_fitness" placeholder="<?php echo HtmlEncode($vehicle_info->fitness->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->fitness->EditValue ?>"<?php echo $vehicle_info->fitness->editAttributes() ?>>
<?php if (!$vehicle_info->fitness->ReadOnly && !$vehicle_info->fitness->Disabled && !isset($vehicle_info->fitness->EditAttrs["readonly"]) && !isset($vehicle_info->fitness->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_fitness", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->fitness->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->other_due->Visible) { // other_due ?>
	<div id="r_other_due" class="form-group row">
		<label id="elh_vehicle_info_other_due" for="x_other_due" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->other_due->caption() ?><?php echo ($vehicle_info->other_due->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->other_due->cellAttributes() ?>>
<span id="el_vehicle_info_other_due">
<input type="text" data-table="vehicle_info" data-field="x_other_due" name="x_other_due" id="x_other_due" placeholder="<?php echo HtmlEncode($vehicle_info->other_due->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->other_due->EditValue ?>"<?php echo $vehicle_info->other_due->editAttributes() ?>>
<?php if (!$vehicle_info->other_due->ReadOnly && !$vehicle_info->other_due->Disabled && !isset($vehicle_info->other_due->EditAttrs["readonly"]) && !isset($vehicle_info->other_due->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infoedit", "x_other_due", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
<?php echo $vehicle_info->other_due->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_vehicle_info_status" for="x_status" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->status->caption() ?><?php echo ($vehicle_info->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->status->cellAttributes() ?>>
<span id="el_vehicle_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_status" data-value-separator="<?php echo $vehicle_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $vehicle_info->status->editAttributes() ?>>
		<?php echo $vehicle_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $vehicle_info->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->running_status->Visible) { // running_status ?>
	<div id="r_running_status" class="form-group row">
		<label id="elh_vehicle_info_running_status" for="x_running_status" class="<?php echo $vehicle_info_edit->LeftColumnClass ?>"><?php echo $vehicle_info->running_status->caption() ?><?php echo ($vehicle_info->running_status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $vehicle_info_edit->RightColumnClass ?>"><div<?php echo $vehicle_info->running_status->cellAttributes() ?>>
<span id="el_vehicle_info_running_status">
<span<?php echo $vehicle_info->running_status->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($vehicle_info->running_status->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="vehicle_info" data-field="x_running_status" name="x_running_status" id="x_running_status" value="<?php echo HtmlEncode($vehicle_info->running_status->CurrentValue) ?>">
<?php echo $vehicle_info->running_status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$vehicle_info_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $vehicle_info_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $vehicle_info_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$vehicle_info_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

		var type = $("#x_type").val();
		if (type == 1)
		{
		$("#r_vehicle_owner").hide();
		$("#r_driver").show();
		$("#r_dor").show();
		$("#r_km_hour").show();
		$("#r_chassis_no").show();
		$("#r_engine_no").show();
		$("#r_load_average").show();
		$("#r_unload_average").show();
		$("#r_load_expenses").show();
		$("#r_unload_expenses").show();
		$("#r_insurance").show();
		$("#r_state_tax").show();
		$("#r_national_permit").show();
		$("#r_pollution").show();
		$("#r_fitness").show();
		$("#r_other_due").show();
		} else {
		$("#r_vehicle_owner").show();
		$("#r_driver").hide();
		$("#r_dor").hide();
		$("#r_km_hour").hide();
		$("#r_chassis_no").hide();
		$("#r_engine_no").hide();
		$("#r_load_average").hide();
		$("#r_unload_average").hide();
		$("#r_load_expenses").hide();
		$("#r_unload_expenses").hide();
		$("#r_insurance").hide();
		$("#r_state_tax").hide();
		$("#r_national_permit").hide();
		$("#r_pollution").hide();
		$("#r_fitness").hide();
		$("#r_other_due").hide();
		}
</script>
<?php include_once "footer.php" ?>
<?php
$vehicle_info_edit->terminate();
?>