<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$vehicle_info_list = new vehicle_info_list();

// Run the page
$vehicle_info_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$vehicle_info_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$vehicle_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fvehicle_infolist = currentForm = new ew.Form("fvehicle_infolist", "list");
fvehicle_infolist.formKeyCountName = '<?php echo $vehicle_info_list->FormKeyCountName ?>';

// Form_CustomValidate event
fvehicle_infolist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvehicle_infolist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvehicle_infolist.lists["x_type"] = <?php echo $vehicle_info_list->type->Lookup->toClientList() ?>;
fvehicle_infolist.lists["x_type"].options = <?php echo JsonEncode($vehicle_info_list->type->options(FALSE, TRUE)) ?>;
fvehicle_infolist.lists["x_vehicle_owner"] = <?php echo $vehicle_info_list->vehicle_owner->Lookup->toClientList() ?>;
fvehicle_infolist.lists["x_vehicle_owner"].options = <?php echo JsonEncode($vehicle_info_list->vehicle_owner->lookupOptions()) ?>;
fvehicle_infolist.lists["x_status"] = <?php echo $vehicle_info_list->status->Lookup->toClientList() ?>;
fvehicle_infolist.lists["x_status"].options = <?php echo JsonEncode($vehicle_info_list->status->options(FALSE, TRUE)) ?>;
fvehicle_infolist.lists["x_operator"] = <?php echo $vehicle_info_list->operator->Lookup->toClientList() ?>;
fvehicle_infolist.lists["x_operator"].options = <?php echo JsonEncode($vehicle_info_list->operator->lookupOptions()) ?>;
fvehicle_infolist.lists["x_running_status"] = <?php echo $vehicle_info_list->running_status->Lookup->toClientList() ?>;
fvehicle_infolist.lists["x_running_status"].options = <?php echo JsonEncode($vehicle_info_list->running_status->options(FALSE, TRUE)) ?>;

// Form object for search
var fvehicle_infolistsrch = currentSearchForm = new ew.Form("fvehicle_infolistsrch");

// Filters
fvehicle_infolistsrch.filterList = <?php echo $vehicle_info_list->getFilterList() ?>;

// Init search panel as collapsed
fvehicle_infolistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$vehicle_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($vehicle_info_list->TotalRecs > 0 && $vehicle_info_list->ExportOptions->visible()) { ?>
<?php $vehicle_info_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($vehicle_info_list->ImportOptions->visible()) { ?>
<?php $vehicle_info_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($vehicle_info_list->SearchOptions->visible()) { ?>
<?php $vehicle_info_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($vehicle_info_list->FilterOptions->visible()) { ?>
<?php $vehicle_info_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$vehicle_info_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$vehicle_info->isExport() && !$vehicle_info->CurrentAction) { ?>
<form name="fvehicle_infolistsrch" id="fvehicle_infolistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($vehicle_info_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fvehicle_infolistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="vehicle_info">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($vehicle_info_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($vehicle_info_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $vehicle_info_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($vehicle_info_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($vehicle_info_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($vehicle_info_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($vehicle_info_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $vehicle_info_list->showPageHeader(); ?>
<?php
$vehicle_info_list->showMessage();
?>
<?php if ($vehicle_info_list->TotalRecs > 0 || $vehicle_info->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($vehicle_info_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> vehicle_info">
<?php if (!$vehicle_info->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$vehicle_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($vehicle_info_list->Pager)) $vehicle_info_list->Pager = new PrevNextPager($vehicle_info_list->StartRec, $vehicle_info_list->DisplayRecs, $vehicle_info_list->TotalRecs, $vehicle_info_list->AutoHidePager) ?>
<?php if ($vehicle_info_list->Pager->RecordCount > 0 && $vehicle_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($vehicle_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($vehicle_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $vehicle_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($vehicle_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($vehicle_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $vehicle_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($vehicle_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $vehicle_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $vehicle_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $vehicle_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($vehicle_info_list->TotalRecs > 0 && (!$vehicle_info_list->AutoHidePageSizeSelector || $vehicle_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="vehicle_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($vehicle_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($vehicle_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($vehicle_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($vehicle_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($vehicle_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($vehicle_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $vehicle_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fvehicle_infolist" id="fvehicle_infolist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($vehicle_info_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $vehicle_info_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="vehicle_info">
<div id="gmp_vehicle_info" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($vehicle_info_list->TotalRecs > 0 || $vehicle_info->isGridEdit()) { ?>
<table id="tbl_vehicle_infolist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$vehicle_info_list->RowType = ROWTYPE_HEADER;

// Render list options
$vehicle_info_list->renderListOptions();

// Render list options (header, left)
$vehicle_info_list->ListOptions->render("header", "left");
?>
<?php if ($vehicle_info->id->Visible) { // id ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->id) == "") { ?>
		<th data-name="id" class="<?php echo $vehicle_info->id->headerCellClass() ?>"><div id="elh_vehicle_info_id" class="vehicle_info_id"><div class="ew-table-header-caption"><?php echo $vehicle_info->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $vehicle_info->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->id) ?>',2);"><div id="elh_vehicle_info_id" class="vehicle_info_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->type->Visible) { // type ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->type) == "") { ?>
		<th data-name="type" class="<?php echo $vehicle_info->type->headerCellClass() ?>"><div id="elh_vehicle_info_type" class="vehicle_info_type"><div class="ew-table-header-caption"><?php echo $vehicle_info->type->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="type" class="<?php echo $vehicle_info->type->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->type) ?>',2);"><div id="elh_vehicle_info_type" class="vehicle_info_type">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->type->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->type->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->type->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->vehicle_owner->Visible) { // vehicle_owner ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->vehicle_owner) == "") { ?>
		<th data-name="vehicle_owner" class="<?php echo $vehicle_info->vehicle_owner->headerCellClass() ?>"><div id="elh_vehicle_info_vehicle_owner" class="vehicle_info_vehicle_owner"><div class="ew-table-header-caption"><?php echo $vehicle_info->vehicle_owner->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="vehicle_owner" class="<?php echo $vehicle_info->vehicle_owner->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->vehicle_owner) ?>',2);"><div id="elh_vehicle_info_vehicle_owner" class="vehicle_info_vehicle_owner">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->vehicle_owner->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->vehicle_owner->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->vehicle_owner->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->no->Visible) { // no ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->no) == "") { ?>
		<th data-name="no" class="<?php echo $vehicle_info->no->headerCellClass() ?>"><div id="elh_vehicle_info_no" class="vehicle_info_no"><div class="ew-table-header-caption"><?php echo $vehicle_info->no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="no" class="<?php echo $vehicle_info->no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->no) ?>',2);"><div id="elh_vehicle_info_no" class="vehicle_info_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->driver_name->Visible) { // driver_name ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->driver_name) == "") { ?>
		<th data-name="driver_name" class="<?php echo $vehicle_info->driver_name->headerCellClass() ?>"><div id="elh_vehicle_info_driver_name" class="vehicle_info_driver_name"><div class="ew-table-header-caption"><?php echo $vehicle_info->driver_name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="driver_name" class="<?php echo $vehicle_info->driver_name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->driver_name) ?>',2);"><div id="elh_vehicle_info_driver_name" class="vehicle_info_driver_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->driver_name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->driver_name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->driver_name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->dor->Visible) { // dor ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->dor) == "") { ?>
		<th data-name="dor" class="<?php echo $vehicle_info->dor->headerCellClass() ?>"><div id="elh_vehicle_info_dor" class="vehicle_info_dor"><div class="ew-table-header-caption"><?php echo $vehicle_info->dor->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="dor" class="<?php echo $vehicle_info->dor->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->dor) ?>',2);"><div id="elh_vehicle_info_dor" class="vehicle_info_dor">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->dor->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->dor->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->dor->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->km_hour->Visible) { // km_hour ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->km_hour) == "") { ?>
		<th data-name="km_hour" class="<?php echo $vehicle_info->km_hour->headerCellClass() ?>"><div id="elh_vehicle_info_km_hour" class="vehicle_info_km_hour"><div class="ew-table-header-caption"><?php echo $vehicle_info->km_hour->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="km_hour" class="<?php echo $vehicle_info->km_hour->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->km_hour) ?>',2);"><div id="elh_vehicle_info_km_hour" class="vehicle_info_km_hour">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->km_hour->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->km_hour->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->km_hour->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->chassis_no->Visible) { // chassis_no ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->chassis_no) == "") { ?>
		<th data-name="chassis_no" class="<?php echo $vehicle_info->chassis_no->headerCellClass() ?>"><div id="elh_vehicle_info_chassis_no" class="vehicle_info_chassis_no"><div class="ew-table-header-caption"><?php echo $vehicle_info->chassis_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="chassis_no" class="<?php echo $vehicle_info->chassis_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->chassis_no) ?>',2);"><div id="elh_vehicle_info_chassis_no" class="vehicle_info_chassis_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->chassis_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->chassis_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->chassis_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->engine_no->Visible) { // engine_no ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->engine_no) == "") { ?>
		<th data-name="engine_no" class="<?php echo $vehicle_info->engine_no->headerCellClass() ?>"><div id="elh_vehicle_info_engine_no" class="vehicle_info_engine_no"><div class="ew-table-header-caption"><?php echo $vehicle_info->engine_no->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="engine_no" class="<?php echo $vehicle_info->engine_no->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->engine_no) ?>',2);"><div id="elh_vehicle_info_engine_no" class="vehicle_info_engine_no">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->engine_no->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->engine_no->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->engine_no->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->load_average->Visible) { // load_average ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->load_average) == "") { ?>
		<th data-name="load_average" class="<?php echo $vehicle_info->load_average->headerCellClass() ?>"><div id="elh_vehicle_info_load_average" class="vehicle_info_load_average"><div class="ew-table-header-caption"><?php echo $vehicle_info->load_average->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_average" class="<?php echo $vehicle_info->load_average->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->load_average) ?>',2);"><div id="elh_vehicle_info_load_average" class="vehicle_info_load_average">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->load_average->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->load_average->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->load_average->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->unload_average->Visible) { // unload_average ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->unload_average) == "") { ?>
		<th data-name="unload_average" class="<?php echo $vehicle_info->unload_average->headerCellClass() ?>"><div id="elh_vehicle_info_unload_average" class="vehicle_info_unload_average"><div class="ew-table-header-caption"><?php echo $vehicle_info->unload_average->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_average" class="<?php echo $vehicle_info->unload_average->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->unload_average) ?>',2);"><div id="elh_vehicle_info_unload_average" class="vehicle_info_unload_average">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->unload_average->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->unload_average->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->unload_average->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->load_expenses->Visible) { // load_expenses ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->load_expenses) == "") { ?>
		<th data-name="load_expenses" class="<?php echo $vehicle_info->load_expenses->headerCellClass() ?>"><div id="elh_vehicle_info_load_expenses" class="vehicle_info_load_expenses"><div class="ew-table-header-caption"><?php echo $vehicle_info->load_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="load_expenses" class="<?php echo $vehicle_info->load_expenses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->load_expenses) ?>',2);"><div id="elh_vehicle_info_load_expenses" class="vehicle_info_load_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->load_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->load_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->load_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->unload_expenses->Visible) { // unload_expenses ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->unload_expenses) == "") { ?>
		<th data-name="unload_expenses" class="<?php echo $vehicle_info->unload_expenses->headerCellClass() ?>"><div id="elh_vehicle_info_unload_expenses" class="vehicle_info_unload_expenses"><div class="ew-table-header-caption"><?php echo $vehicle_info->unload_expenses->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="unload_expenses" class="<?php echo $vehicle_info->unload_expenses->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->unload_expenses) ?>',2);"><div id="elh_vehicle_info_unload_expenses" class="vehicle_info_unload_expenses">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->unload_expenses->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->unload_expenses->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->unload_expenses->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->insurance->Visible) { // insurance ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->insurance) == "") { ?>
		<th data-name="insurance" class="<?php echo $vehicle_info->insurance->headerCellClass() ?>"><div id="elh_vehicle_info_insurance" class="vehicle_info_insurance"><div class="ew-table-header-caption"><?php echo $vehicle_info->insurance->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="insurance" class="<?php echo $vehicle_info->insurance->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->insurance) ?>',2);"><div id="elh_vehicle_info_insurance" class="vehicle_info_insurance">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->insurance->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->insurance->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->insurance->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->state_tax->Visible) { // state_tax ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->state_tax) == "") { ?>
		<th data-name="state_tax" class="<?php echo $vehicle_info->state_tax->headerCellClass() ?>"><div id="elh_vehicle_info_state_tax" class="vehicle_info_state_tax"><div class="ew-table-header-caption"><?php echo $vehicle_info->state_tax->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="state_tax" class="<?php echo $vehicle_info->state_tax->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->state_tax) ?>',2);"><div id="elh_vehicle_info_state_tax" class="vehicle_info_state_tax">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->state_tax->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->state_tax->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->state_tax->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->national_permit->Visible) { // national_permit ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->national_permit) == "") { ?>
		<th data-name="national_permit" class="<?php echo $vehicle_info->national_permit->headerCellClass() ?>"><div id="elh_vehicle_info_national_permit" class="vehicle_info_national_permit"><div class="ew-table-header-caption"><?php echo $vehicle_info->national_permit->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="national_permit" class="<?php echo $vehicle_info->national_permit->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->national_permit) ?>',2);"><div id="elh_vehicle_info_national_permit" class="vehicle_info_national_permit">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->national_permit->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->national_permit->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->national_permit->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->pollution->Visible) { // pollution ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->pollution) == "") { ?>
		<th data-name="pollution" class="<?php echo $vehicle_info->pollution->headerCellClass() ?>"><div id="elh_vehicle_info_pollution" class="vehicle_info_pollution"><div class="ew-table-header-caption"><?php echo $vehicle_info->pollution->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pollution" class="<?php echo $vehicle_info->pollution->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->pollution) ?>',2);"><div id="elh_vehicle_info_pollution" class="vehicle_info_pollution">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->pollution->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->pollution->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->pollution->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->fitness->Visible) { // fitness ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->fitness) == "") { ?>
		<th data-name="fitness" class="<?php echo $vehicle_info->fitness->headerCellClass() ?>"><div id="elh_vehicle_info_fitness" class="vehicle_info_fitness"><div class="ew-table-header-caption"><?php echo $vehicle_info->fitness->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="fitness" class="<?php echo $vehicle_info->fitness->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->fitness) ?>',2);"><div id="elh_vehicle_info_fitness" class="vehicle_info_fitness">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->fitness->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->fitness->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->fitness->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->other_due->Visible) { // other_due ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->other_due) == "") { ?>
		<th data-name="other_due" class="<?php echo $vehicle_info->other_due->headerCellClass() ?>"><div id="elh_vehicle_info_other_due" class="vehicle_info_other_due"><div class="ew-table-header-caption"><?php echo $vehicle_info->other_due->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="other_due" class="<?php echo $vehicle_info->other_due->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->other_due) ?>',2);"><div id="elh_vehicle_info_other_due" class="vehicle_info_other_due">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->other_due->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->other_due->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->other_due->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->status->Visible) { // status ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->status) == "") { ?>
		<th data-name="status" class="<?php echo $vehicle_info->status->headerCellClass() ?>"><div id="elh_vehicle_info_status" class="vehicle_info_status"><div class="ew-table-header-caption"><?php echo $vehicle_info->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $vehicle_info->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->status) ?>',2);"><div id="elh_vehicle_info_status" class="vehicle_info_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->operator->Visible) { // operator ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $vehicle_info->operator->headerCellClass() ?>"><div id="elh_vehicle_info_operator" class="vehicle_info_operator"><div class="ew-table-header-caption"><?php echo $vehicle_info->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $vehicle_info->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->operator) ?>',2);"><div id="elh_vehicle_info_operator" class="vehicle_info_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->datetime->Visible) { // datetime ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $vehicle_info->datetime->headerCellClass() ?>"><div id="elh_vehicle_info_datetime" class="vehicle_info_datetime"><div class="ew-table-header-caption"><?php echo $vehicle_info->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $vehicle_info->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->datetime) ?>',2);"><div id="elh_vehicle_info_datetime" class="vehicle_info_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($vehicle_info->running_status->Visible) { // running_status ?>
	<?php if ($vehicle_info->sortUrl($vehicle_info->running_status) == "") { ?>
		<th data-name="running_status" class="<?php echo $vehicle_info->running_status->headerCellClass() ?>"><div id="elh_vehicle_info_running_status" class="vehicle_info_running_status"><div class="ew-table-header-caption"><?php echo $vehicle_info->running_status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="running_status" class="<?php echo $vehicle_info->running_status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $vehicle_info->SortUrl($vehicle_info->running_status) ?>',2);"><div id="elh_vehicle_info_running_status" class="vehicle_info_running_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $vehicle_info->running_status->caption() ?></span><span class="ew-table-header-sort"><?php if ($vehicle_info->running_status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($vehicle_info->running_status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$vehicle_info_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($vehicle_info->ExportAll && $vehicle_info->isExport()) {
	$vehicle_info_list->StopRec = $vehicle_info_list->TotalRecs;
} else {

	// Set the last record to display
	if ($vehicle_info_list->TotalRecs > $vehicle_info_list->StartRec + $vehicle_info_list->DisplayRecs - 1)
		$vehicle_info_list->StopRec = $vehicle_info_list->StartRec + $vehicle_info_list->DisplayRecs - 1;
	else
		$vehicle_info_list->StopRec = $vehicle_info_list->TotalRecs;
}
$vehicle_info_list->RecCnt = $vehicle_info_list->StartRec - 1;
if ($vehicle_info_list->Recordset && !$vehicle_info_list->Recordset->EOF) {
	$vehicle_info_list->Recordset->moveFirst();
	$selectLimit = $vehicle_info_list->UseSelectLimit;
	if (!$selectLimit && $vehicle_info_list->StartRec > 1)
		$vehicle_info_list->Recordset->move($vehicle_info_list->StartRec - 1);
} elseif (!$vehicle_info->AllowAddDeleteRow && $vehicle_info_list->StopRec == 0) {
	$vehicle_info_list->StopRec = $vehicle_info->GridAddRowCount;
}

// Initialize aggregate
$vehicle_info->RowType = ROWTYPE_AGGREGATEINIT;
$vehicle_info->resetAttributes();
$vehicle_info_list->renderRow();
while ($vehicle_info_list->RecCnt < $vehicle_info_list->StopRec) {
	$vehicle_info_list->RecCnt++;
	if ($vehicle_info_list->RecCnt >= $vehicle_info_list->StartRec) {
		$vehicle_info_list->RowCnt++;

		// Set up key count
		$vehicle_info_list->KeyCount = $vehicle_info_list->RowIndex;

		// Init row class and style
		$vehicle_info->resetAttributes();
		$vehicle_info->CssClass = "";
		if ($vehicle_info->isGridAdd()) {
		} else {
			$vehicle_info_list->loadRowValues($vehicle_info_list->Recordset); // Load row values
		}
		$vehicle_info->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$vehicle_info->RowAttrs = array_merge($vehicle_info->RowAttrs, array('data-rowindex'=>$vehicle_info_list->RowCnt, 'id'=>'r' . $vehicle_info_list->RowCnt . '_vehicle_info', 'data-rowtype'=>$vehicle_info->RowType));

		// Render row
		$vehicle_info_list->renderRow();

		// Render list options
		$vehicle_info_list->renderListOptions();
?>
	<tr<?php echo $vehicle_info->rowAttributes() ?>>
<?php

// Render list options (body, left)
$vehicle_info_list->ListOptions->render("body", "left", $vehicle_info_list->RowCnt);
?>
	<?php if ($vehicle_info->id->Visible) { // id ?>
		<td data-name="id"<?php echo $vehicle_info->id->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_id" class="vehicle_info_id">
<span<?php echo $vehicle_info->id->viewAttributes() ?>>
<?php echo $vehicle_info->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->type->Visible) { // type ?>
		<td data-name="type"<?php echo $vehicle_info->type->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_type" class="vehicle_info_type">
<span<?php echo $vehicle_info->type->viewAttributes() ?>>
<?php echo $vehicle_info->type->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->vehicle_owner->Visible) { // vehicle_owner ?>
		<td data-name="vehicle_owner"<?php echo $vehicle_info->vehicle_owner->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_vehicle_owner" class="vehicle_info_vehicle_owner">
<span<?php echo $vehicle_info->vehicle_owner->viewAttributes() ?>>
<?php echo $vehicle_info->vehicle_owner->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->no->Visible) { // no ?>
		<td data-name="no"<?php echo $vehicle_info->no->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_no" class="vehicle_info_no">
<span<?php echo $vehicle_info->no->viewAttributes() ?>>
<?php echo $vehicle_info->no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->driver_name->Visible) { // driver_name ?>
		<td data-name="driver_name"<?php echo $vehicle_info->driver_name->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_driver_name" class="vehicle_info_driver_name">
<span<?php echo $vehicle_info->driver_name->viewAttributes() ?>>
<?php echo $vehicle_info->driver_name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->dor->Visible) { // dor ?>
		<td data-name="dor"<?php echo $vehicle_info->dor->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_dor" class="vehicle_info_dor">
<span<?php echo $vehicle_info->dor->viewAttributes() ?>>
<?php echo $vehicle_info->dor->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->km_hour->Visible) { // km_hour ?>
		<td data-name="km_hour"<?php echo $vehicle_info->km_hour->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_km_hour" class="vehicle_info_km_hour">
<span<?php echo $vehicle_info->km_hour->viewAttributes() ?>>
<?php echo $vehicle_info->km_hour->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->chassis_no->Visible) { // chassis_no ?>
		<td data-name="chassis_no"<?php echo $vehicle_info->chassis_no->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_chassis_no" class="vehicle_info_chassis_no">
<span<?php echo $vehicle_info->chassis_no->viewAttributes() ?>>
<?php echo $vehicle_info->chassis_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->engine_no->Visible) { // engine_no ?>
		<td data-name="engine_no"<?php echo $vehicle_info->engine_no->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_engine_no" class="vehicle_info_engine_no">
<span<?php echo $vehicle_info->engine_no->viewAttributes() ?>>
<?php echo $vehicle_info->engine_no->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->load_average->Visible) { // load_average ?>
		<td data-name="load_average"<?php echo $vehicle_info->load_average->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_load_average" class="vehicle_info_load_average">
<span<?php echo $vehicle_info->load_average->viewAttributes() ?>>
<?php echo $vehicle_info->load_average->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->unload_average->Visible) { // unload_average ?>
		<td data-name="unload_average"<?php echo $vehicle_info->unload_average->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_unload_average" class="vehicle_info_unload_average">
<span<?php echo $vehicle_info->unload_average->viewAttributes() ?>>
<?php echo $vehicle_info->unload_average->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->load_expenses->Visible) { // load_expenses ?>
		<td data-name="load_expenses"<?php echo $vehicle_info->load_expenses->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_load_expenses" class="vehicle_info_load_expenses">
<span<?php echo $vehicle_info->load_expenses->viewAttributes() ?>>
<?php echo $vehicle_info->load_expenses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->unload_expenses->Visible) { // unload_expenses ?>
		<td data-name="unload_expenses"<?php echo $vehicle_info->unload_expenses->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_unload_expenses" class="vehicle_info_unload_expenses">
<span<?php echo $vehicle_info->unload_expenses->viewAttributes() ?>>
<?php echo $vehicle_info->unload_expenses->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->insurance->Visible) { // insurance ?>
		<td data-name="insurance"<?php echo $vehicle_info->insurance->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_insurance" class="vehicle_info_insurance">
<span<?php echo $vehicle_info->insurance->viewAttributes() ?>>
<?php echo $vehicle_info->insurance->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->state_tax->Visible) { // state_tax ?>
		<td data-name="state_tax"<?php echo $vehicle_info->state_tax->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_state_tax" class="vehicle_info_state_tax">
<span<?php echo $vehicle_info->state_tax->viewAttributes() ?>>
<?php echo $vehicle_info->state_tax->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->national_permit->Visible) { // national_permit ?>
		<td data-name="national_permit"<?php echo $vehicle_info->national_permit->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_national_permit" class="vehicle_info_national_permit">
<span<?php echo $vehicle_info->national_permit->viewAttributes() ?>>
<?php echo $vehicle_info->national_permit->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->pollution->Visible) { // pollution ?>
		<td data-name="pollution"<?php echo $vehicle_info->pollution->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_pollution" class="vehicle_info_pollution">
<span<?php echo $vehicle_info->pollution->viewAttributes() ?>>
<?php echo $vehicle_info->pollution->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->fitness->Visible) { // fitness ?>
		<td data-name="fitness"<?php echo $vehicle_info->fitness->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_fitness" class="vehicle_info_fitness">
<span<?php echo $vehicle_info->fitness->viewAttributes() ?>>
<?php echo $vehicle_info->fitness->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->other_due->Visible) { // other_due ?>
		<td data-name="other_due"<?php echo $vehicle_info->other_due->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_other_due" class="vehicle_info_other_due">
<span<?php echo $vehicle_info->other_due->viewAttributes() ?>>
<?php echo $vehicle_info->other_due->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->status->Visible) { // status ?>
		<td data-name="status"<?php echo $vehicle_info->status->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_status" class="vehicle_info_status">
<span<?php echo $vehicle_info->status->viewAttributes() ?>>
<?php echo $vehicle_info->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $vehicle_info->operator->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_operator" class="vehicle_info_operator">
<span<?php echo $vehicle_info->operator->viewAttributes() ?>>
<?php echo $vehicle_info->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $vehicle_info->datetime->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_datetime" class="vehicle_info_datetime">
<span<?php echo $vehicle_info->datetime->viewAttributes() ?>>
<?php echo $vehicle_info->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($vehicle_info->running_status->Visible) { // running_status ?>
		<td data-name="running_status"<?php echo $vehicle_info->running_status->cellAttributes() ?>>
<span id="el<?php echo $vehicle_info_list->RowCnt ?>_vehicle_info_running_status" class="vehicle_info_running_status">
<span<?php echo $vehicle_info->running_status->viewAttributes() ?>>
<?php echo $vehicle_info->running_status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$vehicle_info_list->ListOptions->render("body", "right", $vehicle_info_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$vehicle_info->isGridAdd())
		$vehicle_info_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$vehicle_info->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($vehicle_info_list->Recordset)
	$vehicle_info_list->Recordset->Close();
?>
<?php if (!$vehicle_info->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$vehicle_info->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($vehicle_info_list->Pager)) $vehicle_info_list->Pager = new PrevNextPager($vehicle_info_list->StartRec, $vehicle_info_list->DisplayRecs, $vehicle_info_list->TotalRecs, $vehicle_info_list->AutoHidePager) ?>
<?php if ($vehicle_info_list->Pager->RecordCount > 0 && $vehicle_info_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($vehicle_info_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($vehicle_info_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $vehicle_info_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($vehicle_info_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($vehicle_info_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $vehicle_info_list->pageUrl() ?>start=<?php echo $vehicle_info_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $vehicle_info_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($vehicle_info_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $vehicle_info_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $vehicle_info_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $vehicle_info_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($vehicle_info_list->TotalRecs > 0 && (!$vehicle_info_list->AutoHidePageSizeSelector || $vehicle_info_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="vehicle_info">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($vehicle_info_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($vehicle_info_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($vehicle_info_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($vehicle_info_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($vehicle_info_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($vehicle_info->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $vehicle_info_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($vehicle_info_list->TotalRecs == 0 && !$vehicle_info->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $vehicle_info_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$vehicle_info_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$vehicle_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$vehicle_info->isExport()) { ?>
<script>
ew.scrollableTable("gmp_vehicle_info", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$vehicle_info_list->terminate();
?>