<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$vehicle_info_search = new vehicle_info_search();

// Run the page
$vehicle_info_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$vehicle_info_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($vehicle_info_search->IsModal) { ?>
var fvehicle_infosearch = currentAdvancedSearchForm = new ew.Form("fvehicle_infosearch", "search");
<?php } else { ?>
var fvehicle_infosearch = currentForm = new ew.Form("fvehicle_infosearch", "search");
<?php } ?>

// Form_CustomValidate event
fvehicle_infosearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvehicle_infosearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvehicle_infosearch.lists["x_type"] = <?php echo $vehicle_info_search->type->Lookup->toClientList() ?>;
fvehicle_infosearch.lists["x_type"].options = <?php echo JsonEncode($vehicle_info_search->type->options(FALSE, TRUE)) ?>;
fvehicle_infosearch.lists["x_vehicle_owner"] = <?php echo $vehicle_info_search->vehicle_owner->Lookup->toClientList() ?>;
fvehicle_infosearch.lists["x_vehicle_owner"].options = <?php echo JsonEncode($vehicle_info_search->vehicle_owner->lookupOptions()) ?>;
fvehicle_infosearch.lists["x_driver"] = <?php echo $vehicle_info_search->driver->Lookup->toClientList() ?>;
fvehicle_infosearch.lists["x_driver"].options = <?php echo JsonEncode($vehicle_info_search->driver->lookupOptions()) ?>;
fvehicle_infosearch.lists["x_status"] = <?php echo $vehicle_info_search->status->Lookup->toClientList() ?>;
fvehicle_infosearch.lists["x_status"].options = <?php echo JsonEncode($vehicle_info_search->status->options(FALSE, TRUE)) ?>;
fvehicle_infosearch.lists["x_operator"] = <?php echo $vehicle_info_search->operator->Lookup->toClientList() ?>;
fvehicle_infosearch.lists["x_operator"].options = <?php echo JsonEncode($vehicle_info_search->operator->lookupOptions()) ?>;
fvehicle_infosearch.lists["x_running_status"] = <?php echo $vehicle_info_search->running_status->Lookup->toClientList() ?>;
fvehicle_infosearch.lists["x_running_status"].options = <?php echo JsonEncode($vehicle_info_search->running_status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fvehicle_infosearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_dor");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->dor->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_km_hour");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->km_hour->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_average");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->load_average->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_average");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->unload_average->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_load_expenses");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->load_expenses->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_unload_expenses");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->unload_expenses->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_insurance");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->insurance->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_state_tax");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->state_tax->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_national_permit");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->national_permit->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pollution");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->pollution->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_fitness");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->fitness->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_other_due");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->other_due->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($vehicle_info->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $vehicle_info_search->showPageHeader(); ?>
<?php
$vehicle_info_search->showMessage();
?>
<form name="fvehicle_infosearch" id="fvehicle_infosearch" class="<?php echo $vehicle_info_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($vehicle_info_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $vehicle_info_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="vehicle_info">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$vehicle_info_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($vehicle_info->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_id"><?php echo $vehicle_info->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->id->cellAttributes() ?>>
			<span id="el_vehicle_info_id">
<input type="text" data-table="vehicle_info" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($vehicle_info->id->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->id->EditValue ?>"<?php echo $vehicle_info->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->type->Visible) { // type ?>
	<div id="r_type" class="form-group row">
		<label for="x_type" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_type"><?php echo $vehicle_info->type->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_type" id="z_type" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->type->cellAttributes() ?>>
			<span id="el_vehicle_info_type">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_type" data-value-separator="<?php echo $vehicle_info->type->displayValueSeparatorAttribute() ?>" id="x_type" name="x_type"<?php echo $vehicle_info->type->editAttributes() ?>>
		<?php echo $vehicle_info->type->selectOptionListHtml("x_type") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->vehicle_owner->Visible) { // vehicle_owner ?>
	<div id="r_vehicle_owner" class="form-group row">
		<label for="x_vehicle_owner" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_vehicle_owner"><?php echo $vehicle_info->vehicle_owner->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_vehicle_owner" id="z_vehicle_owner" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->vehicle_owner->cellAttributes() ?>>
			<span id="el_vehicle_info_vehicle_owner">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_vehicle_owner" data-value-separator="<?php echo $vehicle_info->vehicle_owner->displayValueSeparatorAttribute() ?>" id="x_vehicle_owner" name="x_vehicle_owner"<?php echo $vehicle_info->vehicle_owner->editAttributes() ?>>
		<?php echo $vehicle_info->vehicle_owner->selectOptionListHtml("x_vehicle_owner") ?>
	</select>
</div>
<?php echo $vehicle_info->vehicle_owner->Lookup->getParamTag("p_x_vehicle_owner") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->no->Visible) { // no ?>
	<div id="r_no" class="form-group row">
		<label for="x_no" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_no"><?php echo $vehicle_info->no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_no" id="z_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->no->cellAttributes() ?>>
			<span id="el_vehicle_info_no">
<input type="text" data-table="vehicle_info" data-field="x_no" name="x_no" id="x_no" size="30" maxlength="24" placeholder="<?php echo HtmlEncode($vehicle_info->no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->no->EditValue ?>"<?php echo $vehicle_info->no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->driver->Visible) { // driver ?>
	<div id="r_driver" class="form-group row">
		<label for="x_driver" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_driver"><?php echo $vehicle_info->driver->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_driver" id="z_driver" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->driver->cellAttributes() ?>>
			<span id="el_vehicle_info_driver">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_driver" data-value-separator="<?php echo $vehicle_info->driver->displayValueSeparatorAttribute() ?>" id="x_driver" name="x_driver"<?php echo $vehicle_info->driver->editAttributes() ?>>
		<?php echo $vehicle_info->driver->selectOptionListHtml("x_driver") ?>
	</select>
</div>
<?php echo $vehicle_info->driver->Lookup->getParamTag("p_x_driver") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->driver_name->Visible) { // driver_name ?>
	<div id="r_driver_name" class="form-group row">
		<label for="x_driver_name" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_driver_name"><?php echo $vehicle_info->driver_name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_driver_name" id="z_driver_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->driver_name->cellAttributes() ?>>
			<span id="el_vehicle_info_driver_name">
<input type="text" data-table="vehicle_info" data-field="x_driver_name" name="x_driver_name" id="x_driver_name" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($vehicle_info->driver_name->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->driver_name->EditValue ?>"<?php echo $vehicle_info->driver_name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->dor->Visible) { // dor ?>
	<div id="r_dor" class="form-group row">
		<label for="x_dor" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_dor"><?php echo $vehicle_info->dor->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_dor" id="z_dor" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->dor->cellAttributes() ?>>
			<span id="el_vehicle_info_dor">
<input type="text" data-table="vehicle_info" data-field="x_dor" name="x_dor" id="x_dor" placeholder="<?php echo HtmlEncode($vehicle_info->dor->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->dor->EditValue ?>"<?php echo $vehicle_info->dor->editAttributes() ?>>
<?php if (!$vehicle_info->dor->ReadOnly && !$vehicle_info->dor->Disabled && !isset($vehicle_info->dor->EditAttrs["readonly"]) && !isset($vehicle_info->dor->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_dor", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->km_hour->Visible) { // km_hour ?>
	<div id="r_km_hour" class="form-group row">
		<label for="x_km_hour" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_km_hour"><?php echo $vehicle_info->km_hour->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_km_hour" id="z_km_hour" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->km_hour->cellAttributes() ?>>
			<span id="el_vehicle_info_km_hour">
<input type="text" data-table="vehicle_info" data-field="x_km_hour" name="x_km_hour" id="x_km_hour" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->km_hour->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->km_hour->EditValue ?>"<?php echo $vehicle_info->km_hour->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->chassis_no->Visible) { // chassis_no ?>
	<div id="r_chassis_no" class="form-group row">
		<label for="x_chassis_no" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_chassis_no"><?php echo $vehicle_info->chassis_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_chassis_no" id="z_chassis_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->chassis_no->cellAttributes() ?>>
			<span id="el_vehicle_info_chassis_no">
<input type="text" data-table="vehicle_info" data-field="x_chassis_no" name="x_chassis_no" id="x_chassis_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($vehicle_info->chassis_no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->chassis_no->EditValue ?>"<?php echo $vehicle_info->chassis_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->engine_no->Visible) { // engine_no ?>
	<div id="r_engine_no" class="form-group row">
		<label for="x_engine_no" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_engine_no"><?php echo $vehicle_info->engine_no->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_engine_no" id="z_engine_no" value="LIKE"></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->engine_no->cellAttributes() ?>>
			<span id="el_vehicle_info_engine_no">
<input type="text" data-table="vehicle_info" data-field="x_engine_no" name="x_engine_no" id="x_engine_no" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($vehicle_info->engine_no->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->engine_no->EditValue ?>"<?php echo $vehicle_info->engine_no->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->load_average->Visible) { // load_average ?>
	<div id="r_load_average" class="form-group row">
		<label for="x_load_average" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_load_average"><?php echo $vehicle_info->load_average->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_average" id="z_load_average" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->load_average->cellAttributes() ?>>
			<span id="el_vehicle_info_load_average">
<input type="text" data-table="vehicle_info" data-field="x_load_average" name="x_load_average" id="x_load_average" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->load_average->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->load_average->EditValue ?>"<?php echo $vehicle_info->load_average->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->unload_average->Visible) { // unload_average ?>
	<div id="r_unload_average" class="form-group row">
		<label for="x_unload_average" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_unload_average"><?php echo $vehicle_info->unload_average->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_average" id="z_unload_average" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->unload_average->cellAttributes() ?>>
			<span id="el_vehicle_info_unload_average">
<input type="text" data-table="vehicle_info" data-field="x_unload_average" name="x_unload_average" id="x_unload_average" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->unload_average->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->unload_average->EditValue ?>"<?php echo $vehicle_info->unload_average->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->load_expenses->Visible) { // load_expenses ?>
	<div id="r_load_expenses" class="form-group row">
		<label for="x_load_expenses" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_load_expenses"><?php echo $vehicle_info->load_expenses->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_load_expenses" id="z_load_expenses" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->load_expenses->cellAttributes() ?>>
			<span id="el_vehicle_info_load_expenses">
<input type="text" data-table="vehicle_info" data-field="x_load_expenses" name="x_load_expenses" id="x_load_expenses" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->load_expenses->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->load_expenses->EditValue ?>"<?php echo $vehicle_info->load_expenses->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->unload_expenses->Visible) { // unload_expenses ?>
	<div id="r_unload_expenses" class="form-group row">
		<label for="x_unload_expenses" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_unload_expenses"><?php echo $vehicle_info->unload_expenses->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_unload_expenses" id="z_unload_expenses" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->unload_expenses->cellAttributes() ?>>
			<span id="el_vehicle_info_unload_expenses">
<input type="text" data-table="vehicle_info" data-field="x_unload_expenses" name="x_unload_expenses" id="x_unload_expenses" size="30" placeholder="<?php echo HtmlEncode($vehicle_info->unload_expenses->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->unload_expenses->EditValue ?>"<?php echo $vehicle_info->unload_expenses->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->insurance->Visible) { // insurance ?>
	<div id="r_insurance" class="form-group row">
		<label for="x_insurance" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_insurance"><?php echo $vehicle_info->insurance->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_insurance" id="z_insurance" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->insurance->cellAttributes() ?>>
			<span id="el_vehicle_info_insurance">
<input type="text" data-table="vehicle_info" data-field="x_insurance" name="x_insurance" id="x_insurance" placeholder="<?php echo HtmlEncode($vehicle_info->insurance->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->insurance->EditValue ?>"<?php echo $vehicle_info->insurance->editAttributes() ?>>
<?php if (!$vehicle_info->insurance->ReadOnly && !$vehicle_info->insurance->Disabled && !isset($vehicle_info->insurance->EditAttrs["readonly"]) && !isset($vehicle_info->insurance->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_insurance", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->state_tax->Visible) { // state_tax ?>
	<div id="r_state_tax" class="form-group row">
		<label for="x_state_tax" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_state_tax"><?php echo $vehicle_info->state_tax->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_state_tax" id="z_state_tax" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->state_tax->cellAttributes() ?>>
			<span id="el_vehicle_info_state_tax">
<input type="text" data-table="vehicle_info" data-field="x_state_tax" name="x_state_tax" id="x_state_tax" placeholder="<?php echo HtmlEncode($vehicle_info->state_tax->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->state_tax->EditValue ?>"<?php echo $vehicle_info->state_tax->editAttributes() ?>>
<?php if (!$vehicle_info->state_tax->ReadOnly && !$vehicle_info->state_tax->Disabled && !isset($vehicle_info->state_tax->EditAttrs["readonly"]) && !isset($vehicle_info->state_tax->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_state_tax", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->national_permit->Visible) { // national_permit ?>
	<div id="r_national_permit" class="form-group row">
		<label for="x_national_permit" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_national_permit"><?php echo $vehicle_info->national_permit->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_national_permit" id="z_national_permit" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->national_permit->cellAttributes() ?>>
			<span id="el_vehicle_info_national_permit">
<input type="text" data-table="vehicle_info" data-field="x_national_permit" name="x_national_permit" id="x_national_permit" placeholder="<?php echo HtmlEncode($vehicle_info->national_permit->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->national_permit->EditValue ?>"<?php echo $vehicle_info->national_permit->editAttributes() ?>>
<?php if (!$vehicle_info->national_permit->ReadOnly && !$vehicle_info->national_permit->Disabled && !isset($vehicle_info->national_permit->EditAttrs["readonly"]) && !isset($vehicle_info->national_permit->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_national_permit", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->pollution->Visible) { // pollution ?>
	<div id="r_pollution" class="form-group row">
		<label for="x_pollution" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_pollution"><?php echo $vehicle_info->pollution->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pollution" id="z_pollution" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->pollution->cellAttributes() ?>>
			<span id="el_vehicle_info_pollution">
<input type="text" data-table="vehicle_info" data-field="x_pollution" name="x_pollution" id="x_pollution" placeholder="<?php echo HtmlEncode($vehicle_info->pollution->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->pollution->EditValue ?>"<?php echo $vehicle_info->pollution->editAttributes() ?>>
<?php if (!$vehicle_info->pollution->ReadOnly && !$vehicle_info->pollution->Disabled && !isset($vehicle_info->pollution->EditAttrs["readonly"]) && !isset($vehicle_info->pollution->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_pollution", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->fitness->Visible) { // fitness ?>
	<div id="r_fitness" class="form-group row">
		<label for="x_fitness" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_fitness"><?php echo $vehicle_info->fitness->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_fitness" id="z_fitness" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->fitness->cellAttributes() ?>>
			<span id="el_vehicle_info_fitness">
<input type="text" data-table="vehicle_info" data-field="x_fitness" name="x_fitness" id="x_fitness" placeholder="<?php echo HtmlEncode($vehicle_info->fitness->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->fitness->EditValue ?>"<?php echo $vehicle_info->fitness->editAttributes() ?>>
<?php if (!$vehicle_info->fitness->ReadOnly && !$vehicle_info->fitness->Disabled && !isset($vehicle_info->fitness->EditAttrs["readonly"]) && !isset($vehicle_info->fitness->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_fitness", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->other_due->Visible) { // other_due ?>
	<div id="r_other_due" class="form-group row">
		<label for="x_other_due" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_other_due"><?php echo $vehicle_info->other_due->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_other_due" id="z_other_due" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->other_due->cellAttributes() ?>>
			<span id="el_vehicle_info_other_due">
<input type="text" data-table="vehicle_info" data-field="x_other_due" name="x_other_due" id="x_other_due" placeholder="<?php echo HtmlEncode($vehicle_info->other_due->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->other_due->EditValue ?>"<?php echo $vehicle_info->other_due->editAttributes() ?>>
<?php if (!$vehicle_info->other_due->ReadOnly && !$vehicle_info->other_due->Disabled && !isset($vehicle_info->other_due->EditAttrs["readonly"]) && !isset($vehicle_info->other_due->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_other_due", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_status"><?php echo $vehicle_info->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->status->cellAttributes() ?>>
			<span id="el_vehicle_info_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_status" data-value-separator="<?php echo $vehicle_info->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $vehicle_info->status->editAttributes() ?>>
		<?php echo $vehicle_info->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_operator"><?php echo $vehicle_info->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->operator->cellAttributes() ?>>
			<span id="el_vehicle_info_operator">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_operator" data-value-separator="<?php echo $vehicle_info->operator->displayValueSeparatorAttribute() ?>" id="x_operator" name="x_operator"<?php echo $vehicle_info->operator->editAttributes() ?>>
		<?php echo $vehicle_info->operator->selectOptionListHtml("x_operator") ?>
	</select>
</div>
<?php echo $vehicle_info->operator->Lookup->getParamTag("p_x_operator") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_datetime"><?php echo $vehicle_info->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->datetime->cellAttributes() ?>>
			<span id="el_vehicle_info_datetime">
<input type="text" data-table="vehicle_info" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($vehicle_info->datetime->getPlaceHolder()) ?>" value="<?php echo $vehicle_info->datetime->EditValue ?>"<?php echo $vehicle_info->datetime->editAttributes() ?>>
<?php if (!$vehicle_info->datetime->ReadOnly && !$vehicle_info->datetime->Disabled && !isset($vehicle_info->datetime->EditAttrs["readonly"]) && !isset($vehicle_info->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fvehicle_infosearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($vehicle_info->running_status->Visible) { // running_status ?>
	<div id="r_running_status" class="form-group row">
		<label for="x_running_status" class="<?php echo $vehicle_info_search->LeftColumnClass ?>"><span id="elh_vehicle_info_running_status"><?php echo $vehicle_info->running_status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_running_status" id="z_running_status" value="="></span>
		</label>
		<div class="<?php echo $vehicle_info_search->RightColumnClass ?>"><div<?php echo $vehicle_info->running_status->cellAttributes() ?>>
			<span id="el_vehicle_info_running_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="vehicle_info" data-field="x_running_status" data-value-separator="<?php echo $vehicle_info->running_status->displayValueSeparatorAttribute() ?>" id="x_running_status" name="x_running_status"<?php echo $vehicle_info->running_status->editAttributes() ?>>
		<?php echo $vehicle_info->running_status->selectOptionListHtml("x_running_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$vehicle_info_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $vehicle_info_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$vehicle_info_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$vehicle_info_search->terminate();
?>