<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$vehicle_info_view = new vehicle_info_view();

// Run the page
$vehicle_info_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$vehicle_info_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$vehicle_info->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fvehicle_infoview = currentForm = new ew.Form("fvehicle_infoview", "view");

// Form_CustomValidate event
fvehicle_infoview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fvehicle_infoview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fvehicle_infoview.lists["x_type"] = <?php echo $vehicle_info_view->type->Lookup->toClientList() ?>;
fvehicle_infoview.lists["x_type"].options = <?php echo JsonEncode($vehicle_info_view->type->options(FALSE, TRUE)) ?>;
fvehicle_infoview.lists["x_vehicle_owner"] = <?php echo $vehicle_info_view->vehicle_owner->Lookup->toClientList() ?>;
fvehicle_infoview.lists["x_vehicle_owner"].options = <?php echo JsonEncode($vehicle_info_view->vehicle_owner->lookupOptions()) ?>;
fvehicle_infoview.lists["x_status"] = <?php echo $vehicle_info_view->status->Lookup->toClientList() ?>;
fvehicle_infoview.lists["x_status"].options = <?php echo JsonEncode($vehicle_info_view->status->options(FALSE, TRUE)) ?>;
fvehicle_infoview.lists["x_operator"] = <?php echo $vehicle_info_view->operator->Lookup->toClientList() ?>;
fvehicle_infoview.lists["x_operator"].options = <?php echo JsonEncode($vehicle_info_view->operator->lookupOptions()) ?>;
fvehicle_infoview.lists["x_running_status"] = <?php echo $vehicle_info_view->running_status->Lookup->toClientList() ?>;
fvehicle_infoview.lists["x_running_status"].options = <?php echo JsonEncode($vehicle_info_view->running_status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$vehicle_info->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $vehicle_info_view->ExportOptions->render("body") ?>
<?php $vehicle_info_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $vehicle_info_view->showPageHeader(); ?>
<?php
$vehicle_info_view->showMessage();
?>
<form name="fvehicle_infoview" id="fvehicle_infoview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($vehicle_info_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $vehicle_info_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="vehicle_info">
<input type="hidden" name="modal" value="<?php echo (int)$vehicle_info_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($vehicle_info->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_id"><?php echo $vehicle_info->id->caption() ?></span></td>
		<td data-name="id"<?php echo $vehicle_info->id->cellAttributes() ?>>
<span id="el_vehicle_info_id">
<span<?php echo $vehicle_info->id->viewAttributes() ?>>
<?php echo $vehicle_info->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->type->Visible) { // type ?>
	<tr id="r_type">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_type"><?php echo $vehicle_info->type->caption() ?></span></td>
		<td data-name="type"<?php echo $vehicle_info->type->cellAttributes() ?>>
<span id="el_vehicle_info_type">
<span<?php echo $vehicle_info->type->viewAttributes() ?>>
<?php echo $vehicle_info->type->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->vehicle_owner->Visible) { // vehicle_owner ?>
	<tr id="r_vehicle_owner">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_vehicle_owner"><?php echo $vehicle_info->vehicle_owner->caption() ?></span></td>
		<td data-name="vehicle_owner"<?php echo $vehicle_info->vehicle_owner->cellAttributes() ?>>
<span id="el_vehicle_info_vehicle_owner">
<span<?php echo $vehicle_info->vehicle_owner->viewAttributes() ?>>
<?php echo $vehicle_info->vehicle_owner->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->no->Visible) { // no ?>
	<tr id="r_no">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_no"><?php echo $vehicle_info->no->caption() ?></span></td>
		<td data-name="no"<?php echo $vehicle_info->no->cellAttributes() ?>>
<span id="el_vehicle_info_no">
<span<?php echo $vehicle_info->no->viewAttributes() ?>>
<?php echo $vehicle_info->no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->driver_name->Visible) { // driver_name ?>
	<tr id="r_driver_name">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_driver_name"><?php echo $vehicle_info->driver_name->caption() ?></span></td>
		<td data-name="driver_name"<?php echo $vehicle_info->driver_name->cellAttributes() ?>>
<span id="el_vehicle_info_driver_name">
<span<?php echo $vehicle_info->driver_name->viewAttributes() ?>>
<?php echo $vehicle_info->driver_name->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->dor->Visible) { // dor ?>
	<tr id="r_dor">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_dor"><?php echo $vehicle_info->dor->caption() ?></span></td>
		<td data-name="dor"<?php echo $vehicle_info->dor->cellAttributes() ?>>
<span id="el_vehicle_info_dor">
<span<?php echo $vehicle_info->dor->viewAttributes() ?>>
<?php echo $vehicle_info->dor->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->km_hour->Visible) { // km_hour ?>
	<tr id="r_km_hour">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_km_hour"><?php echo $vehicle_info->km_hour->caption() ?></span></td>
		<td data-name="km_hour"<?php echo $vehicle_info->km_hour->cellAttributes() ?>>
<span id="el_vehicle_info_km_hour">
<span<?php echo $vehicle_info->km_hour->viewAttributes() ?>>
<?php echo $vehicle_info->km_hour->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->chassis_no->Visible) { // chassis_no ?>
	<tr id="r_chassis_no">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_chassis_no"><?php echo $vehicle_info->chassis_no->caption() ?></span></td>
		<td data-name="chassis_no"<?php echo $vehicle_info->chassis_no->cellAttributes() ?>>
<span id="el_vehicle_info_chassis_no">
<span<?php echo $vehicle_info->chassis_no->viewAttributes() ?>>
<?php echo $vehicle_info->chassis_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->engine_no->Visible) { // engine_no ?>
	<tr id="r_engine_no">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_engine_no"><?php echo $vehicle_info->engine_no->caption() ?></span></td>
		<td data-name="engine_no"<?php echo $vehicle_info->engine_no->cellAttributes() ?>>
<span id="el_vehicle_info_engine_no">
<span<?php echo $vehicle_info->engine_no->viewAttributes() ?>>
<?php echo $vehicle_info->engine_no->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->load_average->Visible) { // load_average ?>
	<tr id="r_load_average">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_load_average"><?php echo $vehicle_info->load_average->caption() ?></span></td>
		<td data-name="load_average"<?php echo $vehicle_info->load_average->cellAttributes() ?>>
<span id="el_vehicle_info_load_average">
<span<?php echo $vehicle_info->load_average->viewAttributes() ?>>
<?php echo $vehicle_info->load_average->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->unload_average->Visible) { // unload_average ?>
	<tr id="r_unload_average">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_unload_average"><?php echo $vehicle_info->unload_average->caption() ?></span></td>
		<td data-name="unload_average"<?php echo $vehicle_info->unload_average->cellAttributes() ?>>
<span id="el_vehicle_info_unload_average">
<span<?php echo $vehicle_info->unload_average->viewAttributes() ?>>
<?php echo $vehicle_info->unload_average->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->load_expenses->Visible) { // load_expenses ?>
	<tr id="r_load_expenses">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_load_expenses"><?php echo $vehicle_info->load_expenses->caption() ?></span></td>
		<td data-name="load_expenses"<?php echo $vehicle_info->load_expenses->cellAttributes() ?>>
<span id="el_vehicle_info_load_expenses">
<span<?php echo $vehicle_info->load_expenses->viewAttributes() ?>>
<?php echo $vehicle_info->load_expenses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->unload_expenses->Visible) { // unload_expenses ?>
	<tr id="r_unload_expenses">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_unload_expenses"><?php echo $vehicle_info->unload_expenses->caption() ?></span></td>
		<td data-name="unload_expenses"<?php echo $vehicle_info->unload_expenses->cellAttributes() ?>>
<span id="el_vehicle_info_unload_expenses">
<span<?php echo $vehicle_info->unload_expenses->viewAttributes() ?>>
<?php echo $vehicle_info->unload_expenses->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->insurance->Visible) { // insurance ?>
	<tr id="r_insurance">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_insurance"><?php echo $vehicle_info->insurance->caption() ?></span></td>
		<td data-name="insurance"<?php echo $vehicle_info->insurance->cellAttributes() ?>>
<span id="el_vehicle_info_insurance">
<span<?php echo $vehicle_info->insurance->viewAttributes() ?>>
<?php echo $vehicle_info->insurance->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->state_tax->Visible) { // state_tax ?>
	<tr id="r_state_tax">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_state_tax"><?php echo $vehicle_info->state_tax->caption() ?></span></td>
		<td data-name="state_tax"<?php echo $vehicle_info->state_tax->cellAttributes() ?>>
<span id="el_vehicle_info_state_tax">
<span<?php echo $vehicle_info->state_tax->viewAttributes() ?>>
<?php echo $vehicle_info->state_tax->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->national_permit->Visible) { // national_permit ?>
	<tr id="r_national_permit">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_national_permit"><?php echo $vehicle_info->national_permit->caption() ?></span></td>
		<td data-name="national_permit"<?php echo $vehicle_info->national_permit->cellAttributes() ?>>
<span id="el_vehicle_info_national_permit">
<span<?php echo $vehicle_info->national_permit->viewAttributes() ?>>
<?php echo $vehicle_info->national_permit->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->pollution->Visible) { // pollution ?>
	<tr id="r_pollution">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_pollution"><?php echo $vehicle_info->pollution->caption() ?></span></td>
		<td data-name="pollution"<?php echo $vehicle_info->pollution->cellAttributes() ?>>
<span id="el_vehicle_info_pollution">
<span<?php echo $vehicle_info->pollution->viewAttributes() ?>>
<?php echo $vehicle_info->pollution->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->fitness->Visible) { // fitness ?>
	<tr id="r_fitness">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_fitness"><?php echo $vehicle_info->fitness->caption() ?></span></td>
		<td data-name="fitness"<?php echo $vehicle_info->fitness->cellAttributes() ?>>
<span id="el_vehicle_info_fitness">
<span<?php echo $vehicle_info->fitness->viewAttributes() ?>>
<?php echo $vehicle_info->fitness->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->other_due->Visible) { // other_due ?>
	<tr id="r_other_due">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_other_due"><?php echo $vehicle_info->other_due->caption() ?></span></td>
		<td data-name="other_due"<?php echo $vehicle_info->other_due->cellAttributes() ?>>
<span id="el_vehicle_info_other_due">
<span<?php echo $vehicle_info->other_due->viewAttributes() ?>>
<?php echo $vehicle_info->other_due->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_status"><?php echo $vehicle_info->status->caption() ?></span></td>
		<td data-name="status"<?php echo $vehicle_info->status->cellAttributes() ?>>
<span id="el_vehicle_info_status">
<span<?php echo $vehicle_info->status->viewAttributes() ?>>
<?php echo $vehicle_info->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_operator"><?php echo $vehicle_info->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $vehicle_info->operator->cellAttributes() ?>>
<span id="el_vehicle_info_operator">
<span<?php echo $vehicle_info->operator->viewAttributes() ?>>
<?php echo $vehicle_info->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_datetime"><?php echo $vehicle_info->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $vehicle_info->datetime->cellAttributes() ?>>
<span id="el_vehicle_info_datetime">
<span<?php echo $vehicle_info->datetime->viewAttributes() ?>>
<?php echo $vehicle_info->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($vehicle_info->running_status->Visible) { // running_status ?>
	<tr id="r_running_status">
		<td class="<?php echo $vehicle_info_view->TableLeftColumnClass ?>"><span id="elh_vehicle_info_running_status"><?php echo $vehicle_info->running_status->caption() ?></span></td>
		<td data-name="running_status"<?php echo $vehicle_info->running_status->cellAttributes() ?>>
<span id="el_vehicle_info_running_status">
<span<?php echo $vehicle_info->running_status->viewAttributes() ?>>
<?php echo $vehicle_info->running_status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$vehicle_info_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$vehicle_info->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$vehicle_info_view->terminate();
?>