<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$weekly_production_list = new weekly_production_list();

// Run the page
$weekly_production_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$weekly_production_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$weekly_production->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fweekly_productionlist = currentForm = new ew.Form("fweekly_productionlist", "list");
fweekly_productionlist.formKeyCountName = '<?php echo $weekly_production_list->FormKeyCountName ?>';

// Form_CustomValidate event
fweekly_productionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fweekly_productionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fweekly_productionlist.lists["x_location"] = <?php echo $weekly_production_list->location->Lookup->toClientList() ?>;
fweekly_productionlist.lists["x_location"].options = <?php echo JsonEncode($weekly_production_list->location->lookupOptions()) ?>;
fweekly_productionlist.lists["x_category"] = <?php echo $weekly_production_list->category->Lookup->toClientList() ?>;
fweekly_productionlist.lists["x_category"].options = <?php echo JsonEncode($weekly_production_list->category->lookupOptions()) ?>;
fweekly_productionlist.lists["x_process"] = <?php echo $weekly_production_list->process->Lookup->toClientList() ?>;
fweekly_productionlist.lists["x_process"].options = <?php echo JsonEncode($weekly_production_list->process->lookupOptions()) ?>;

// Form object for search
var fweekly_productionlistsrch = currentSearchForm = new ew.Form("fweekly_productionlistsrch");

// Validate function for search
fweekly_productionlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_week");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($weekly_production->week->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fweekly_productionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fweekly_productionlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fweekly_productionlistsrch.lists["x_location"] = <?php echo $weekly_production_list->location->Lookup->toClientList() ?>;
fweekly_productionlistsrch.lists["x_location"].options = <?php echo JsonEncode($weekly_production_list->location->lookupOptions()) ?>;
fweekly_productionlistsrch.lists["x_process"] = <?php echo $weekly_production_list->process->Lookup->toClientList() ?>;
fweekly_productionlistsrch.lists["x_process"].options = <?php echo JsonEncode($weekly_production_list->process->lookupOptions()) ?>;

// Filters
fweekly_productionlistsrch.filterList = <?php echo $weekly_production_list->getFilterList() ?>;

// Init search panel as collapsed
fweekly_productionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$weekly_production->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($weekly_production_list->TotalRecs > 0 && $weekly_production_list->ExportOptions->visible()) { ?>
<?php $weekly_production_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($weekly_production_list->ImportOptions->visible()) { ?>
<?php $weekly_production_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($weekly_production_list->SearchOptions->visible()) { ?>
<?php $weekly_production_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($weekly_production_list->FilterOptions->visible()) { ?>
<?php $weekly_production_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$weekly_production_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$weekly_production->isExport() && !$weekly_production->CurrentAction) { ?>
<form name="fweekly_productionlistsrch" id="fweekly_productionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($weekly_production_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fweekly_productionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="weekly_production">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$weekly_production_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$weekly_production->RowType = ROWTYPE_SEARCH;

// Render row
$weekly_production->resetAttributes();
$weekly_production_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($weekly_production->week->Visible) { // week ?>
	<div id="xsc_week" class="ew-cell form-group">
		<label for="x_week" class="ew-search-caption ew-label"><?php echo $weekly_production->week->caption() ?></label>
		<span class="ew-search-operator"><select name="z_week" id="z_week" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($weekly_production->week->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="weekly_production" data-field="x_week" name="x_week" id="x_week" size="30" placeholder="<?php echo HtmlEncode($weekly_production->week->getPlaceHolder()) ?>" value="<?php echo $weekly_production->week->EditValue ?>"<?php echo $weekly_production->week->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_week style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_week style="d-none"">
<input type="text" data-table="weekly_production" data-field="x_week" name="y_week" id="y_week" size="30" placeholder="<?php echo HtmlEncode($weekly_production->week->getPlaceHolder()) ?>" value="<?php echo $weekly_production->week->EditValue2 ?>"<?php echo $weekly_production->week->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($weekly_production->location->Visible) { // location ?>
	<div id="xsc_location" class="ew-cell form-group">
		<label for="x_location" class="ew-search-caption ew-label"><?php echo $weekly_production->location->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_location" id="z_location" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="weekly_production" data-field="x_location" data-value-separator="<?php echo $weekly_production->location->displayValueSeparatorAttribute() ?>" id="x_location" name="x_location"<?php echo $weekly_production->location->editAttributes() ?>>
		<?php echo $weekly_production->location->selectOptionListHtml("x_location") ?>
	</select>
</div>
<?php echo $weekly_production->location->Lookup->getParamTag("p_x_location") ?>
</span>
	</div>
<?php } ?>
<?php if ($weekly_production->process->Visible) { // process ?>
	<div id="xsc_process" class="ew-cell form-group">
		<label for="x_process" class="ew-search-caption ew-label"><?php echo $weekly_production->process->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_process" id="z_process" value="="></span>
		<span class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="weekly_production" data-field="x_process" data-value-separator="<?php echo $weekly_production->process->displayValueSeparatorAttribute() ?>" id="x_process" name="x_process"<?php echo $weekly_production->process->editAttributes() ?>>
		<?php echo $weekly_production->process->selectOptionListHtml("x_process") ?>
	</select>
</div>
<?php echo $weekly_production->process->Lookup->getParamTag("p_x_process") ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($weekly_production_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($weekly_production_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $weekly_production_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($weekly_production_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($weekly_production_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($weekly_production_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($weekly_production_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $weekly_production_list->showPageHeader(); ?>
<?php
$weekly_production_list->showMessage();
?>
<?php if ($weekly_production_list->TotalRecs > 0 || $weekly_production->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($weekly_production_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> weekly_production">
<?php if (!$weekly_production->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$weekly_production->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($weekly_production_list->Pager)) $weekly_production_list->Pager = new PrevNextPager($weekly_production_list->StartRec, $weekly_production_list->DisplayRecs, $weekly_production_list->TotalRecs, $weekly_production_list->AutoHidePager) ?>
<?php if ($weekly_production_list->Pager->RecordCount > 0 && $weekly_production_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($weekly_production_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($weekly_production_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $weekly_production_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($weekly_production_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($weekly_production_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $weekly_production_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($weekly_production_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $weekly_production_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $weekly_production_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $weekly_production_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($weekly_production_list->TotalRecs > 0 && (!$weekly_production_list->AutoHidePageSizeSelector || $weekly_production_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="weekly_production">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($weekly_production_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($weekly_production_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($weekly_production_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($weekly_production_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($weekly_production_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($weekly_production->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $weekly_production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fweekly_productionlist" id="fweekly_productionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($weekly_production_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $weekly_production_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="weekly_production">
<div id="gmp_weekly_production" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($weekly_production_list->TotalRecs > 0 || $weekly_production->isGridEdit()) { ?>
<table id="tbl_weekly_productionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$weekly_production_list->RowType = ROWTYPE_HEADER;

// Render list options
$weekly_production_list->renderListOptions();

// Render list options (header, left)
$weekly_production_list->ListOptions->render("header", "left");
?>
<?php if ($weekly_production->week->Visible) { // week ?>
	<?php if ($weekly_production->sortUrl($weekly_production->week) == "") { ?>
		<th data-name="week" class="<?php echo $weekly_production->week->headerCellClass() ?>"><div id="elh_weekly_production_week" class="weekly_production_week"><div class="ew-table-header-caption"><?php echo $weekly_production->week->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="week" class="<?php echo $weekly_production->week->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weekly_production->SortUrl($weekly_production->week) ?>',2);"><div id="elh_weekly_production_week" class="weekly_production_week">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weekly_production->week->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weekly_production->week->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weekly_production->week->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weekly_production->location->Visible) { // location ?>
	<?php if ($weekly_production->sortUrl($weekly_production->location) == "") { ?>
		<th data-name="location" class="<?php echo $weekly_production->location->headerCellClass() ?>"><div id="elh_weekly_production_location" class="weekly_production_location"><div class="ew-table-header-caption"><?php echo $weekly_production->location->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="location" class="<?php echo $weekly_production->location->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weekly_production->SortUrl($weekly_production->location) ?>',2);"><div id="elh_weekly_production_location" class="weekly_production_location">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weekly_production->location->caption() ?></span><span class="ew-table-header-sort"><?php if ($weekly_production->location->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weekly_production->location->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weekly_production->category->Visible) { // category ?>
	<?php if ($weekly_production->sortUrl($weekly_production->category) == "") { ?>
		<th data-name="category" class="<?php echo $weekly_production->category->headerCellClass() ?>"><div id="elh_weekly_production_category" class="weekly_production_category"><div class="ew-table-header-caption"><?php echo $weekly_production->category->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="category" class="<?php echo $weekly_production->category->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weekly_production->SortUrl($weekly_production->category) ?>',2);"><div id="elh_weekly_production_category" class="weekly_production_category">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weekly_production->category->caption() ?></span><span class="ew-table-header-sort"><?php if ($weekly_production->category->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weekly_production->category->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weekly_production->process->Visible) { // process ?>
	<?php if ($weekly_production->sortUrl($weekly_production->process) == "") { ?>
		<th data-name="process" class="<?php echo $weekly_production->process->headerCellClass() ?>"><div id="elh_weekly_production_process" class="weekly_production_process"><div class="ew-table-header-caption"><?php echo $weekly_production->process->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="process" class="<?php echo $weekly_production->process->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weekly_production->SortUrl($weekly_production->process) ?>',2);"><div id="elh_weekly_production_process" class="weekly_production_process">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weekly_production->process->caption() ?></span><span class="ew-table-header-sort"><?php if ($weekly_production->process->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weekly_production->process->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weekly_production->pcs->Visible) { // pcs ?>
	<?php if ($weekly_production->sortUrl($weekly_production->pcs) == "") { ?>
		<th data-name="pcs" class="<?php echo $weekly_production->pcs->headerCellClass() ?>"><div id="elh_weekly_production_pcs" class="weekly_production_pcs"><div class="ew-table-header-caption"><?php echo $weekly_production->pcs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pcs" class="<?php echo $weekly_production->pcs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weekly_production->SortUrl($weekly_production->pcs) ?>',2);"><div id="elh_weekly_production_pcs" class="weekly_production_pcs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weekly_production->pcs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weekly_production->pcs->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weekly_production->pcs->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weekly_production->sqm->Visible) { // sqm ?>
	<?php if ($weekly_production->sortUrl($weekly_production->sqm) == "") { ?>
		<th data-name="sqm" class="<?php echo $weekly_production->sqm->headerCellClass() ?>"><div id="elh_weekly_production_sqm" class="weekly_production_sqm"><div class="ew-table-header-caption"><?php echo $weekly_production->sqm->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="sqm" class="<?php echo $weekly_production->sqm->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weekly_production->SortUrl($weekly_production->sqm) ?>',2);"><div id="elh_weekly_production_sqm" class="weekly_production_sqm">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weekly_production->sqm->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weekly_production->sqm->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weekly_production->sqm->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$weekly_production_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($weekly_production->ExportAll && $weekly_production->isExport()) {
	$weekly_production_list->StopRec = $weekly_production_list->TotalRecs;
} else {

	// Set the last record to display
	if ($weekly_production_list->TotalRecs > $weekly_production_list->StartRec + $weekly_production_list->DisplayRecs - 1)
		$weekly_production_list->StopRec = $weekly_production_list->StartRec + $weekly_production_list->DisplayRecs - 1;
	else
		$weekly_production_list->StopRec = $weekly_production_list->TotalRecs;
}
$weekly_production_list->RecCnt = $weekly_production_list->StartRec - 1;
if ($weekly_production_list->Recordset && !$weekly_production_list->Recordset->EOF) {
	$weekly_production_list->Recordset->moveFirst();
	$selectLimit = $weekly_production_list->UseSelectLimit;
	if (!$selectLimit && $weekly_production_list->StartRec > 1)
		$weekly_production_list->Recordset->move($weekly_production_list->StartRec - 1);
} elseif (!$weekly_production->AllowAddDeleteRow && $weekly_production_list->StopRec == 0) {
	$weekly_production_list->StopRec = $weekly_production->GridAddRowCount;
}

// Initialize aggregate
$weekly_production->RowType = ROWTYPE_AGGREGATEINIT;
$weekly_production->resetAttributes();
$weekly_production_list->renderRow();
while ($weekly_production_list->RecCnt < $weekly_production_list->StopRec) {
	$weekly_production_list->RecCnt++;
	if ($weekly_production_list->RecCnt >= $weekly_production_list->StartRec) {
		$weekly_production_list->RowCnt++;

		// Set up key count
		$weekly_production_list->KeyCount = $weekly_production_list->RowIndex;

		// Init row class and style
		$weekly_production->resetAttributes();
		$weekly_production->CssClass = "";
		if ($weekly_production->isGridAdd()) {
		} else {
			$weekly_production_list->loadRowValues($weekly_production_list->Recordset); // Load row values
		}
		$weekly_production->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$weekly_production->RowAttrs = array_merge($weekly_production->RowAttrs, array('data-rowindex'=>$weekly_production_list->RowCnt, 'id'=>'r' . $weekly_production_list->RowCnt . '_weekly_production', 'data-rowtype'=>$weekly_production->RowType));

		// Render row
		$weekly_production_list->renderRow();

		// Render list options
		$weekly_production_list->renderListOptions();
?>
	<tr<?php echo $weekly_production->rowAttributes() ?>>
<?php

// Render list options (body, left)
$weekly_production_list->ListOptions->render("body", "left", $weekly_production_list->RowCnt);
?>
	<?php if ($weekly_production->week->Visible) { // week ?>
		<td data-name="week"<?php echo $weekly_production->week->cellAttributes() ?>>
<span id="el<?php echo $weekly_production_list->RowCnt ?>_weekly_production_week" class="weekly_production_week">
<span<?php echo $weekly_production->week->viewAttributes() ?>>
<?php echo $weekly_production->week->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weekly_production->location->Visible) { // location ?>
		<td data-name="location"<?php echo $weekly_production->location->cellAttributes() ?>>
<span id="el<?php echo $weekly_production_list->RowCnt ?>_weekly_production_location" class="weekly_production_location">
<span<?php echo $weekly_production->location->viewAttributes() ?>>
<?php echo $weekly_production->location->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weekly_production->category->Visible) { // category ?>
		<td data-name="category"<?php echo $weekly_production->category->cellAttributes() ?>>
<span id="el<?php echo $weekly_production_list->RowCnt ?>_weekly_production_category" class="weekly_production_category">
<span<?php echo $weekly_production->category->viewAttributes() ?>>
<?php echo $weekly_production->category->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weekly_production->process->Visible) { // process ?>
		<td data-name="process"<?php echo $weekly_production->process->cellAttributes() ?>>
<span id="el<?php echo $weekly_production_list->RowCnt ?>_weekly_production_process" class="weekly_production_process">
<span<?php echo $weekly_production->process->viewAttributes() ?>>
<?php echo $weekly_production->process->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weekly_production->pcs->Visible) { // pcs ?>
		<td data-name="pcs"<?php echo $weekly_production->pcs->cellAttributes() ?>>
<span id="el<?php echo $weekly_production_list->RowCnt ?>_weekly_production_pcs" class="weekly_production_pcs">
<span<?php echo $weekly_production->pcs->viewAttributes() ?>>
<?php echo $weekly_production->pcs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weekly_production->sqm->Visible) { // sqm ?>
		<td data-name="sqm"<?php echo $weekly_production->sqm->cellAttributes() ?>>
<span id="el<?php echo $weekly_production_list->RowCnt ?>_weekly_production_sqm" class="weekly_production_sqm">
<span<?php echo $weekly_production->sqm->viewAttributes() ?>>
<?php echo $weekly_production->sqm->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$weekly_production_list->ListOptions->render("body", "right", $weekly_production_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$weekly_production->isGridAdd())
		$weekly_production_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$weekly_production->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($weekly_production_list->Recordset)
	$weekly_production_list->Recordset->Close();
?>
<?php if (!$weekly_production->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$weekly_production->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($weekly_production_list->Pager)) $weekly_production_list->Pager = new PrevNextPager($weekly_production_list->StartRec, $weekly_production_list->DisplayRecs, $weekly_production_list->TotalRecs, $weekly_production_list->AutoHidePager) ?>
<?php if ($weekly_production_list->Pager->RecordCount > 0 && $weekly_production_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($weekly_production_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($weekly_production_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $weekly_production_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($weekly_production_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($weekly_production_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $weekly_production_list->pageUrl() ?>start=<?php echo $weekly_production_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $weekly_production_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($weekly_production_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $weekly_production_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $weekly_production_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $weekly_production_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($weekly_production_list->TotalRecs > 0 && (!$weekly_production_list->AutoHidePageSizeSelector || $weekly_production_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="weekly_production">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($weekly_production_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($weekly_production_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($weekly_production_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($weekly_production_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($weekly_production_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($weekly_production->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $weekly_production_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($weekly_production_list->TotalRecs == 0 && !$weekly_production->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $weekly_production_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$weekly_production_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$weekly_production->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$weekly_production->isExport()) { ?>
<script>
ew.scrollableTable("gmp_weekly_production", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$weekly_production_list->terminate();
?>