<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$weight_comparision_list = new weight_comparision_list();

// Run the page
$weight_comparision_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$weight_comparision_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$weight_comparision->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fweight_comparisionlist = currentForm = new ew.Form("fweight_comparisionlist", "list");
fweight_comparisionlist.formKeyCountName = '<?php echo $weight_comparision_list->FormKeyCountName ?>';

// Form_CustomValidate event
fweight_comparisionlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fweight_comparisionlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fweight_comparisionlistsrch = currentSearchForm = new ew.Form("fweight_comparisionlistsrch");

// Validate function for search
fweight_comparisionlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "__barcode");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($weight_comparision->_barcode->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_s_weight");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($weight_comparision->s_weight->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_diff_p");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($weight_comparision->diff_p->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($weight_comparision->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fweight_comparisionlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fweight_comparisionlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fweight_comparisionlistsrch.filterList = <?php echo $weight_comparision_list->getFilterList() ?>;

// Init search panel as collapsed
fweight_comparisionlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$weight_comparision->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($weight_comparision_list->TotalRecs > 0 && $weight_comparision_list->ExportOptions->visible()) { ?>
<?php $weight_comparision_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($weight_comparision_list->ImportOptions->visible()) { ?>
<?php $weight_comparision_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($weight_comparision_list->SearchOptions->visible()) { ?>
<?php $weight_comparision_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($weight_comparision_list->FilterOptions->visible()) { ?>
<?php $weight_comparision_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$weight_comparision_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$weight_comparision->isExport() && !$weight_comparision->CurrentAction) { ?>
<form name="fweight_comparisionlistsrch" id="fweight_comparisionlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($weight_comparision_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fweight_comparisionlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="weight_comparision">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$weight_comparision_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$weight_comparision->RowType = ROWTYPE_SEARCH;

// Render row
$weight_comparision->resetAttributes();
$weight_comparision_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($weight_comparision->_barcode->Visible) { // barcode ?>
	<div id="xsc__barcode" class="ew-cell form-group">
		<label for="x__barcode" class="ew-search-caption ew-label"><?php echo $weight_comparision->_barcode->caption() ?></label>
		<span class="ew-search-operator"><select name="z__barcode" id="z__barcode" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($weight_comparision->_barcode->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="weight_comparision" data-field="x__barcode" name="x__barcode" id="x__barcode" size="30" placeholder="<?php echo HtmlEncode($weight_comparision->_barcode->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->_barcode->EditValue ?>"<?php echo $weight_comparision->_barcode->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1__barcode style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1__barcode style="d-none"">
<input type="text" data-table="weight_comparision" data-field="x__barcode" name="y__barcode" id="y__barcode" size="30" placeholder="<?php echo HtmlEncode($weight_comparision->_barcode->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->_barcode->EditValue2 ?>"<?php echo $weight_comparision->_barcode->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($weight_comparision->design->Visible) { // design ?>
	<div id="xsc_design" class="ew-cell form-group">
		<label for="x_design" class="ew-search-caption ew-label"><?php echo $weight_comparision->design->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_design" id="z_design" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="weight_comparision" data-field="x_design" name="x_design" id="x_design" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($weight_comparision->design->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->design->EditValue ?>"<?php echo $weight_comparision->design->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
<?php if ($weight_comparision->size->Visible) { // size ?>
	<div id="xsc_size" class="ew-cell form-group">
		<label for="x_size" class="ew-search-caption ew-label"><?php echo $weight_comparision->size->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_size" id="z_size" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="weight_comparision" data-field="x_size" name="x_size" id="x_size" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($weight_comparision->size->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->size->EditValue ?>"<?php echo $weight_comparision->size->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($weight_comparision->s_weight->Visible) { // s_weight ?>
	<div id="xsc_s_weight" class="ew-cell form-group">
		<label for="x_s_weight" class="ew-search-caption ew-label"><?php echo $weight_comparision->s_weight->caption() ?></label>
		<span class="ew-search-operator"><select name="z_s_weight" id="z_s_weight" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($weight_comparision->s_weight->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="weight_comparision" data-field="x_s_weight" name="x_s_weight" id="x_s_weight" size="30" placeholder="<?php echo HtmlEncode($weight_comparision->s_weight->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->s_weight->EditValue ?>"<?php echo $weight_comparision->s_weight->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_s_weight style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_s_weight style="d-none"">
<input type="text" data-table="weight_comparision" data-field="x_s_weight" name="y_s_weight" id="y_s_weight" size="30" placeholder="<?php echo HtmlEncode($weight_comparision->s_weight->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->s_weight->EditValue2 ?>"<?php echo $weight_comparision->s_weight->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_3" class="ew-row d-sm-flex">
<?php if ($weight_comparision->diff_p->Visible) { // diff_p ?>
	<div id="xsc_diff_p" class="ew-cell form-group">
		<label for="x_diff_p" class="ew-search-caption ew-label"><?php echo $weight_comparision->diff_p->caption() ?></label>
		<span class="ew-search-operator"><select name="z_diff_p" id="z_diff_p" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="IS NULL"<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "IS NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NULL") ?></option><option value="IS NOT NULL"<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "IS NOT NULL") ? " selected" : "" ?> ><?php echo $Language->phrase("IS NOT NULL") ?></option><option value="BETWEEN"<?php echo ($weight_comparision->diff_p->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="weight_comparision" data-field="x_diff_p" name="x_diff_p" id="x_diff_p" size="30" placeholder="<?php echo HtmlEncode($weight_comparision->diff_p->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->diff_p->EditValue ?>"<?php echo $weight_comparision->diff_p->editAttributes() ?>>
</span>
		<span class="ew-search-cond btw1_diff_p style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_diff_p style="d-none"">
<input type="text" data-table="weight_comparision" data-field="x_diff_p" name="y_diff_p" id="y_diff_p" size="30" placeholder="<?php echo HtmlEncode($weight_comparision->diff_p->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->diff_p->EditValue2 ?>"<?php echo $weight_comparision->diff_p->editAttributes() ?>>
</span>
	</div>
<?php } ?>
<?php if ($weight_comparision->datetime->Visible) { // datetime ?>
	<div id="xsc_datetime" class="ew-cell form-group">
		<label for="x_datetime" class="ew-search-caption ew-label"><?php echo $weight_comparision->datetime->caption() ?></label>
		<span class="ew-search-operator"><select name="z_datetime" id="z_datetime" class="form-control" onchange="ew.forms(this).searchOperatorChanged(this);"><option value="="<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == "=") ? " selected" : "" ?> ><?php echo $Language->phrase("EQUAL") ?></option><option value="<>"<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == "<>") ? " selected" : "" ?> ><?php echo $Language->phrase("<>") ?></option><option value="<"<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == "<") ? " selected" : "" ?> ><?php echo $Language->phrase("<") ?></option><option value="<="<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == "<=") ? " selected" : "" ?> ><?php echo $Language->phrase("<=") ?></option><option value=">"<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == ">") ? " selected" : "" ?> ><?php echo $Language->phrase(">") ?></option><option value=">="<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == ">=") ? " selected" : "" ?> ><?php echo $Language->phrase(">=") ?></option><option value="BETWEEN"<?php echo ($weight_comparision->datetime->AdvancedSearch->SearchOperator == "BETWEEN") ? " selected" : "" ?> ><?php echo $Language->phrase("BETWEEN") ?></option></select></span>
		<span class="ew-search-field">
<input type="text" data-table="weight_comparision" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($weight_comparision->datetime->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->datetime->EditValue ?>"<?php echo $weight_comparision->datetime->editAttributes() ?>>
<?php if (!$weight_comparision->datetime->ReadOnly && !$weight_comparision->datetime->Disabled && !isset($weight_comparision->datetime->EditAttrs["readonly"]) && !isset($weight_comparision->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fweight_comparisionlistsrch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		<span class="ew-search-cond btw1_datetime style="d-none""><label><?php echo $Language->Phrase("AND") ?></label></span>
		<span class="ew-search-field btw1_datetime style="d-none"">
<input type="text" data-table="weight_comparision" data-field="x_datetime" name="y_datetime" id="y_datetime" placeholder="<?php echo HtmlEncode($weight_comparision->datetime->getPlaceHolder()) ?>" value="<?php echo $weight_comparision->datetime->EditValue2 ?>"<?php echo $weight_comparision->datetime->editAttributes() ?>>
<?php if (!$weight_comparision->datetime->ReadOnly && !$weight_comparision->datetime->Disabled && !isset($weight_comparision->datetime->EditAttrs["readonly"]) && !isset($weight_comparision->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fweight_comparisionlistsrch", "y_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_4" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($weight_comparision_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($weight_comparision_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $weight_comparision_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($weight_comparision_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($weight_comparision_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($weight_comparision_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($weight_comparision_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $weight_comparision_list->showPageHeader(); ?>
<?php
$weight_comparision_list->showMessage();
?>
<?php if ($weight_comparision_list->TotalRecs > 0 || $weight_comparision->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($weight_comparision_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> weight_comparision">
<?php if (!$weight_comparision->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$weight_comparision->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($weight_comparision_list->Pager)) $weight_comparision_list->Pager = new PrevNextPager($weight_comparision_list->StartRec, $weight_comparision_list->DisplayRecs, $weight_comparision_list->TotalRecs, $weight_comparision_list->AutoHidePager) ?>
<?php if ($weight_comparision_list->Pager->RecordCount > 0 && $weight_comparision_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($weight_comparision_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($weight_comparision_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $weight_comparision_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($weight_comparision_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($weight_comparision_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $weight_comparision_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($weight_comparision_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $weight_comparision_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $weight_comparision_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $weight_comparision_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($weight_comparision_list->TotalRecs > 0 && (!$weight_comparision_list->AutoHidePageSizeSelector || $weight_comparision_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="weight_comparision">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($weight_comparision_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($weight_comparision_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($weight_comparision_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($weight_comparision_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($weight_comparision_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($weight_comparision->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $weight_comparision_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fweight_comparisionlist" id="fweight_comparisionlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($weight_comparision_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $weight_comparision_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="weight_comparision">
<div id="gmp_weight_comparision" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($weight_comparision_list->TotalRecs > 0 || $weight_comparision->isGridEdit()) { ?>
<table id="tbl_weight_comparisionlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$weight_comparision_list->RowType = ROWTYPE_HEADER;

// Render list options
$weight_comparision_list->renderListOptions();

// Render list options (header, left)
$weight_comparision_list->ListOptions->render("header", "left");
?>
<?php if ($weight_comparision->_barcode->Visible) { // barcode ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->_barcode) == "") { ?>
		<th data-name="_barcode" class="<?php echo $weight_comparision->_barcode->headerCellClass() ?>"><div id="elh_weight_comparision__barcode" class="weight_comparision__barcode"><div class="ew-table-header-caption"><?php echo $weight_comparision->_barcode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="_barcode" class="<?php echo $weight_comparision->_barcode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->_barcode) ?>',2);"><div id="elh_weight_comparision__barcode" class="weight_comparision__barcode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->_barcode->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->_barcode->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->_barcode->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->design->Visible) { // design ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->design) == "") { ?>
		<th data-name="design" class="<?php echo $weight_comparision->design->headerCellClass() ?>"><div id="elh_weight_comparision_design" class="weight_comparision_design"><div class="ew-table-header-caption"><?php echo $weight_comparision->design->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="design" class="<?php echo $weight_comparision->design->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->design) ?>',2);"><div id="elh_weight_comparision_design" class="weight_comparision_design">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->design->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->design->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->design->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->size->Visible) { // size ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->size) == "") { ?>
		<th data-name="size" class="<?php echo $weight_comparision->size->headerCellClass() ?>"><div id="elh_weight_comparision_size" class="weight_comparision_size"><div class="ew-table-header-caption"><?php echo $weight_comparision->size->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size" class="<?php echo $weight_comparision->size->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->size) ?>',2);"><div id="elh_weight_comparision_size" class="weight_comparision_size">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->size->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->size->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->size->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->size_actual->Visible) { // size_actual ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->size_actual) == "") { ?>
		<th data-name="size_actual" class="<?php echo $weight_comparision->size_actual->headerCellClass() ?>"><div id="elh_weight_comparision_size_actual" class="weight_comparision_size_actual"><div class="ew-table-header-caption"><?php echo $weight_comparision->size_actual->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="size_actual" class="<?php echo $weight_comparision->size_actual->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->size_actual) ?>',2);"><div id="elh_weight_comparision_size_actual" class="weight_comparision_size_actual">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->size_actual->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->size_actual->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->size_actual->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->s_weight->Visible) { // s_weight ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->s_weight) == "") { ?>
		<th data-name="s_weight" class="<?php echo $weight_comparision->s_weight->headerCellClass() ?>"><div id="elh_weight_comparision_s_weight" class="weight_comparision_s_weight"><div class="ew-table-header-caption"><?php echo $weight_comparision->s_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="s_weight" class="<?php echo $weight_comparision->s_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->s_weight) ?>',2);"><div id="elh_weight_comparision_s_weight" class="weight_comparision_s_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->s_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->s_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->s_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->a_weight->Visible) { // a_weight ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->a_weight) == "") { ?>
		<th data-name="a_weight" class="<?php echo $weight_comparision->a_weight->headerCellClass() ?>"><div id="elh_weight_comparision_a_weight" class="weight_comparision_a_weight"><div class="ew-table-header-caption"><?php echo $weight_comparision->a_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="a_weight" class="<?php echo $weight_comparision->a_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->a_weight) ?>',2);"><div id="elh_weight_comparision_a_weight" class="weight_comparision_a_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->a_weight->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->a_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->a_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->diff_p->Visible) { // diff_p ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->diff_p) == "") { ?>
		<th data-name="diff_p" class="<?php echo $weight_comparision->diff_p->headerCellClass() ?>"><div id="elh_weight_comparision_diff_p" class="weight_comparision_diff_p"><div class="ew-table-header-caption"><?php echo $weight_comparision->diff_p->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="diff_p" class="<?php echo $weight_comparision->diff_p->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->diff_p) ?>',2);"><div id="elh_weight_comparision_diff_p" class="weight_comparision_diff_p">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->diff_p->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->diff_p->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->diff_p->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->datetime->Visible) { // datetime ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $weight_comparision->datetime->headerCellClass() ?>"><div id="elh_weight_comparision_datetime" class="weight_comparision_datetime"><div class="ew-table-header-caption"><?php echo $weight_comparision->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $weight_comparision->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->datetime) ?>',2);"><div id="elh_weight_comparision_datetime" class="weight_comparision_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->datetime->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->po->Visible) { // po ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->po) == "") { ?>
		<th data-name="po" class="<?php echo $weight_comparision->po->headerCellClass() ?>"><div id="elh_weight_comparision_po" class="weight_comparision_po"><div class="ew-table-header-caption"><?php echo $weight_comparision->po->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="po" class="<?php echo $weight_comparision->po->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->po) ?>',2);"><div id="elh_weight_comparision_po" class="weight_comparision_po">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->po->caption() ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->po->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->po->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($weight_comparision->buyers_id->Visible) { // buyers_id ?>
	<?php if ($weight_comparision->sortUrl($weight_comparision->buyers_id) == "") { ?>
		<th data-name="buyers_id" class="<?php echo $weight_comparision->buyers_id->headerCellClass() ?>"><div id="elh_weight_comparision_buyers_id" class="weight_comparision_buyers_id"><div class="ew-table-header-caption"><?php echo $weight_comparision->buyers_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="buyers_id" class="<?php echo $weight_comparision->buyers_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $weight_comparision->SortUrl($weight_comparision->buyers_id) ?>',2);"><div id="elh_weight_comparision_buyers_id" class="weight_comparision_buyers_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $weight_comparision->buyers_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($weight_comparision->buyers_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($weight_comparision->buyers_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$weight_comparision_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($weight_comparision->ExportAll && $weight_comparision->isExport()) {
	$weight_comparision_list->StopRec = $weight_comparision_list->TotalRecs;
} else {

	// Set the last record to display
	if ($weight_comparision_list->TotalRecs > $weight_comparision_list->StartRec + $weight_comparision_list->DisplayRecs - 1)
		$weight_comparision_list->StopRec = $weight_comparision_list->StartRec + $weight_comparision_list->DisplayRecs - 1;
	else
		$weight_comparision_list->StopRec = $weight_comparision_list->TotalRecs;
}
$weight_comparision_list->RecCnt = $weight_comparision_list->StartRec - 1;
if ($weight_comparision_list->Recordset && !$weight_comparision_list->Recordset->EOF) {
	$weight_comparision_list->Recordset->moveFirst();
	$selectLimit = $weight_comparision_list->UseSelectLimit;
	if (!$selectLimit && $weight_comparision_list->StartRec > 1)
		$weight_comparision_list->Recordset->move($weight_comparision_list->StartRec - 1);
} elseif (!$weight_comparision->AllowAddDeleteRow && $weight_comparision_list->StopRec == 0) {
	$weight_comparision_list->StopRec = $weight_comparision->GridAddRowCount;
}

// Initialize aggregate
$weight_comparision->RowType = ROWTYPE_AGGREGATEINIT;
$weight_comparision->resetAttributes();
$weight_comparision_list->renderRow();
while ($weight_comparision_list->RecCnt < $weight_comparision_list->StopRec) {
	$weight_comparision_list->RecCnt++;
	if ($weight_comparision_list->RecCnt >= $weight_comparision_list->StartRec) {
		$weight_comparision_list->RowCnt++;

		// Set up key count
		$weight_comparision_list->KeyCount = $weight_comparision_list->RowIndex;

		// Init row class and style
		$weight_comparision->resetAttributes();
		$weight_comparision->CssClass = "";
		if ($weight_comparision->isGridAdd()) {
		} else {
			$weight_comparision_list->loadRowValues($weight_comparision_list->Recordset); // Load row values
		}
		$weight_comparision->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$weight_comparision->RowAttrs = array_merge($weight_comparision->RowAttrs, array('data-rowindex'=>$weight_comparision_list->RowCnt, 'id'=>'r' . $weight_comparision_list->RowCnt . '_weight_comparision', 'data-rowtype'=>$weight_comparision->RowType));

		// Render row
		$weight_comparision_list->renderRow();

		// Render list options
		$weight_comparision_list->renderListOptions();
?>
	<tr<?php echo $weight_comparision->rowAttributes() ?>>
<?php

// Render list options (body, left)
$weight_comparision_list->ListOptions->render("body", "left", $weight_comparision_list->RowCnt);
?>
	<?php if ($weight_comparision->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode"<?php echo $weight_comparision->_barcode->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision__barcode" class="weight_comparision__barcode">
<span<?php echo $weight_comparision->_barcode->viewAttributes() ?>>
<?php echo $weight_comparision->_barcode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->design->Visible) { // design ?>
		<td data-name="design"<?php echo $weight_comparision->design->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_design" class="weight_comparision_design">
<span<?php echo $weight_comparision->design->viewAttributes() ?>>
<?php echo $weight_comparision->design->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->size->Visible) { // size ?>
		<td data-name="size"<?php echo $weight_comparision->size->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_size" class="weight_comparision_size">
<span<?php echo $weight_comparision->size->viewAttributes() ?>>
<?php echo $weight_comparision->size->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->size_actual->Visible) { // size_actual ?>
		<td data-name="size_actual"<?php echo $weight_comparision->size_actual->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_size_actual" class="weight_comparision_size_actual">
<span<?php echo $weight_comparision->size_actual->viewAttributes() ?>>
<?php echo $weight_comparision->size_actual->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->s_weight->Visible) { // s_weight ?>
		<td data-name="s_weight"<?php echo $weight_comparision->s_weight->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_s_weight" class="weight_comparision_s_weight">
<span<?php echo $weight_comparision->s_weight->viewAttributes() ?>>
<?php echo $weight_comparision->s_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->a_weight->Visible) { // a_weight ?>
		<td data-name="a_weight"<?php echo $weight_comparision->a_weight->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_a_weight" class="weight_comparision_a_weight">
<span<?php echo $weight_comparision->a_weight->viewAttributes() ?>>
<?php echo $weight_comparision->a_weight->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->diff_p->Visible) { // diff_p ?>
		<td data-name="diff_p"<?php echo $weight_comparision->diff_p->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_diff_p" class="weight_comparision_diff_p">
<span<?php echo $weight_comparision->diff_p->viewAttributes() ?>>
<?php echo $weight_comparision->diff_p->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $weight_comparision->datetime->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_datetime" class="weight_comparision_datetime">
<span<?php echo $weight_comparision->datetime->viewAttributes() ?>>
<?php echo $weight_comparision->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->po->Visible) { // po ?>
		<td data-name="po"<?php echo $weight_comparision->po->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_po" class="weight_comparision_po">
<span<?php echo $weight_comparision->po->viewAttributes() ?>>
<?php echo $weight_comparision->po->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($weight_comparision->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id"<?php echo $weight_comparision->buyers_id->cellAttributes() ?>>
<span id="el<?php echo $weight_comparision_list->RowCnt ?>_weight_comparision_buyers_id" class="weight_comparision_buyers_id">
<span<?php echo $weight_comparision->buyers_id->viewAttributes() ?>>
<?php echo $weight_comparision->buyers_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$weight_comparision_list->ListOptions->render("body", "right", $weight_comparision_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$weight_comparision->isGridAdd())
		$weight_comparision_list->Recordset->moveNext();
}
?>
</tbody>
<?php

// Render aggregate row
$weight_comparision->RowType = ROWTYPE_AGGREGATE;
$weight_comparision->resetAttributes();
$weight_comparision_list->renderRow();
?>
<?php if ($weight_comparision_list->TotalRecs > 0 && !$weight_comparision->isGridAdd() && !$weight_comparision->isGridEdit()) { ?>
<tfoot><!-- Table footer -->
	<tr class="ew-table-footer">
<?php

// Render list options
$weight_comparision_list->renderListOptions();

// Render list options (footer, left)
$weight_comparision_list->ListOptions->render("footer", "left");
?>
	<?php if ($weight_comparision->_barcode->Visible) { // barcode ?>
		<td data-name="_barcode" class="<?php echo $weight_comparision->_barcode->footerCellClass() ?>"><span id="elf_weight_comparision__barcode" class="weight_comparision__barcode">
		<span class="ew-aggregate"><?php echo $Language->phrase("COUNT") ?></span><span class="ew-aggregate-value">
		<?php echo $weight_comparision->_barcode->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->design->Visible) { // design ?>
		<td data-name="design" class="<?php echo $weight_comparision->design->footerCellClass() ?>"><span id="elf_weight_comparision_design" class="weight_comparision_design">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->size->Visible) { // size ?>
		<td data-name="size" class="<?php echo $weight_comparision->size->footerCellClass() ?>"><span id="elf_weight_comparision_size" class="weight_comparision_size">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->size_actual->Visible) { // size_actual ?>
		<td data-name="size_actual" class="<?php echo $weight_comparision->size_actual->footerCellClass() ?>"><span id="elf_weight_comparision_size_actual" class="weight_comparision_size_actual">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->s_weight->Visible) { // s_weight ?>
		<td data-name="s_weight" class="<?php echo $weight_comparision->s_weight->footerCellClass() ?>"><span id="elf_weight_comparision_s_weight" class="weight_comparision_s_weight">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $weight_comparision->s_weight->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->a_weight->Visible) { // a_weight ?>
		<td data-name="a_weight" class="<?php echo $weight_comparision->a_weight->footerCellClass() ?>"><span id="elf_weight_comparision_a_weight" class="weight_comparision_a_weight">
		<span class="ew-aggregate"><?php echo $Language->phrase("TOTAL") ?></span><span class="ew-aggregate-value">
		<?php echo $weight_comparision->a_weight->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->diff_p->Visible) { // diff_p ?>
		<td data-name="diff_p" class="<?php echo $weight_comparision->diff_p->footerCellClass() ?>"><span id="elf_weight_comparision_diff_p" class="weight_comparision_diff_p">
		<span class="ew-aggregate"><?php echo $Language->phrase("AVERAGE") ?></span><span class="ew-aggregate-value">
		<?php echo $weight_comparision->diff_p->ViewValue ?></span>
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->datetime->Visible) { // datetime ?>
		<td data-name="datetime" class="<?php echo $weight_comparision->datetime->footerCellClass() ?>"><span id="elf_weight_comparision_datetime" class="weight_comparision_datetime">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->po->Visible) { // po ?>
		<td data-name="po" class="<?php echo $weight_comparision->po->footerCellClass() ?>"><span id="elf_weight_comparision_po" class="weight_comparision_po">
		&nbsp;
		</span></td>
	<?php } ?>
	<?php if ($weight_comparision->buyers_id->Visible) { // buyers_id ?>
		<td data-name="buyers_id" class="<?php echo $weight_comparision->buyers_id->footerCellClass() ?>"><span id="elf_weight_comparision_buyers_id" class="weight_comparision_buyers_id">
		&nbsp;
		</span></td>
	<?php } ?>
<?php

// Render list options (footer, right)
$weight_comparision_list->ListOptions->render("footer", "right");
?>
	</tr>
</tfoot>
<?php } ?>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$weight_comparision->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($weight_comparision_list->Recordset)
	$weight_comparision_list->Recordset->Close();
?>
<?php if (!$weight_comparision->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$weight_comparision->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($weight_comparision_list->Pager)) $weight_comparision_list->Pager = new PrevNextPager($weight_comparision_list->StartRec, $weight_comparision_list->DisplayRecs, $weight_comparision_list->TotalRecs, $weight_comparision_list->AutoHidePager) ?>
<?php if ($weight_comparision_list->Pager->RecordCount > 0 && $weight_comparision_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($weight_comparision_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($weight_comparision_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $weight_comparision_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($weight_comparision_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($weight_comparision_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $weight_comparision_list->pageUrl() ?>start=<?php echo $weight_comparision_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $weight_comparision_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($weight_comparision_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $weight_comparision_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $weight_comparision_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $weight_comparision_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($weight_comparision_list->TotalRecs > 0 && (!$weight_comparision_list->AutoHidePageSizeSelector || $weight_comparision_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="weight_comparision">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($weight_comparision_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($weight_comparision_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($weight_comparision_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($weight_comparision_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($weight_comparision_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($weight_comparision->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $weight_comparision_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($weight_comparision_list->TotalRecs == 0 && !$weight_comparision->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $weight_comparision_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$weight_comparision_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$weight_comparision->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$weight_comparision->isExport()) { ?>
<script>
ew.scrollableTable("gmp_weight_comparision", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$weight_comparision_list->terminate();
?>