<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$whatsapp_setup_edit = new whatsapp_setup_edit();

// Run the page
$whatsapp_setup_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$whatsapp_setup_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fwhatsapp_setupedit = currentForm = new ew.Form("fwhatsapp_setupedit", "edit");

// Validate form
fwhatsapp_setupedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($whatsapp_setup_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->id->caption(), $whatsapp_setup->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->mobile->Required) { ?>
			elm = this.getElements("x" + infix + "_mobile");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->mobile->caption(), $whatsapp_setup->mobile->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->url->Required) { ?>
			elm = this.getElements("x" + infix + "_url");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->url->caption(), $whatsapp_setup->url->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->Instance_id->Required) { ?>
			elm = this.getElements("x" + infix + "_Instance_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->Instance_id->caption(), $whatsapp_setup->Instance_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->token->Required) { ?>
			elm = this.getElements("x" + infix + "_token");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->token->caption(), $whatsapp_setup->token->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->company->Required) { ?>
			elm = this.getElements("x" + infix + "_company[]");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->company->caption(), $whatsapp_setup->company->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->operator->caption(), $whatsapp_setup->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->datetime->caption(), $whatsapp_setup->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($whatsapp_setup_edit->direct_whatsapp->Required) { ?>
			elm = this.getElements("x" + infix + "_direct_whatsapp");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->direct_whatsapp->caption(), $whatsapp_setup->direct_whatsapp->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_direct_whatsapp");
			if (elm && !ew.checkInteger(elm.value))
				return this.onError(elm, "<?php echo JsEncode($whatsapp_setup->direct_whatsapp->errorMessage()) ?>");
		<?php if ($whatsapp_setup_edit->whatsapp_message->Required) { ?>
			elm = this.getElements("x" + infix + "_whatsapp_message");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $whatsapp_setup->whatsapp_message->caption(), $whatsapp_setup->whatsapp_message->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fwhatsapp_setupedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fwhatsapp_setupedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fwhatsapp_setupedit.lists["x_company[]"] = <?php echo $whatsapp_setup_edit->company->Lookup->toClientList() ?>;
fwhatsapp_setupedit.lists["x_company[]"].options = <?php echo JsonEncode($whatsapp_setup_edit->company->lookupOptions()) ?>;
fwhatsapp_setupedit.lists["x_operator"] = <?php echo $whatsapp_setup_edit->operator->Lookup->toClientList() ?>;
fwhatsapp_setupedit.lists["x_operator"].options = <?php echo JsonEncode($whatsapp_setup_edit->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $whatsapp_setup_edit->showPageHeader(); ?>
<?php
$whatsapp_setup_edit->showMessage();
?>
<form name="fwhatsapp_setupedit" id="fwhatsapp_setupedit" class="<?php echo $whatsapp_setup_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($whatsapp_setup_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $whatsapp_setup_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="whatsapp_setup">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$whatsapp_setup_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($whatsapp_setup->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_whatsapp_setup_id" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->id->caption() ?><?php echo ($whatsapp_setup->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->id->cellAttributes() ?>>
<span id="el_whatsapp_setup_id">
<span<?php echo $whatsapp_setup->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($whatsapp_setup->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="whatsapp_setup" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($whatsapp_setup->id->CurrentValue) ?>">
<?php echo $whatsapp_setup->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->mobile->Visible) { // mobile ?>
	<div id="r_mobile" class="form-group row">
		<label id="elh_whatsapp_setup_mobile" for="x_mobile" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->mobile->caption() ?><?php echo ($whatsapp_setup->mobile->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->mobile->cellAttributes() ?>>
<span id="el_whatsapp_setup_mobile">
<input type="text" data-table="whatsapp_setup" data-field="x_mobile" name="x_mobile" id="x_mobile" size="30" maxlength="48" placeholder="<?php echo HtmlEncode($whatsapp_setup->mobile->getPlaceHolder()) ?>" value="<?php echo $whatsapp_setup->mobile->EditValue ?>"<?php echo $whatsapp_setup->mobile->editAttributes() ?>>
</span>
<?php echo $whatsapp_setup->mobile->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->url->Visible) { // url ?>
	<div id="r_url" class="form-group row">
		<label id="elh_whatsapp_setup_url" for="x_url" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->url->caption() ?><?php echo ($whatsapp_setup->url->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->url->cellAttributes() ?>>
<span id="el_whatsapp_setup_url">
<input type="text" data-table="whatsapp_setup" data-field="x_url" name="x_url" id="x_url" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($whatsapp_setup->url->getPlaceHolder()) ?>" value="<?php echo $whatsapp_setup->url->EditValue ?>"<?php echo $whatsapp_setup->url->editAttributes() ?>>
</span>
<?php echo $whatsapp_setup->url->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->Instance_id->Visible) { // Instance_id ?>
	<div id="r_Instance_id" class="form-group row">
		<label id="elh_whatsapp_setup_Instance_id" for="x_Instance_id" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->Instance_id->caption() ?><?php echo ($whatsapp_setup->Instance_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->Instance_id->cellAttributes() ?>>
<span id="el_whatsapp_setup_Instance_id">
<input type="text" data-table="whatsapp_setup" data-field="x_Instance_id" name="x_Instance_id" id="x_Instance_id" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($whatsapp_setup->Instance_id->getPlaceHolder()) ?>" value="<?php echo $whatsapp_setup->Instance_id->EditValue ?>"<?php echo $whatsapp_setup->Instance_id->editAttributes() ?>>
</span>
<?php echo $whatsapp_setup->Instance_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->token->Visible) { // token ?>
	<div id="r_token" class="form-group row">
		<label id="elh_whatsapp_setup_token" for="x_token" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->token->caption() ?><?php echo ($whatsapp_setup->token->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->token->cellAttributes() ?>>
<span id="el_whatsapp_setup_token">
<input type="text" data-table="whatsapp_setup" data-field="x_token" name="x_token" id="x_token" size="30" maxlength="192" placeholder="<?php echo HtmlEncode($whatsapp_setup->token->getPlaceHolder()) ?>" value="<?php echo $whatsapp_setup->token->EditValue ?>"<?php echo $whatsapp_setup->token->editAttributes() ?>>
</span>
<?php echo $whatsapp_setup->token->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->company->Visible) { // company ?>
	<div id="r_company" class="form-group row">
		<label id="elh_whatsapp_setup_company" for="x_company" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->company->caption() ?><?php echo ($whatsapp_setup->company->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->company->cellAttributes() ?>>
<span id="el_whatsapp_setup_company">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="whatsapp_setup" data-field="x_company" data-value-separator="<?php echo $whatsapp_setup->company->displayValueSeparatorAttribute() ?>" id="x_company[]" name="x_company[]" multiple="multiple"<?php echo $whatsapp_setup->company->editAttributes() ?>>
		<?php echo $whatsapp_setup->company->selectOptionListHtml("x_company[]") ?>
	</select>
</div>
<?php echo $whatsapp_setup->company->Lookup->getParamTag("p_x_company") ?>
</span>
<?php echo $whatsapp_setup->company->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->direct_whatsapp->Visible) { // direct_whatsapp ?>
	<div id="r_direct_whatsapp" class="form-group row">
		<label id="elh_whatsapp_setup_direct_whatsapp" for="x_direct_whatsapp" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->direct_whatsapp->caption() ?><?php echo ($whatsapp_setup->direct_whatsapp->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->direct_whatsapp->cellAttributes() ?>>
<span id="el_whatsapp_setup_direct_whatsapp">
<input type="text" data-table="whatsapp_setup" data-field="x_direct_whatsapp" name="x_direct_whatsapp" id="x_direct_whatsapp" size="30" placeholder="<?php echo HtmlEncode($whatsapp_setup->direct_whatsapp->getPlaceHolder()) ?>" value="<?php echo $whatsapp_setup->direct_whatsapp->EditValue ?>"<?php echo $whatsapp_setup->direct_whatsapp->editAttributes() ?>>
</span>
<?php echo $whatsapp_setup->direct_whatsapp->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($whatsapp_setup->whatsapp_message->Visible) { // whatsapp_message ?>
	<div id="r_whatsapp_message" class="form-group row">
		<label id="elh_whatsapp_setup_whatsapp_message" for="x_whatsapp_message" class="<?php echo $whatsapp_setup_edit->LeftColumnClass ?>"><?php echo $whatsapp_setup->whatsapp_message->caption() ?><?php echo ($whatsapp_setup->whatsapp_message->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $whatsapp_setup_edit->RightColumnClass ?>"><div<?php echo $whatsapp_setup->whatsapp_message->cellAttributes() ?>>
<span id="el_whatsapp_setup_whatsapp_message">
<textarea data-table="whatsapp_setup" data-field="x_whatsapp_message" name="x_whatsapp_message" id="x_whatsapp_message" cols="35" rows="4" placeholder="<?php echo HtmlEncode($whatsapp_setup->whatsapp_message->getPlaceHolder()) ?>"<?php echo $whatsapp_setup->whatsapp_message->editAttributes() ?>><?php echo $whatsapp_setup->whatsapp_message->EditValue ?></textarea>
</span>
<?php echo $whatsapp_setup->whatsapp_message->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$whatsapp_setup_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $whatsapp_setup_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $whatsapp_setup_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$whatsapp_setup_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$whatsapp_setup_edit->terminate();
?>