<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$whatsapp_setup_list = new whatsapp_setup_list();

// Run the page
$whatsapp_setup_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$whatsapp_setup_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fwhatsapp_setuplist = currentForm = new ew.Form("fwhatsapp_setuplist", "list");
fwhatsapp_setuplist.formKeyCountName = '<?php echo $whatsapp_setup_list->FormKeyCountName ?>';

// Form_CustomValidate event
fwhatsapp_setuplist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fwhatsapp_setuplist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fwhatsapp_setuplist.lists["x_company[]"] = <?php echo $whatsapp_setup_list->company->Lookup->toClientList() ?>;
fwhatsapp_setuplist.lists["x_company[]"].options = <?php echo JsonEncode($whatsapp_setup_list->company->lookupOptions()) ?>;
fwhatsapp_setuplist.lists["x_operator"] = <?php echo $whatsapp_setup_list->operator->Lookup->toClientList() ?>;
fwhatsapp_setuplist.lists["x_operator"].options = <?php echo JsonEncode($whatsapp_setup_list->operator->lookupOptions()) ?>;

// Form object for search
var fwhatsapp_setuplistsrch = currentSearchForm = new ew.Form("fwhatsapp_setuplistsrch");

// Filters
fwhatsapp_setuplistsrch.filterList = <?php echo $whatsapp_setup_list->getFilterList() ?>;

// Init search panel as collapsed
fwhatsapp_setuplistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($whatsapp_setup_list->TotalRecs > 0 && $whatsapp_setup_list->ExportOptions->visible()) { ?>
<?php $whatsapp_setup_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($whatsapp_setup_list->ImportOptions->visible()) { ?>
<?php $whatsapp_setup_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($whatsapp_setup_list->SearchOptions->visible()) { ?>
<?php $whatsapp_setup_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($whatsapp_setup_list->FilterOptions->visible()) { ?>
<?php $whatsapp_setup_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$whatsapp_setup_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$whatsapp_setup->isExport() && !$whatsapp_setup->CurrentAction) { ?>
<form name="fwhatsapp_setuplistsrch" id="fwhatsapp_setuplistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($whatsapp_setup_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fwhatsapp_setuplistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="whatsapp_setup">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($whatsapp_setup_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($whatsapp_setup_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $whatsapp_setup_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($whatsapp_setup_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($whatsapp_setup_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($whatsapp_setup_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($whatsapp_setup_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $whatsapp_setup_list->showPageHeader(); ?>
<?php
$whatsapp_setup_list->showMessage();
?>
<?php if ($whatsapp_setup_list->TotalRecs > 0 || $whatsapp_setup->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($whatsapp_setup_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> whatsapp_setup">
<?php if (!$whatsapp_setup->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$whatsapp_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($whatsapp_setup_list->Pager)) $whatsapp_setup_list->Pager = new PrevNextPager($whatsapp_setup_list->StartRec, $whatsapp_setup_list->DisplayRecs, $whatsapp_setup_list->TotalRecs, $whatsapp_setup_list->AutoHidePager) ?>
<?php if ($whatsapp_setup_list->Pager->RecordCount > 0 && $whatsapp_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($whatsapp_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($whatsapp_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $whatsapp_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($whatsapp_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($whatsapp_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($whatsapp_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($whatsapp_setup_list->TotalRecs > 0 && (!$whatsapp_setup_list->AutoHidePageSizeSelector || $whatsapp_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="whatsapp_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($whatsapp_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($whatsapp_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($whatsapp_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($whatsapp_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($whatsapp_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($whatsapp_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $whatsapp_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fwhatsapp_setuplist" id="fwhatsapp_setuplist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($whatsapp_setup_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $whatsapp_setup_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="whatsapp_setup">
<div id="gmp_whatsapp_setup" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($whatsapp_setup_list->TotalRecs > 0 || $whatsapp_setup->isGridEdit()) { ?>
<table id="tbl_whatsapp_setuplist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$whatsapp_setup_list->RowType = ROWTYPE_HEADER;

// Render list options
$whatsapp_setup_list->renderListOptions();

// Render list options (header, left)
$whatsapp_setup_list->ListOptions->render("header", "left");
?>
<?php if ($whatsapp_setup->id->Visible) { // id ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->id) == "") { ?>
		<th data-name="id" class="<?php echo $whatsapp_setup->id->headerCellClass() ?>"><div id="elh_whatsapp_setup_id" class="whatsapp_setup_id"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $whatsapp_setup->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->id) ?>',2);"><div id="elh_whatsapp_setup_id" class="whatsapp_setup_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->mobile->Visible) { // mobile ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->mobile) == "") { ?>
		<th data-name="mobile" class="<?php echo $whatsapp_setup->mobile->headerCellClass() ?>"><div id="elh_whatsapp_setup_mobile" class="whatsapp_setup_mobile"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->mobile->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="mobile" class="<?php echo $whatsapp_setup->mobile->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->mobile) ?>',2);"><div id="elh_whatsapp_setup_mobile" class="whatsapp_setup_mobile">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->mobile->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->mobile->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->mobile->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->url->Visible) { // url ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->url) == "") { ?>
		<th data-name="url" class="<?php echo $whatsapp_setup->url->headerCellClass() ?>"><div id="elh_whatsapp_setup_url" class="whatsapp_setup_url"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->url->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="url" class="<?php echo $whatsapp_setup->url->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->url) ?>',2);"><div id="elh_whatsapp_setup_url" class="whatsapp_setup_url">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->url->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->url->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->url->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->Instance_id->Visible) { // Instance_id ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->Instance_id) == "") { ?>
		<th data-name="Instance_id" class="<?php echo $whatsapp_setup->Instance_id->headerCellClass() ?>"><div id="elh_whatsapp_setup_Instance_id" class="whatsapp_setup_Instance_id"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->Instance_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Instance_id" class="<?php echo $whatsapp_setup->Instance_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->Instance_id) ?>',2);"><div id="elh_whatsapp_setup_Instance_id" class="whatsapp_setup_Instance_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->Instance_id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->Instance_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->Instance_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->token->Visible) { // token ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->token) == "") { ?>
		<th data-name="token" class="<?php echo $whatsapp_setup->token->headerCellClass() ?>"><div id="elh_whatsapp_setup_token" class="whatsapp_setup_token"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->token->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="token" class="<?php echo $whatsapp_setup->token->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->token) ?>',2);"><div id="elh_whatsapp_setup_token" class="whatsapp_setup_token">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->token->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->token->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->token->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->company->Visible) { // company ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->company) == "") { ?>
		<th data-name="company" class="<?php echo $whatsapp_setup->company->headerCellClass() ?>"><div id="elh_whatsapp_setup_company" class="whatsapp_setup_company"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->company->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="company" class="<?php echo $whatsapp_setup->company->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->company) ?>',2);"><div id="elh_whatsapp_setup_company" class="whatsapp_setup_company">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->company->caption() ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->company->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->company->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->operator->Visible) { // operator ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $whatsapp_setup->operator->headerCellClass() ?>"><div id="elh_whatsapp_setup_operator" class="whatsapp_setup_operator"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $whatsapp_setup->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->operator) ?>',2);"><div id="elh_whatsapp_setup_operator" class="whatsapp_setup_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->datetime->Visible) { // datetime ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $whatsapp_setup->datetime->headerCellClass() ?>"><div id="elh_whatsapp_setup_datetime" class="whatsapp_setup_datetime"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $whatsapp_setup->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->datetime) ?>',2);"><div id="elh_whatsapp_setup_datetime" class="whatsapp_setup_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($whatsapp_setup->direct_whatsapp->Visible) { // direct_whatsapp ?>
	<?php if ($whatsapp_setup->sortUrl($whatsapp_setup->direct_whatsapp) == "") { ?>
		<th data-name="direct_whatsapp" class="<?php echo $whatsapp_setup->direct_whatsapp->headerCellClass() ?>"><div id="elh_whatsapp_setup_direct_whatsapp" class="whatsapp_setup_direct_whatsapp"><div class="ew-table-header-caption"><?php echo $whatsapp_setup->direct_whatsapp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="direct_whatsapp" class="<?php echo $whatsapp_setup->direct_whatsapp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $whatsapp_setup->SortUrl($whatsapp_setup->direct_whatsapp) ?>',2);"><div id="elh_whatsapp_setup_direct_whatsapp" class="whatsapp_setup_direct_whatsapp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $whatsapp_setup->direct_whatsapp->caption() ?></span><span class="ew-table-header-sort"><?php if ($whatsapp_setup->direct_whatsapp->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($whatsapp_setup->direct_whatsapp->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$whatsapp_setup_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($whatsapp_setup->ExportAll && $whatsapp_setup->isExport()) {
	$whatsapp_setup_list->StopRec = $whatsapp_setup_list->TotalRecs;
} else {

	// Set the last record to display
	if ($whatsapp_setup_list->TotalRecs > $whatsapp_setup_list->StartRec + $whatsapp_setup_list->DisplayRecs - 1)
		$whatsapp_setup_list->StopRec = $whatsapp_setup_list->StartRec + $whatsapp_setup_list->DisplayRecs - 1;
	else
		$whatsapp_setup_list->StopRec = $whatsapp_setup_list->TotalRecs;
}
$whatsapp_setup_list->RecCnt = $whatsapp_setup_list->StartRec - 1;
if ($whatsapp_setup_list->Recordset && !$whatsapp_setup_list->Recordset->EOF) {
	$whatsapp_setup_list->Recordset->moveFirst();
	$selectLimit = $whatsapp_setup_list->UseSelectLimit;
	if (!$selectLimit && $whatsapp_setup_list->StartRec > 1)
		$whatsapp_setup_list->Recordset->move($whatsapp_setup_list->StartRec - 1);
} elseif (!$whatsapp_setup->AllowAddDeleteRow && $whatsapp_setup_list->StopRec == 0) {
	$whatsapp_setup_list->StopRec = $whatsapp_setup->GridAddRowCount;
}

// Initialize aggregate
$whatsapp_setup->RowType = ROWTYPE_AGGREGATEINIT;
$whatsapp_setup->resetAttributes();
$whatsapp_setup_list->renderRow();
while ($whatsapp_setup_list->RecCnt < $whatsapp_setup_list->StopRec) {
	$whatsapp_setup_list->RecCnt++;
	if ($whatsapp_setup_list->RecCnt >= $whatsapp_setup_list->StartRec) {
		$whatsapp_setup_list->RowCnt++;

		// Set up key count
		$whatsapp_setup_list->KeyCount = $whatsapp_setup_list->RowIndex;

		// Init row class and style
		$whatsapp_setup->resetAttributes();
		$whatsapp_setup->CssClass = "";
		if ($whatsapp_setup->isGridAdd()) {
		} else {
			$whatsapp_setup_list->loadRowValues($whatsapp_setup_list->Recordset); // Load row values
		}
		$whatsapp_setup->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$whatsapp_setup->RowAttrs = array_merge($whatsapp_setup->RowAttrs, array('data-rowindex'=>$whatsapp_setup_list->RowCnt, 'id'=>'r' . $whatsapp_setup_list->RowCnt . '_whatsapp_setup', 'data-rowtype'=>$whatsapp_setup->RowType));

		// Render row
		$whatsapp_setup_list->renderRow();

		// Render list options
		$whatsapp_setup_list->renderListOptions();
?>
	<tr<?php echo $whatsapp_setup->rowAttributes() ?>>
<?php

// Render list options (body, left)
$whatsapp_setup_list->ListOptions->render("body", "left", $whatsapp_setup_list->RowCnt);
?>
	<?php if ($whatsapp_setup->id->Visible) { // id ?>
		<td data-name="id"<?php echo $whatsapp_setup->id->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_id" class="whatsapp_setup_id">
<span<?php echo $whatsapp_setup->id->viewAttributes() ?>>
<?php echo $whatsapp_setup->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->mobile->Visible) { // mobile ?>
		<td data-name="mobile"<?php echo $whatsapp_setup->mobile->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_mobile" class="whatsapp_setup_mobile">
<span<?php echo $whatsapp_setup->mobile->viewAttributes() ?>>
<?php echo $whatsapp_setup->mobile->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->url->Visible) { // url ?>
		<td data-name="url"<?php echo $whatsapp_setup->url->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_url" class="whatsapp_setup_url">
<span<?php echo $whatsapp_setup->url->viewAttributes() ?>>
<?php echo $whatsapp_setup->url->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->Instance_id->Visible) { // Instance_id ?>
		<td data-name="Instance_id"<?php echo $whatsapp_setup->Instance_id->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_Instance_id" class="whatsapp_setup_Instance_id">
<span<?php echo $whatsapp_setup->Instance_id->viewAttributes() ?>>
<?php echo $whatsapp_setup->Instance_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->token->Visible) { // token ?>
		<td data-name="token"<?php echo $whatsapp_setup->token->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_token" class="whatsapp_setup_token">
<span<?php echo $whatsapp_setup->token->viewAttributes() ?>>
<?php echo $whatsapp_setup->token->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->company->Visible) { // company ?>
		<td data-name="company"<?php echo $whatsapp_setup->company->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_company" class="whatsapp_setup_company">
<span<?php echo $whatsapp_setup->company->viewAttributes() ?>>
<?php echo $whatsapp_setup->company->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $whatsapp_setup->operator->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_operator" class="whatsapp_setup_operator">
<span<?php echo $whatsapp_setup->operator->viewAttributes() ?>>
<?php echo $whatsapp_setup->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $whatsapp_setup->datetime->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_datetime" class="whatsapp_setup_datetime">
<span<?php echo $whatsapp_setup->datetime->viewAttributes() ?>>
<?php echo $whatsapp_setup->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($whatsapp_setup->direct_whatsapp->Visible) { // direct_whatsapp ?>
		<td data-name="direct_whatsapp"<?php echo $whatsapp_setup->direct_whatsapp->cellAttributes() ?>>
<span id="el<?php echo $whatsapp_setup_list->RowCnt ?>_whatsapp_setup_direct_whatsapp" class="whatsapp_setup_direct_whatsapp">
<span<?php echo $whatsapp_setup->direct_whatsapp->viewAttributes() ?>>
<?php echo $whatsapp_setup->direct_whatsapp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$whatsapp_setup_list->ListOptions->render("body", "right", $whatsapp_setup_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$whatsapp_setup->isGridAdd())
		$whatsapp_setup_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$whatsapp_setup->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($whatsapp_setup_list->Recordset)
	$whatsapp_setup_list->Recordset->Close();
?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$whatsapp_setup->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($whatsapp_setup_list->Pager)) $whatsapp_setup_list->Pager = new PrevNextPager($whatsapp_setup_list->StartRec, $whatsapp_setup_list->DisplayRecs, $whatsapp_setup_list->TotalRecs, $whatsapp_setup_list->AutoHidePager) ?>
<?php if ($whatsapp_setup_list->Pager->RecordCount > 0 && $whatsapp_setup_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($whatsapp_setup_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($whatsapp_setup_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $whatsapp_setup_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($whatsapp_setup_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($whatsapp_setup_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $whatsapp_setup_list->pageUrl() ?>start=<?php echo $whatsapp_setup_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($whatsapp_setup_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $whatsapp_setup_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($whatsapp_setup_list->TotalRecs > 0 && (!$whatsapp_setup_list->AutoHidePageSizeSelector || $whatsapp_setup_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="whatsapp_setup">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($whatsapp_setup_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($whatsapp_setup_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($whatsapp_setup_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($whatsapp_setup_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($whatsapp_setup_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($whatsapp_setup->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $whatsapp_setup_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($whatsapp_setup_list->TotalRecs == 0 && !$whatsapp_setup->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $whatsapp_setup_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$whatsapp_setup_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$whatsapp_setup->isExport()) { ?>
<script>
ew.scrollableTable("gmp_whatsapp_setup", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$whatsapp_setup_list->terminate();
?>